/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.sql.result;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.NoSuchElementException;
import org.assertj.core.api.Assertions;
import org.codefilarete.stalactite.sql.result.ResultSetIterator;
import org.codefilarete.stalactite.sql.test.DatabaseIntegrationTest;
import org.codefilarete.tool.collection.Arrays;
import org.junit.jupiter.api.Test;

abstract class ResultSetIteratorITTest
extends DatabaseIntegrationTest {
    ResultSetIteratorITTest() {
    }

    @Test
    void hasNext_emptyResultSet() throws SQLException {
        Connection connection = this.connectionProvider.giveConnection();
        this.ensureTable(connection);
        PreparedStatement selectStmnt = connection.prepareStatement("select name from Toto");
        ResultSet selectStmntRs = selectStmnt.executeQuery();
        ResultSetIterator<String> resultSetIterator = new ResultSetIterator<String>(selectStmntRs){

            public String convert(ResultSet rs) throws SQLException {
                return rs.getString("name");
            }
        };
        Assertions.assertThat((boolean)resultSetIterator.hasNext()).isFalse();
    }

    @Test
    void hasNext_filledResultSet() throws SQLException {
        Connection connection = this.connectionProvider.giveConnection();
        this.ensureTable(connection);
        PreparedStatement insertDataStmnt = connection.prepareStatement("insert into Toto(name) values ('a'), ('b'), ('c')");
        insertDataStmnt.execute();
        PreparedStatement selectStmnt = connection.prepareStatement("select name from Toto");
        ResultSet selectStmntRs = selectStmnt.executeQuery();
        ResultSetIterator<String> resultSetIterator = new ResultSetIterator<String>(selectStmntRs){

            public String convert(ResultSet rs) throws SQLException {
                return rs.getString("name");
            }
        };
        Assertions.assertThat((boolean)resultSetIterator.hasNext()).isTrue();
        resultSetIterator.next();
        Assertions.assertThat((boolean)resultSetIterator.hasNext()).isTrue();
        resultSetIterator.next();
        Assertions.assertThat((boolean)resultSetIterator.hasNext()).isTrue();
        resultSetIterator.next();
        Assertions.assertThat((boolean)resultSetIterator.hasNext()).isFalse();
    }

    @Test
    void next_withoutCallToHasNext_throwsNoSuchElementException() throws SQLException {
        Connection connection = this.connectionProvider.giveConnection();
        this.ensureTable(connection);
        PreparedStatement insertDataStmnt = connection.prepareStatement("insert into Toto(name) values ('a'), ('b'), ('c')");
        insertDataStmnt.execute();
        PreparedStatement selectStmnt = connection.prepareStatement("select name from Toto");
        ResultSet selectStmntRs = selectStmnt.executeQuery();
        ResultSetIterator<String> resultSetIterator = new ResultSetIterator<String>(selectStmntRs){

            public String convert(ResultSet rs) throws SQLException {
                return rs.getString("name");
            }
        };
        Assertions.assertThatExceptionOfType(NoSuchElementException.class).isThrownBy(() -> ((ResultSetIterator)resultSetIterator).next());
        Assertions.assertThat((boolean)resultSetIterator.hasNext()).isTrue();
        resultSetIterator.next();
        Assertions.assertThatExceptionOfType(NoSuchElementException.class).isThrownBy(() -> ((ResultSetIterator)resultSetIterator).next());
    }

    @Test
    void convert() throws SQLException {
        Connection connection = this.connectionProvider.giveConnection();
        this.ensureTable(connection);
        PreparedStatement insertDataStmnt = connection.prepareStatement("insert into Toto(name) values ('a'), ('b'), ('c')");
        insertDataStmnt.execute();
        PreparedStatement selectStmnt = connection.prepareStatement("select name from Toto");
        ResultSet selectStmntRs = selectStmnt.executeQuery();
        ResultSetIterator<String> resultSetIterator = new ResultSetIterator<String>(selectStmntRs){

            public String convert(ResultSet rs) throws SQLException {
                return rs.getString("name");
            }
        };
        Assertions.assertThat((List)resultSetIterator.convert()).isEqualTo((Object)Arrays.asList((Object[])new String[]{"a", "b", "c"}));
    }

    private void ensureTable(Connection connection) throws SQLException {
        PreparedStatement createTableStmnt = connection.prepareStatement("create table Toto(name VARCHAR(10))");
        createTableStmnt.execute();
    }
}

