/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.spring.repository.query.execution;

import java.lang.reflect.Method;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import org.codefilarete.reflection.AccessorChain;
import org.codefilarete.reflection.AccessorDefinition;
import org.codefilarete.reflection.ValueAccessPoint;
import org.codefilarete.stalactite.query.model.JoinLink;
import org.codefilarete.stalactite.spring.repository.query.StalactiteQueryMethod;
import org.codefilarete.stalactite.spring.repository.query.StalactiteRepositoryQuery;
import org.codefilarete.stalactite.spring.repository.query.execution.AbstractQueryExecutor;
import org.codefilarete.stalactite.spring.repository.query.execution.StalactiteQueryMethodInvocationParameters;
import org.codefilarete.stalactite.spring.repository.query.execution.reduce.LimitHandler;
import org.codefilarete.stalactite.spring.repository.query.execution.reduce.QueryResultCollectioner;
import org.codefilarete.stalactite.spring.repository.query.execution.reduce.QueryResultPager;
import org.codefilarete.stalactite.spring.repository.query.execution.reduce.QueryResultReducer;
import org.codefilarete.stalactite.spring.repository.query.execution.reduce.QueryResultSingler;
import org.codefilarete.stalactite.spring.repository.query.execution.reduce.QueryResultSlicer;
import org.codefilarete.tool.Reflections;
import org.codefilarete.tool.collection.Iterables;
import org.springframework.data.repository.query.ParameterAccessor;
import org.springframework.data.repository.query.Parameters;
import org.springframework.data.repository.query.ParametersParameterAccessor;
import org.springframework.data.repository.query.ResultProcessor;

public abstract class AbstractRepositoryQuery<C, R>
implements StalactiteRepositoryQuery<C, R> {
    protected final StalactiteQueryMethod method;

    public static IdentityHashMap<JoinLink<?, ?>, String> buildAliases(IdentityHashMap<? extends JoinLink<?, ?>, ? extends AccessorChain<?, ?>> columnToProperties) {
        return (IdentityHashMap)Iterables.map(columnToProperties.entrySet(), Map.Entry::getKey, entry -> AccessorDefinition.giveDefinition((ValueAccessPoint)((ValueAccessPoint)entry.getValue())).getName().replace('.', '_'), IdentityHashMap::new);
    }

    public AbstractRepositoryQuery(StalactiteQueryMethod method) {
        this.method = method;
    }

    @Override
    public StalactiteQueryMethod getQueryMethod() {
        return this.method;
    }

    @Override
    public R execute(Object[] parameters) {
        StalactiteQueryMethodInvocationParameters invocationParameters = new StalactiteQueryMethodInvocationParameters(this.method, parameters);
        AbstractQueryExecutor<List<Object>, Object> queryExecutor = this.buildQueryExecutor(invocationParameters);
        Supplier resultSupplier = queryExecutor.buildQueryExecutor(invocationParameters);
        R adaptation = this.buildResultReducer(invocationParameters).adapt(resultSupplier).apply(parameters);
        ResultProcessor resultProcessor = this.buildResultProcessor(parameters);
        return (R)resultProcessor.processResult(adaptation);
    }

    protected abstract AbstractQueryExecutor<List<Object>, Object> buildQueryExecutor(StalactiteQueryMethodInvocationParameters var1);

    protected <ROW> QueryResultReducer<R, ROW> buildResultReducer(StalactiteQueryMethodInvocationParameters invocationParameters) {
        QueryResultReducer result;
        switch (this.method.getQueryMethodReturnType()) {
            case COLLECTION: {
                result = new QueryResultCollectioner();
                break;
            }
            case PAGE: {
                result = new QueryResultPager(this, (LimitHandler)invocationParameters, this.buildCountSupplier(invocationParameters));
                break;
            }
            case SLICE: {
                result = new QueryResultSlicer(this, invocationParameters);
                break;
            }
            case SINGLE_ENTITY: {
                result = new QueryResultSingler();
                break;
            }
            case SINGLE_PROJECTION: {
                result = new QueryResultSingler();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported return type for method " + Reflections.toString((Method)this.method.getMethod()));
            }
        }
        return result;
    }

    protected abstract LongSupplier buildCountSupplier(StalactiteQueryMethodInvocationParameters var1);

    protected ResultProcessor buildResultProcessor(Object[] parameters) {
        ResultProcessor resultProcessor = this.method.getResultProcessor();
        if (this.method.getParameters().hasDynamicProjection()) {
            resultProcessor = resultProcessor.withDynamicProjection((ParameterAccessor)new ParametersParameterAccessor((Parameters)this.method.getParameters(), parameters));
        }
        return resultProcessor;
    }
}

