/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.configurer.polymorphism;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.codefilarete.reflection.ReversibleAccessor;
import org.codefilarete.reflection.ValueAccessPointMap;
import org.codefilarete.reflection.ValueAccessPointSet;
import org.codefilarete.stalactite.engine.PolymorphismPolicy;
import org.codefilarete.stalactite.engine.SubEntityMappingConfiguration;
import org.codefilarete.stalactite.engine.configurer.AbstractIdentification;
import org.codefilarete.stalactite.engine.configurer.BeanMappingBuilder;
import org.codefilarete.stalactite.engine.configurer.NamingConfiguration;
import org.codefilarete.stalactite.engine.configurer.PersisterBuilderImpl;
import org.codefilarete.stalactite.engine.configurer.polymorphism.AbstractPolymorphicPersisterBuilder;
import org.codefilarete.stalactite.engine.runtime.AbstractPolymorphismPersister;
import org.codefilarete.stalactite.engine.runtime.ConfiguredRelationalPersister;
import org.codefilarete.stalactite.engine.runtime.SimpleRelationalEntityPersister;
import org.codefilarete.stalactite.engine.runtime.singletable.SingleTablePolymorphismPersister;
import org.codefilarete.stalactite.mapping.ClassMapping;
import org.codefilarete.stalactite.sql.ConnectionConfiguration;
import org.codefilarete.stalactite.sql.Dialect;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.stalactite.sql.statement.binder.ColumnBinderRegistry;
import org.codefilarete.tool.Reflections;
import org.codefilarete.tool.collection.KeepOrderSet;
import org.codefilarete.tool.exception.NotImplementedException;
import org.codefilarete.tool.function.Converter;

class SingleTablePolymorphismBuilder<C, I, T extends Table<T>, DTYPE>
extends AbstractPolymorphicPersisterBuilder<C, I, T> {
    private final Map<ReversibleAccessor<C, Object>, Column<T, Object>> mainMapping;
    private final Map<ReversibleAccessor<C, Object>, Column<T, Object>> mainReadonlyMapping;
    private final ValueAccessPointMap<C, Converter<Object, Object>> mainReadConverters;
    private final ValueAccessPointMap<C, Converter<Object, Object>> mainWriteConverters;

    SingleTablePolymorphismBuilder(PolymorphismPolicy.SingleTablePolymorphism<C, DTYPE> polymorphismPolicy, AbstractIdentification<C, I> identification, ConfiguredRelationalPersister<C, I> mainPersister, Map<? extends ReversibleAccessor<C, Object>, ? extends Column<T, Object>> mainMapping, Map<? extends ReversibleAccessor<C, Object>, ? extends Column<T, Object>> mainReadonlyMapping, ValueAccessPointMap<C, ? extends Converter<Object, Object>> mainReadConverters, ValueAccessPointMap<C, ? extends Converter<Object, Object>> mainWriteConverters, ColumnBinderRegistry columnBinderRegistry, NamingConfiguration namingConfiguration) {
        super(polymorphismPolicy, identification, mainPersister, columnBinderRegistry, namingConfiguration);
        this.mainMapping = mainMapping;
        this.mainReadonlyMapping = mainReadonlyMapping;
        this.mainReadConverters = mainReadConverters;
        this.mainWriteConverters = mainWriteConverters;
    }

    @Override
    public AbstractPolymorphismPersister<C, I> build(Dialect dialect, ConnectionConfiguration connectionConfiguration) {
        Map persisterPerSubclass = this.collectSubClassPersister(dialect, connectionConfiguration);
        this.registerSubEntitiesRelations(persisterPerSubclass, dialect, connectionConfiguration);
        Column<T, DTYPE> discriminatorColumn = this.ensureDiscriminatorColumn();
        SingleTablePolymorphismPersister result = new SingleTablePolymorphismPersister(this.mainPersister, persisterPerSubclass, connectionConfiguration.getConnectionProvider(), dialect, discriminatorColumn, (PolymorphismPolicy.SingleTablePolymorphism)this.polymorphismPolicy);
        return result;
    }

    private Map<Class<C>, Set<C>> computeEntitiesPerType(Iterable<? extends C> entities) {
        HashMap entitiesPerType = new HashMap();
        entities.forEach(entity -> entitiesPerType.computeIfAbsent(entity.getClass(), p -> new KeepOrderSet()).add(entity));
        return entitiesPerType;
    }

    private <D extends C> Map<Class<D>, ConfiguredRelationalPersister<D, I>> collectSubClassPersister(Dialect dialect, ConnectionConfiguration connectionConfiguration) {
        HashMap<Class<D>, ConfiguredRelationalPersister<D, I>> persisterPerSubclass = new HashMap<Class<D>, ConfiguredRelationalPersister<D, I>>();
        Table mainTable = this.mainPersister.getMapping().getTargetTable();
        for (SubEntityMappingConfiguration subConfiguration : this.polymorphismPolicy.getSubClasses()) {
            persisterPerSubclass.put(subConfiguration.getEntityType(), this.buildSubclassPersister(dialect, connectionConfiguration, mainTable, subConfiguration));
        }
        return persisterPerSubclass;
    }

    private <D extends C> SimpleRelationalEntityPersister<D, I, T> buildSubclassPersister(Dialect dialect, ConnectionConfiguration connectionConfiguration, T mainTable, SubEntityMappingConfiguration<D> subConfiguration) {
        BeanMappingBuilder.giveTargetTable(subConfiguration.getPropertiesMapping(), mainTable);
        BeanMappingBuilder<D, T> beanMappingBuilder = new BeanMappingBuilder<D, T>(subConfiguration.getPropertiesMapping(), mainTable, this.columnBinderRegistry, this.namingConfiguration.getColumnNamingStrategy());
        BeanMappingBuilder.BeanMapping<D, T> beanMapping = beanMappingBuilder.build();
        Map<ReversibleAccessor<D, Object>, Column<T, Object>> subEntityPropertiesMapping = beanMapping.getMapping();
        Map<ReversibleAccessor<D, Object>, Column<T, Object>> subEntityReadonlyPropertiesMapping = beanMapping.getReadonlyMapping();
        ValueAccessPointMap<D, Converter<Object, Object>> subEntityPropertiesReadConverters = beanMapping.getReadConverters();
        ValueAccessPointMap<D, Converter<Object, Object>> subEntityPropertiesWriteConverters = beanMapping.getWriteConverters();
        subEntityPropertiesMapping.putAll(this.mainMapping);
        subEntityReadonlyPropertiesMapping.putAll(this.mainReadonlyMapping);
        subEntityPropertiesReadConverters.putAll(this.mainReadConverters);
        subEntityPropertiesWriteConverters.putAll(this.mainWriteConverters);
        ClassMapping classMappingStrategy = PersisterBuilderImpl.createClassMappingStrategy(true, mainTable, subEntityPropertiesMapping, subEntityReadonlyPropertiesMapping, subEntityPropertiesReadConverters, subEntityPropertiesWriteConverters, new ValueAccessPointSet(), this.identification, subConfiguration.getPropertiesMapping().getBeanType(), null);
        classMappingStrategy.addShadowColumns((ClassMapping)this.mainPersister.getMapping());
        return new SimpleRelationalEntityPersister(classMappingStrategy, dialect, connectionConfiguration);
    }

    @Override
    protected void assertSubPolymorphismIsSupported(PolymorphismPolicy<? extends C> subPolymorphismPolicy) {
        if (!(subPolymorphismPolicy instanceof PolymorphismPolicy.JoinTablePolymorphism)) {
            throw new NotImplementedException("Combining single-table polymorphism policy with " + Reflections.toString(subPolymorphismPolicy.getClass()));
        }
    }

    private Column<T, DTYPE> ensureDiscriminatorColumn() {
        Column result = this.mainPersister.getMapping().getTargetTable().addColumn(((PolymorphismPolicy.SingleTablePolymorphism)this.polymorphismPolicy).getDiscriminatorColumn(), ((PolymorphismPolicy.SingleTablePolymorphism)this.polymorphismPolicy).getDiscrimintorType());
        result.setNullable(false);
        return result;
    }
}

