/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.TreeSet;
import javax.sql.DataSource;
import org.assertj.core.api.Assertions;
import org.codefilarete.stalactite.engine.CascadeOptions;
import org.codefilarete.stalactite.engine.EntityMappingConfigurationProvider;
import org.codefilarete.stalactite.engine.EntityPersister;
import org.codefilarete.stalactite.engine.FluentEntityMappingBuilder;
import org.codefilarete.stalactite.engine.JdbcForeignKey;
import org.codefilarete.stalactite.engine.MappingEase;
import org.codefilarete.stalactite.engine.PersistenceContext;
import org.codefilarete.stalactite.engine.idprovider.LongProvider;
import org.codefilarete.stalactite.engine.runtime.OptimizedUpdatePersister;
import org.codefilarete.stalactite.id.Identified;
import org.codefilarete.stalactite.id.Identifier;
import org.codefilarete.stalactite.id.PersistableIdentifier;
import org.codefilarete.stalactite.id.PersistedIdentifier;
import org.codefilarete.stalactite.id.StatefulIdentifierAlreadyAssignedIdentifierPolicy;
import org.codefilarete.stalactite.sql.ConnectionProvider;
import org.codefilarete.stalactite.sql.CurrentThreadConnectionProvider;
import org.codefilarete.stalactite.sql.Dialect;
import org.codefilarete.stalactite.sql.HSQLDBDialect;
import org.codefilarete.stalactite.sql.ddl.DDLDeployer;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.stalactite.sql.result.Accumulators;
import org.codefilarete.stalactite.sql.result.ResultSetIterator;
import org.codefilarete.stalactite.sql.statement.binder.DefaultParameterBinders;
import org.codefilarete.stalactite.sql.test.HSQLDBInMemoryDataSource;
import org.codefilarete.tool.bean.Objects;
import org.codefilarete.tool.collection.Arrays;
import org.codefilarete.tool.collection.Iterables;
import org.codefilarete.tool.function.SerializableTriFunction;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;

class FluentEntityMappingConfigurationSupportManyToManySetTest {
    private static final HSQLDBDialect DIALECT = new HSQLDBDialect();
    private static FluentEntityMappingBuilder<Choice, Identifier<Long>> CHOICE_MAPPING_CONFIGURATION;
    private final DataSource dataSource = new HSQLDBInMemoryDataSource();
    private final ConnectionProvider connectionProvider = new CurrentThreadConnectionProvider(this.dataSource);
    private PersistenceContext persistenceContext;

    FluentEntityMappingConfigurationSupportManyToManySetTest() {
    }

    @BeforeAll
    static void initBinders() {
        DIALECT.getColumnBinderRegistry().register(Identifier.class, Identifier.identifierBinder(DefaultParameterBinders.LONG_PRIMITIVE_BINDER));
        DIALECT.getSqlTypeRegistry().put(Identifier.class, "int");
    }

    @BeforeEach
    void beforeTest() {
        this.persistenceContext = new PersistenceContext(this.connectionProvider, (Dialect)DIALECT);
        CHOICE_MAPPING_CONFIGURATION = MappingEase.entityBuilder(Choice.class, Identifier.LONG_TYPE).mapKey(Choice::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Choice::getLabel);
    }

    @Test
    void foreignKeysAreCreated() throws SQLException {
        EntityPersister answerPersister = MappingEase.entityBuilder(Answer.class, Identifier.LONG_TYPE).mapKey(Answer::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).mapManyToMany(Answer::getChoices, CHOICE_MAPPING_CONFIGURATION).cascading(CascadeOptions.RelationMode.READ_ONLY).build(this.persistenceContext);
        DDLDeployer ddlDeployer = new DDLDeployer(this.persistenceContext);
        ddlDeployer.deployDDL();
        Connection currentConnection = this.persistenceContext.getConnectionProvider().giveConnection();
        ResultSetIterator<JdbcForeignKey> fkChoiceIterator = new ResultSetIterator<JdbcForeignKey>(currentConnection.getMetaData().getImportedKeys(null, null, "ANSWER_CHOICES")){

            public JdbcForeignKey convert(ResultSet rs) throws SQLException {
                return new JdbcForeignKey(rs.getString("FK_NAME"), rs.getString("FKTABLE_NAME"), rs.getString("FKCOLUMN_NAME"), rs.getString("PKTABLE_NAME"), rs.getString("PKCOLUMN_NAME"));
            }
        };
        Set foundForeignKey = (Set)Iterables.collect(() -> FluentEntityMappingConfigurationSupportManyToManySetTest.lambda$foreignKeysAreCreated$0((ResultSetIterator)fkChoiceIterator), JdbcForeignKey::getSignature, HashSet::new);
        Assertions.assertThat((Collection)foundForeignKey).containsExactlyInAnyOrder((Object[])new String[]{new JdbcForeignKey("FK_ANSWER_CHOICES_ANSWER_ID_ANSWER_ID", "ANSWER_CHOICES", "ANSWER_ID", "ANSWER", "ID").getSignature(), new JdbcForeignKey("FK_ANSWER_CHOICES_CHOICES_ID_CHOICE_ID", "ANSWER_CHOICES", "CHOICES_ID", "CHOICE", "ID").getSignature()});
    }

    @Test
    void foreignKeysAreCreated_targetTableSpecified() throws SQLException {
        Table targetTable = new Table("MyChoice");
        EntityPersister answerPersister = MappingEase.entityBuilder(Answer.class, Identifier.LONG_TYPE).mapKey(Answer::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).mapManyToMany(Answer::getChoices, CHOICE_MAPPING_CONFIGURATION, targetTable).cascading(CascadeOptions.RelationMode.READ_ONLY).build(this.persistenceContext);
        DDLDeployer ddlDeployer = new DDLDeployer(this.persistenceContext);
        ddlDeployer.deployDDL();
        Connection currentConnection = this.persistenceContext.getConnectionProvider().giveConnection();
        ResultSetIterator<JdbcForeignKey> fkChoiceIterator = new ResultSetIterator<JdbcForeignKey>(currentConnection.getMetaData().getImportedKeys(null, null, "ANSWER_CHOICES")){

            public JdbcForeignKey convert(ResultSet rs) throws SQLException {
                return new JdbcForeignKey(rs.getString("FK_NAME"), rs.getString("FKTABLE_NAME"), rs.getString("FKCOLUMN_NAME"), rs.getString("PKTABLE_NAME"), rs.getString("PKCOLUMN_NAME"));
            }
        };
        Set foundForeignKey = (Set)Iterables.collect(() -> FluentEntityMappingConfigurationSupportManyToManySetTest.lambda$foreignKeysAreCreated_targetTableSpecified$1((ResultSetIterator)fkChoiceIterator), JdbcForeignKey::getSignature, HashSet::new);
        Assertions.assertThat((Collection)foundForeignKey).containsExactlyInAnyOrder((Object[])new String[]{new JdbcForeignKey("FK_ANSWER_CHOICES_ANSWER_ID_ANSWER_ID", "ANSWER_CHOICES", "ANSWER_ID", "ANSWER", "ID").getSignature(), new JdbcForeignKey("FK_ANSWER_CHOICES_CHOICES_ID_MYCHOICE_ID", "ANSWER_CHOICES", "CHOICES_ID", "MYCHOICE", "ID").getSignature()});
    }

    @Test
    void crud_relationContainsOneToMany() {
        EntityPersister persister = MappingEase.entityBuilder(Answer.class, Identifier.LONG_TYPE).mapKey(Answer::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).mapManyToMany(Answer::getChoices, CHOICE_MAPPING_CONFIGURATION).build(this.persistenceContext);
        DDLDeployer ddlDeployer = new DDLDeployer(this.persistenceContext);
        ddlDeployer.deployDDL();
        Answer answer = new Answer(new PersistableIdentifier<Long>(1L));
        Choice grenoble = new Choice(new PersistableIdentifier<Long>(13L));
        grenoble.setLabel("Grenoble");
        Choice lyon = new Choice(new PersistableIdentifier<Long>(17L));
        lyon.setLabel("Lyon");
        answer.addChoices(grenoble, lyon);
        persister.insert((Object)answer);
        PersistenceContext.ExecutableBeanPropertyQueryMapper longExecutableQuery3 = this.persistenceContext.newQuery((CharSequence)"select answer_id from answer_choices", Long.class).mapKey("answer_id", Long.class);
        Set choiceAnswerIds = (Set)longExecutableQuery3.execute(Accumulators.toSet());
        Assertions.assertThat((Collection)choiceAnswerIds).containsExactlyInAnyOrder((Object[])new Long[]{(Long)answer.getId().getSurrogate()});
        Answer loadedAnswer = (Answer)persister.select(answer.getId());
        Assertions.assertThat(loadedAnswer.getChoices()).extracting(Choice::getLabel).containsExactlyInAnyOrder((Object[])new String[]{"Grenoble", "Lyon"});
        Answer modifiedAnswer = new Answer(answer.getId());
        modifiedAnswer.addChoices((Choice)Iterables.first(answer.getChoices()));
        persister.update((Object)modifiedAnswer, (Object)answer, false);
        PersistenceContext.ExecutableBeanPropertyQueryMapper longExecutableQuery2 = this.persistenceContext.newQuery((CharSequence)"select answer_id from answer_choices", Long.class).mapKey("answer_id", Long.class);
        choiceAnswerIds = (Set)longExecutableQuery2.execute(Accumulators.toSet());
        Assertions.assertThat((Collection)choiceAnswerIds).containsExactlyInAnyOrder((Object[])new Long[]{(Long)answer.getId().getSurrogate()});
        PersistenceContext.ExecutableBeanPropertyQueryMapper longExecutableQuery1 = this.persistenceContext.newQuery((CharSequence)"select id from choice", Long.class).mapKey("id", Long.class);
        Set choiceIds = (Set)longExecutableQuery1.execute(Accumulators.toSet());
        Assertions.assertThat((Collection)choiceIds).containsExactlyInAnyOrder((Object[])new Long[]{(Long)grenoble.getId().getSurrogate(), (Long)lyon.getId().getSurrogate()});
        persister.delete((Object)modifiedAnswer);
        PersistenceContext.ExecutableBeanPropertyQueryMapper longExecutableQuery = this.persistenceContext.newQuery((CharSequence)"select answer_id from answer_choices", Long.class).mapKey("answer_id", Long.class);
        choiceAnswerIds = (Set)longExecutableQuery.execute(Accumulators.toSet());
        Assertions.assertThat((Collection)choiceAnswerIds).isEmpty();
    }

    @Test
    void crud_relationContainsManyToMany() {
        EntityPersister persister = MappingEase.entityBuilder(Answer.class, Identifier.LONG_TYPE).mapKey(Answer::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).mapManyToMany(Answer::getChoices, CHOICE_MAPPING_CONFIGURATION).cascading(CascadeOptions.RelationMode.ALL).build(this.persistenceContext);
        DDLDeployer ddlDeployer = new DDLDeployer(this.persistenceContext);
        ddlDeployer.deployDDL();
        Answer answer1 = new Answer(new PersistableIdentifier<Long>(1L));
        Answer answer2 = new Answer(new PersistableIdentifier<Long>(2L));
        Choice grenoble = new Choice(new PersistableIdentifier<Long>(13L));
        grenoble.setLabel("Grenoble");
        Choice lyon = new Choice(new PersistableIdentifier<Long>(17L));
        lyon.setLabel("Lyon");
        answer1.addChoices(grenoble, lyon);
        answer2.addChoices(grenoble, lyon);
        persister.insert((Iterable)Arrays.asList((Object[])new Answer[]{answer1, answer2}));
        PersistenceContext.ExecutableBeanPropertyQueryMapper longExecutableQuery3 = this.persistenceContext.newQuery((CharSequence)"select answer_id from answer_choices", Long.class).mapKey("answer_id", Long.class);
        Set choiceAnswerIds = (Set)longExecutableQuery3.execute(Accumulators.toSet());
        Assertions.assertThat((Collection)choiceAnswerIds).containsExactlyInAnyOrder((Object[])new Long[]{(Long)answer1.getId().getSurrogate(), (Long)answer2.getId().getSurrogate()});
        Answer loadedAnswer = (Answer)persister.select(answer1.getId());
        Assertions.assertThat(loadedAnswer.getChoices()).extracting(Choice::getLabel).containsExactlyInAnyOrder((Object[])new String[]{"Grenoble", "Lyon"});
        Answer modifiedAnswer = new Answer(answer1.getId());
        modifiedAnswer.addChoices((Choice)Iterables.first(answer1.getChoices()));
        persister.update((Object)modifiedAnswer, (Object)answer1, false);
        PersistenceContext.ExecutableBeanPropertyQueryMapper longExecutableQuery2 = this.persistenceContext.newQuery((CharSequence)"select answer_id from answer_choices", Long.class).mapKey("answer_id", Long.class);
        choiceAnswerIds = (Set)longExecutableQuery2.execute(Accumulators.toSet());
        Assertions.assertThat((Collection)choiceAnswerIds).containsExactlyInAnyOrder((Object[])new Long[]{(Long)answer1.getId().getSurrogate(), (Long)answer2.getId().getSurrogate()});
        PersistenceContext.ExecutableBeanPropertyQueryMapper longExecutableQuery1 = this.persistenceContext.newQuery((CharSequence)"select id from choice", Long.class).mapKey("id", Long.class);
        Set choiceIds = (Set)longExecutableQuery1.execute(Accumulators.toSet());
        Assertions.assertThat((Collection)choiceIds).containsExactlyInAnyOrder((Object[])new Long[]{(Long)grenoble.getId().getSurrogate(), (Long)lyon.getId().getSurrogate()});
        persister.delete((Object)modifiedAnswer);
        PersistenceContext.ExecutableBeanPropertyQueryMapper longExecutableQuery = this.persistenceContext.newQuery((CharSequence)"select answer_id from answer_choices", Long.class).mapKey("answer_id", Long.class);
        choiceAnswerIds = (Set)longExecutableQuery.execute(Accumulators.toSet());
        Assertions.assertThat((Collection)choiceAnswerIds).containsExactlyInAnyOrder((Object[])new Long[]{(Long)answer2.getId().getSurrogate()});
    }

    @Test
    void crud_relationContainsManyToMany_indexed() {
        EntityPersister persister = MappingEase.entityBuilder(Answer.class, Identifier.LONG_TYPE).mapKey(Answer::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).mapManyToMany(Answer::getChoices, CHOICE_MAPPING_CONFIGURATION).indexedBy("myIdx").cascading(CascadeOptions.RelationMode.ALL).build(this.persistenceContext);
        DDLDeployer ddlDeployer = new DDLDeployer(this.persistenceContext);
        ddlDeployer.deployDDL();
        Answer answer1 = new Answer(new PersistableIdentifier<Long>(1L));
        Answer answer2 = new Answer(new PersistableIdentifier<Long>(2L));
        Choice grenoble = new Choice(new PersistableIdentifier<Long>(13L));
        grenoble.setLabel("Grenoble");
        Choice lyon = new Choice(new PersistableIdentifier<Long>(17L));
        lyon.setLabel("Lyon");
        answer1.addChoices(lyon, grenoble);
        answer2.addChoices(grenoble, lyon);
        persister.insert((Iterable)Arrays.asList((Object[])new Answer[]{answer1, answer2}));
        PersistenceContext.ExecutableBeanPropertyQueryMapper trioExecutableQuery = this.persistenceContext.newQuery((CharSequence)"select answer_id, choices_id, myIdx from answer_choices", Trio.class).mapKey((SerializableTriFunction & Serializable)(x$0, x$1, x$2) -> Trio.forInteger(x$0, x$1, x$2), "answer_id", "choices_id", "myIdx");
        Set choiceAnswerIds = (Set)trioExecutableQuery.execute(Accumulators.toSet());
        Assertions.assertThat((Collection)choiceAnswerIds).containsExactlyInAnyOrder((Object[])new Trio[]{new Trio<Integer, Integer, Integer>(1, 17, 1), new Trio<Integer, Integer, Integer>(1, 13, 2), new Trio<Integer, Integer, Integer>(2, 13, 1), new Trio<Integer, Integer, Integer>(2, 17, 2)});
    }

    @Test
    void select_collectionFactory() throws SQLException {
        EntityPersister answerPersister = MappingEase.entityBuilder(Answer.class, Identifier.LONG_TYPE).mapKey(Answer::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).mapManyToMany(Answer::getChoices, CHOICE_MAPPING_CONFIGURATION).initializeWith(() -> new TreeSet<Choice>(Comparator.comparing(Choice::getLabel))).build(this.persistenceContext);
        DDLDeployer ddlDeployer = new DDLDeployer(this.persistenceContext);
        ddlDeployer.deployDDL();
        this.persistenceContext.getConnectionProvider().giveConnection().prepareStatement("insert into Answer(id) values (42)").execute();
        this.persistenceContext.getConnectionProvider().giveConnection().prepareStatement("insert into Choice(id, label) values (1, 'Paris')").execute();
        this.persistenceContext.getConnectionProvider().giveConnection().prepareStatement("insert into Choice(id, label) values (2, 'Lyon')").execute();
        this.persistenceContext.getConnectionProvider().giveConnection().prepareStatement("insert into Answer_Choices(answer_id, choices_id) values (42, 1), (42, 2)").execute();
        Answer loadedAnswer = (Answer)answerPersister.select(new PersistedIdentifier<Long>(42L));
        Assertions.assertThat(loadedAnswer.getChoices().getClass()).isEqualTo(TreeSet.class);
        Assertions.assertThat(loadedAnswer.getChoices()).extracting(Choice::getLabel).containsExactly((Object[])new String[]{"Lyon", "Paris"});
    }

    @Test
    void select_noRecordInAssociationTable_mustReturnEmptyCollection() throws SQLException {
        EntityPersister answerPersister = MappingEase.entityBuilder(Answer.class, Identifier.LONG_TYPE).mapKey(Answer::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).mapManyToMany(Answer::getChoices, CHOICE_MAPPING_CONFIGURATION).cascading(CascadeOptions.RelationMode.READ_ONLY).build(this.persistenceContext);
        Assertions.assertThat((Object)((OptimizedUpdatePersister)answerPersister).getSurrogate().getEntityJoinTree().getJoin("Answer_Choices0")).isNull();
        DDLDeployer ddlDeployer = new DDLDeployer(this.persistenceContext);
        ddlDeployer.deployDDL();
        this.persistenceContext.getConnectionProvider().giveConnection().createStatement().executeUpdate("insert into Answer(id) values (42)");
        Answer loadedAnswer = (Answer)answerPersister.select(new PersistedIdentifier<Long>(42L));
        Assertions.assertThat(loadedAnswer.getChoices()).isEqualTo(null);
    }

    private static /* synthetic */ Iterator lambda$foreignKeysAreCreated_targetTableSpecified$1(ResultSetIterator fkChoiceIterator) {
        return fkChoiceIterator;
    }

    private static /* synthetic */ Iterator lambda$foreignKeysAreCreated$0(ResultSetIterator fkChoiceIterator) {
        return fkChoiceIterator;
    }

    private static class Choice
    implements Identified<Long> {
        private Identifier<Long> id;
        private String label;

        public Choice() {
        }

        private Choice(long id) {
            this.id = new PersistableIdentifier<Long>(id);
        }

        public Choice(Identifier<Long> id) {
            this.id = id;
        }

        @Override
        public Identifier<Long> getId() {
            return this.id;
        }

        public String getLabel() {
            return this.label;
        }

        public void setLabel(String label) {
            this.label = label;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Choice)) {
                return false;
            }
            Choice choice = (Choice)o;
            return Objects.equals(this.id, choice.id);
        }

        public int hashCode() {
            return Objects.hashCode(this.id);
        }

        public String toString() {
            return "Choice{id=" + this.id.getSurrogate() + ", label='" + this.label + '\'' + '}';
        }
    }

    public static class Answer
    implements Identified<Long> {
        private Identifier<Long> id;
        private String comment;
        private Set<Choice> choices;

        private Answer() {
        }

        private Answer(Long id) {
            this(new PersistableIdentifier<Long>(id));
        }

        private Answer(Identifier<Long> id) {
            this.id = id;
        }

        public Answer(Choice choice) {
            this.choices.add(choice);
        }

        @Override
        public Identifier<Long> getId() {
            return this.id;
        }

        public String getComment() {
            return this.comment;
        }

        public void setComment(String comment) {
            this.comment = comment;
        }

        public Set<Choice> getChoices() {
            return this.choices;
        }

        public void addChoices(Collection<Choice> choices) {
            this.choices.addAll(choices);
        }

        public void addChoices(Choice ... choices) {
            if (this.choices == null) {
                this.choices = new LinkedHashSet<Choice>();
            }
            this.choices.addAll(Arrays.asList((Object[])choices));
        }

        public void setChoices(Set<Choice> choices) {
            this.choices = choices;
        }
    }

    @Nested
    class CascadeAssociationOnly {
        CascadeAssociationOnly() {
        }

        @Test
        void insert_associationRecordsMustBeInserted_butNotTargetEntities() throws SQLException {
            EntityPersister answerPersister = MappingEase.entityBuilder(Answer.class, Identifier.LONG_TYPE).mapKey(Answer::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).mapOneToMany(Answer::getChoices, (EntityMappingConfigurationProvider)CHOICE_MAPPING_CONFIGURATION).cascading(CascadeOptions.RelationMode.ASSOCIATION_ONLY).build(FluentEntityMappingConfigurationSupportManyToManySetTest.this.persistenceContext);
            DDLDeployer ddlDeployer = new DDLDeployer(FluentEntityMappingConfigurationSupportManyToManySetTest.this.persistenceContext);
            ddlDeployer.deployDDL();
            FluentEntityMappingConfigurationSupportManyToManySetTest.this.persistenceContext.getConnectionProvider().giveConnection().createStatement().executeUpdate("insert into Choice(id) values (100), (200), (300)");
            Answer answer1 = new Answer(new PersistableIdentifier<Long>(42L));
            Choice choice1 = new Choice(new PersistableIdentifier<Long>(100L));
            Choice choice2 = new Choice(new PersistableIdentifier<Long>(200L));
            answer1.addChoices(choice1, choice2);
            Answer answer2 = new Answer(new PersistableIdentifier<Long>(666L));
            Choice choice3 = new Choice(new PersistableIdentifier<Long>(300L));
            answer2.addChoices(choice3);
            answerPersister.insert((Iterable)Arrays.asList((Object[])new Answer[]{answer1, answer2}));
            PersistenceContext.ExecutableBeanPropertyQueryMapper longExecutableQuery1 = FluentEntityMappingConfigurationSupportManyToManySetTest.this.persistenceContext.newQuery((CharSequence)"select id from Answer where id in (42, 666)", Long.class).mapKey("id", Long.class);
            Set answerIds = (Set)longExecutableQuery1.execute(Accumulators.toSet());
            Assertions.assertThat((Collection)answerIds).containsExactlyInAnyOrder((Object[])new Long[]{(Long)answer1.getId().getSurrogate(), (Long)answer2.getId().getSurrogate()});
            PersistenceContext.ExecutableBeanPropertyQueryMapper longExecutableQuery = FluentEntityMappingConfigurationSupportManyToManySetTest.this.persistenceContext.newQuery((CharSequence)"select choices_Id from Answer_choices where answer_id in (42, 666)", Long.class).mapKey("choices_id", Long.class);
            Set choicesInRelationIds = (Set)longExecutableQuery.execute(Accumulators.toSet());
            Assertions.assertThat((Collection)choicesInRelationIds).containsExactlyInAnyOrder((Object[])new Long[]{(Long)choice1.getId().getSurrogate(), (Long)choice2.getId().getSurrogate(), (Long)choice3.getId().getSurrogate()});
        }

        @Test
        void update_associationRecordsMustBeUpdated_butNotTargetEntities() throws SQLException {
            EntityPersister answerPersister = MappingEase.entityBuilder(Answer.class, Identifier.LONG_TYPE).mapKey(Answer::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Answer::getComment).mapOneToMany(Answer::getChoices, (EntityMappingConfigurationProvider)CHOICE_MAPPING_CONFIGURATION).cascading(CascadeOptions.RelationMode.ASSOCIATION_ONLY).build(FluentEntityMappingConfigurationSupportManyToManySetTest.this.persistenceContext);
            DDLDeployer ddlDeployer = new DDLDeployer(FluentEntityMappingConfigurationSupportManyToManySetTest.this.persistenceContext);
            ddlDeployer.deployDDL();
            FluentEntityMappingConfigurationSupportManyToManySetTest.this.persistenceContext.getConnectionProvider().giveConnection().createStatement().executeUpdate("insert into Choice(id) values (100), (200)");
            Answer answer1 = new Answer(new PersistableIdentifier<Long>(42L));
            answer1.setComment("Hello world !");
            Choice choice1 = new Choice(new PersistableIdentifier<Long>(100L));
            Choice choice2 = new Choice(new PersistableIdentifier<Long>(200L));
            answer1.addChoices(choice1, choice2);
            answerPersister.insert((Object)answer1);
            choice1.setLabel("Grenoble");
            answerPersister.update((Object)answer1, answerPersister.select(answer1.getId()), true);
            String answerComment = (String)FluentEntityMappingConfigurationSupportManyToManySetTest.this.persistenceContext.newQuery((CharSequence)"select comment from Answer where id = 42", String.class).mapKey("comment", String.class).execute(Accumulators.getFirst());
            Assertions.assertThat((String)answerComment).isEqualTo(answer1.getComment());
            PersistenceContext.ExecutableBeanPropertyQueryMapper stringExecutableQuery1 = FluentEntityMappingConfigurationSupportManyToManySetTest.this.persistenceContext.newQuery((CharSequence)"select label from Choice where id = 100", String.class).mapKey("label", String.class);
            Set choiceLabels = (Set)stringExecutableQuery1.execute(Accumulators.toSet());
            Assertions.assertThat((Collection)choiceLabels).containsExactlyInAnyOrder((Object[])new String[]{null});
            Assertions.assertThat((int)answer1.getChoices().size()).isEqualTo(2);
            answer1.getChoices().remove(choice1);
            Assertions.assertThat((int)answer1.getChoices().size()).isEqualTo(1);
            answerPersister.update((Object)answer1, answerPersister.select(answer1.getId()), true);
            PersistenceContext.ExecutableBeanPropertyQueryMapper stringExecutableQuery = FluentEntityMappingConfigurationSupportManyToManySetTest.this.persistenceContext.newQuery((CharSequence)"select label from Choice where id = 100", String.class).mapKey("label", String.class);
            choiceLabels = (Set)stringExecutableQuery.execute(Accumulators.toSet());
            Assertions.assertThat((Collection)choiceLabels).containsExactlyInAnyOrder((Object[])new String[]{null});
        }

        @Test
        void delete_associationRecordsMustBeDeleted_butNotTargetEntities() throws SQLException {
            EntityPersister answerPersister = MappingEase.entityBuilder(Answer.class, Identifier.LONG_TYPE).mapKey(Answer::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).mapManyToMany(Answer::getChoices, (EntityMappingConfigurationProvider)CHOICE_MAPPING_CONFIGURATION).cascading(CascadeOptions.RelationMode.ASSOCIATION_ONLY).build(FluentEntityMappingConfigurationSupportManyToManySetTest.this.persistenceContext);
            DDLDeployer ddlDeployer = new DDLDeployer(FluentEntityMappingConfigurationSupportManyToManySetTest.this.persistenceContext);
            ddlDeployer.deployDDL();
            FluentEntityMappingConfigurationSupportManyToManySetTest.this.persistenceContext.getConnectionProvider().giveConnection().createStatement().executeUpdate("insert into Answer(id) values (42, 666)");
            FluentEntityMappingConfigurationSupportManyToManySetTest.this.persistenceContext.getConnectionProvider().giveConnection().createStatement().executeUpdate("insert into Choice(id) values (100), (200), (300)");
            FluentEntityMappingConfigurationSupportManyToManySetTest.this.persistenceContext.getConnectionProvider().giveConnection().createStatement().executeUpdate("insert into Answer_choices(answer_Id, choices_Id) values (42, 100), (42, 200), (666, 300)");
            Answer answer1 = new Answer(new PersistedIdentifier<Long>(42L));
            Choice choice1 = new Choice(new PersistedIdentifier<Long>(100L));
            Choice choice2 = new Choice(new PersistedIdentifier<Long>(200L));
            answer1.addChoices(choice1, choice2);
            Answer answer2 = new Answer(new PersistedIdentifier<Long>(666L));
            Choice choice3 = new Choice(new PersistedIdentifier<Long>(300L));
            answer2.addChoices(choice3);
            answerPersister.delete((Object)answer1);
            Long answerCount = (Long)FluentEntityMappingConfigurationSupportManyToManySetTest.this.persistenceContext.newQuery((CharSequence)"select count(*) as answerCount from Answer where id = 42", Long.class).mapKey("answerCount", Long.class).execute(Accumulators.getFirst());
            Assertions.assertThat((Long)answerCount).isEqualTo(0L);
            Long relationCount = (Long)FluentEntityMappingConfigurationSupportManyToManySetTest.this.persistenceContext.newQuery((CharSequence)"select count(*) as relationCount from Answer_choices where answer_Id = 42", Long.class).mapKey("relationCount", Long.class).execute(Accumulators.getFirst());
            Assertions.assertThat((Long)relationCount).isEqualTo(0L);
            PersistenceContext.ExecutableBeanPropertyQueryMapper longExecutableQuery3 = FluentEntityMappingConfigurationSupportManyToManySetTest.this.persistenceContext.newQuery((CharSequence)"select id from Choice where id in (100, 200)", Long.class).mapKey("id", Long.class);
            Set choiceIds = (Set)longExecutableQuery3.execute(Accumulators.toSet());
            Assertions.assertThat((Collection)choiceIds).containsExactlyInAnyOrder((Object[])new Long[]{100L, 200L});
            PersistenceContext.ExecutableBeanPropertyQueryMapper longExecutableQuery2 = FluentEntityMappingConfigurationSupportManyToManySetTest.this.persistenceContext.newQuery((CharSequence)"select id from Answer where id = 666", Long.class).mapKey("id", Long.class);
            Set answerIds = (Set)longExecutableQuery2.execute(Accumulators.toSet());
            Assertions.assertThat((Collection)answerIds).containsExactlyInAnyOrder((Object[])new Long[]{666L});
            PersistenceContext.ExecutableBeanPropertyQueryMapper longExecutableQuery1 = FluentEntityMappingConfigurationSupportManyToManySetTest.this.persistenceContext.newQuery((CharSequence)"select id from Choice where id = 300", Long.class).mapKey("id", Long.class);
            choiceIds = (Set)longExecutableQuery1.execute(Accumulators.toSet());
            Assertions.assertThat((Collection)choiceIds).containsExactlyInAnyOrder((Object[])new Long[]{300L});
            answerPersister.delete((Object)answer2);
            answerCount = (Long)FluentEntityMappingConfigurationSupportManyToManySetTest.this.persistenceContext.newQuery((CharSequence)"select count(*) as answerCount from Answer where id = 666", Long.class).mapKey("answerCount", Long.class).execute(Accumulators.getFirst());
            Assertions.assertThat((Long)answerCount).isEqualTo(0L);
            relationCount = (Long)FluentEntityMappingConfigurationSupportManyToManySetTest.this.persistenceContext.newQuery((CharSequence)"select count(*) as relationCount from Answer_choices where answer_Id = 666", Long.class).mapKey("relationCount", Long.class).execute(Accumulators.getFirst());
            Assertions.assertThat((Long)relationCount).isEqualTo(0L);
            PersistenceContext.ExecutableBeanPropertyQueryMapper longExecutableQuery = FluentEntityMappingConfigurationSupportManyToManySetTest.this.persistenceContext.newQuery((CharSequence)"select id from Choice where id = 300", Long.class).mapKey("id", Long.class);
            choiceIds = (Set)longExecutableQuery.execute(Accumulators.toSet());
            Assertions.assertThat((Collection)choiceIds).containsExactlyInAnyOrder((Object[])new Long[]{300L});
        }
    }

    @Nested
    class CascadeAllOrphanRemoval {
        CascadeAllOrphanRemoval() {
        }

        @Test
        void update_removedElementsAreDeleted() {
            EntityPersister answerPersister = MappingEase.entityBuilder(Answer.class, Identifier.LONG_TYPE).mapKey(Answer::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).mapOneToMany(Answer::getChoices, (EntityMappingConfigurationProvider)CHOICE_MAPPING_CONFIGURATION).cascading(CascadeOptions.RelationMode.ALL_ORPHAN_REMOVAL).build(FluentEntityMappingConfigurationSupportManyToManySetTest.this.persistenceContext);
            DDLDeployer ddlDeployer = new DDLDeployer(FluentEntityMappingConfigurationSupportManyToManySetTest.this.persistenceContext);
            ddlDeployer.deployDDL();
            LongProvider answerIdProvider = new LongProvider();
            Answer dummyAnswer = new Answer((Long)answerIdProvider.giveNewIdentifier());
            LongProvider cityIdProvider = new LongProvider();
            Choice paris = new Choice((Long)cityIdProvider.giveNewIdentifier());
            paris.setLabel("Paris");
            dummyAnswer.addChoices(paris);
            Choice lyon = new Choice((Long)cityIdProvider.giveNewIdentifier());
            lyon.setLabel("Lyon");
            dummyAnswer.addChoices(lyon);
            answerPersister.insert((Object)dummyAnswer);
            Answer persistedAnswer = (Answer)answerPersister.select(dummyAnswer.getId());
            persistedAnswer.getChoices().remove(paris);
            Choice grenoble = new Choice((Long)cityIdProvider.giveNewIdentifier());
            grenoble.setLabel("Grenoble");
            persistedAnswer.addChoices(grenoble);
            ((Choice)Iterables.first(persistedAnswer.getChoices())).setLabel("changed");
            answerPersister.update((Object)persistedAnswer, (Object)dummyAnswer, true);
            Answer persistedAnswer2 = (Answer)answerPersister.select(dummyAnswer.getId());
            Assertions.assertThat(persistedAnswer2.getChoices()).isEqualTo((Object)Arrays.asHashSet((Object[])new Choice[]{lyon, grenoble}));
            Assertions.assertThat(persistedAnswer2.getChoices()).extracting(Choice::getLabel).containsExactlyInAnyOrder((Object[])new String[]{"changed", "Grenoble"});
        }

        @Test
        void delete_associationRecordsMustBeDeleted() throws SQLException {
            EntityPersister answerPersister = MappingEase.entityBuilder(Answer.class, Identifier.LONG_TYPE).mapKey(Answer::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).mapOneToMany(Answer::getChoices, (EntityMappingConfigurationProvider)CHOICE_MAPPING_CONFIGURATION).cascading(CascadeOptions.RelationMode.ALL_ORPHAN_REMOVAL).build(FluentEntityMappingConfigurationSupportManyToManySetTest.this.persistenceContext);
            DDLDeployer ddlDeployer = new DDLDeployer(FluentEntityMappingConfigurationSupportManyToManySetTest.this.persistenceContext);
            ddlDeployer.deployDDL();
            FluentEntityMappingConfigurationSupportManyToManySetTest.this.persistenceContext.getConnectionProvider().giveConnection().createStatement().executeUpdate("insert into Answer(id) values (42, 666)");
            FluentEntityMappingConfigurationSupportManyToManySetTest.this.persistenceContext.getConnectionProvider().giveConnection().createStatement().executeUpdate("insert into Choice(id) values (100), (200), (300)");
            FluentEntityMappingConfigurationSupportManyToManySetTest.this.persistenceContext.getConnectionProvider().giveConnection().createStatement().executeUpdate("insert into Answer_choices(answer_Id, choices_Id) values (42, 100), (42, 200), (666, 300)");
            Answer answer1 = new Answer(new PersistedIdentifier<Long>(42L));
            Choice city1 = new Choice(new PersistedIdentifier<Long>(100L));
            Choice city2 = new Choice(new PersistedIdentifier<Long>(200L));
            answer1.addChoices(city1, city2);
            Answer answer2 = new Answer(new PersistedIdentifier<Long>(666L));
            Choice city3 = new Choice(new PersistedIdentifier<Long>(300L));
            answer2.addChoices(city3);
            answerPersister.delete((Object)answer1);
            Long answerCount = (Long)FluentEntityMappingConfigurationSupportManyToManySetTest.this.persistenceContext.newQuery((CharSequence)"select count(*) as answerCount from Answer where id = 42", Long.class).mapKey("answerCount", Long.class).execute(Accumulators.getFirst());
            Assertions.assertThat((Long)answerCount).isEqualTo(0L);
            Long relationCount = (Long)FluentEntityMappingConfigurationSupportManyToManySetTest.this.persistenceContext.newQuery((CharSequence)"select count(*) as relationCount from Answer_choices where answer_Id = 42", Long.class).mapKey("relationCount", Long.class).execute(Accumulators.getFirst());
            Assertions.assertThat((Long)relationCount).isEqualTo(0L);
            PersistenceContext.ExecutableBeanPropertyQueryMapper longExecutableQuery3 = FluentEntityMappingConfigurationSupportManyToManySetTest.this.persistenceContext.newQuery((CharSequence)"select id from Choice where id in (100, 200)", Long.class).mapKey("id", Long.class);
            Set choiceIds = (Set)longExecutableQuery3.execute(Accumulators.toSet());
            Assertions.assertThat((Collection)choiceIds).isEmpty();
            PersistenceContext.ExecutableBeanPropertyQueryMapper longExecutableQuery2 = FluentEntityMappingConfigurationSupportManyToManySetTest.this.persistenceContext.newQuery((CharSequence)"select id from Answer where id = 666", Long.class).mapKey("id", Long.class);
            Set answerIds = (Set)longExecutableQuery2.execute(Accumulators.toSet());
            Assertions.assertThat((Collection)answerIds).containsExactlyInAnyOrder((Object[])new Long[]{666L});
            PersistenceContext.ExecutableBeanPropertyQueryMapper longExecutableQuery1 = FluentEntityMappingConfigurationSupportManyToManySetTest.this.persistenceContext.newQuery((CharSequence)"select id from Choice where id = 300", Long.class).mapKey("id", Long.class);
            choiceIds = (Set)longExecutableQuery1.execute(Accumulators.toSet());
            Assertions.assertThat((Collection)choiceIds).containsExactlyInAnyOrder((Object[])new Long[]{300L});
            answerPersister.delete((Object)answer2);
            answerCount = (Long)FluentEntityMappingConfigurationSupportManyToManySetTest.this.persistenceContext.newQuery((CharSequence)"select count(*) as answerCount from Answer where id = 666", Long.class).mapKey("answerCount", Long.class).execute(Accumulators.getFirst());
            Assertions.assertThat((Long)answerCount).isEqualTo(0L);
            relationCount = (Long)FluentEntityMappingConfigurationSupportManyToManySetTest.this.persistenceContext.newQuery((CharSequence)"select count(*) as relationCount from Answer_choices where answer_Id = 666", Long.class).mapKey("relationCount", Long.class).execute(Accumulators.getFirst());
            Assertions.assertThat((Long)relationCount).isEqualTo(0L);
            PersistenceContext.ExecutableBeanPropertyQueryMapper longExecutableQuery = FluentEntityMappingConfigurationSupportManyToManySetTest.this.persistenceContext.newQuery((CharSequence)"select id from Choice where id = 300", Long.class).mapKey("id", Long.class);
            choiceIds = (Set)longExecutableQuery.execute(Accumulators.toSet());
            Assertions.assertThat((Collection)choiceIds).isEmpty();
        }
    }

    @Nested
    class CascadeAll {
        CascadeAll() {
        }

        @Test
        void update_associationTableIsMaintained() {
            EntityPersister answerPersister = MappingEase.entityBuilder(Answer.class, Identifier.LONG_TYPE).mapKey(Answer::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).mapOneToMany(Answer::getChoices, (EntityMappingConfigurationProvider)CHOICE_MAPPING_CONFIGURATION).cascading(CascadeOptions.RelationMode.ALL).build(FluentEntityMappingConfigurationSupportManyToManySetTest.this.persistenceContext);
            DDLDeployer ddlDeployer = new DDLDeployer(FluentEntityMappingConfigurationSupportManyToManySetTest.this.persistenceContext);
            ddlDeployer.deployDDL();
            LongProvider answerIdProvider = new LongProvider();
            Answer dummyAnswer = new Answer((Long)answerIdProvider.giveNewIdentifier());
            LongProvider cityIdProvider = new LongProvider();
            Choice paris = new Choice((Long)cityIdProvider.giveNewIdentifier());
            paris.setLabel("Paris");
            dummyAnswer.addChoices(paris);
            Choice lyon = new Choice((Long)cityIdProvider.giveNewIdentifier());
            lyon.setLabel("Lyon");
            dummyAnswer.addChoices(lyon);
            answerPersister.insert((Object)dummyAnswer);
            Answer persistedAnswer = (Answer)answerPersister.select(dummyAnswer.getId());
            persistedAnswer.getChoices().remove(paris);
            Choice grenoble = new Choice((Long)cityIdProvider.giveNewIdentifier());
            grenoble.setLabel("Grenoble");
            persistedAnswer.addChoices(grenoble);
            ((Choice)Iterables.first(persistedAnswer.getChoices())).setLabel("changed");
            answerPersister.update((Object)persistedAnswer, (Object)dummyAnswer, true);
            Answer persistedAnswer2 = (Answer)answerPersister.select(dummyAnswer.getId());
            Assertions.assertThat(persistedAnswer2.getChoices()).extracting(Choice::getLabel).containsExactlyInAnyOrder((Object[])new String[]{"changed", "Grenoble"});
        }

        @Test
        void delete_associationRecordsMustBeDeleted() throws SQLException {
            EntityPersister answerPersister = MappingEase.entityBuilder(Answer.class, Identifier.LONG_TYPE).mapKey(Answer::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).mapOneToMany(Answer::getChoices, (EntityMappingConfigurationProvider)CHOICE_MAPPING_CONFIGURATION).cascading(CascadeOptions.RelationMode.ALL).build(FluentEntityMappingConfigurationSupportManyToManySetTest.this.persistenceContext);
            DDLDeployer ddlDeployer = new DDLDeployer(FluentEntityMappingConfigurationSupportManyToManySetTest.this.persistenceContext);
            ddlDeployer.deployDDL();
            FluentEntityMappingConfigurationSupportManyToManySetTest.this.persistenceContext.getConnectionProvider().giveConnection().createStatement().executeUpdate("insert into Answer(id) values (42, 666)");
            FluentEntityMappingConfigurationSupportManyToManySetTest.this.persistenceContext.getConnectionProvider().giveConnection().createStatement().executeUpdate("insert into Choice(id) values (100), (200), (300)");
            FluentEntityMappingConfigurationSupportManyToManySetTest.this.persistenceContext.getConnectionProvider().giveConnection().createStatement().executeUpdate("insert into Answer_choices(answer_Id, choices_Id) values (42, 100), (42, 200), (666, 300)");
            Answer answer1 = new Answer(new PersistedIdentifier<Long>(42L));
            Choice city1 = new Choice(new PersistedIdentifier<Long>(100L));
            Choice city2 = new Choice(new PersistedIdentifier<Long>(200L));
            answer1.addChoices(city1, city2);
            Answer answer2 = new Answer(new PersistedIdentifier<Long>(666L));
            Choice city3 = new Choice(new PersistedIdentifier<Long>(300L));
            answer2.addChoices(city3);
            answerPersister.delete((Object)answer1);
            Long answerCount = (Long)FluentEntityMappingConfigurationSupportManyToManySetTest.this.persistenceContext.newQuery((CharSequence)"select count(*) as answerCount from Answer where id = 42", Long.class).mapKey("answerCount", Long.class).execute(Accumulators.getFirst());
            Assertions.assertThat((Long)answerCount).isEqualTo(0L);
            Long relationCount = (Long)FluentEntityMappingConfigurationSupportManyToManySetTest.this.persistenceContext.newQuery((CharSequence)"select count(*) as relationCount from Answer_choices where answer_Id = 42", Long.class).mapKey("relationCount", Long.class).execute(Accumulators.getFirst());
            Assertions.assertThat((Long)relationCount).isEqualTo(0L);
            PersistenceContext.ExecutableBeanPropertyQueryMapper longExecutableQuery3 = FluentEntityMappingConfigurationSupportManyToManySetTest.this.persistenceContext.newQuery((CharSequence)"select id from Choice where id in (100, 200)", Long.class).mapKey("id", Long.class);
            Set choiceIds = (Set)longExecutableQuery3.execute(Accumulators.toSet());
            Assertions.assertThat((Collection)choiceIds).containsExactlyInAnyOrder((Object[])new Long[]{100L, 200L});
            PersistenceContext.ExecutableBeanPropertyQueryMapper longExecutableQuery2 = FluentEntityMappingConfigurationSupportManyToManySetTest.this.persistenceContext.newQuery((CharSequence)"select id from Answer where id = 666", Long.class).mapKey("id", Long.class);
            Set answerIds = (Set)longExecutableQuery2.execute(Accumulators.toSet());
            Assertions.assertThat((Collection)answerIds).containsExactlyInAnyOrder((Object[])new Long[]{666L});
            PersistenceContext.ExecutableBeanPropertyQueryMapper longExecutableQuery1 = FluentEntityMappingConfigurationSupportManyToManySetTest.this.persistenceContext.newQuery((CharSequence)"select id from Choice where id = 300", Long.class).mapKey("id", Long.class);
            choiceIds = (Set)longExecutableQuery1.execute(Accumulators.toSet());
            Assertions.assertThat((Collection)choiceIds).containsExactlyInAnyOrder((Object[])new Long[]{300L});
            answerPersister.delete((Object)answer2);
            answerCount = (Long)FluentEntityMappingConfigurationSupportManyToManySetTest.this.persistenceContext.newQuery((CharSequence)"select count(*) as answerCount from Answer where id = 666", Long.class).mapKey("answerCount", Long.class).execute(Accumulators.getFirst());
            Assertions.assertThat((Long)answerCount).isEqualTo(0L);
            relationCount = (Long)FluentEntityMappingConfigurationSupportManyToManySetTest.this.persistenceContext.newQuery((CharSequence)"select count(*) as relationCount from Answer_choices where answer_Id = 666", Long.class).mapKey("relationCount", Long.class).execute(Accumulators.getFirst());
            Assertions.assertThat((Long)relationCount).isEqualTo(0L);
            PersistenceContext.ExecutableBeanPropertyQueryMapper longExecutableQuery = FluentEntityMappingConfigurationSupportManyToManySetTest.this.persistenceContext.newQuery((CharSequence)"select id from Choice where id = 300", Long.class).mapKey("id", Long.class);
            choiceIds = (Set)longExecutableQuery.execute(Accumulators.toSet());
            Assertions.assertThat((Collection)choiceIds).containsExactlyInAnyOrder((Object[])new Long[]{300L});
        }
    }

    @Nested
    class CascadeReadOnly {
        CascadeReadOnly() {
        }

        @Test
        void insert_onlySourceEntitiesArePersisted() {
            EntityPersister answerPersister = MappingEase.entityBuilder(Answer.class, Identifier.LONG_TYPE).mapKey(Answer::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).mapManyToMany(Answer::getChoices, (EntityMappingConfigurationProvider)CHOICE_MAPPING_CONFIGURATION).cascading(CascadeOptions.RelationMode.READ_ONLY).build(FluentEntityMappingConfigurationSupportManyToManySetTest.this.persistenceContext);
            DDLDeployer ddlDeployer = new DDLDeployer(FluentEntityMappingConfigurationSupportManyToManySetTest.this.persistenceContext);
            ddlDeployer.deployDDL();
            Answer answer = new Answer(new PersistableIdentifier<Long>(1L));
            Choice grenoble = new Choice(new PersistableIdentifier<Long>(13L));
            grenoble.setLabel("Grenoble");
            Choice lyon = new Choice(new PersistableIdentifier<Long>(17L));
            lyon.setLabel("Lyon");
            answer.addChoices(grenoble, lyon);
            answerPersister.insert((Object)answer);
            PersistenceContext.ExecutableBeanPropertyQueryMapper longExecutableQuery = FluentEntityMappingConfigurationSupportManyToManySetTest.this.persistenceContext.newQuery((CharSequence)"select id from answer", Long.class).mapKey("id", Long.class);
            Set answerIds = (Set)longExecutableQuery.execute(Accumulators.toSet());
            Assertions.assertThat((Collection)answerIds).containsExactlyInAnyOrder((Object[])new Long[]{(Long)answer.getId().getSurrogate()});
            Long choiceAnswerCount = (Long)FluentEntityMappingConfigurationSupportManyToManySetTest.this.persistenceContext.newQuery((CharSequence)"select count(*) as relationCount from answer_choices", Long.class).mapKey("relationCount", Long.class).execute(Accumulators.getFirst());
            Assertions.assertThat((Long)choiceAnswerCount).isEqualTo(0L);
            Long choiceCount = (Long)FluentEntityMappingConfigurationSupportManyToManySetTest.this.persistenceContext.newQuery((CharSequence)"select count(*) as choiceCount from choice", Long.class).mapKey("choiceCount", Long.class).execute(Accumulators.getFirst());
            Assertions.assertThat((Long)choiceCount).isEqualTo(0L);
        }
    }

    private static class Trio<L, M, R> {
        private final L left;
        private final M middle;
        private final R right;

        private static Trio<Integer, Integer, Integer> forInteger(Integer left, Integer middle, Integer right) {
            return new Trio<Integer, Integer, Integer>(left, middle, right);
        }

        public Trio(L left, M middle, R right) {
            this.left = left;
            this.middle = middle;
            this.right = right;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Trio trio = (Trio)o;
            return Objects.equals(this.left, trio.left) && Objects.equals(this.middle, trio.middle) && Objects.equals(this.right, trio.right);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.left, this.middle, this.right});
        }

        public String toString() {
            return "{left=" + this.left + ", middle=" + this.middle + ", right=" + this.right + '}';
        }
    }
}

