/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.runtime;

import java.sql.ResultSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.codefilarete.stalactite.engine.runtime.ConfiguredRelationalPersister;
import org.codefilarete.stalactite.engine.runtime.load.EntityInflater;
import org.codefilarete.stalactite.engine.runtime.load.EntityJoinTree;
import org.codefilarete.stalactite.engine.runtime.load.EntityTreeQueryBuilder;
import org.codefilarete.stalactite.engine.runtime.load.JoinRoot;
import org.codefilarete.stalactite.mapping.ColumnedRow;
import org.codefilarete.stalactite.mapping.RowTransformer;
import org.codefilarete.stalactite.mapping.id.assembly.IdentifierAssembler;
import org.codefilarete.stalactite.query.EntitySelector;
import org.codefilarete.stalactite.query.builder.QuerySQLBuilderFactory;
import org.codefilarete.stalactite.query.model.CriteriaChain;
import org.codefilarete.stalactite.query.model.Fromable;
import org.codefilarete.stalactite.query.model.Query;
import org.codefilarete.stalactite.query.model.QueryEase;
import org.codefilarete.stalactite.query.model.Select;
import org.codefilarete.stalactite.query.model.Selectable;
import org.codefilarete.stalactite.query.model.Union;
import org.codefilarete.stalactite.sql.ConnectionProvider;
import org.codefilarete.stalactite.sql.Dialect;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.stalactite.sql.result.Accumulator;
import org.codefilarete.stalactite.sql.result.Row;
import org.codefilarete.stalactite.sql.result.RowIterator;
import org.codefilarete.stalactite.sql.statement.PreparedSQL;
import org.codefilarete.stalactite.sql.statement.ReadOperation;
import org.codefilarete.stalactite.sql.statement.SQLExecutionException;
import org.codefilarete.stalactite.sql.statement.SQLStatement;
import org.codefilarete.stalactite.sql.statement.binder.ResultSetReader;
import org.codefilarete.stalactite.sql.statement.binder.ResultSetReaderRegistry;
import org.codefilarete.tool.VisibleForTesting;
import org.codefilarete.tool.collection.Iterables;
import org.codefilarete.tool.collection.KeepOrderMap;
import org.codefilarete.tool.collection.KeepOrderSet;

public class TablePerClassPolymorphismEntitySelector<C, I, T extends Table<T>>
implements EntitySelector<C, I> {
    @VisibleForTesting
    static final String DISCRIMINATOR_ALIAS = "DISCRIMINATOR";
    private final IdentifierAssembler<I, T> identifierAssembler;
    private final Map<Class<C>, ConfiguredRelationalPersister<C, I>> persisterPerSubclass;
    private final EntityJoinTree<C, I> mainEntityJoinTree;
    private final ConnectionProvider connectionProvider;
    private final Dialect dialect;
    private final T mainTable;
    private final Map<String, Class> discriminatorValues;
    private final TablePerClassEntityJoinTree<C, I> entityJoinTree;

    public TablePerClassPolymorphismEntitySelector(IdentifierAssembler<I, T> identifierAssembler, Map<? extends Class<C>, ? extends ConfiguredRelationalPersister<C, I>> persisterPerSubclass, EntityJoinTree<C, I> mainEntityJoinTree, ConnectionProvider connectionProvider, Dialect dialect) {
        this.identifierAssembler = identifierAssembler;
        this.persisterPerSubclass = persisterPerSubclass;
        this.mainEntityJoinTree = mainEntityJoinTree;
        this.connectionProvider = connectionProvider;
        this.dialect = dialect;
        this.mainTable = (Table)mainEntityJoinTree.getRoot().getTable();
        this.discriminatorValues = new HashMap<String, Class>();
        persisterPerSubclass.forEach((subEntityType, subEntityTable) -> this.discriminatorValues.put(subEntityType.getSimpleName(), (Class)subEntityType));
        this.entityJoinTree = this.buildEntityJoinTree();
    }

    TablePerClassEntityJoinTree<C, I> buildEntityJoinTree() {
        Map aliasPerColumnName = Iterables.map((Iterable)this.mainTable.getColumns(), Column::getName, Column::getName);
        KeepOrderSet queries = new KeepOrderSet();
        this.persisterPerSubclass.forEach((arg_0, arg_1) -> this.lambda$buildEntityJoinTree$1(aliasPerColumnName, (Set)queries, arg_0, arg_1));
        Union union = new Union((Collection)queries);
        queries.forEach(query -> query.getColumns().forEach(column -> union.registerColumn(column.getExpression(), column.getJavaType())));
        Union.UnionInFrom pseudoTable = union.asPseudoTable(this.mainTable.getName());
        TablePerClassEntityJoinTree result = new TablePerClassEntityJoinTree(pseudoTable, (Table)this.mainTable);
        this.mainEntityJoinTree.projectTo(result, "ROOT");
        return result;
    }

    private <SUBTABLE extends Table<SUBTABLE>> Query buildSubConfigurationQuery(String discriminatorValue, T mainTable, SUBTABLE subEntityTable, Map<String, String> aliasPerColumnName) {
        Map aliasPerColumn = Iterables.map((Iterable)mainTable.getColumns(), column -> subEntityTable.getColumn(column.getName()), c -> (String)aliasPerColumnName.get(c.getName()), KeepOrderMap::new);
        return (Query)QueryEase.select((Map)aliasPerColumn).add(discriminatorValue, String.class).as(DISCRIMINATOR_ALIAS).from(subEntityTable).getQuery();
    }

    @Override
    public Set<C> select(CriteriaChain where) {
        EntityTreeQueryBuilder.EntityTreeQuery<C> entityTreeQuery = new EntityTreeQueryBuilder<C>(this.entityJoinTree, (ResultSetReaderRegistry)this.dialect.getColumnBinderRegistry()).buildSelectQuery();
        Query query = entityTreeQuery.getQuery();
        IdentityHashMap<Selectable<?>, Selectable<?>> columnClones = entityTreeQuery.getColumnClones();
        IdentityHashMap originalColumnsToClones = new IdentityHashMap(columnClones.size());
        originalColumnsToClones.putAll(columnClones);
        originalColumnsToClones.putAll(this.entityJoinTree.getMainColumnToPseudoColumn());
        QuerySQLBuilderFactory.QuerySQLBuilder sqlQueryBuilder = this.dialect.getQuerySQLBuilderFactory().queryBuilder(query, where, originalColumnsToClones);
        query.getSelectSurrogate().clear();
        this.mainTable.getPrimaryKey().getColumns().forEach(pkColumn -> {
            Selectable column = this.mainEntityJoinTree.getRoot().getTable().findColumn(pkColumn.getName());
            query.select(column, pkColumn.getName());
        });
        query.select(DISCRIMINATOR_ALIAS, String.class);
        HashMap<String, ResultSetReader> columnReaders = new HashMap<String, ResultSetReader>();
        Map aliases = query.getAliases();
        aliases.forEach((selectable, s) -> {
            ResultSetReader reader = selectable instanceof Column ? this.dialect.getColumnBinderRegistry().getReader((Object)((Column)selectable)) : this.dialect.getColumnBinderRegistry().getReader(selectable.getJavaType());
            columnReaders.put((String)s, reader);
        });
        this.mainTable.getColumns().forEach(column -> aliases.put(column, column.getName()));
        columnReaders.put(DISCRIMINATOR_ALIAS, (ResultSetReader)this.dialect.getColumnBinderRegistry().getBinder(String.class));
        ColumnedRow columnedRow = new ColumnedRow(aliases::get);
        Map<Class, Set<I>> idsPerSubclass = this.readIds(sqlQueryBuilder.toPreparedSQL(), columnReaders, columnedRow);
        HashSet result = new HashSet();
        idsPerSubclass.forEach((subClass, subEntityIds) -> result.addAll(this.persisterPerSubclass.get(subClass).select((Iterable)subEntityIds)));
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map<Class, Set<I>> readIds(PreparedSQL preparedSQL, Map<String, ResultSetReader> columnReaders, ColumnedRow columnedRow) {
        try (ReadOperation closeableOperation = new ReadOperation((SQLStatement)preparedSQL, this.connectionProvider);){
            ResultSet resultSet = closeableOperation.execute();
            RowIterator rowIterator = new RowIterator(resultSet, columnReaders);
            KeepOrderMap idsPerSubclass = new KeepOrderMap();
            rowIterator.forEachRemaining(arg_0 -> this.lambda$readIds$11((Map)idsPerSubclass, columnedRow, arg_0));
            KeepOrderMap keepOrderMap = idsPerSubclass;
            return keepOrderMap;
        }
        catch (RuntimeException e) {
            throw new SQLExecutionException(preparedSQL.getSQL(), (Throwable)e);
        }
    }

    @Override
    public <R, O> R selectProjection(Consumer<Select> selectAdapter, Accumulator<? super Function<Selectable<O>, O>, Object, R> accumulator, CriteriaChain where, boolean distinct, Consumer<Query.FluentOrderByClause> orderByClauseConsumer) {
        EntityTreeQueryBuilder.EntityTreeQuery<C> entityTreeQuery = new EntityTreeQueryBuilder<C>(this.entityJoinTree, (ResultSetReaderRegistry)this.dialect.getColumnBinderRegistry()).buildSelectQuery();
        Query query = entityTreeQuery.getQuery();
        query.getSelectSurrogate().setDistinct(distinct);
        IdentityHashMap<Selectable<?>, Selectable<?>> columnClones = entityTreeQuery.getColumnClones();
        IdentityHashMap originalColumnsToClones = new IdentityHashMap(columnClones.size());
        originalColumnsToClones.putAll(columnClones);
        originalColumnsToClones.putAll(this.entityJoinTree.getMainColumnToPseudoColumn());
        QuerySQLBuilderFactory.QuerySQLBuilder sqlQueryBuilder = this.dialect.getQuerySQLBuilderFactory().queryBuilder(query, where, originalColumnsToClones);
        selectAdapter.accept(query.getSelectSurrogate());
        Map aliases = query.getAliases();
        ColumnedRow columnedRow = new ColumnedRow(aliases::get);
        Map columnReaders = Iterables.map((Iterable)query.getColumns(), new AliasAsserter(aliases::get), selectable -> this.dialect.getColumnBinderRegistry().getBinder(selectable.getJavaType()));
        PreparedSQL preparedSQL = sqlQueryBuilder.toPreparedSQL();
        return this.readProjection(preparedSQL, columnReaders, columnedRow, accumulator);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <R, O> R readProjection(PreparedSQL preparedSQL, Map<String, ResultSetReader<?>> columnReaders, ColumnedRow columnedRow, Accumulator<? super Function<Selectable<O>, O>, Object, R> accumulator) {
        try (ReadOperation closeableOperation = new ReadOperation((SQLStatement)preparedSQL, this.connectionProvider);){
            ResultSet resultSet = closeableOperation.execute();
            RowIterator rowIterator = new RowIterator(resultSet, columnReaders);
            Object object = accumulator.collect((Iterable)Iterables.stream((Iterator)rowIterator).map(row -> selectable -> columnedRow.getValue(selectable, row)).collect(Collectors.toList()));
            return (R)object;
        }
        catch (RuntimeException e) {
            throw new SQLExecutionException(preparedSQL.getSQL(), (Throwable)e);
        }
    }

    private /* synthetic */ void lambda$readIds$11(Map idsPerSubclass, ColumnedRow columnedRow, Row row) {
        String discriminatorValue = (String)row.get(DISCRIMINATOR_ALIAS);
        Class entitySubclass = this.discriminatorValues.get(discriminatorValue.trim());
        idsPerSubclass.computeIfAbsent(entitySubclass, k -> new HashSet()).add(this.identifierAssembler.assemble(row, columnedRow));
    }

    private /* synthetic */ void lambda$buildEntityJoinTree$1(Map aliasPerColumnName, Set queries, Class subEntityType, ConfiguredRelationalPersister subEntityPersister) {
        Query query = this.buildSubConfigurationQuery("'" + subEntityType.getSimpleName() + "'", this.mainTable, subEntityPersister.getMainTable(), aliasPerColumnName);
        queries.add(query);
    }

    private static class TablePerClassEntityJoinTree<C, I>
    extends EntityJoinTree<C, I> {
        private final IdentityHashMap<Column<?, ?>, Selectable<?>> mainColumnToPseudoColumn = new IdentityHashMap();

        public TablePerClassEntityJoinTree(final Union.UnionInFrom pseudoTable, Table mainTable) {
            super(new EntityInflater<C, I>(){

                @Override
                public Class<C> getEntityType() {
                    return null;
                }

                @Override
                public I giveIdentifier(Row row, ColumnedRow columnedRow) {
                    return null;
                }

                @Override
                public RowTransformer<C> copyTransformerWithAliases(ColumnedRow columnedRow) {
                    return null;
                }

                @Override
                public Set<Selectable<?>> getSelectableColumns() {
                    return pseudoTable.getColumns();
                }
            }, (Fromable)pseudoTable);
            pseudoTable.getColumns().forEach(pseudoColumn -> {
                Column column = mainTable.findColumn(pseudoColumn.getExpression());
                if (column != null) {
                    this.mainColumnToPseudoColumn.put((Column<?, ?>)column, (Selectable<?>)pseudoColumn);
                }
            });
        }

        @Override
        public JoinRoot<C, I, Union.UnionInFrom> getRoot() {
            return super.getRoot();
        }

        public IdentityHashMap<Column<?, ?>, Selectable<?>> getMainColumnToPseudoColumn() {
            return this.mainColumnToPseudoColumn;
        }
    }

    private static class AliasAsserter<S extends Selectable>
    implements Function<S, String> {
        private final Function<S, String> delegate;

        private AliasAsserter(Function<S, String> delegate) {
            this.delegate = delegate;
        }

        @Override
        public String apply(S selectable) {
            String alias = this.delegate.apply(selectable);
            if (alias == null) {
                throw new IllegalArgumentException("Item '" + selectable.getExpression() + "' must have an alias");
            }
            return alias;
        }
    }
}

