/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.runtime;

import java.sql.ResultSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.codefilarete.stalactite.engine.runtime.ConfiguredRelationalPersister;
import org.codefilarete.stalactite.engine.runtime.load.EntityJoinTree;
import org.codefilarete.stalactite.engine.runtime.load.EntityTreeQueryBuilder;
import org.codefilarete.stalactite.mapping.ColumnedRow;
import org.codefilarete.stalactite.query.EntitySelector;
import org.codefilarete.stalactite.query.builder.QuerySQLBuilderFactory;
import org.codefilarete.stalactite.query.model.CriteriaChain;
import org.codefilarete.stalactite.query.model.Query;
import org.codefilarete.stalactite.query.model.Select;
import org.codefilarete.stalactite.query.model.Selectable;
import org.codefilarete.stalactite.sql.ConnectionProvider;
import org.codefilarete.stalactite.sql.Dialect;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.Key;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.stalactite.sql.result.Accumulator;
import org.codefilarete.stalactite.sql.result.Row;
import org.codefilarete.stalactite.sql.result.RowIterator;
import org.codefilarete.stalactite.sql.statement.PreparedSQL;
import org.codefilarete.stalactite.sql.statement.ReadOperation;
import org.codefilarete.stalactite.sql.statement.SQLExecutionException;
import org.codefilarete.stalactite.sql.statement.SQLStatement;
import org.codefilarete.stalactite.sql.statement.binder.ResultSetReader;
import org.codefilarete.stalactite.sql.statement.binder.ResultSetReaderRegistry;
import org.codefilarete.tool.Duo;
import org.codefilarete.tool.collection.Iterables;
import org.codefilarete.tool.collection.KeepOrderMap;

public class JoinTablePolymorphismEntitySelector<C, I, T extends Table<T>>
implements EntitySelector<C, I> {
    private final Map<Class<C>, ConfiguredRelationalPersister<C, I>> persisterPerSubclass;
    private final T mainTable;
    private final EntityJoinTree<C, I> entityJoinTree;
    private final ConnectionProvider connectionProvider;
    private final Dialect dialect;

    public JoinTablePolymorphismEntitySelector(Map<? extends Class<C>, ? extends ConfiguredRelationalPersister<C, I>> persisterPerSubclass, T mainTable, EntityJoinTree<C, I> entityJoinTree, ConnectionProvider connectionProvider, Dialect dialect) {
        this.persisterPerSubclass = persisterPerSubclass;
        this.mainTable = mainTable;
        this.entityJoinTree = entityJoinTree;
        this.connectionProvider = connectionProvider;
        this.dialect = dialect;
    }

    @Override
    public Set<C> select(CriteriaChain where) {
        EntityTreeQueryBuilder.EntityTreeQuery<C> entityTreeQuery = new EntityTreeQueryBuilder<C>(this.entityJoinTree, (ResultSetReaderRegistry)this.dialect.getColumnBinderRegistry()).buildSelectQuery();
        Query query = entityTreeQuery.getQuery();
        this.persisterPerSubclass.values().forEach(subclassPersister -> {
            query.getFrom().leftOuterJoin((Key)this.mainTable.getPrimaryKey(), (Key)subclassPersister.getMainTable().getPrimaryKey());
            subclassPersister.getMainTable().getPrimaryKey().getColumns().forEach(column -> query.select((Selectable)column, column.getAlias()));
        });
        QuerySQLBuilderFactory.QuerySQLBuilder sqlQueryBuilder = this.dialect.getQuerySQLBuilderFactory().queryBuilder(query, where, entityTreeQuery.getColumnClones());
        HashMap<String, ResultSetReader> columnReaders = new HashMap<String, ResultSetReader>();
        Map aliases = query.getAliases();
        aliases.forEach((selectable, s) -> {
            ResultSetReader cfr_ignored_0 = (ResultSetReader)columnReaders.put((String)s, (ResultSetReader)this.dialect.getColumnBinderRegistry().getBinder((Object)((Column)selectable)));
        });
        ColumnedRow columnedRow = new ColumnedRow(aliases::get);
        Map<Class, Set<I>> idsPerSubtype = this.readIds(sqlQueryBuilder.toPreparedSQL(), columnReaders, columnedRow);
        HashSet result = new HashSet();
        idsPerSubtype.forEach((k, v) -> result.addAll(this.persisterPerSubclass.get(k).select((Iterable)v)));
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map<Class, Set<I>> readIds(PreparedSQL preparedSQL, Map<String, ResultSetReader> columnReaders, ColumnedRow columnedRow) {
        KeepOrderMap result = new KeepOrderMap();
        try (ReadOperation readOperation = new ReadOperation((SQLStatement)preparedSQL, this.connectionProvider);){
            ResultSet resultSet = readOperation.execute();
            RowIterator resultSetIterator = new RowIterator(resultSet, columnReaders);
            resultSetIterator.forEachRemaining(arg_0 -> this.lambda$readIds$5(columnedRow, (Map)result, arg_0));
            KeepOrderMap keepOrderMap = result;
            return keepOrderMap;
        }
        catch (RuntimeException e) {
            throw new SQLExecutionException(preparedSQL.getSQL(), (Throwable)e);
        }
    }

    @Override
    public <R, O> R selectProjection(Consumer<Select> selectAdapter, Accumulator<? super Function<Selectable<O>, O>, Object, R> accumulator, CriteriaChain where, boolean distinct, Consumer<Query.FluentOrderByClause> orderByClauseConsumer) {
        EntityTreeQueryBuilder.EntityTreeQuery<C> entityTreeQuery = new EntityTreeQueryBuilder<C>(this.entityJoinTree, (ResultSetReaderRegistry)this.dialect.getColumnBinderRegistry()).buildSelectQuery();
        Query query = entityTreeQuery.getQuery();
        query.getSelectSurrogate().setDistinct(distinct);
        QuerySQLBuilderFactory.QuerySQLBuilder sqlQueryBuilder = this.dialect.getQuerySQLBuilderFactory().queryBuilder(query, where, entityTreeQuery.getColumnClones());
        selectAdapter.accept(query.getSelectSurrogate());
        Map aliases = query.getAliases();
        ColumnedRow columnedRow = new ColumnedRow(aliases::get);
        Map columnReaders = Iterables.map((Iterable)query.getColumns(), new AliasAsserter(aliases::get), selectable -> this.dialect.getColumnBinderRegistry().getBinder(selectable.getJavaType()));
        PreparedSQL preparedSQL = sqlQueryBuilder.toPreparedSQL();
        return this.readProjection(preparedSQL, columnReaders, columnedRow, accumulator);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <R, O> R readProjection(PreparedSQL preparedSQL, Map<String, ResultSetReader<?>> columnReaders, ColumnedRow columnedRow, Accumulator<? super Function<Selectable<O>, O>, Object, R> accumulator) {
        try (ReadOperation closeableOperation = new ReadOperation((SQLStatement)preparedSQL, this.connectionProvider);){
            ResultSet resultSet = closeableOperation.execute();
            RowIterator rowIterator = new RowIterator(resultSet, columnReaders);
            Object object = accumulator.collect((Iterable)Iterables.stream((Iterator)rowIterator).map(row -> selectable -> columnedRow.getValue(selectable, row)).collect(Collectors.toList()));
            return (R)object;
        }
        catch (RuntimeException e) {
            throw new SQLExecutionException(preparedSQL.getSQL(), (Throwable)e);
        }
    }

    private /* synthetic */ void lambda$readIds$5(ColumnedRow columnedRow, Map result, Row row) {
        Set<Map.Entry<Class<C>, ConfiguredRelationalPersister<C, I>>> entries = this.persisterPerSubclass.entrySet();
        Duo duo = null;
        for (Map.Entry<Class<C>, ConfiguredRelationalPersister<C, I>> entry : entries) {
            Object identifier = entry.getValue().getMapping().getIdMapping().getIdentifierAssembler().assemble(row, columnedRow);
            if (identifier == null) continue;
            duo = new Duo(entry.getKey(), identifier);
            break;
        }
        result.computeIfAbsent(duo.getLeft(), k -> new HashSet()).add(duo.getRight());
    }

    private static class AliasAsserter<S extends Selectable>
    implements Function<S, String> {
        private final Function<S, String> delegate;

        private AliasAsserter(Function<S, String> delegate) {
            this.delegate = delegate;
        }

        @Override
        public String apply(S selectable) {
            String alias = this.delegate.apply(selectable);
            if (alias == null) {
                throw new IllegalArgumentException("Item " + selectable.getExpression() + " must have an alias");
            }
            return alias;
        }
    }
}

