/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.idprovider;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.sql.DataSource;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.InstanceOfAssertFactories;
import org.codefilarete.stalactite.engine.PersistenceContext;
import org.codefilarete.stalactite.engine.SeparateTransactionExecutor;
import org.codefilarete.stalactite.engine.TransactionalConnectionProvider;
import org.codefilarete.stalactite.engine.idprovider.PooledSequenceIdentifierProvider;
import org.codefilarete.stalactite.mapping.id.sequence.PooledHiLoSequence;
import org.codefilarete.stalactite.mapping.id.sequence.PooledHiLoSequenceOptions;
import org.codefilarete.stalactite.mapping.id.sequence.SequenceStorageOptions;
import org.codefilarete.stalactite.sql.ConnectionProvider;
import org.codefilarete.stalactite.sql.CurrentThreadConnectionProvider;
import org.codefilarete.stalactite.sql.Dialect;
import org.codefilarete.stalactite.sql.HSQLDBDialect;
import org.codefilarete.stalactite.sql.ddl.DDLDeployer;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.stalactite.sql.test.HSQLDBInMemoryDataSource;
import org.codefilarete.tool.collection.Arrays;
import org.codefilarete.tool.exception.Exceptions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class PooledSequenceIdentifierProviderTest {
    private PooledHiLoSequence sequenceIdentifierGenerator;
    private PersistenceContext persistenceContext;

    @BeforeEach
    public void setUp() {
        this.persistenceContext = new PersistenceContext((ConnectionProvider)new TransactionalConnectionProvider((DataSource)new HSQLDBInMemoryDataSource()), (Dialect)new HSQLDBDialect());
    }

    @Test
    public void giveNewIdentifier() {
        this.sequenceIdentifierGenerator = new PooledHiLoSequence(new PooledHiLoSequenceOptions(10, "Toto", SequenceStorageOptions.DEFAULT), this.persistenceContext.getDialect(), (SeparateTransactionExecutor)this.persistenceContext.getConnectionProvider(), this.persistenceContext.getJDBCBatchSize());
        DDLDeployer ddlDeployer = new DDLDeployer(this.persistenceContext);
        ddlDeployer.getDdlGenerator().setTables((Set)Arrays.asSet((Object[])new Table[]{this.sequenceIdentifierGenerator.getPersister().getMapping().getTargetTable()}));
        ddlDeployer.deployDDL();
        List starterKit = Arrays.asList((Object[])new Long[0]);
        ExecutorService backgroundLoader = Executors.newSingleThreadExecutor();
        PooledSequenceIdentifierProvider testInstance = new PooledSequenceIdentifierProvider((Collection)starterKit, 2, (Executor)backgroundLoader, Duration.ofSeconds(2L), this.sequenceIdentifierGenerator);
        ArrayList<Long> generated = new ArrayList<Long>();
        ArrayList<Long> expectedGeneration = new ArrayList<Long>();
        for (int i = 1; i < 15; ++i) {
            long persistableIdentifier = (Long)testInstance.giveNewIdentifier();
            generated.add(persistableIdentifier);
            expectedGeneration.add(Long.valueOf(i));
        }
        Assertions.assertThat(generated).isEqualTo(expectedGeneration);
    }

    @Test
    public void giveNewIdentifier_persistenceContextDoesntProvideSeparateTransactionExecutor_throwsException() {
        PersistenceContext persistenceContext = new PersistenceContext((ConnectionProvider)new CurrentThreadConnectionProvider((DataSource)new HSQLDBInMemoryDataSource()), (Dialect)new HSQLDBDialect());
        this.sequenceIdentifierGenerator = new PooledHiLoSequence(new PooledHiLoSequenceOptions(10, "Toto", SequenceStorageOptions.DEFAULT), persistenceContext.getDialect(), (SeparateTransactionExecutor)persistenceContext.getConnectionProvider(), persistenceContext.getJDBCBatchSize());
        DDLDeployer ddlDeployer = new DDLDeployer(persistenceContext);
        ddlDeployer.getDdlGenerator().setTables((Set)Arrays.asSet((Object[])new Table[]{this.sequenceIdentifierGenerator.getPersister().getMapping().getTargetTable()}));
        ddlDeployer.deployDDL();
        List starterKit = Arrays.asList((Object[])new Long[0]);
        Executor sameThreadExecutor = Runnable::run;
        PooledSequenceIdentifierProvider testInstance = new PooledSequenceIdentifierProvider((Collection)starterKit, 2, sameThreadExecutor, Duration.ofSeconds(2L), this.sequenceIdentifierGenerator);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((PooledSequenceIdentifierProvider)testInstance).giveNewIdentifier()).extracting(t -> (RuntimeException)Exceptions.findExceptionInCauses((Throwable)t, RuntimeException.class), InstanceOfAssertFactories.THROWABLE)).hasMessage("Can't execute operation in separate transaction because connection provider doesn't implement o.c.s.e.SeparateTransactionExecutor");
    }
}

