/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.configurer.builder;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import javax.sql.DataSource;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.InstanceOfAssertFactories;
import org.codefilarete.stalactite.dsl.MappingEase;
import org.codefilarete.stalactite.dsl.PolymorphismPolicy;
import org.codefilarete.stalactite.dsl.embeddable.EmbeddableMappingConfigurationProvider;
import org.codefilarete.stalactite.dsl.entity.EntityMappingConfigurationProvider;
import org.codefilarete.stalactite.dsl.entity.FluentEntityMappingBuilder;
import org.codefilarete.stalactite.dsl.subentity.SubEntityMappingConfigurationProvider;
import org.codefilarete.stalactite.engine.EntityPersister;
import org.codefilarete.stalactite.engine.PersisterRegistry;
import org.codefilarete.stalactite.engine.configurer.builder.DefaultPersisterBuilder;
import org.codefilarete.stalactite.engine.model.AbstractVehicle;
import org.codefilarete.stalactite.engine.model.Car;
import org.codefilarete.stalactite.engine.model.Color;
import org.codefilarete.stalactite.engine.model.Country;
import org.codefilarete.stalactite.engine.model.Timestamp;
import org.codefilarete.stalactite.engine.model.Vehicle;
import org.codefilarete.stalactite.engine.runtime.ConfiguredRelationalPersister;
import org.codefilarete.stalactite.id.Identifier;
import org.codefilarete.stalactite.id.StatefulIdentifierAlreadyAssignedIdentifierPolicy;
import org.codefilarete.stalactite.sql.ConnectionConfiguration;
import org.codefilarete.stalactite.sql.ConnectionProvider;
import org.codefilarete.stalactite.sql.CurrentThreadConnectionProvider;
import org.codefilarete.stalactite.sql.Dialect;
import org.codefilarete.stalactite.sql.result.InMemoryResultSet;
import org.codefilarete.stalactite.sql.statement.binder.DefaultParameterBinders;
import org.codefilarete.stalactite.sql.statement.binder.LambdaParameterBinder;
import org.codefilarete.stalactite.sql.statement.binder.NullAwareParameterBinder;
import org.codefilarete.stalactite.sql.statement.binder.ParameterBinder;
import org.codefilarete.stalactite.test.DefaultDialect;
import org.codefilarete.tool.collection.Arrays;
import org.codefilarete.tool.collection.Maps;
import org.codefilarete.tool.exception.Exceptions;
import org.codefilarete.tool.function.Serie;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Answers;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

class DefaultPersisterBuilderTest {
    private DefaultDialect dialect;

    DefaultPersisterBuilderTest() {
    }

    @BeforeEach
    void initializeDialect() {
        this.dialect = new DefaultDialect();
        this.dialect.getColumnBinderRegistry().register(Identifier.class, Identifier.identifierBinder(DefaultParameterBinders.LONG_PRIMITIVE_BINDER));
        this.dialect.getSqlTypeRegistry().put(Identifier.class, "int");
        this.dialect.getColumnBinderRegistry().register(Color.class, (ParameterBinder)new NullAwareParameterBinder((ParameterBinder)new LambdaParameterBinder(DefaultParameterBinders.INTEGER_PRIMITIVE_BINDER, Color::new, Color::getRgb)));
        this.dialect.getSqlTypeRegistry().put(Color.class, "int");
        this.dialect.getDmlGenerator().sortColumnsAlphabetically();
    }

    @Test
    void build_connectionProviderIsNotRollbackObserver_throwsException() {
        FluentEntityMappingBuilder.FluentMappingBuilderPropertyOptions persisterConfiguration = MappingEase.entityBuilder(Country.class, Identifier.LONG_TYPE).versionedBy(Country::getVersion, (Serie)new Serie.IntegerSerie()).mapKey(Country::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Country::getName).map(Country::getDescription);
        ConnectionConfiguration.ConnectionConfigurationSupport notARollbackObserverConnectionConfiguration = new ConnectionConfiguration.ConnectionConfigurationSupport((ConnectionProvider)new CurrentThreadConnectionProvider((DataSource)Mockito.mock(DataSource.class)), 10);
        DefaultPersisterBuilder testInstance = new DefaultPersisterBuilder((Dialect)this.dialect, (ConnectionConfiguration)notARollbackObserverConnectionConfiguration, (PersisterRegistry)Mockito.mock(PersisterRegistry.class));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> DefaultPersisterBuilderTest.lambda$build_connectionProviderIsNotRollbackObserver_throwsException$0(testInstance, (FluentEntityMappingBuilder)persisterConfiguration)).isInstanceOf(UnsupportedOperationException.class)).hasMessage("Version control is only supported for o.c.s.s.ConnectionProvider that implements o.c.s.s.RollbackObserver");
    }

    @Test
    void build_twiceForSameClass_throwsException() {
        FluentEntityMappingBuilder.FluentMappingBuilderEmbeddableMappingConfigurationImportedEmbedOptions persisterConfiguration = MappingEase.entityBuilder(Car.class, Identifier.LONG_TYPE).mapKey(AbstractVehicle::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Car::getModel).embed(AbstractVehicle::getTimestamp, (EmbeddableMappingConfigurationProvider)MappingEase.embeddableBuilder(Timestamp.class).map(Timestamp::getCreationDate).map(Timestamp::getModificationDate));
        ConnectionConfiguration.ConnectionConfigurationSupport connectionConfiguration = new ConnectionConfiguration.ConnectionConfigurationSupport((ConnectionProvider)Mockito.mock(ConnectionProvider.class, (MockSettings)Mockito.withSettings().defaultAnswer((Answer)Answers.RETURNS_MOCKS)), 10);
        DefaultPersisterBuilder testInstance = new DefaultPersisterBuilder((Dialect)this.dialect, (ConnectionConfiguration)connectionConfiguration, (PersisterRegistry)new PersisterRegistry.DefaultPersisterRegistry());
        testInstance.build((EntityMappingConfigurationProvider)persisterConfiguration);
        ((AbstractThrowableAssert)Assertions.assertThatCode(() -> DefaultPersisterBuilderTest.lambda$build_twiceForSameClass_throwsException$1(testInstance, (FluentEntityMappingBuilder)persisterConfiguration)).isInstanceOf(IllegalStateException.class)).hasMessage("Persister already exists for o.c.s.e.m.Car");
    }

    @Test
    void build_singleTable_singleClass() throws SQLException {
        FluentEntityMappingBuilder.FluentMappingBuilderEmbeddableMappingConfigurationImportedEmbedOptions persisterConfiguration = MappingEase.entityBuilder(Car.class, Identifier.LONG_TYPE).map(Car::getModel).map(Vehicle::getColor).mapKey(AbstractVehicle::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).embed(AbstractVehicle::getTimestamp, (EmbeddableMappingConfigurationProvider)MappingEase.embeddableBuilder(Timestamp.class).map(Timestamp::getCreationDate).map(Timestamp::getModificationDate));
        ConnectionProvider connectionProviderMock = (ConnectionProvider)Mockito.mock(ConnectionProvider.class, (MockSettings)Mockito.withSettings().defaultAnswer((Answer)Answers.RETURNS_MOCKS));
        Connection connectionMock = (Connection)Mockito.mock(Connection.class);
        Mockito.when((Object)connectionProviderMock.giveConnection()).thenReturn((Object)connectionMock);
        ArgumentCaptor sqlCaptor = ArgumentCaptor.forClass(String.class);
        PreparedStatement preparedStatementMock = (PreparedStatement)Mockito.mock(PreparedStatement.class);
        Mockito.when((Object)connectionMock.prepareStatement((String)sqlCaptor.capture(), ArgumentMatchers.eq((int)1))).thenReturn((Object)preparedStatementMock);
        Mockito.when((Object)preparedStatementMock.executeLargeBatch()).thenReturn((Object)new long[]{1L});
        DefaultPersisterBuilder testInstance = new DefaultPersisterBuilder((Dialect)this.dialect, (ConnectionConfiguration)new ConnectionConfiguration.ConnectionConfigurationSupport(connectionProviderMock, 10), (PersisterRegistry)new PersisterRegistry.DefaultPersisterRegistry());
        ConfiguredRelationalPersister result = testInstance.build((EntityMappingConfigurationProvider)persisterConfiguration);
        Car entity = new Car(1L);
        entity.setModel("Renault");
        entity.setColor(new Color(123));
        entity.setTimestamp(new Timestamp());
        result.insert((Object)entity);
        Assertions.assertThat((List)sqlCaptor.getAllValues()).containsExactly((Object[])new String[]{"insert into Car(color, creationDate, id, model, modificationDate) values (?, ?, ?, ?, ?)"});
    }

    @Test
    void build_singleTable_withInheritance() throws SQLException {
        FluentEntityMappingBuilder.FluentMappingBuilderInheritanceOptions persisterConfiguration = MappingEase.entityBuilder(Car.class, Identifier.LONG_TYPE).map(Car::getModel).mapSuperClass((EntityMappingConfigurationProvider)MappingEase.entityBuilder(Vehicle.class, Identifier.LONG_TYPE).map(Vehicle::getColor).mapSuperClass((EntityMappingConfigurationProvider)MappingEase.entityBuilder(AbstractVehicle.class, Identifier.LONG_TYPE).mapKey(AbstractVehicle::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).embed(AbstractVehicle::getTimestamp, (EmbeddableMappingConfigurationProvider)MappingEase.embeddableBuilder(Timestamp.class).map(Timestamp::getCreationDate).map(Timestamp::getModificationDate))));
        ConnectionProvider connectionProviderMock = (ConnectionProvider)Mockito.mock(ConnectionProvider.class, (MockSettings)Mockito.withSettings().defaultAnswer((Answer)Answers.RETURNS_MOCKS));
        Connection connectionMock = (Connection)Mockito.mock(Connection.class);
        Mockito.when((Object)connectionProviderMock.giveConnection()).thenReturn((Object)connectionMock);
        ArgumentCaptor sqlCaptor = ArgumentCaptor.forClass(String.class);
        PreparedStatement preparedStatementMock = (PreparedStatement)Mockito.mock(PreparedStatement.class);
        Mockito.when((Object)connectionMock.prepareStatement((String)sqlCaptor.capture(), ArgumentMatchers.eq((int)1))).thenReturn((Object)preparedStatementMock);
        Mockito.when((Object)preparedStatementMock.executeLargeBatch()).thenReturn((Object)new long[]{1L});
        DefaultPersisterBuilder testInstance = new DefaultPersisterBuilder((Dialect)this.dialect, (ConnectionConfiguration)new ConnectionConfiguration.ConnectionConfigurationSupport(connectionProviderMock, 10), (PersisterRegistry)new PersisterRegistry.DefaultPersisterRegistry());
        ConfiguredRelationalPersister result = testInstance.build((EntityMappingConfigurationProvider)persisterConfiguration);
        Car entity = new Car(1L);
        entity.setModel("Renault");
        entity.setColor(new Color(123));
        entity.setTimestamp(new Timestamp());
        result.insert((Object)entity);
        Assertions.assertThat((List)sqlCaptor.getAllValues()).containsExactly((Object[])new String[]{"insert into Car(color, creationDate, id, model, modificationDate) values (?, ?, ?, ?, ?)"});
    }

    @Test
    void build_joinedTables() throws SQLException {
        FluentEntityMappingBuilder.FluentMappingBuilderInheritanceOptions persisterConfiguration = MappingEase.entityBuilder(Car.class, Identifier.LONG_TYPE).map(Car::getModel).mapSuperClass((EntityMappingConfigurationProvider)MappingEase.entityBuilder(Vehicle.class, Identifier.LONG_TYPE).map(Vehicle::getColor).mapSuperClass((EntityMappingConfigurationProvider)MappingEase.entityBuilder(AbstractVehicle.class, Identifier.LONG_TYPE).mapKey(AbstractVehicle::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).embed(AbstractVehicle::getTimestamp, (EmbeddableMappingConfigurationProvider)MappingEase.embeddableBuilder(Timestamp.class).map(Timestamp::getCreationDate).map(Timestamp::getModificationDate))).withJoinedTable()).withJoinedTable();
        ConnectionProvider connectionProviderMock = (ConnectionProvider)Mockito.mock(ConnectionProvider.class, (MockSettings)Mockito.withSettings().defaultAnswer((Answer)Answers.RETURNS_MOCKS));
        Connection connectionMock = (Connection)Mockito.mock(Connection.class);
        Mockito.when((Object)connectionProviderMock.giveConnection()).thenReturn((Object)connectionMock);
        ArgumentCaptor insertCaptor = ArgumentCaptor.forClass(String.class);
        PreparedStatement preparedStatementMock = (PreparedStatement)Mockito.mock(PreparedStatement.class);
        Mockito.when((Object)connectionMock.prepareStatement((String)insertCaptor.capture(), ArgumentMatchers.eq((int)1))).thenReturn((Object)preparedStatementMock);
        Mockito.when((Object)preparedStatementMock.executeLargeBatch()).thenReturn((Object)new long[]{1L});
        Mockito.when((Object)preparedStatementMock.executeQuery()).thenReturn((Object)new InMemoryResultSet(Collections.emptyIterator()));
        DefaultPersisterBuilder testInstance = new DefaultPersisterBuilder((Dialect)this.dialect, (ConnectionConfiguration)new ConnectionConfiguration.ConnectionConfigurationSupport(connectionProviderMock, 10), (PersisterRegistry)new PersisterRegistry.DefaultPersisterRegistry());
        ConfiguredRelationalPersister result = testInstance.build((EntityMappingConfigurationProvider)persisterConfiguration);
        Car entity = new Car(1L);
        entity.setModel("Renault");
        entity.setColor(new Color(123));
        entity.setTimestamp(new Timestamp());
        result.insert((Object)entity);
        Assertions.assertThat((List)insertCaptor.getAllValues()).containsExactly((Object[])new String[]{"insert into AbstractVehicle(creationDate, id, modificationDate) values (?, ?, ?)", "insert into Vehicle(color, id) values (?, ?)", "insert into Car(id, model) values (?, ?)"});
        ArgumentCaptor deleteCaptor = ArgumentCaptor.forClass(String.class);
        Mockito.when((Object)connectionMock.prepareStatement((String)deleteCaptor.capture())).thenReturn((Object)preparedStatementMock);
        result.delete((Object)entity);
        Assertions.assertThat((List)deleteCaptor.getAllValues()).containsExactly((Object[])new String[]{"delete from Car where id = ?", "delete from Vehicle where id = ?", "delete from AbstractVehicle where id = ?"});
        ArgumentCaptor selectCaptor = ArgumentCaptor.forClass(String.class);
        Mockito.when((Object)connectionMock.prepareStatement((String)selectCaptor.capture())).thenReturn((Object)preparedStatementMock);
        result.select(entity.getId());
        Assertions.assertThat((List)selectCaptor.getAllValues()).containsExactly((Object[])new String[]{"select Car.model as Car_model, Car.id as Car_id, AbstractVehicle.creationDate as AbstractVehicle_creationDate, AbstractVehicle.modificationDate as AbstractVehicle_modificationDate, AbstractVehicle.id as AbstractVehicle_id, Vehicle.color as Vehicle_color, Vehicle.id as Vehicle_id from Car inner join AbstractVehicle as AbstractVehicle on Car.id = AbstractVehicle.id inner join Vehicle as Vehicle on Car.id = Vehicle.id where Car.id in (?)"});
    }

    @Test
    void build_createsAnInstanceThatDoesntRequireTwoSelectsOnItsUpdateMethod() throws SQLException {
        FluentEntityMappingBuilder.FluentMappingBuilderPropertyOptions persisterConfiguration = MappingEase.entityBuilder(Car.class, Identifier.LONG_TYPE).mapKey(AbstractVehicle::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Car::getModel);
        ConnectionProvider connectionProviderMock = (ConnectionProvider)Mockito.mock(ConnectionProvider.class, (MockSettings)Mockito.withSettings().defaultAnswer((Answer)Answers.RETURNS_MOCKS));
        Connection connectionMock = (Connection)Mockito.mock(Connection.class);
        Mockito.when((Object)connectionProviderMock.giveConnection()).thenReturn((Object)connectionMock);
        ArgumentCaptor insertCaptor = ArgumentCaptor.forClass(String.class);
        PreparedStatement preparedStatementMock = (PreparedStatement)Mockito.mock(PreparedStatement.class);
        Mockito.when((Object)connectionMock.prepareStatement((String)insertCaptor.capture())).thenReturn((Object)preparedStatementMock);
        Mockito.when((Object)connectionMock.prepareStatement((String)insertCaptor.capture(), ArgumentMatchers.eq((int)1))).thenReturn((Object)preparedStatementMock);
        Mockito.when((Object)preparedStatementMock.executeLargeBatch()).thenReturn((Object)new long[]{1L});
        Mockito.when((Object)preparedStatementMock.executeQuery()).thenReturn((Object)new InMemoryResultSet((Iterable)Arrays.asList((Object[])new Maps.ChainingHashMap[]{Maps.forHashMap(String.class, Object.class).add((Object)"Car_id", (Object)1L).add((Object)"Car_model", (Object)"Renault")})));
        DefaultPersisterBuilder testInstance = new DefaultPersisterBuilder((Dialect)this.dialect, (ConnectionConfiguration)new ConnectionConfiguration.ConnectionConfigurationSupport(connectionProviderMock, 10), (PersisterRegistry)new PersisterRegistry.DefaultPersisterRegistry());
        ConfiguredRelationalPersister result = testInstance.build((EntityMappingConfigurationProvider)persisterConfiguration);
        Car dummyCar = new Car(1L);
        dummyCar.setModel("Renault");
        result.insert((Object)dummyCar);
        result.update(dummyCar.getId(), vehicle -> vehicle.setModel("Peugeot"));
        Assertions.assertThat((List)insertCaptor.getAllValues()).containsExactly((Object[])new String[]{"insert into Car(id, model) values (?, ?)", "select Car.model as Car_model, Car.id as Car_id from Car where Car.id in (?)", "update Car set model = ? where id = ?"});
        ArgumentCaptor valueIndexCaptor = ArgumentCaptor.forClass(Integer.TYPE);
        ArgumentCaptor valueCaptor = ArgumentCaptor.forClass(String.class);
        ((PreparedStatement)Mockito.verify((Object)preparedStatementMock, (VerificationMode)Mockito.times((int)2))).setString((Integer)valueIndexCaptor.capture(), (String)valueCaptor.capture());
        Assertions.assertThat((List)valueCaptor.getAllValues()).containsExactly((Object[])new String[]{"Renault", "Peugeot"});
        ((PreparedStatement)Mockito.verify((Object)preparedStatementMock)).executeQuery();
    }

    @Test
    void build_resultAssertsThatPersisterManageGivenEntities() {
        FluentEntityMappingBuilder.FluentMappingBuilderEmbeddableMappingConfigurationImportedEmbedOptions persisterConfiguration = MappingEase.entityBuilder(AbstractVehicle.class, Identifier.LONG_TYPE).mapKey(AbstractVehicle::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).embed(AbstractVehicle::getTimestamp, (EmbeddableMappingConfigurationProvider)MappingEase.embeddableBuilder(Timestamp.class).map(Timestamp::getCreationDate).map(Timestamp::getModificationDate));
        ConnectionProvider connectionProviderMock = (ConnectionProvider)Mockito.mock(ConnectionProvider.class, (MockSettings)Mockito.withSettings().defaultAnswer((Answer)Answers.RETURNS_MOCKS));
        DefaultPersisterBuilder testInstance = new DefaultPersisterBuilder((Dialect)this.dialect, (ConnectionConfiguration)new ConnectionConfiguration.ConnectionConfigurationSupport(connectionProviderMock, 10), (PersisterRegistry)new PersisterRegistry.DefaultPersisterRegistry());
        ConfiguredRelationalPersister result = testInstance.build((EntityMappingConfigurationProvider)persisterConfiguration);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> DefaultPersisterBuilderTest.lambda$build_resultAssertsThatPersisterManageGivenEntities$3((EntityPersister)result)).extracting(t -> (UnsupportedOperationException)Exceptions.findExceptionInCauses((Throwable)t, UnsupportedOperationException.class), InstanceOfAssertFactories.THROWABLE)).hasMessage("Persister of o.c.s.e.m.AbstractVehicle is not configured to persist o.c.s.e.m.Vehicle");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> DefaultPersisterBuilderTest.lambda$build_resultAssertsThatPersisterManageGivenEntities$5((EntityPersister)result)).extracting(t -> (UnsupportedOperationException)Exceptions.findExceptionInCauses((Throwable)t, UnsupportedOperationException.class), InstanceOfAssertFactories.THROWABLE)).hasMessage("Persister of o.c.s.e.m.AbstractVehicle is not configured to persist o.c.s.e.m.Vehicle");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> DefaultPersisterBuilderTest.lambda$build_resultAssertsThatPersisterManageGivenEntities$7((EntityPersister)result)).extracting(t -> (UnsupportedOperationException)Exceptions.findExceptionInCauses((Throwable)t, UnsupportedOperationException.class), InstanceOfAssertFactories.THROWABLE)).hasMessage("Persister of o.c.s.e.m.AbstractVehicle is not configured to persist o.c.s.e.m.Vehicle");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> DefaultPersisterBuilderTest.lambda$build_resultAssertsThatPersisterManageGivenEntities$9((EntityPersister)result)).extracting(t -> (UnsupportedOperationException)Exceptions.findExceptionInCauses((Throwable)t, UnsupportedOperationException.class), InstanceOfAssertFactories.THROWABLE)).hasMessage("Persister of o.c.s.e.m.AbstractVehicle is not configured to persist o.c.s.e.m.Vehicle");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> DefaultPersisterBuilderTest.lambda$build_resultAssertsThatPersisterManageGivenEntities$11((EntityPersister)result)).extracting(t -> (UnsupportedOperationException)Exceptions.findExceptionInCauses((Throwable)t, UnsupportedOperationException.class), InstanceOfAssertFactories.THROWABLE)).hasMessage("Persister of o.c.s.e.m.AbstractVehicle is not configured to persist o.c.s.e.m.Vehicle");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> DefaultPersisterBuilderTest.lambda$build_resultAssertsThatPersisterManageGivenEntities$13((EntityPersister)result)).extracting(t -> (UnsupportedOperationException)Exceptions.findExceptionInCauses((Throwable)t, UnsupportedOperationException.class), InstanceOfAssertFactories.THROWABLE)).hasMessage("Persister of o.c.s.e.m.AbstractVehicle is not configured to persist o.c.s.e.m.Vehicle");
    }

    @Test
    void build_withPolymorphismJoinedTables_resultAssertsThatPersisterManageGivenEntities() {
        FluentEntityMappingBuilder persisterConfiguration = MappingEase.entityBuilder(AbstractVehicle.class, Identifier.LONG_TYPE).mapKey(AbstractVehicle::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).embed(AbstractVehicle::getTimestamp, (EmbeddableMappingConfigurationProvider)MappingEase.embeddableBuilder(Timestamp.class).map(Timestamp::getCreationDate).map(Timestamp::getModificationDate)).mapPolymorphism((PolymorphismPolicy)PolymorphismPolicy.joinTable().addSubClass((SubEntityMappingConfigurationProvider)MappingEase.subentityBuilder(Vehicle.class, Identifier.LONG_TYPE)));
        ConnectionProvider connectionProviderMock = (ConnectionProvider)Mockito.mock(ConnectionProvider.class, (MockSettings)Mockito.withSettings().defaultAnswer((Answer)Answers.RETURNS_MOCKS));
        DefaultPersisterBuilder testInstance = new DefaultPersisterBuilder((Dialect)this.dialect, (ConnectionConfiguration)new ConnectionConfiguration.ConnectionConfigurationSupport(connectionProviderMock, 10), (PersisterRegistry)new PersisterRegistry.DefaultPersisterRegistry());
        ConfiguredRelationalPersister result = testInstance.build((EntityMappingConfigurationProvider)persisterConfiguration);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> DefaultPersisterBuilderTest.lambda$build_withPolymorphismJoinedTables_resultAssertsThatPersisterManageGivenEntities$15((EntityPersister)result)).extracting(t -> (UnsupportedOperationException)Exceptions.findExceptionInCauses((Throwable)t, UnsupportedOperationException.class), InstanceOfAssertFactories.THROWABLE)).hasMessage("Persister of o.c.s.e.m.AbstractVehicle is not configured to persist o.c.s.e.m.Car");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> DefaultPersisterBuilderTest.lambda$build_withPolymorphismJoinedTables_resultAssertsThatPersisterManageGivenEntities$17((EntityPersister)result)).extracting(t -> (UnsupportedOperationException)Exceptions.findExceptionInCauses((Throwable)t, UnsupportedOperationException.class), InstanceOfAssertFactories.THROWABLE)).hasMessage("Persister of o.c.s.e.m.AbstractVehicle is not configured to persist o.c.s.e.m.Car");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> DefaultPersisterBuilderTest.lambda$build_withPolymorphismJoinedTables_resultAssertsThatPersisterManageGivenEntities$19((EntityPersister)result)).extracting(t -> (UnsupportedOperationException)Exceptions.findExceptionInCauses((Throwable)t, UnsupportedOperationException.class), InstanceOfAssertFactories.THROWABLE)).hasMessage("Persister of o.c.s.e.m.AbstractVehicle is not configured to persist o.c.s.e.m.Car");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> DefaultPersisterBuilderTest.lambda$build_withPolymorphismJoinedTables_resultAssertsThatPersisterManageGivenEntities$21((EntityPersister)result)).extracting(t -> (UnsupportedOperationException)Exceptions.findExceptionInCauses((Throwable)t, UnsupportedOperationException.class), InstanceOfAssertFactories.THROWABLE)).hasMessage("Persister of o.c.s.e.m.AbstractVehicle is not configured to persist o.c.s.e.m.Car");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> DefaultPersisterBuilderTest.lambda$build_withPolymorphismJoinedTables_resultAssertsThatPersisterManageGivenEntities$23((EntityPersister)result)).extracting(t -> (UnsupportedOperationException)Exceptions.findExceptionInCauses((Throwable)t, UnsupportedOperationException.class), InstanceOfAssertFactories.THROWABLE)).hasMessage("Persister of o.c.s.e.m.AbstractVehicle is not configured to persist o.c.s.e.m.Car");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> DefaultPersisterBuilderTest.lambda$build_withPolymorphismJoinedTables_resultAssertsThatPersisterManageGivenEntities$25((EntityPersister)result)).extracting(t -> (UnsupportedOperationException)Exceptions.findExceptionInCauses((Throwable)t, UnsupportedOperationException.class), InstanceOfAssertFactories.THROWABLE)).hasMessage("Persister of o.c.s.e.m.AbstractVehicle is not configured to persist o.c.s.e.m.Car");
    }

    @Test
    void build_withPolymorphismSingleTable_resultAssertsThatPersisterManageGivenEntities() {
        FluentEntityMappingBuilder persisterConfiguration = MappingEase.entityBuilder(AbstractVehicle.class, Identifier.LONG_TYPE).mapKey(AbstractVehicle::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).embed(AbstractVehicle::getTimestamp, (EmbeddableMappingConfigurationProvider)MappingEase.embeddableBuilder(Timestamp.class).map(Timestamp::getCreationDate).map(Timestamp::getModificationDate)).mapPolymorphism((PolymorphismPolicy)PolymorphismPolicy.singleTable().addSubClass((SubEntityMappingConfigurationProvider)MappingEase.subentityBuilder(Vehicle.class, Identifier.LONG_TYPE), (Object)"Vehicle"));
        ConnectionProvider connectionProviderMock = (ConnectionProvider)Mockito.mock(ConnectionProvider.class, (MockSettings)Mockito.withSettings().defaultAnswer((Answer)Answers.RETURNS_MOCKS));
        DefaultPersisterBuilder testInstance = new DefaultPersisterBuilder((Dialect)this.dialect, (ConnectionConfiguration)new ConnectionConfiguration.ConnectionConfigurationSupport(connectionProviderMock, 10), (PersisterRegistry)new PersisterRegistry.DefaultPersisterRegistry());
        ConfiguredRelationalPersister result = testInstance.build((EntityMappingConfigurationProvider)persisterConfiguration);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> DefaultPersisterBuilderTest.lambda$build_withPolymorphismSingleTable_resultAssertsThatPersisterManageGivenEntities$27((EntityPersister)result)).extracting(t -> (UnsupportedOperationException)Exceptions.findExceptionInCauses((Throwable)t, UnsupportedOperationException.class), InstanceOfAssertFactories.THROWABLE)).hasMessage("Persister of o.c.s.e.m.AbstractVehicle is not configured to persist o.c.s.e.m.Car");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> DefaultPersisterBuilderTest.lambda$build_withPolymorphismSingleTable_resultAssertsThatPersisterManageGivenEntities$29((EntityPersister)result)).extracting(t -> (UnsupportedOperationException)Exceptions.findExceptionInCauses((Throwable)t, UnsupportedOperationException.class), InstanceOfAssertFactories.THROWABLE)).hasMessage("Persister of o.c.s.e.m.AbstractVehicle is not configured to persist o.c.s.e.m.Car");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> DefaultPersisterBuilderTest.lambda$build_withPolymorphismSingleTable_resultAssertsThatPersisterManageGivenEntities$31((EntityPersister)result)).extracting(t -> (UnsupportedOperationException)Exceptions.findExceptionInCauses((Throwable)t, UnsupportedOperationException.class), InstanceOfAssertFactories.THROWABLE)).hasMessage("Persister of o.c.s.e.m.AbstractVehicle is not configured to persist o.c.s.e.m.Car");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> DefaultPersisterBuilderTest.lambda$build_withPolymorphismSingleTable_resultAssertsThatPersisterManageGivenEntities$33((EntityPersister)result)).extracting(t -> (UnsupportedOperationException)Exceptions.findExceptionInCauses((Throwable)t, UnsupportedOperationException.class), InstanceOfAssertFactories.THROWABLE)).hasMessage("Persister of o.c.s.e.m.AbstractVehicle is not configured to persist o.c.s.e.m.Car");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> DefaultPersisterBuilderTest.lambda$build_withPolymorphismSingleTable_resultAssertsThatPersisterManageGivenEntities$35((EntityPersister)result)).extracting(t -> (UnsupportedOperationException)Exceptions.findExceptionInCauses((Throwable)t, UnsupportedOperationException.class), InstanceOfAssertFactories.THROWABLE)).hasMessage("Persister of o.c.s.e.m.AbstractVehicle is not configured to persist o.c.s.e.m.Car");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> DefaultPersisterBuilderTest.lambda$build_withPolymorphismSingleTable_resultAssertsThatPersisterManageGivenEntities$37((EntityPersister)result)).extracting(t -> (UnsupportedOperationException)Exceptions.findExceptionInCauses((Throwable)t, UnsupportedOperationException.class), InstanceOfAssertFactories.THROWABLE)).hasMessage("Persister of o.c.s.e.m.AbstractVehicle is not configured to persist o.c.s.e.m.Car");
    }

    private static /* synthetic */ void lambda$build_withPolymorphismSingleTable_resultAssertsThatPersisterManageGivenEntities$37(EntityPersister result) throws Throwable {
        result.deleteById((Object)new Car(42L));
    }

    private static /* synthetic */ void lambda$build_withPolymorphismSingleTable_resultAssertsThatPersisterManageGivenEntities$35(EntityPersister result) throws Throwable {
        result.delete((Object)new Car(42L));
    }

    private static /* synthetic */ void lambda$build_withPolymorphismSingleTable_resultAssertsThatPersisterManageGivenEntities$33(EntityPersister result) throws Throwable {
        result.updateById((Object)new Car(42L));
    }

    private static /* synthetic */ void lambda$build_withPolymorphismSingleTable_resultAssertsThatPersisterManageGivenEntities$31(EntityPersister result) throws Throwable {
        result.update((Object)new Car(42L));
    }

    private static /* synthetic */ void lambda$build_withPolymorphismSingleTable_resultAssertsThatPersisterManageGivenEntities$29(EntityPersister result) throws Throwable {
        result.insert((Object)new Car(42L));
    }

    private static /* synthetic */ void lambda$build_withPolymorphismSingleTable_resultAssertsThatPersisterManageGivenEntities$27(EntityPersister result) throws Throwable {
        result.persist((Object)new Car(42L));
    }

    private static /* synthetic */ void lambda$build_withPolymorphismJoinedTables_resultAssertsThatPersisterManageGivenEntities$25(EntityPersister result) throws Throwable {
        result.deleteById((Object)new Car(42L));
    }

    private static /* synthetic */ void lambda$build_withPolymorphismJoinedTables_resultAssertsThatPersisterManageGivenEntities$23(EntityPersister result) throws Throwable {
        result.delete((Object)new Car(42L));
    }

    private static /* synthetic */ void lambda$build_withPolymorphismJoinedTables_resultAssertsThatPersisterManageGivenEntities$21(EntityPersister result) throws Throwable {
        result.updateById((Object)new Car(42L));
    }

    private static /* synthetic */ void lambda$build_withPolymorphismJoinedTables_resultAssertsThatPersisterManageGivenEntities$19(EntityPersister result) throws Throwable {
        result.update((Object)new Car(42L));
    }

    private static /* synthetic */ void lambda$build_withPolymorphismJoinedTables_resultAssertsThatPersisterManageGivenEntities$17(EntityPersister result) throws Throwable {
        result.insert((Object)new Car(42L));
    }

    private static /* synthetic */ void lambda$build_withPolymorphismJoinedTables_resultAssertsThatPersisterManageGivenEntities$15(EntityPersister result) throws Throwable {
        result.persist((Object)new Car(42L));
    }

    private static /* synthetic */ void lambda$build_resultAssertsThatPersisterManageGivenEntities$13(EntityPersister result) throws Throwable {
        result.deleteById((Object)new Vehicle(42L));
    }

    private static /* synthetic */ void lambda$build_resultAssertsThatPersisterManageGivenEntities$11(EntityPersister result) throws Throwable {
        result.delete((Object)new Vehicle(42L));
    }

    private static /* synthetic */ void lambda$build_resultAssertsThatPersisterManageGivenEntities$9(EntityPersister result) throws Throwable {
        result.updateById((Object)new Vehicle(42L));
    }

    private static /* synthetic */ void lambda$build_resultAssertsThatPersisterManageGivenEntities$7(EntityPersister result) throws Throwable {
        result.update((Object)new Vehicle(42L));
    }

    private static /* synthetic */ void lambda$build_resultAssertsThatPersisterManageGivenEntities$5(EntityPersister result) throws Throwable {
        result.insert((Object)new Vehicle(42L));
    }

    private static /* synthetic */ void lambda$build_resultAssertsThatPersisterManageGivenEntities$3(EntityPersister result) throws Throwable {
        result.persist((Object)new Vehicle(42L));
    }

    private static /* synthetic */ void lambda$build_twiceForSameClass_throwsException$1(DefaultPersisterBuilder testInstance, FluentEntityMappingBuilder persisterConfiguration) throws Throwable {
        testInstance.build((EntityMappingConfigurationProvider)persisterConfiguration);
    }

    private static /* synthetic */ void lambda$build_connectionProviderIsNotRollbackObserver_throwsException$0(DefaultPersisterBuilder testInstance, FluentEntityMappingBuilder persisterConfiguration) throws Throwable {
        testInstance.build((EntityMappingConfigurationProvider)persisterConfiguration);
    }
}

