/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.spring.repository.query;

import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import org.codefilarete.reflection.Accessor;
import org.codefilarete.reflection.AccessorByMember;
import org.codefilarete.reflection.AccessorChain;
import org.codefilarete.reflection.AccessorDefinition;
import org.codefilarete.reflection.Accessors;
import org.codefilarete.reflection.ValueAccessPoint;
import org.codefilarete.stalactite.engine.EntityPersister;
import org.codefilarete.stalactite.engine.runtime.AdvancedEntityPersister;
import org.codefilarete.stalactite.engine.runtime.ProjectionQueryCriteriaSupport;
import org.codefilarete.stalactite.engine.runtime.RelationalEntityPersister;
import org.codefilarete.stalactite.engine.runtime.query.EntityCriteriaSupport;
import org.codefilarete.stalactite.engine.runtime.query.EntityQueryCriteriaSupport;
import org.codefilarete.stalactite.query.model.JoinLink;
import org.codefilarete.stalactite.query.model.Limit;
import org.codefilarete.stalactite.query.model.LogicalOperator;
import org.codefilarete.stalactite.query.model.Selectable;
import org.codefilarete.stalactite.spring.repository.query.AbstractDerivedQuery;
import org.codefilarete.stalactite.spring.repository.query.AbstractQueryExecutor;
import org.codefilarete.stalactite.spring.repository.query.AbstractRepositoryQuery;
import org.codefilarete.stalactite.spring.repository.query.PartTreeStalactiteCountProjection;
import org.codefilarete.stalactite.spring.repository.query.ProjectionMappingFinder;
import org.codefilarete.stalactite.spring.repository.query.StalactiteQueryMethod;
import org.codefilarete.stalactite.spring.repository.query.StalactiteQueryMethodInvocationParameters;
import org.codefilarete.stalactite.spring.repository.query.reduce.LimitHandler;
import org.codefilarete.stalactite.spring.repository.query.reduce.QueryResultCollectioner;
import org.codefilarete.stalactite.spring.repository.query.reduce.QueryResultPager;
import org.codefilarete.stalactite.spring.repository.query.reduce.QueryResultReducer;
import org.codefilarete.stalactite.spring.repository.query.reduce.QueryResultSingler;
import org.codefilarete.stalactite.spring.repository.query.reduce.QueryResultSlicer;
import org.codefilarete.stalactite.sql.Dialect;
import org.codefilarete.stalactite.sql.result.Accumulator;
import org.codefilarete.stalactite.sql.result.Accumulators;
import org.codefilarete.tool.VisibleForTesting;
import org.springframework.data.domain.Sort;
import org.springframework.data.mapping.PropertyPath;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.repository.query.Parameter;
import org.springframework.data.repository.query.parser.Part;
import org.springframework.data.repository.query.parser.PartTree;

public class PartTreeStalactiteProjection<C, R>
extends AbstractRepositoryQuery<C, R> {
    private final ProjectionMappingFinder<C> projectionMappingFinder;
    private final AdvancedEntityPersister<C, ?> entityPersister;
    private final PartTree partTree;
    private final ProjectionFactory factory;
    private final Dialect dialect;
    private final PartTreeStalactiteCountProjection<C> countQuery;
    private final ProjectionCriteriaAppender projectionCriteriaAppender;

    @VisibleForTesting
    public static void buildHierarchicMap(AccessorChain<?, ?> dottedProperty, Object value, Map<String, Object> root) {
        Map current = root;
        int lengthMinus1 = dottedProperty.getAccessors().size() - 1;
        for (int i = 0; i < lengthMinus1; ++i) {
            Accessor accessor = (Accessor)dottedProperty.getAccessors().get(i);
            String propertyName = AccessorDefinition.giveDefinition((ValueAccessPoint)accessor).getName();
            current = (Map)current.computeIfAbsent((String)propertyName, k -> new HashMap());
        }
        Accessor lastAccessor = (Accessor)dottedProperty.getAccessors().get(lengthMinus1);
        String propertyName = AccessorDefinition.giveDefinition((ValueAccessPoint)lastAccessor).getName();
        current.putIfAbsent((String)propertyName, (Object)value);
    }

    public PartTreeStalactiteProjection(StalactiteQueryMethod method, AdvancedEntityPersister<C, ?> entityPersister, PartTree partTree, ProjectionFactory factory, Dialect dialect) {
        super(method);
        this.entityPersister = entityPersister;
        this.partTree = partTree;
        this.factory = factory;
        this.dialect = dialect;
        this.countQuery = new PartTreeStalactiteCountProjection<C>(method, entityPersister, partTree);
        this.projectionMappingFinder = new ProjectionMappingFinder<C>(factory, entityPersister);
        this.projectionMappingFinder.lookup(method.getDomainClass());
        this.projectionCriteriaAppender = new ProjectionCriteriaAppender(partTree, entityPersister);
    }

    @Override
    protected AbstractQueryExecutor<List<Object>, Object> buildQueryExecutor(StalactiteQueryMethodInvocationParameters invocationParameters) {
        boolean runProjectionQuery;
        IdentityHashMap<JoinLink<?, ?>, AccessorChain<C, ?>> propertiesColumns;
        if (this.method.getParameters().hasDynamicProjection()) {
            propertiesColumns = this.projectionMappingFinder.lookup(invocationParameters.getDynamicProjectionType());
            runProjectionQuery = this.factory.getProjectionInformation(invocationParameters.getDynamicProjectionType()).isClosed() && !invocationParameters.getDynamicProjectionType().isAssignableFrom(this.entityPersister.getClassToPersist());
        } else {
            propertiesColumns = this.projectionMappingFinder.lookup(this.method.getReturnedObjectType());
            runProjectionQuery = this.factory.getProjectionInformation(this.method.getReturnedObjectType()).isClosed();
        }
        if (runProjectionQuery) {
            return this.createClosedProjectionExecutor(invocationParameters, propertiesColumns);
        }
        return this.createDomainQueryExecutor();
    }

    private AbstractQueryExecutor<List<C>, C> createDomainQueryExecutor() {
        return new AbstractQueryExecutor<List<C>, C>(this.method, this.dialect){

            @Override
            public Supplier<List<C>> buildQueryExecutor(Object[] parameters) {
                CriteriaAppender criteriaAppender = new CriteriaAppender(PartTreeStalactiteProjection.this.partTree, PartTreeStalactiteProjection.this.entityPersister);
                criteriaAppender.criteriaChain.consume(parameters);
                EntityQueryCriteriaSupport executableEntityQuery = criteriaAppender.executableEntityQuery;
                Object adaptation = PartTreeStalactiteProjection.this.buildResultWindower(criteriaAppender).adapt(() -> {
                    StalactiteQueryMethodInvocationParameters invocationParameters = new StalactiteQueryMethodInvocationParameters(this.method, parameters);
                    EntityQueryCriteriaSupport cEntityQueryCriteriaSupport = PartTreeStalactiteProjection.this.handleDynamicSort(invocationParameters, executableEntityQuery);
                    RelationalEntityPersister.ExecutableEntityQueryCriteria cExecutableEntityQueryCriteria = cEntityQueryCriteriaSupport.wrapIntoExecutable();
                    int i = 1;
                    for (Parameter bindableParameter : invocationParameters.getParameters().getBindableParameters()) {
                        Object value = invocationParameters.getBindableValue(bindableParameter.getIndex());
                        cExecutableEntityQueryCriteria.set(String.valueOf(i++), value);
                    }
                    return (List)cExecutableEntityQueryCriteria.execute(Accumulators.toList());
                }).apply(parameters);
                return () -> (List)this.method.getResultProcessor().processResult(adaptation);
            }
        };
    }

    private EntityQueryCriteriaSupport<C, ?> handleDynamicSort(StalactiteQueryMethodInvocationParameters invocationParameters, EntityQueryCriteriaSupport<C, ?> executableEntityQuery) {
        EntityQueryCriteriaSupport derivedQueryToUse;
        if (invocationParameters.getSort().isSorted()) {
            Class declaringClass = this.getQueryMethod().getEntityInformation().getJavaType();
            EntityQueryCriteriaSupport.EntityQueryPageSupport dynamicSortSupport = new EntityQueryCriteriaSupport.EntityQueryPageSupport();
            invocationParameters.getSort().stream().forEachOrdered(order -> {
                AccessorByMember accessor = Accessors.accessor((Class)declaringClass, (String)order.getProperty());
                dynamicSortSupport.orderBy(new AccessorChain(new Accessor[]{accessor}), order.getDirection() == Sort.Direction.ASC ? EntityPersister.OrderByChain.Order.ASC : EntityPersister.OrderByChain.Order.DESC, order.isIgnoreCase());
            });
            derivedQueryToUse = executableEntityQuery.copyFor(dynamicSortSupport);
        } else {
            derivedQueryToUse = executableEntityQuery;
        }
        return derivedQueryToUse;
    }

    private QueryResultReducer<R, C> buildResultWindower(CriteriaAppender criteriaAppender) {
        final EntityQueryCriteriaSupport executableEntityQuery = criteriaAppender.executableEntityQuery;
        QueryResultReducer result = this.method.isPageQuery() ? new QueryResultPager(this, new LimitHandler(){

            @Override
            public void limit(int count) {
                executableEntityQuery.getQueryPageSupport().limit(count);
            }

            @Override
            public void limit(int count, Integer offset) {
                executableEntityQuery.getQueryPageSupport().limit(count, offset);
            }
        }, new PartTreeStalactiteCountProjection<C>(this.method, this.entityPersister, this.partTree)) : (this.method.isSliceQuery() ? new QueryResultSlicer(this, new LimitHandler(){

            @Override
            public void limit(int count) {
                executableEntityQuery.getQueryPageSupport().limit(count);
            }

            @Override
            public void limit(int count, Integer offset) {
                executableEntityQuery.getQueryPageSupport().limit(count, offset);
            }
        }) : (this.method.isCollectionQuery() ? new QueryResultCollectioner() : new QueryResultSingler()));
        return result;
    }

    private AbstractQueryExecutor<List<Object>, Object> createClosedProjectionExecutor(final StalactiteQueryMethodInvocationParameters invocationParameters, final IdentityHashMap<JoinLink<?, ?>, AccessorChain<C, ?>> columnToProperties) {
        IdentityHashMap<JoinLink<?, ?>, String> aliases = PartTreeStalactiteProjection.buildAliases(columnToProperties);
        final ProjectionQueryCriteriaSupport actualProjectionQueryCriteriaSupport = this.projectionCriteriaAppender.executableEntityQuery.copyFor(select -> {
            select.clear();
            columnToProperties.keySet().forEach(selectable -> select.add((Selectable)selectable, (String)aliases.get(selectable)));
        });
        Accumulator<Function<Selectable<Object>, Object>, List<Map<String, Object>>, List<Map<String, Object>>> accumulator = new Accumulator<Function<Selectable<Object>, Object>, List<Map<String, Object>>, List<Map<String, Object>>>(){

            public Supplier<List<Map<String, Object>>> supplier() {
                return LinkedList::new;
            }

            public BiConsumer<List<Map<String, Object>>, Function<Selectable<Object>, Object>> aggregator() {
                return (finalResult, databaseRowDataProvider) -> {
                    HashMap<String, Object> row = new HashMap<String, Object>();
                    finalResult.add(row);
                    for (Map.Entry entry : columnToProperties.entrySet()) {
                        PartTreeStalactiteProjection.buildHierarchicMap((AccessorChain)entry.getValue(), databaseRowDataProvider.apply((Selectable)entry.getKey()), row);
                    }
                };
            }

            public Function<List<Map<String, Object>>, List<Map<String, Object>>> finisher() {
                return Function.identity();
            }
        };
        return new AbstractQueryExecutor<List<Object>, Object>(this.method, this.dialect, (Accumulator)accumulator){
            final /* synthetic */ Accumulator val$accumulator;
            {
                this.val$accumulator = accumulator;
                super(method, dialect);
            }

            @Override
            public Supplier<List<Object>> buildQueryExecutor(Object[] parameters) {
                return () -> {
                    EntityPersister.ExecutableProjectionQuery projectionQuery = PartTreeStalactiteProjection.this.handleDynamicSort(invocationParameters, actualProjectionQueryCriteriaSupport).wrapIntoExecutable();
                    Limit limit = invocationParameters.getLimit();
                    if (limit != null) {
                        projectionQuery.limit(limit.getCount().intValue(), limit.getOffset());
                    }
                    int i = 1;
                    for (Parameter bindableParameter : invocationParameters.getParameters().getBindableParameters()) {
                        Object value = invocationParameters.getBindableValue(bindableParameter.getIndex());
                        projectionQuery.set(String.valueOf(i++), value);
                    }
                    return (List)projectionQuery.execute(this.val$accumulator);
                };
            }
        };
    }

    private ProjectionQueryCriteriaSupport<C, ?> handleDynamicSort(StalactiteQueryMethodInvocationParameters invocationParameters, ProjectionQueryCriteriaSupport<C, ?> actualProjectionQueryCriteriaSupport) {
        ProjectionQueryCriteriaSupport derivedQueryToUse;
        if (invocationParameters.getSort().isSorted()) {
            Class declaringClass = this.getQueryMethod().getEntityInformation().getJavaType();
            ProjectionQueryCriteriaSupport.ProjectionQueryPageSupport dynamicSortSupport = new ProjectionQueryCriteriaSupport.ProjectionQueryPageSupport();
            invocationParameters.getSort().stream().forEachOrdered(order -> {
                AccessorByMember accessor = Accessors.accessor((Class)declaringClass, (String)order.getProperty());
                dynamicSortSupport.orderBy(new AccessorChain(new Accessor[]{accessor}), order.getDirection() == Sort.Direction.ASC ? EntityPersister.OrderByChain.Order.ASC : EntityPersister.OrderByChain.Order.DESC, order.isIgnoreCase());
            });
            derivedQueryToUse = actualProjectionQueryCriteriaSupport.copyFor(dynamicSortSupport);
        } else {
            derivedQueryToUse = actualProjectionQueryCriteriaSupport;
        }
        return derivedQueryToUse;
    }

    @Override
    protected LongSupplier buildCountSupplier(StalactiteQueryMethodInvocationParameters accessor) {
        return () -> this.countQuery.execute(accessor.getValues());
    }

    private class ProjectionCriteriaAppender
    extends AbstractDerivedQuery<C> {
        private final ProjectionQueryCriteriaSupport<C, ?> executableEntityQuery;
        private EntityCriteriaSupport<C> currentSupport;

        private ProjectionCriteriaAppender(PartTree tree, AdvancedEntityPersister<C, ?> entityPersister) {
            this(tree, entityPersister.newProjectionCriteriaSupport(selectables -> {}), entityPersister);
        }

        private ProjectionCriteriaAppender(PartTree tree, ProjectionQueryCriteriaSupport<C, ?> projectionQueryCriteriaSupport, AdvancedEntityPersister<C, ?> entityPersister) {
            this.executableEntityQuery = projectionQueryCriteriaSupport;
            this.currentSupport = this.executableEntityQuery.getEntityCriteriaSupport();
            tree.forEach(this::append);
            if (tree.getSort().isSorted()) {
                this.appendSort(tree, entityPersister);
            }
        }

        private void appendSort(PartTree tree, AdvancedEntityPersister<C, ?> entityPersister) {
            tree.getSort().iterator().forEachRemaining(order -> {
                PropertyPath propertyPath = PropertyPath.from((String)order.getProperty(), (Class)entityPersister.getClassToPersist());
                AccessorChain orderProperty = this.convertToAccessorChain(propertyPath);
                this.executableEntityQuery.getQueryPageSupport().orderBy(orderProperty, order.getDirection() == Sort.Direction.ASC ? EntityPersister.OrderByChain.Order.ASC : EntityPersister.OrderByChain.Order.DESC, order.isIgnoreCase());
            });
        }

        private void append(PartTree.OrPart part) {
            Iterator iterator;
            boolean nested = false;
            if (part.stream().count() > 1L) {
                nested = true;
                this.currentSupport = this.currentSupport.beginNested();
            }
            if ((iterator = part.iterator()).hasNext()) {
                this.append((Part)iterator.next(), LogicalOperator.OR);
            }
            iterator.forEachRemaining(p -> this.append((Part)p, LogicalOperator.AND));
            if (nested) {
                this.currentSupport = this.currentSupport.endNested();
            }
        }

        private void append(Part part, LogicalOperator orOrAnd) {
            AccessorChain getter = this.convertToAccessorChain(part.getProperty());
            AbstractDerivedQuery.Criterion criterion = this.convertToCriterion(part.getType(), part.shouldIgnoreCase() != Part.IgnoreCaseType.NEVER);
            this.currentSupport.add(orOrAnd, getter.getAccessors(), criterion.operator);
            this.criteriaChain.criteria.add(criterion);
        }
    }

    private class CriteriaAppender
    extends AbstractDerivedQuery<C> {
        private final EntityQueryCriteriaSupport<C, ?> executableEntityQuery;
        private EntityCriteriaSupport<C> currentSupport;

        private CriteriaAppender(PartTree tree, AdvancedEntityPersister<C, ?> entityPersister) {
            this.executableEntityQuery = entityPersister.newCriteriaSupport();
            this.currentSupport = this.executableEntityQuery.getEntityCriteriaSupport();
            tree.forEach(this::append);
            if (tree.getSort().isSorted()) {
                this.appendSort(tree, entityPersister);
            }
        }

        private void appendSort(PartTree tree, AdvancedEntityPersister<C, ?> entityPersister) {
            tree.getSort().iterator().forEachRemaining(order -> {
                PropertyPath propertyPath = PropertyPath.from((String)order.getProperty(), (Class)entityPersister.getClassToPersist());
                AccessorChain orderProperty = this.convertToAccessorChain(propertyPath);
                this.executableEntityQuery.getQueryPageSupport().orderBy(orderProperty, order.getDirection() == Sort.Direction.ASC ? EntityPersister.OrderByChain.Order.ASC : EntityPersister.OrderByChain.Order.DESC, order.isIgnoreCase());
            });
        }

        private void append(PartTree.OrPart part) {
            Iterator iterator;
            boolean nested = false;
            if (part.stream().count() > 1L) {
                nested = true;
                this.currentSupport = this.currentSupport.beginNested();
            }
            if ((iterator = part.iterator()).hasNext()) {
                this.append((Part)iterator.next(), LogicalOperator.OR);
            }
            iterator.forEachRemaining(p -> this.append((Part)p, LogicalOperator.AND));
            if (nested) {
                this.currentSupport = this.currentSupport.endNested();
            }
        }

        private void append(Part part, LogicalOperator orOrAnd) {
            AccessorChain getter = this.convertToAccessorChain(part.getProperty());
            AbstractDerivedQuery.Criterion criterion = this.convertToCriterion(part.getType(), part.shouldIgnoreCase() != Part.IgnoreCaseType.NEVER);
            this.currentSupport.add(orOrAnd, getter.getAccessors(), criterion.operator);
            this.criteriaChain.criteria.add(criterion);
        }
    }
}

