/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.mapping.id.manager;

import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import org.codefilarete.stalactite.engine.listener.InsertListener;
import org.codefilarete.stalactite.engine.listener.PersistListener;
import org.codefilarete.stalactite.engine.listener.SelectListener;
import org.codefilarete.stalactite.mapping.id.manager.AlreadyAssignedIdentifierManager;
import org.codefilarete.tool.collection.Collections;

public class CompositeKeyAlreadyAssignedIdentifierInsertionManager<C, I>
extends AlreadyAssignedIdentifierManager<C, I> {
    private final ThreadLocal<Set<C>> currentMarkedPersistedEntities;
    private final CurrentContextManagerInsertListener currentContextManagerInsertListener = new CurrentContextManagerInsertListener();
    private final CurrentContextManagerSelectListener currentContextManagerSelectListener = new CurrentContextManagerSelectListener();
    private final CurrentContextManagerPersistListener currentContextManagerPersistListener = new CurrentContextManagerPersistListener();

    public CompositeKeyAlreadyAssignedIdentifierInsertionManager(Class<I> identifierType, Consumer<C> markAsPersistedFunction, Function<C, Boolean> isPersistedFunction) {
        super(identifierType, markAsPersistedFunction, isPersistedFunction);
        this.currentMarkedPersistedEntities = null;
    }

    public CompositeKeyAlreadyAssignedIdentifierInsertionManager(Class<I> identifierType) {
        this(identifierType, new ThreadLocal<Set<C>>());
    }

    private CompositeKeyAlreadyAssignedIdentifierInsertionManager(Class<I> identifierType, ThreadLocal<Set<C>> currentMarkedPersistedEntities) {
        super(identifierType, o -> ((Set)currentMarkedPersistedEntities.get()).add(o), o -> ((Set)currentMarkedPersistedEntities.get()).contains(o));
        this.currentMarkedPersistedEntities = currentMarkedPersistedEntities;
    }

    public PersistListener<C> getPersistListener() {
        return this.currentContextManagerPersistListener;
    }

    @Override
    public InsertListener<C> getInsertListener() {
        return this.currentContextManagerInsertListener;
    }

    @Override
    public SelectListener<C, I> getSelectListener() {
        return this.currentContextManagerSelectListener;
    }

    private void ensureCurrentEntitySet() {
        this.currentMarkedPersistedEntities.set(Collections.newIdentitySet((int)100));
    }

    private void clearCurrentEntitySet() {
        this.currentMarkedPersistedEntities.remove();
    }

    private class CurrentContextManagerSelectListener
    implements SelectListener<C, I> {
        private CurrentContextManagerSelectListener() {
        }

        @Override
        public void beforeSelect(Iterable<I> ids) {
            CompositeKeyAlreadyAssignedIdentifierInsertionManager.this.ensureCurrentEntitySet();
        }

        @Override
        public void afterSelect(Set<? extends C> result) {
            CompositeKeyAlreadyAssignedIdentifierInsertionManager.this.markAsPersisted(result);
            CompositeKeyAlreadyAssignedIdentifierInsertionManager.this.clearCurrentEntitySet();
        }

        @Override
        public void onSelectError(Iterable<I> ids, RuntimeException exception) {
            CompositeKeyAlreadyAssignedIdentifierInsertionManager.this.clearCurrentEntitySet();
        }
    }

    private class CurrentContextManagerInsertListener
    implements InsertListener<C> {
        private CurrentContextManagerInsertListener() {
        }

        @Override
        public void beforeInsert(Iterable<? extends C> entities) {
            CompositeKeyAlreadyAssignedIdentifierInsertionManager.this.ensureCurrentEntitySet();
        }

        @Override
        public void afterInsert(Iterable<? extends C> entities) {
            CompositeKeyAlreadyAssignedIdentifierInsertionManager.this.markAsPersisted(entities);
            CompositeKeyAlreadyAssignedIdentifierInsertionManager.this.clearCurrentEntitySet();
        }

        @Override
        public void onInsertError(Iterable<? extends C> entities, RuntimeException runtimeException) {
            CompositeKeyAlreadyAssignedIdentifierInsertionManager.this.clearCurrentEntitySet();
        }
    }

    private class CurrentContextManagerPersistListener
    implements PersistListener<C> {
        private CurrentContextManagerPersistListener() {
        }

        @Override
        public void beforePersist(Iterable<? extends C> entities) {
            CompositeKeyAlreadyAssignedIdentifierInsertionManager.this.ensureCurrentEntitySet();
        }

        @Override
        public void afterPersist(Iterable<? extends C> entities) {
            CompositeKeyAlreadyAssignedIdentifierInsertionManager.this.clearCurrentEntitySet();
        }
    }
}

