/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.spring.repository.query;

import java.util.ArrayList;
import java.util.List;
import org.codefilarete.reflection.AccessorChain;
import org.codefilarete.reflection.Accessors;
import org.codefilarete.stalactite.query.model.ConditionalOperator;
import org.codefilarete.stalactite.query.model.operator.Between;
import org.codefilarete.stalactite.query.model.operator.Equals;
import org.codefilarete.stalactite.query.model.operator.Greater;
import org.codefilarete.stalactite.query.model.operator.In;
import org.codefilarete.stalactite.query.model.operator.InIgnoreCase;
import org.codefilarete.stalactite.query.model.operator.IsNull;
import org.codefilarete.stalactite.query.model.operator.Lesser;
import org.codefilarete.stalactite.query.model.operator.Like;
import org.codefilarete.tool.collection.Arrays;
import org.springframework.data.mapping.PropertyPath;
import org.springframework.data.repository.query.parser.Part;

public abstract class AbstractDerivedQuery<T> {
    protected final CriteriaChain criteriaChain = new CriteriaChain(new ArrayList<Criterion>());

    protected Criterion convertToCriterion(Part.Type type, boolean ignoreCase) {
        Like operator = null;
        switch (type) {
            case BETWEEN: {
                operator = new Between();
                break;
            }
            case IS_NOT_NULL: {
                operator = new IsNull().not();
                break;
            }
            case IS_NULL: {
                operator = new IsNull();
                break;
            }
            case BEFORE: 
            case LESS_THAN: {
                operator = new Lesser();
                break;
            }
            case LESS_THAN_EQUAL: {
                operator = new Lesser().equals();
                break;
            }
            case AFTER: 
            case GREATER_THAN: {
                operator = new Greater();
                break;
            }
            case GREATER_THAN_EQUAL: {
                operator = new Greater().equals();
                break;
            }
            case NOT_LIKE: {
                operator = new Like(false, false).not();
                if (!ignoreCase) break;
                operator = operator.ignoringCase();
                break;
            }
            case LIKE: {
                operator = new Like(false, false);
                if (!ignoreCase) break;
                operator = operator.ignoringCase();
                break;
            }
            case STARTING_WITH: {
                operator = Like.startsWith();
                break;
            }
            case ENDING_WITH: {
                operator = Like.endsWith();
                break;
            }
            case IS_NOT_EMPTY: {
                break;
            }
            case IS_EMPTY: {
                break;
            }
            case NOT_CONTAINING: {
                operator = Like.contains().not();
                break;
            }
            case CONTAINING: {
                operator = Like.contains();
                break;
            }
            case NOT_IN: {
                operator = new In().not();
                if (!ignoreCase) break;
                operator = ((In)operator).ignoringCase();
                break;
            }
            case IN: {
                operator = new In();
                if (!ignoreCase) break;
                operator = ((In)operator).ignoringCase();
                break;
            }
            case TRUE: {
                operator = new Equals((Object)true);
                break;
            }
            case FALSE: {
                operator = new Equals((Object)false);
                break;
            }
            case NEGATING_SIMPLE_PROPERTY: {
                operator = new Equals().not();
                if (!ignoreCase) break;
                operator = ((Equals)operator).ignoringCase();
                break;
            }
            case SIMPLE_PROPERTY: {
                operator = new Equals();
                if (!ignoreCase) break;
                operator = ((Equals)operator).ignoringCase();
                break;
            }
        }
        if (operator == null) {
            throw new UnsupportedOperationException("Unsupported operator type: " + type);
        }
        if (operator instanceof Between) {
            return new Criterion((ConditionalOperator)operator, 2){

                @Override
                public Object convert(Object[] arguments, int argumentIndex) {
                    return new Between.Interval(arguments[argumentIndex], arguments[argumentIndex + 1]);
                }
            };
        }
        if (operator instanceof In || operator instanceof InIgnoreCase) {
            return new Criterion((ConditionalOperator)operator, 2){

                @Override
                public Object convert(Object[] arguments, int argumentIndex) {
                    Object argument = arguments[argumentIndex];
                    if (argument instanceof Object[]) {
                        return Arrays.asList((Object[])((Object[])argument));
                    }
                    return argument;
                }
            };
        }
        if (operator instanceof IsNull) {
            return new Criterion((ConditionalOperator)operator, 0){

                @Override
                public void setValue(Object[] arguments, int argumentIndex) {
                }
            };
        }
        if (type == Part.Type.TRUE || type == Part.Type.FALSE) {
            return new Criterion((ConditionalOperator)operator, 0){

                @Override
                public void setValue(Object[] arguments, int argumentIndex) {
                }
            };
        }
        return new Criterion((ConditionalOperator)operator);
    }

    protected <O> AccessorChain<T, O> convertToAccessorChain(PropertyPath property) {
        ArrayList accessorChain = new ArrayList();
        property.forEach(path -> accessorChain.add(Accessors.accessor((Class)path.getOwningType().getType(), (String)path.getSegment())));
        return new AccessorChain(accessorChain);
    }

    protected static class CriteriaChain {
        protected final List<Criterion> criteria;

        protected CriteriaChain(List<Criterion> criteria) {
            this.criteria = criteria;
        }

        void consume(Object[] arguments) {
            int argumentIndex = 0;
            for (Criterion criterion : this.criteria) {
                criterion.setValue(arguments, argumentIndex);
                argumentIndex += criterion.argumentCount;
            }
        }
    }

    protected static class Criterion {
        protected final ConditionalOperator<Object, Object> operator;
        private final int argumentCount;

        private Criterion(ConditionalOperator<?, ?> operator) {
            this(operator, 1);
        }

        public Criterion(ConditionalOperator<?, ?> operator, int argumentCount) {
            this.operator = operator;
            this.argumentCount = argumentCount;
        }

        public void setValue(Object[] arguments, int argumentIndex) {
            this.operator.setValue(this.convert(arguments, argumentIndex));
        }

        protected Object convert(Object[] arguments, int argumentIndex) {
            return arguments[argumentIndex];
        }
    }
}

