/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.dsl.idpolicy;

import java.util.function.Consumer;
import java.util.function.Function;
import org.codefilarete.stalactite.dsl.idpolicy.AlreadyAssignedIdentifierPolicy;
import org.codefilarete.stalactite.dsl.idpolicy.AlreadyAssignedIdentifierPolicySupport;
import org.codefilarete.stalactite.dsl.idpolicy.BeforeInsertIdentifierPolicy;
import org.codefilarete.stalactite.dsl.idpolicy.BeforeInsertIdentifierPolicySupport;
import org.codefilarete.stalactite.dsl.idpolicy.DatabaseSequenceIdentifierPolicySupport;
import org.codefilarete.stalactite.dsl.idpolicy.DatabaseSequenceNamingStrategy;
import org.codefilarete.stalactite.dsl.idpolicy.GeneratedKeysPolicy;
import org.codefilarete.stalactite.dsl.idpolicy.GeneratedKeysPolicySupport;
import org.codefilarete.stalactite.dsl.idpolicy.PooledHiLoSequenceIdentifierPolicySupport;
import org.codefilarete.stalactite.mapping.id.sequence.DatabaseSequenceSettings;
import org.codefilarete.stalactite.mapping.id.sequence.hilo.PooledHiLoSequenceStorageOptions;
import org.codefilarete.tool.function.Sequence;

public interface IdentifierPolicy<ID> {
    public static <I> GeneratedKeysPolicy<I> databaseAutoIncrement() {
        return new GeneratedKeysPolicySupport();
    }

    public static BeforeInsertIdentifierPolicy<Long> pooledHiLoSequence() {
        return new PooledHiLoSequenceIdentifierPolicySupport();
    }

    public static BeforeInsertIdentifierPolicy<Long> pooledHiLoSequence(PooledHiLoSequenceStorageOptions sequenceStorageOptions) {
        return new PooledHiLoSequenceIdentifierPolicySupport(sequenceStorageOptions);
    }

    public static BeforeInsertIdentifierPolicy<Long> databaseSequence(DatabaseSequenceNamingStrategy namingStrategy) {
        return new DatabaseSequenceIdentifierPolicySupport(namingStrategy);
    }

    public static BeforeInsertIdentifierPolicy<Long> databaseSequence(String name) {
        return new DatabaseSequenceIdentifierPolicySupport(entityType -> name);
    }

    public static BeforeInsertIdentifierPolicy<Long> databaseSequence(DatabaseSequenceNamingStrategy namingStrategy, DatabaseSequenceSettings databaseSequenceSettings) {
        return new DatabaseSequenceIdentifierPolicySupport(namingStrategy, databaseSequenceSettings);
    }

    public static BeforeInsertIdentifierPolicy<Long> databaseSequence(String name, DatabaseSequenceSettings databaseSequenceSettings) {
        return new DatabaseSequenceIdentifierPolicySupport(entityType -> name, databaseSequenceSettings);
    }

    public static <I> BeforeInsertIdentifierPolicy<I> pooledHiLoSequence(Sequence<I> sequence) {
        return new BeforeInsertIdentifierPolicySupport<I>(sequence);
    }

    public static <C, I> AlreadyAssignedIdentifierPolicy<C, I> alreadyAssigned() {
        return IdentifierPolicy.alreadyAssigned(null, null);
    }

    public static <C, I> AlreadyAssignedIdentifierPolicy<C, I> alreadyAssigned(Consumer<C> markAsPersistedFunction, Function<C, Boolean> isPersistedFunction) {
        return new AlreadyAssignedIdentifierPolicySupport(markAsPersistedFunction, isPersistedFunction);
    }
}

