/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.spring.repository.query;

import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import org.codefilarete.stalactite.spring.repository.query.AbstractQueryExecutor;
import org.codefilarete.stalactite.spring.repository.query.StalactiteQueryMethod;
import org.codefilarete.stalactite.spring.repository.query.StalactiteQueryMethodInvocationParameters;
import org.codefilarete.stalactite.spring.repository.query.StalactiteRepositoryQuery;
import org.codefilarete.stalactite.spring.repository.query.reduce.LimitHandler;
import org.codefilarete.stalactite.spring.repository.query.reduce.QueryResultCollectioner;
import org.codefilarete.stalactite.spring.repository.query.reduce.QueryResultPager;
import org.codefilarete.stalactite.spring.repository.query.reduce.QueryResultReducer;
import org.codefilarete.stalactite.spring.repository.query.reduce.QueryResultSingler;
import org.codefilarete.stalactite.spring.repository.query.reduce.QueryResultSlicer;
import org.codefilarete.stalactite.sql.statement.binder.PreparedStatementWriter;
import org.codefilarete.tool.Reflections;
import org.springframework.data.repository.query.ParameterAccessor;
import org.springframework.data.repository.query.Parameters;
import org.springframework.data.repository.query.ParametersParameterAccessor;
import org.springframework.data.repository.query.ResultProcessor;

public abstract class AbstractRepositoryQuery<C, R>
implements StalactiteRepositoryQuery<C, R> {
    protected final StalactiteQueryMethod method;

    public AbstractRepositoryQuery(StalactiteQueryMethod method) {
        this.method = method;
    }

    @Override
    public StalactiteQueryMethod getQueryMethod() {
        return this.method;
    }

    @Override
    public R execute(Object[] parameters) {
        StalactiteQueryMethodInvocationParameters accessor = new StalactiteQueryMethodInvocationParameters(this.method, parameters);
        AbstractQueryExecutor<List<Object>, Object> queryExecutor = this.buildQueryExecutor(accessor);
        Supplier resultSupplier = queryExecutor.buildQueryExecutor(parameters);
        R adaptation = this.buildResultReducer(accessor, queryExecutor.bindParameters(accessor)).adapt(resultSupplier).apply(parameters);
        ResultProcessor resultProcessor = this.buildResultProcessor(parameters);
        return (R)resultProcessor.processResult(adaptation);
    }

    protected abstract AbstractQueryExecutor<List<Object>, Object> buildQueryExecutor(StalactiteQueryMethodInvocationParameters var1);

    protected <ROW> QueryResultReducer<R, ROW> buildResultReducer(StalactiteQueryMethodInvocationParameters invocationParameters, Map<String, PreparedStatementWriter<?>> bindParameters) {
        QueryResultReducer result;
        switch (this.method.getQueryMethodReturnType()) {
            case COLLECTION: {
                result = new QueryResultCollectioner();
                break;
            }
            case PAGE: {
                result = new QueryResultPager(this, (LimitHandler)invocationParameters, this.buildCountSupplier(invocationParameters, bindParameters));
                break;
            }
            case SLICE: {
                result = new QueryResultSlicer(this, invocationParameters);
                break;
            }
            case SINGLE_ENTITY: {
                result = new QueryResultSingler();
                break;
            }
            case SINGLE_PROJECTION: {
                result = new QueryResultSingler();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported return type for method " + Reflections.toString((Method)this.method.getMethod()));
            }
        }
        return result;
    }

    protected abstract LongSupplier buildCountSupplier(StalactiteQueryMethodInvocationParameters var1, Map<String, PreparedStatementWriter<?>> var2);

    protected ResultProcessor buildResultProcessor(Object[] parameters) {
        ResultProcessor resultProcessor = this.method.getResultProcessor();
        if (this.method.getParameters().hasDynamicProjection()) {
            resultProcessor = resultProcessor.withDynamicProjection((ParameterAccessor)new ParametersParameterAccessor((Parameters)this.method.getParameters(), parameters));
        }
        return resultProcessor;
    }
}

