/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.spring.repository.query;

import java.lang.reflect.Method;
import org.codefilarete.stalactite.engine.runtime.AdvancedEntityPersister;
import org.codefilarete.stalactite.spring.repository.query.PartTreeStalactiteCountProjection;
import org.codefilarete.stalactite.spring.repository.query.PartTreeStalactiteDelete;
import org.codefilarete.stalactite.spring.repository.query.PartTreeStalactiteExistsProjection;
import org.codefilarete.stalactite.spring.repository.query.PartTreeStalactiteProjection;
import org.codefilarete.stalactite.spring.repository.query.PartTreeStalactiteQuery;
import org.codefilarete.stalactite.spring.repository.query.QueryMethodValidator;
import org.codefilarete.stalactite.spring.repository.query.StalactiteQueryMethod;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.repository.core.NamedQueries;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.query.QueryLookupStrategy;
import org.springframework.data.repository.query.RepositoryQuery;
import org.springframework.data.repository.query.parser.PartTree;

public class CreateQueryLookupStrategy<T>
implements QueryLookupStrategy {
    private final AdvancedEntityPersister<T, ?> entityPersister;

    public CreateQueryLookupStrategy(AdvancedEntityPersister<T, ?> entityPersister) {
        this.entityPersister = entityPersister;
    }

    public RepositoryQuery resolveQuery(Method method, RepositoryMetadata metadata, ProjectionFactory factory, NamedQueries namedQueries) {
        PartTree partTree = new PartTree(method.getName(), this.entityPersister.getClassToPersist());
        StalactiteQueryMethod queryMethod = new StalactiteQueryMethod(method, metadata, factory);
        new QueryMethodValidator(partTree, queryMethod).validate();
        if (partTree.isDelete()) {
            return new PartTreeStalactiteDelete<T>(queryMethod, this.entityPersister, partTree);
        }
        if (partTree.isCountProjection()) {
            return new PartTreeStalactiteCountProjection<T>(queryMethod, this.entityPersister, partTree);
        }
        if (partTree.isExistsProjection()) {
            return new PartTreeStalactiteExistsProjection<T>(queryMethod, this.entityPersister, partTree);
        }
        if (queryMethod.getResultProcessor().getReturnedType().isProjecting() && factory.getProjectionInformation(queryMethod.getReturnedObjectType()).isClosed()) {
            return new PartTreeStalactiteProjection(queryMethod, this.entityPersister, partTree, factory);
        }
        return new PartTreeStalactiteQuery(queryMethod, this.entityPersister, partTree);
    }
}

