/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.runtime.singletable;

import java.sql.ResultSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.codefilarete.stalactite.engine.PolymorphismPolicy;
import org.codefilarete.stalactite.engine.configurer.PersisterBuilderContext;
import org.codefilarete.stalactite.engine.configurer.PersisterBuilderImpl;
import org.codefilarete.stalactite.engine.runtime.AbstractPolymorphicEntityFinder;
import org.codefilarete.stalactite.engine.runtime.ConfiguredRelationalPersister;
import org.codefilarete.stalactite.engine.runtime.load.EntityJoinTree;
import org.codefilarete.stalactite.engine.runtime.load.EntityTreeQueryBuilder;
import org.codefilarete.stalactite.engine.runtime.load.SingleTableRootJoinNode;
import org.codefilarete.stalactite.engine.runtime.query.EntityCriteriaSupport;
import org.codefilarete.stalactite.engine.runtime.query.EntityQueryCriteriaSupport;
import org.codefilarete.stalactite.mapping.id.assembly.IdentifierAssembler;
import org.codefilarete.stalactite.query.ConfiguredEntityCriteria;
import org.codefilarete.stalactite.query.builder.QuerySQLBuilderFactory;
import org.codefilarete.stalactite.query.model.GroupBy;
import org.codefilarete.stalactite.query.model.Having;
import org.codefilarete.stalactite.query.model.Limit;
import org.codefilarete.stalactite.query.model.OrderBy;
import org.codefilarete.stalactite.query.model.Query;
import org.codefilarete.stalactite.query.model.Select;
import org.codefilarete.stalactite.query.model.Selectable;
import org.codefilarete.stalactite.query.model.Where;
import org.codefilarete.stalactite.sql.ConnectionProvider;
import org.codefilarete.stalactite.sql.Dialect;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.PrimaryKey;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.stalactite.sql.result.ColumnedRow;
import org.codefilarete.stalactite.sql.result.ColumnedRowIterator;
import org.codefilarete.stalactite.sql.statement.PreparedSQL;
import org.codefilarete.stalactite.sql.statement.ReadOperation;
import org.codefilarete.stalactite.sql.statement.SQLExecutionException;
import org.codefilarete.stalactite.sql.statement.SQLStatement;
import org.codefilarete.stalactite.sql.statement.binder.ResultSetReader;
import org.codefilarete.stalactite.sql.statement.binder.ResultSetReaderRegistry;
import org.codefilarete.tool.VisibleForTesting;
import org.codefilarete.tool.collection.KeepOrderMap;
import org.codefilarete.tool.collection.KeepOrderSet;

public class SingleTablePolymorphismEntityFinder<C, I, T extends Table<T>, DTYPE>
extends AbstractPolymorphicEntityFinder<C, I, T> {
    @VisibleForTesting
    static final String DISCRIMINATOR_ALIAS = "DISCRIMINATOR";
    private final IdentifierAssembler<I, T> identifierAssembler;
    private final Column<T, DTYPE> discriminatorColumn;
    private final PolymorphismPolicy.SingleTablePolymorphism<C, DTYPE> polymorphismPolicy;
    private final EntityJoinTree<C, I> singleLoadEntityJoinTree;
    private final EntityCriteriaSupport<C> criteriaSupport;
    private Query query;
    private EntityTreeQueryBuilder.EntityTreeQuery<C> entityTreeQuery;

    public SingleTablePolymorphismEntityFinder(ConfiguredRelationalPersister<C, I> mainPersister, Map<? extends Class<C>, ? extends ConfiguredRelationalPersister<C, I>> persisterPerSubclass, Column<T, DTYPE> discriminatorColumn, PolymorphismPolicy.SingleTablePolymorphism<C, DTYPE> polymorphismPolicy, ConnectionProvider connectionProvider, Dialect dialect) {
        super(mainPersister, persisterPerSubclass, connectionProvider, dialect);
        this.identifierAssembler = mainPersister.getMapping().getIdMapping().getIdentifierAssembler();
        this.discriminatorColumn = discriminatorColumn;
        this.polymorphismPolicy = polymorphismPolicy;
        this.singleLoadEntityJoinTree = this.buildSingleLoadEntityJoinTree(mainPersister, persisterPerSubclass);
        this.criteriaSupport = new EntityCriteriaSupport<C>(this.singleLoadEntityJoinTree);
        PersisterBuilderContext.CURRENT.get().addBuildLifeCycleListener(new PersisterBuilderImpl.BuildLifeCycleListener(){

            @Override
            public void afterBuild() {
            }

            @Override
            public void afterAllBuild() {
                SingleTablePolymorphismEntityFinder.this.buildQuery();
            }
        });
    }

    private void buildQuery() {
        this.entityTreeQuery = new EntityTreeQueryBuilder<C>(this.singleLoadEntityJoinTree, (ResultSetReaderRegistry)this.dialect.getColumnBinderRegistry()).buildSelectQuery();
        this.query = this.entityTreeQuery.getQuery();
    }

    @Override
    protected EntityTreeQueryBuilder.EntityTreeQuery<C> getAggregateQueryTemplate() {
        return this.entityTreeQuery;
    }

    @Override
    public EntityJoinTree<C, I> getEntityJoinTree() {
        return this.singleLoadEntityJoinTree;
    }

    @Override
    public EntityQueryCriteriaSupport<C, I> newCriteriaSupport() {
        return new EntityQueryCriteriaSupport(this, this.criteriaSupport.copy());
    }

    private SingleLoadEntityJoinTree<C, I, DTYPE> buildSingleLoadEntityJoinTree(ConfiguredRelationalPersister<C, I> mainPersister, Map<? extends Class<C>, ? extends ConfiguredRelationalPersister<C, I>> persisterPerSubclass) {
        SingleLoadEntityJoinTree result = new SingleLoadEntityJoinTree(mainPersister, new HashSet<ConfiguredRelationalPersister<C, I>>(persisterPerSubclass.values()), this.discriminatorColumn, this.polymorphismPolicy);
        mainPersister.getEntityJoinTree().projectTo(result, "ROOT");
        persisterPerSubclass.values().forEach(subPersister -> subPersister.getEntityJoinTree().projectTo(result, "ROOT"));
        return result;
    }

    @Override
    public Set<C> selectWithSingleQuery(ConfiguredEntityCriteria where, Map<String, Object> values, OrderBy orderBy, Limit limit) {
        this.LOGGER.debug("Finding entities in a single query with criteria {}", (Object)where);
        if (this.hasSubPolymorphicPersister) {
            this.LOGGER.debug("Single query was asked but due to sub-polymorphism the query is made in 2 phases");
            return this.selectIn2Phases(where, values, orderBy, limit);
        }
        Where add = new Where();
        add.add((Iterable)this.query.getWhereDelegate().getConditions());
        add.add(where.getCriteria());
        Query queryClone = new Query(this.query.getSelectDelegate(), this.query.getFromDelegate(), add, new GroupBy(), new Having(), orderBy, limit);
        return super.selectWithSingleQuery(queryClone, values, this.entityTreeQuery, this.dialect, this.connectionProvider);
    }

    @Override
    public Set<C> selectIn2Phases(ConfiguredEntityCriteria where, Map<String, Object> values, OrderBy orderBy, Limit limit) {
        this.LOGGER.debug("Finding entities in 2-phases query with criteria {}", (Object)where);
        Query queryClone = new Query(new Select(), this.query.getFromDelegate(), new Where(where.getCriteria()), new GroupBy(), new Having(), orderBy, limit);
        QuerySQLBuilderFactory.QuerySQLBuilder sqlQueryBuilder = this.dialect.getQuerySQLBuilderFactory().queryBuilder(queryClone);
        PrimaryKey pk = ((Table)this.mainEntityJoinTree.getRoot().getTable()).getPrimaryKey();
        pk.getColumns().forEach(column -> queryClone.select((Selectable)column, column.getAlias()));
        queryClone.select(this.discriminatorColumn, DISCRIMINATOR_ALIAS);
        HashMap columnReaders = new HashMap();
        queryClone.getColumns().forEach(selectable -> {
            ResultSetReader cfr_ignored_0 = (ResultSetReader)columnReaders.put((Selectable<?>)selectable, (ResultSetReader<?>)this.dialect.getColumnBinderRegistry().getBinder((Object)((Column)selectable)));
        });
        Map<Class, Set<I>> idsPerSubtype = this.readIds(sqlQueryBuilder.toPreparableSQL().toPreparedSQL(values), columnReaders, queryClone.getAliases());
        Set ids = idsPerSubtype.values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
        if (this.hasSubPolymorphicPersister) {
            this.LOGGER.debug("Asking sub-polymorphic persisters to load the entities");
            HashSet result = new HashSet();
            idsPerSubtype.forEach((k, v) -> result.addAll(((ConfiguredRelationalPersister)this.persisterPerSubclass.get(k)).select((Iterable)v)));
            return result;
        }
        return this.selectWithSingleQueryWhereIdIn(ids);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map<Class, Set<I>> readIds(PreparedSQL preparedSQL, Map<Selectable<?>, ResultSetReader<?>> columnReaders, Map<Selectable<?>, String> aliases) {
        try (ReadOperation closeableOperation = this.dialect.getReadOperationFactory().createInstance((SQLStatement)preparedSQL, this.connectionProvider);){
            ResultSet resultSet = closeableOperation.execute();
            ColumnedRowIterator rowIterator = new ColumnedRowIterator(resultSet, columnReaders, aliases);
            KeepOrderMap result = new KeepOrderMap();
            rowIterator.forEachRemaining(arg_0 -> this.lambda$readIds$5((Map)result, arg_0));
            KeepOrderMap keepOrderMap = result;
            return keepOrderMap;
        }
        catch (RuntimeException e) {
            throw new SQLExecutionException(preparedSQL.getSQL(), (Throwable)e);
        }
    }

    private /* synthetic */ void lambda$readIds$5(Map result, ColumnedRow row) {
        Object dtype = row.get(this.discriminatorColumn);
        Object id = this.identifierAssembler.assemble(row);
        result.computeIfAbsent(this.polymorphismPolicy.getClass(dtype), k -> new KeepOrderSet()).add(id);
    }

    private static class SingleLoadEntityJoinTree<C, I, DTYPE>
    extends EntityJoinTree<C, I> {
        public <T extends Table<T>> SingleLoadEntityJoinTree(ConfiguredRelationalPersister<C, I> mainPersister, Set<? extends ConfiguredRelationalPersister<C, I>> subPersisters, Column<T, DTYPE> discriminatorColumn, PolymorphismPolicy.SingleTablePolymorphism<C, DTYPE> polymorphismPolicy) {
            super((EntityJoinTree<C, I> self) -> new SingleTableRootJoinNode(self, mainPersister, subPersisters, discriminatorColumn, polymorphismPolicy));
        }
    }
}

