/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.mapping;

import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Function;
import org.codefilarete.reflection.Accessors;
import org.codefilarete.reflection.Mutator;
import org.codefilarete.stalactite.mapping.AbstractTransformer;
import org.codefilarete.stalactite.mapping.RowTransformer;
import org.codefilarete.stalactite.query.model.Selectable;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.stalactite.sql.result.ColumnedRow;
import org.codefilarete.tool.Reflections;
import org.codefilarete.tool.bean.FieldIterator;
import org.codefilarete.tool.collection.Iterables;

public class ToBeanRowTransformer<C>
extends AbstractTransformer<C> {
    private final Map<Column<?, ?>, Mutator<C, Object>> columnToMember;

    public ToBeanRowTransformer(Class<C> clazz, Table table, boolean warnOnMissingColumn) {
        this(clazz, new HashMap(10));
        Map columnPerName = table.mapColumnsOnName();
        FieldIterator fieldIterator = new FieldIterator(clazz);
        Iterables.stream((Iterator)fieldIterator).forEach(field -> {
            Column column = (Column)columnPerName.get(field.getName());
            if (column == null) {
                if (warnOnMissingColumn) {
                    throw new UnsupportedOperationException("Missing column for field " + Reflections.toString((Field)field));
                }
            } else {
                this.columnToMember.put(column, (Mutator<C, Object>)Accessors.mutatorByField((Field)field));
            }
        });
    }

    public ToBeanRowTransformer(Class<C> clazz, Map<? extends Column<?, ?>, ? extends Mutator<C, Object>> columnToMember) {
        super(clazz);
        this.columnToMember = columnToMember;
    }

    public ToBeanRowTransformer(Function<? extends ColumnedRow, C> beanFactory, Map<? extends Column<?, ?>, ? extends Mutator<C, Object>> columnToMember) {
        super(beanFactory);
        this.columnToMember = columnToMember;
    }

    protected ToBeanRowTransformer(Function<ColumnedRow, C> beanFactory, Map<? extends Column<?, ?>, ? extends Mutator<C, Object>> columnToMember, Collection<RowTransformer.TransformerListener<C>> rowTransformerListeners) {
        super(beanFactory, rowTransformerListeners);
        this.columnToMember = columnToMember;
    }

    public Map<Column<?, ?>, Mutator<C, Object>> getColumnToMember() {
        return this.columnToMember;
    }

    @Override
    public void applyRowToBean(ColumnedRow source, C targetRowBean) {
        for (Map.Entry<Column<?, ?>, Mutator<C, Object>> columnFieldEntry : this.columnToMember.entrySet()) {
            Object propertyValue = source.get((Selectable)columnFieldEntry.getKey());
            this.applyValueToBean(targetRowBean, columnFieldEntry, propertyValue);
        }
    }

    protected void applyValueToBean(C targetRowBean, Map.Entry<? extends Column, ? extends Mutator<C, Object>> columnFieldEntry, Object propertyValue) {
        columnFieldEntry.getValue().set(targetRowBean, propertyValue);
    }
}

