/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.crud;

import java.util.Set;
import org.codefilarete.stalactite.engine.crud.ExecutableUpdate;
import org.codefilarete.stalactite.query.model.Where;
import org.codefilarete.stalactite.sql.ConnectionProvider;
import org.codefilarete.stalactite.sql.Dialect;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.stalactite.sql.order.Update;
import org.codefilarete.stalactite.sql.order.UpdateCommandBuilder;
import org.codefilarete.stalactite.sql.statement.WriteOperation;

public class DefaultExecutableUpdate<T extends Table<T>>
extends Update<T>
implements ExecutableUpdate<T> {
    private final Dialect dialect;
    private final ConnectionProvider connectionProvider;

    public DefaultExecutableUpdate(T targetTable, Dialect dialect, ConnectionProvider connectionProvider) {
        super(targetTable);
        this.dialect = dialect;
        this.connectionProvider = connectionProvider;
    }

    public DefaultExecutableUpdate(T targetTable, Where<?> where, Dialect dialect, ConnectionProvider connectionProvider) {
        super(targetTable, where);
        this.dialect = dialect;
        this.connectionProvider = connectionProvider;
    }

    public DefaultExecutableUpdate(T targetTable, Set<? extends Column<T, ?>> columnsToUpdate, Dialect dialect, ConnectionProvider connectionProvider) {
        super(targetTable, columnsToUpdate);
        this.dialect = dialect;
        this.connectionProvider = connectionProvider;
    }

    public DefaultExecutableUpdate(T targetTable, Set<? extends Column<T, ?>> columnsToUpdate, Where<?> where, Dialect dialect, ConnectionProvider connectionProvider) {
        super(targetTable, columnsToUpdate, where);
        this.dialect = dialect;
        this.connectionProvider = connectionProvider;
    }

    @Override
    public <O> DefaultExecutableUpdate<T> set(Column<? extends T, O> column, O value) {
        super.set(column, value);
        return this;
    }

    @Override
    public <O> DefaultExecutableUpdate<T> set(Column<? extends T, O> column1, Column<?, O> column2) {
        super.set(column1, column2);
        return this;
    }

    @Override
    public <O> DefaultExecutableUpdate<T> set(String paramName, O value) {
        super.set(paramName, value);
        return this;
    }

    @Override
    public long execute() {
        UpdateCommandBuilder.UpdateStatement updateStatement = new UpdateCommandBuilder(this, this.dialect).toStatement();
        try (WriteOperation writeOperation = this.dialect.getWriteOperationFactory().createInstance(updateStatement, this.connectionProvider);){
            writeOperation.setValues(updateStatement.getValues());
            long l = writeOperation.execute();
            return l;
        }
    }
}

