/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.spring.repository.query.nativ;

import java.lang.reflect.Executable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.LongSupplier;
import javax.annotation.Nullable;
import org.codefilarete.reflection.MethodReferenceCapturer;
import org.codefilarete.stalactite.engine.runtime.AdvancedEntityPersister;
import org.codefilarete.stalactite.engine.runtime.RelationalEntityFinder;
import org.codefilarete.stalactite.query.model.Selectable;
import org.codefilarete.stalactite.spring.repository.query.AbstractQueryExecutor;
import org.codefilarete.stalactite.spring.repository.query.AbstractRepositoryQuery;
import org.codefilarete.stalactite.spring.repository.query.NativeQuery;
import org.codefilarete.stalactite.spring.repository.query.ProjectionTypeInformationExtractor;
import org.codefilarete.stalactite.spring.repository.query.StalactiteQueryMethod;
import org.codefilarete.stalactite.spring.repository.query.StalactiteQueryMethodInvocationParameters;
import org.codefilarete.stalactite.spring.repository.query.nativ.EntityNativeQueryExecutor;
import org.codefilarete.stalactite.spring.repository.query.nativ.TupleNativeQueryExecutor;
import org.codefilarete.stalactite.sql.ConnectionProvider;
import org.codefilarete.stalactite.sql.Dialect;
import org.codefilarete.stalactite.sql.result.ResultSetIterator;
import org.codefilarete.stalactite.sql.statement.ReadOperation;
import org.codefilarete.stalactite.sql.statement.SQLExecutionException;
import org.codefilarete.stalactite.sql.statement.SQLStatement;
import org.codefilarete.stalactite.sql.statement.StringParamedSQL;
import org.codefilarete.stalactite.sql.statement.binder.PreparedStatementWriter;
import org.codefilarete.tool.Reflections;
import org.springframework.data.mapping.PropertyPath;
import org.springframework.data.projection.ProjectionFactory;

public class SqlNativeRepositoryQuery<C, R>
extends AbstractRepositoryQuery<C, R> {
    private final String sql;
    @Nullable
    private final String sqlCount;
    private final ProjectionFactory factory;
    private final Dialect dialect;
    private final ConnectionProvider connectionProvider;
    private final RelationalEntityFinder<C, ?, ?> relationalEntityFinder;
    private final ProjectionTypeInformationExtractor<C> projectionTypeInformationExtractor;

    public SqlNativeRepositoryQuery(StalactiteQueryMethod queryMethod, String sql, @Nullable String sqlCount, AdvancedEntityPersister<C, ?> entityPersister, ProjectionFactory factory, Dialect dialect, ConnectionProvider connectionProvider) {
        super(queryMethod);
        this.sql = sql;
        this.sqlCount = sqlCount;
        this.factory = factory;
        this.dialect = dialect;
        this.connectionProvider = connectionProvider;
        this.projectionTypeInformationExtractor = new ProjectionTypeInformationExtractor<C>(factory, entityPersister);
        this.relationalEntityFinder = new RelationalEntityFinder(entityPersister.getEntityJoinTree(), connectionProvider, dialect, true);
    }

    @Override
    protected AbstractQueryExecutor<List<Object>, Object> buildQueryExecutor(StalactiteQueryMethodInvocationParameters invocationParameters) {
        AbstractQueryExecutor queryExecutor;
        if (this.method.getParameters().hasDynamicProjection() && this.factory.getProjectionInformation(invocationParameters.getDynamicProjectionType()).isClosed() || this.getQueryMethod().getResultProcessor().getReturnedType().isProjecting()) {
            if (this.method.getParameters().hasDynamicProjection()) {
                this.projectionTypeInformationExtractor.extract(invocationParameters.getDynamicProjectionType());
            } else {
                this.projectionTypeInformationExtractor.extract(this.method.getReturnedObjectType());
            }
            IdentityHashMap<Selectable<?>, String> aliases = this.projectionTypeInformationExtractor.getAliases();
            IdentityHashMap<Selectable<?>, PropertyPath> columnToProperties = this.projectionTypeInformationExtractor.getColumnToProperties();
            queryExecutor = new TupleNativeQueryExecutor(this.getQueryMethod(), this.sql, this.dialect, this.connectionProvider, aliases, columnToProperties, invocationParameters::getLimit);
        } else {
            queryExecutor = new EntityNativeQueryExecutor<Object>(this.getQueryMethod(), this.sql, this.relationalEntityFinder, this.dialect);
        }
        return queryExecutor;
    }

    @Override
    protected LongSupplier buildCountSupplier(StalactiteQueryMethodInvocationParameters invocationParameters, Map<String, PreparedStatementWriter<?>> bindParameters) {
        return () -> {
            if (this.sqlCount == null || this.sqlCount.isEmpty()) {
                MethodReferenceCapturer methodReferenceCapturer = new MethodReferenceCapturer();
                Executable countQueryAccessor = methodReferenceCapturer.findExecutable(NativeQuery::countQuery);
                throw new IllegalStateException("Count query is mandatory for paged queries, please provide one through " + Reflections.toString((Executable)countQueryAccessor));
            }
            StringParamedSQL query = new StringParamedSQL(this.sqlCount, bindParameters);
            query.setValues(invocationParameters.getNamedValues());
            try (ReadOperation readOperation = this.dialect.getReadOperationFactory().createInstance((SQLStatement)query, this.connectionProvider);){
                readOperation.setValues(query.getValues());
                ResultSet resultSet = readOperation.execute();
                ResultSetIterator<Long> resultSetIterator = new ResultSetIterator<Long>(resultSet){

                    public Long convert(ResultSet resultSet) throws SQLException {
                        return resultSet.getLong(1);
                    }
                };
                long l = resultSetIterator.hasNext() ? (Long)resultSetIterator.next() : 0L;
                return l;
            }
            catch (RuntimeException e) {
                throw new SQLExecutionException(query.getSQL(), (Throwable)e);
            }
        };
    }
}

