/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.spring.repository.query;

import java.util.IdentityHashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.codefilarete.reflection.Accessor;
import org.codefilarete.reflection.AccessorChain;
import org.codefilarete.reflection.Accessors;
import org.codefilarete.stalactite.engine.runtime.AdvancedEntityPersister;
import org.codefilarete.stalactite.engine.runtime.query.AggregateAccessPointToColumnMapping;
import org.codefilarete.stalactite.query.model.Selectable;
import org.codefilarete.tool.collection.Iterables;
import org.springframework.data.mapping.PropertyPath;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.projection.EntityProjection;
import org.springframework.data.projection.EntityProjectionIntrospector;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.relational.core.mapping.RelationalMappingContext;

public class ProjectionTypeInformationExtractor<C> {
    private IdentityHashMap<Selectable<?>, String> aliases = new IdentityHashMap();
    private IdentityHashMap<Selectable<?>, PropertyPath> columnToProperties = new IdentityHashMap();
    private final AggregateAccessPointToColumnMapping<C> aggregateColumnMapping;
    private final EntityProjectionIntrospector entityProjectionIntrospector;
    private final Class<C> aggregateType;

    public ProjectionTypeInformationExtractor(ProjectionFactory factory, AdvancedEntityPersister<C, ?> entityPersister) {
        EntityProjectionIntrospector.ProjectionPredicate predicate = (returnType, domainType) -> !domainType.isAssignableFrom(returnType) && !returnType.isAssignableFrom(domainType);
        this.entityProjectionIntrospector = EntityProjectionIntrospector.create((ProjectionFactory)factory, (EntityProjectionIntrospector.ProjectionPredicate)predicate, (MappingContext)new RelationalMappingContext());
        this.aggregateColumnMapping = entityPersister.getEntityFinder().newCriteriaSupport().getEntityCriteriaSupport().getAggregateColumnMapping();
        this.aggregateType = entityPersister.getClassToPersist();
    }

    public IdentityHashMap<Selectable<?>, String> getAliases() {
        return this.aliases;
    }

    public IdentityHashMap<Selectable<?>, PropertyPath> getColumnToProperties() {
        return this.columnToProperties;
    }

    public void extract(Class<?> projectionTypeToIntrospect) {
        this.aliases = new IdentityHashMap();
        this.columnToProperties = new IdentityHashMap();
        EntityProjection projectionTypeIntrospection = this.entityProjectionIntrospector.introspect(projectionTypeToIntrospect, this.aggregateType);
        projectionTypeIntrospection.forEachRecursive(projectionProperty -> {
            AccessorChain accessorChain = new AccessorChain();
            List collect = projectionProperty.getPropertyPath().stream().collect(Collectors.toList());
            if (collect.size() >= 2) {
                collect = Iterables.cutTail(collect);
            }
            collect.forEach(propertyPath -> propertyPath.forEach(propertyPath1 -> accessorChain.add((Accessor)Accessors.accessor((Class)propertyPath1.getOwningType().getType(), (String)propertyPath1.getSegment(), (Class)propertyPath1.getType()))));
            Selectable selectable = this.aggregateColumnMapping.giveColumn(accessorChain.getAccessors());
            this.columnToProperties.put(selectable, projectionProperty.getPropertyPath());
            String alias = projectionProperty.getPropertyPath().toDotPath().replace('.', '_');
            this.aliases.put(selectable, alias);
        });
    }
}

