/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.spring.repository.query;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.codefilarete.reflection.Accessor;
import org.codefilarete.reflection.AccessorByMember;
import org.codefilarete.reflection.AccessorChain;
import org.codefilarete.reflection.Accessors;
import org.codefilarete.stalactite.engine.EntityPersister;
import org.codefilarete.stalactite.engine.runtime.AdvancedEntityPersister;
import org.codefilarete.stalactite.engine.runtime.query.EntityCriteriaSupport;
import org.codefilarete.stalactite.engine.runtime.query.EntityQueryCriteriaSupport;
import org.codefilarete.stalactite.query.model.LogicalOperator;
import org.codefilarete.stalactite.spring.repository.query.AbstractDerivedQuery;
import org.codefilarete.stalactite.spring.repository.query.PartTreeStalactiteCountProjection;
import org.codefilarete.stalactite.spring.repository.query.StalactiteQueryMethod;
import org.codefilarete.stalactite.spring.repository.query.StalactiteRepositoryQuery;
import org.codefilarete.stalactite.spring.repository.query.reduce.LimitHandler;
import org.codefilarete.stalactite.spring.repository.query.reduce.QueryResultCollectioner;
import org.codefilarete.stalactite.spring.repository.query.reduce.QueryResultPager;
import org.codefilarete.stalactite.spring.repository.query.reduce.QueryResultReducer;
import org.codefilarete.stalactite.spring.repository.query.reduce.QueryResultSingler;
import org.codefilarete.stalactite.spring.repository.query.reduce.QueryResultSlicer;
import org.codefilarete.stalactite.sql.result.Accumulators;
import org.codefilarete.tool.Nullable;
import org.springframework.data.domain.Sort;
import org.springframework.data.mapping.PropertyPath;
import org.springframework.data.repository.query.ParameterAccessor;
import org.springframework.data.repository.query.Parameters;
import org.springframework.data.repository.query.ParametersParameterAccessor;
import org.springframework.data.repository.query.parser.Part;
import org.springframework.data.repository.query.parser.PartTree;

public class PartTreeStalactiteQuery<C, R>
implements StalactiteRepositoryQuery<C, R> {
    private final StalactiteQueryMethod method;
    protected final DerivedQuery<C> query;
    private final AdvancedEntityPersister<C, ?> entityPersister;
    private final PartTree tree;

    public PartTreeStalactiteQuery(StalactiteQueryMethod method, AdvancedEntityPersister<C, ?> entityPersister, PartTree tree) {
        this.method = method;
        this.entityPersister = entityPersister;
        this.tree = tree;
        try {
            this.query = new DerivedQuery(entityPersister, tree);
            if (tree.getSort().isSorted()) {
                tree.getSort().iterator().forEachRemaining(order -> {
                    PropertyPath propertyPath = PropertyPath.from((String)order.getProperty(), (Class)entityPersister.getClassToPersist());
                    AccessorChain orderProperty = this.query.convertToAccessorChain(propertyPath);
                    this.query.executableEntityQuery.getQueryPageSupport().orderBy(orderProperty, order.getDirection() == Sort.Direction.ASC ? EntityPersister.OrderByChain.Order.ASC : EntityPersister.OrderByChain.Order.DESC, order.isIgnoreCase());
                });
            }
            Nullable.nullable((Object)tree.getMaxResults()).invoke(arg_0 -> ((EntityQueryCriteriaSupport.EntityQueryPageSupport)this.query.executableEntityQuery.getQueryPageSupport()).limit(arg_0));
        }
        catch (RuntimeException o_O) {
            throw new IllegalArgumentException(String.format("Failed to create query for method %s! %s", new Object[]{method, o_O.getMessage()}), o_O);
        }
    }

    @Override
    @org.springframework.lang.Nullable
    public R execute(Object[] parameters) {
        this.query.criteriaChain.consume(parameters);
        R adaptation = this.buildResultWindower().adapt(() -> (List)this.handleDynamicSort(parameters).wrapGraphLoad(new HashMap()).apply(Accumulators.toList())).apply(parameters);
        if (this.method.getParameters().hasDynamicProjection()) {
            return (R)this.method.getResultProcessor().withDynamicProjection((ParameterAccessor)new ParametersParameterAccessor((Parameters)this.method.getParameters(), parameters)).processResult(adaptation);
        }
        return (R)this.method.getResultProcessor().processResult(adaptation);
    }

    private QueryResultReducer<R, C> buildResultWindower() {
        QueryResultReducer result = this.method.isPageQuery() ? new QueryResultPager(this, new LimitHandler(){

            @Override
            public void limit(int count) {
                PartTreeStalactiteQuery.this.query.executableEntityQuery.getQueryPageSupport().limit(count);
            }

            @Override
            public void limit(int count, Integer offset) {
                PartTreeStalactiteQuery.this.query.executableEntityQuery.getQueryPageSupport().limit(count, offset);
            }
        }, new PartTreeStalactiteCountProjection<C>(this.method, this.entityPersister, this.tree)) : (this.method.isSliceQuery() ? new QueryResultSlicer(this, new LimitHandler(){

            @Override
            public void limit(int count) {
                PartTreeStalactiteQuery.this.query.executableEntityQuery.getQueryPageSupport().limit(count);
            }

            @Override
            public void limit(int count, Integer offset) {
                PartTreeStalactiteQuery.this.query.executableEntityQuery.getQueryPageSupport().limit(count, offset);
            }
        }) : (this.method.isCollectionQuery() ? new QueryResultCollectioner() : new QueryResultSingler()));
        return result;
    }

    private EntityQueryCriteriaSupport<C, ?> handleDynamicSort(Object[] parameters) {
        EntityQueryCriteriaSupport derivedQueryToUse;
        ParametersParameterAccessor parameterHelper = new ParametersParameterAccessor((Parameters)this.getQueryMethod().getParameters(), parameters);
        if (parameterHelper.getSort().isSorted()) {
            DerivedQuery derivedQuery = new DerivedQuery(this.query.executableEntityQuery);
            Class declaringClass = this.getQueryMethod().getEntityInformation().getJavaType();
            parameterHelper.getSort().stream().forEachOrdered(order -> {
                AccessorByMember accessor = Accessors.accessor((Class)declaringClass, (String)order.getProperty());
                derivedQuery.dynamicSortSupport.orderBy(new AccessorChain(new Accessor[]{accessor}), order.getDirection() == Sort.Direction.ASC ? EntityPersister.OrderByChain.Order.ASC : EntityPersister.OrderByChain.Order.DESC, order.isIgnoreCase());
            });
            derivedQueryToUse = derivedQuery.executableEntityQuery.copyFor(derivedQuery.dynamicSortSupport);
        } else {
            derivedQueryToUse = this.query.executableEntityQuery;
        }
        return derivedQueryToUse;
    }

    @Override
    public StalactiteQueryMethod getQueryMethod() {
        return this.method;
    }

    static class DerivedQuery<T>
    extends AbstractDerivedQuery<T> {
        protected final EntityQueryCriteriaSupport<T, ?> executableEntityQuery;
        protected final EntityQueryCriteriaSupport.EntityQueryPageSupport<T> dynamicSortSupport = new EntityQueryCriteriaSupport.EntityQueryPageSupport();
        protected EntityCriteriaSupport<T> currentSupport;

        private DerivedQuery(AdvancedEntityPersister<T, ?> entityPersister, PartTree tree) {
            this.executableEntityQuery = entityPersister.newCriteriaSupport();
            tree.forEach(this::append);
        }

        private DerivedQuery(EntityQueryCriteriaSupport<T, ?> executableEntityQuery) {
            this.executableEntityQuery = executableEntityQuery;
        }

        private void append(PartTree.OrPart part) {
            Iterator iterator;
            this.currentSupport = this.executableEntityQuery.getEntityCriteriaSupport();
            boolean nested = false;
            if (part.stream().count() > 1L) {
                nested = true;
                this.currentSupport = this.currentSupport.beginNested();
            }
            if ((iterator = part.iterator()).hasNext()) {
                this.append((Part)iterator.next(), LogicalOperator.OR);
            }
            iterator.forEachRemaining(p -> this.append((Part)p, LogicalOperator.AND));
            if (nested) {
                this.currentSupport = this.currentSupport.endNested();
            }
        }

        private void append(Part part, LogicalOperator orOrAnd) {
            AccessorChain getter = this.convertToAccessorChain(part.getProperty());
            AbstractDerivedQuery.Criterion criterion = this.convertToCriterion(part.getType(), part.shouldIgnoreCase() != Part.IgnoreCaseType.NEVER);
            this.currentSupport.add(orOrAnd, getter.getAccessors(), criterion.operator);
            this.criteriaChain.criteria.add(criterion);
        }
    }
}

