/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.spring.repository.query;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.codefilarete.stalactite.spring.repository.query.QueryExecutor;
import org.codefilarete.stalactite.spring.repository.query.StalactiteQueryMethod;
import org.codefilarete.stalactite.sql.Dialect;
import org.codefilarete.stalactite.sql.statement.binder.PreparedStatementWriter;
import org.springframework.core.ResolvableType;
import org.springframework.data.relational.repository.query.RelationalParameters;
import org.springframework.data.repository.query.ParametersParameterAccessor;

public abstract class AbstractQueryExecutor<C extends Collection<R>, R>
implements QueryExecutor<C, R> {
    protected final StalactiteQueryMethod method;
    protected final Dialect dialect;

    public AbstractQueryExecutor(StalactiteQueryMethod method, Dialect dialect) {
        this.method = method;
        this.dialect = dialect;
    }

    public Map<String, PreparedStatementWriter<?>> bindParameters(ParametersParameterAccessor accessor) {
        HashMap result = new HashMap();
        RelationalParameters bindableParameters = (RelationalParameters)this.method.getParameters().getBindableParameters();
        for (RelationalParameters.RelationalParameter bindableParameter : bindableParameters) {
            Class<Object> valueType;
            String parameterName = (String)bindableParameter.getName().orElseThrow(() -> new IllegalStateException("For queries with named parameters you need to provide names for method parameters. Use @Param for query method parameters, or when on Java 8+ use the javac flag -parameters."));
            Object value = accessor.getBindableValue(bindableParameter.getIndex());
            if (value instanceof Iterable) {
                ResolvableType resolvableType = bindableParameter.getResolvableType();
                valueType = resolvableType.getGeneric(new int[]{0}).resolve();
            } else {
                valueType = value.getClass().isArray() ? value.getClass().getComponentType() : value.getClass();
            }
            PreparedStatementWriter writer = this.dialect.getColumnBinderRegistry().getWriter(valueType);
            result.put(parameterName, writer);
        }
        return result;
    }
}

