/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.runtime.query;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.map.HashedMap;
import org.codefilarete.reflection.AccessorByMethodReference;
import org.codefilarete.reflection.AccessorChain;
import org.codefilarete.reflection.AccessorDefinition;
import org.codefilarete.reflection.MutatorByMethodReference;
import org.codefilarete.reflection.ValueAccessPoint;
import org.codefilarete.stalactite.engine.runtime.load.EntityJoinTree;
import org.codefilarete.stalactite.engine.runtime.query.AggregateAccessPointToColumnMapping;
import org.codefilarete.stalactite.query.ConfiguredEntityCriteria;
import org.codefilarete.stalactite.query.RelationalEntityCriteria;
import org.codefilarete.stalactite.query.model.AbstractCriterion;
import org.codefilarete.stalactite.query.model.ColumnCriterion;
import org.codefilarete.stalactite.query.model.ConditionalOperator;
import org.codefilarete.stalactite.query.model.Criteria;
import org.codefilarete.stalactite.query.model.CriteriaChain;
import org.codefilarete.stalactite.query.model.LogicalOperator;
import org.codefilarete.stalactite.query.model.Selectable;
import org.codefilarete.tool.Duo;
import org.codefilarete.tool.Reflections;
import org.codefilarete.tool.VisibleForTesting;
import org.codefilarete.tool.collection.Arrays;
import org.codefilarete.tool.collection.PairIterator;
import org.danekja.java.util.function.serializable.SerializableBiConsumer;
import org.danekja.java.util.function.serializable.SerializableFunction;

public class EntityCriteriaSupport<C>
implements RelationalEntityCriteria<C, EntityCriteriaSupport<C>>,
ConfiguredEntityCriteria {
    private final Criteria<?> criteria = new Criteria();
    private final EntityCriteriaSupport<C> parent;
    private final AggregateAccessPointToColumnMapping<C> aggregateColumnMapping;
    private boolean hasCollectionCriteria;

    public EntityCriteriaSupport(EntityJoinTree<C, ?> tree) {
        this(tree, false);
    }

    public EntityCriteriaSupport(EntityJoinTree<C, ?> tree, boolean withImmediatePropertiesCollect) {
        this(new AggregateAccessPointToColumnMapping<C>(tree, withImmediatePropertiesCollect));
    }

    private EntityCriteriaSupport(AggregateAccessPointToColumnMapping<C> source) {
        this.aggregateColumnMapping = source;
        this.parent = null;
    }

    private EntityCriteriaSupport(AggregateAccessPointToColumnMapping<C> source, EntityCriteriaSupport<C> parent) {
        this.aggregateColumnMapping = source;
        this.parent = parent;
    }

    public EntityCriteriaSupport<C> copy() {
        return new EntityCriteriaSupport<C>(this.aggregateColumnMapping);
    }

    public AggregateAccessPointToColumnMapping<C> getAggregateColumnMapping() {
        return this.aggregateColumnMapping;
    }

    public <O> EntityCriteriaSupport<C> add(LogicalOperator logicalOperator, List<? extends ValueAccessPoint<?>> accessPointChain, ConditionalOperator<O, ?> condition) {
        this.appendAsCriterion(logicalOperator, accessPointChain, condition);
        this.computeCollectionCriteriaIndicator(accessPointChain);
        return this;
    }

    void appendAsCriterion(LogicalOperator logicalOperator, List<? extends ValueAccessPoint<?>> accessPointChain, ConditionalOperator<?, ?> condition) {
        Selectable<?> column = this.aggregateColumnMapping.giveColumn(accessPointChain);
        this.criteria.add((AbstractCriterion)new ColumnCriterion(logicalOperator, column, condition));
        if (this.criteria.getOperator() == null) {
            this.criteria.setOperator(logicalOperator);
        }
    }

    private void computeCollectionCriteriaIndicator(List<? extends ValueAccessPoint<?>> accessPointChain) {
        this.hasCollectionCriteria |= accessPointChain.stream().anyMatch(valueAccessPoint -> Collection.class.isAssignableFrom(AccessorDefinition.giveDefinition((ValueAccessPoint)valueAccessPoint).getMemberType()));
    }

    public <O> EntityCriteriaSupport<C> and(SerializableFunction<C, O> getter, ConditionalOperator<O, ?> operator) {
        return this.add(LogicalOperator.AND, Arrays.asList((Object[])new AccessorByMethodReference[]{new AccessorByMethodReference(getter)}), operator);
    }

    public <O> EntityCriteriaSupport<C> and(SerializableBiConsumer<C, O> setter, ConditionalOperator<O, ?> operator) {
        return this.add(LogicalOperator.AND, Arrays.asList((Object[])new MutatorByMethodReference[]{new MutatorByMethodReference(setter)}), operator);
    }

    public <O> EntityCriteriaSupport<C> or(SerializableFunction<C, O> getter, ConditionalOperator<O, ?> operator) {
        return this.add(LogicalOperator.OR, Arrays.asList((Object[])new AccessorByMethodReference[]{new AccessorByMethodReference(getter)}), operator);
    }

    public <O> EntityCriteriaSupport<C> or(SerializableBiConsumer<C, O> setter, ConditionalOperator<O, ?> operator) {
        return this.add(LogicalOperator.OR, Arrays.asList((Object[])new MutatorByMethodReference[]{new MutatorByMethodReference(setter)}), operator);
    }

    public EntityCriteriaSupport<C> beginNested() {
        EntityCriteriaSupport<C> abstractCriteria = new EntityCriteriaSupport<C>(this.aggregateColumnMapping, this);
        this.criteria.add(abstractCriteria.criteria);
        return abstractCriteria;
    }

    public EntityCriteriaSupport<C> endNested() {
        return this.parent;
    }

    public <A, B> EntityCriteriaSupport<C> and(SerializableFunction<C, A> getter1, SerializableFunction<A, B> getter2, ConditionalOperator<B, ?> operator) {
        return this.and(AccessorChain.fromMethodReferences(getter1, getter2).getAccessors(), (ConditionalOperator)operator);
    }

    public <O> EntityCriteriaSupport<C> and(List<? extends ValueAccessPoint<?>> getter, ConditionalOperator<O, ?> operator) {
        return this.add(LogicalOperator.AND, getter, operator);
    }

    public <O> EntityCriteriaSupport<C> or(List<? extends ValueAccessPoint<?>> getter, ConditionalOperator<O, ?> operator) {
        return this.add(LogicalOperator.OR, getter, operator);
    }

    @Override
    public CriteriaChain<?> getCriteria() {
        return this.criteria;
    }

    @Override
    public boolean hasCollectionCriteria() {
        return this.hasCollectionCriteria;
    }

    public boolean hasCollectionProperty() {
        return this.aggregateColumnMapping.hasCollectionProperty();
    }

    public String toString() {
        return Reflections.toString(this.getClass()) + "criteria=" + this.criteria.getConditions() + ", hasCollectionCriteria=" + this.hasCollectionCriteria + ", parent=" + this.parent;
    }

    @VisibleForTesting
    static class AccessorToColumnMap
    extends HashedMap<List<? extends ValueAccessPoint<?>>, Selectable<?>> {
        AccessorToColumnMap() {
        }

        protected int hash(Object key) {
            List accessors = (List)key;
            int result = 1;
            for (ValueAccessPoint accessor : accessors) {
                AccessorDefinition accessorDefinition = AccessorDefinition.giveDefinition((ValueAccessPoint)accessor);
                result = 31 * result + 31 * accessorDefinition.getDeclaringClass().hashCode() + accessorDefinition.getName().hashCode();
            }
            return result;
        }

        protected boolean isEqualKey(Object key1, Object key2) {
            List accessors1 = (List)key1;
            List accessors2 = (List)key2;
            List accessorDefinitions1 = accessors1.stream().map(AccessorDefinition::giveDefinition).collect(Collectors.toList());
            List accessorDefinitions2 = accessors2.stream().map(AccessorDefinition::giveDefinition).collect(Collectors.toList());
            PairIterator pairIterator = new PairIterator(accessorDefinitions1, accessorDefinitions2);
            boolean result = false;
            while (!result && pairIterator.hasNext()) {
                Duo accessorsPair = pairIterator.next();
                result = ((AccessorDefinition)accessorsPair.getLeft()).getDeclaringClass().equals(((AccessorDefinition)accessorsPair.getRight()).getDeclaringClass()) && ((AccessorDefinition)accessorsPair.getLeft()).getName().equals(((AccessorDefinition)accessorsPair.getRight()).getName()) && ((AccessorDefinition)accessorsPair.getLeft()).getMemberType().equals(((AccessorDefinition)accessorsPair.getRight()).getMemberType());
            }
            return result;
        }
    }
}

