/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.configurer.map;

import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.codefilarete.stalactite.engine.CascadeOptions;
import org.codefilarete.stalactite.engine.EntityPersister;
import org.codefilarete.stalactite.engine.configurer.map.KeyValueRecord;
import org.codefilarete.stalactite.engine.configurer.map.RecordId;
import org.codefilarete.stalactite.engine.diff.AbstractDiff;
import org.codefilarete.stalactite.engine.runtime.CollectionUpdater;
import org.codefilarete.stalactite.engine.runtime.ConfiguredRelationalPersister;
import org.codefilarete.tool.Duo;
import org.codefilarete.tool.collection.Iterables;
import org.codefilarete.tool.collection.KeepOrderSet;
import org.codefilarete.tool.collection.StreamSplitter;

class MapEntryKeyAndValueEntitiesUpdater<SRC, SRCID, K, V, KK, VV>
extends CollectionUpdater<SRC, KeyValueRecord<K, V, SRCID>, Set<KeyValueRecord<K, V, SRCID>>> {
    private final ConfiguredRelationalPersister<K, ?> keyEntityPersister;
    private final ConfiguredRelationalPersister<V, ?> valueEntityPersister;
    private final CascadeOptions.RelationMode keyEntityMaintenanceMode;
    private final CascadeOptions.RelationMode valueEntityMaintenanceMode;
    private final boolean associationRecordWritable;

    public MapEntryKeyAndValueEntitiesUpdater(Function<SRC, Set<KeyValueRecord<K, V, SRCID>>> targetEntityGetter, Function<K, KK> keyMapper, Function<V, VV> valueMapper, ConfiguredRelationalPersister<K, ?> keyEntityPersister, ConfiguredRelationalPersister<V, ?> valueEntityPersister, EntityPersister<KeyValueRecord<KK, VV, SRCID>, RecordId<KK, SRCID>> keyValueRecordPersister, CascadeOptions.RelationMode keyMaintenanceMode, CascadeOptions.RelationMode valueMaintenanceMode) {
        super(targetEntityGetter, new RelationalPersisterAsEntityWriter<K, V, KK, VV, SRCID>(keyValueRecordPersister, keyMapper, valueMapper), (O o, I i) -> {}, true, (O entry) -> {
            int result = entry.getId().getId().hashCode();
            result = 31 * result + keyEntityPersister.getId(entry.getKey()).hashCode();
            return result;
        });
        this.keyEntityPersister = keyEntityPersister;
        this.valueEntityPersister = valueEntityPersister;
        this.keyEntityMaintenanceMode = keyMaintenanceMode;
        this.valueEntityMaintenanceMode = valueMaintenanceMode;
        this.associationRecordWritable = this.keyEntityMaintenanceMode != CascadeOptions.RelationMode.READ_ONLY;
    }

    @Override
    protected void insertTargets(CollectionUpdater.UpdateContext updateContext) {
        if (this.keyEntityMaintenanceMode == CascadeOptions.RelationMode.ALL || this.keyEntityMaintenanceMode == CascadeOptions.RelationMode.ALL_ORPHAN_REMOVAL) {
            this.keyEntityPersister.insert(updateContext.getAddedElements().stream().map(KeyValueRecord::getKey).collect(Collectors.toSet()));
        }
        if (this.valueEntityMaintenanceMode == CascadeOptions.RelationMode.ALL || this.valueEntityMaintenanceMode == CascadeOptions.RelationMode.ALL_ORPHAN_REMOVAL) {
            this.valueEntityPersister.insert(updateContext.getAddedElements().stream().map(KeyValueRecord::getValue).collect(Collectors.toSet()));
        }
        if (this.associationRecordWritable) {
            super.insertTargets(updateContext);
        }
    }

    @Override
    protected void updateTargets(CollectionUpdater.UpdateContext updateContext, boolean allColumnsStatement) {
        if (this.valueEntityMaintenanceMode != CascadeOptions.RelationMode.READ_ONLY) {
            KeepOrderSet removedValues = new KeepOrderSet();
            KeepOrderSet addedValues = new KeepOrderSet();
            KeepOrderSet modifiedValues = new KeepOrderSet();
            new StreamSplitter(updateContext.getHeldElements().stream()).dispatch(diff -> diff.getReplacingInstance() == null, arg_0 -> MapEntryKeyAndValueEntitiesUpdater.lambda$updateTargets$3((Set)removedValues, arg_0)).dispatch(diff -> diff.getReplacingInstance() != null, arg_0 -> this.lambda$updateTargets$5((Set)modifiedValues, (Set)addedValues, (Set)removedValues, arg_0)).split();
            if (this.valueEntityMaintenanceMode == CascadeOptions.RelationMode.ALL || this.valueEntityMaintenanceMode == CascadeOptions.RelationMode.ALL_ORPHAN_REMOVAL) {
                this.valueEntityPersister.persist((Iterable)addedValues);
            }
            Set recordsToBeUpdated = modifiedValues.stream().map(diff -> new Duo(diff.getReplacingInstance(), diff.getSourceInstance())).collect(Collectors.toSet());
            this.elementPersister.update(recordsToBeUpdated, allColumnsStatement);
            if (this.valueEntityMaintenanceMode == CascadeOptions.RelationMode.ALL_ORPHAN_REMOVAL) {
                this.valueEntityPersister.delete((Iterable)removedValues);
            }
        }
    }

    @Override
    protected void deleteTargets(CollectionUpdater.UpdateContext updateContext) {
        if (this.associationRecordWritable) {
            super.deleteTargets(updateContext);
        }
        if (this.keyEntityMaintenanceMode == CascadeOptions.RelationMode.ALL_ORPHAN_REMOVAL) {
            this.keyEntityPersister.delete(updateContext.getRemovedElements().stream().map(KeyValueRecord::getKey).collect(Collectors.toSet()));
        }
        if (this.valueEntityMaintenanceMode == CascadeOptions.RelationMode.ALL_ORPHAN_REMOVAL) {
            this.valueEntityPersister.delete(updateContext.getRemovedElements().stream().map(KeyValueRecord::getValue).collect(Collectors.toSet()));
        }
    }

    private /* synthetic */ void lambda$updateTargets$5(Set modifiedValues, Set addedValues, Set removedValues, AbstractDiff entry) {
        if (!this.valueEntityPersister.getId(((KeyValueRecord)entry.getSourceInstance()).getValue()).equals(this.valueEntityPersister.getId(((KeyValueRecord)entry.getReplacingInstance()).getValue()))) {
            modifiedValues.add(entry);
            addedValues.add(((KeyValueRecord)entry.getReplacingInstance()).getValue());
            removedValues.add(((KeyValueRecord)entry.getSourceInstance()).getValue());
        }
    }

    private static /* synthetic */ void lambda$updateTargets$3(Set removedValues, AbstractDiff entry) {
        removedValues.add(((KeyValueRecord)entry.getSourceInstance()).getValue());
    }

    private static class RelationalPersisterAsEntityWriter<K, V, KK, VV, SRCID>
    implements CollectionUpdater.EntityWriter<KeyValueRecord<K, V, SRCID>> {
        private final EntityPersister<KeyValueRecord<KK, VV, SRCID>, RecordId<KK, SRCID>> relationEntityPersister;
        private final Function<K, KK> keyMapper;
        private final Function<V, VV> valueMapper;

        public RelationalPersisterAsEntityWriter(EntityPersister<KeyValueRecord<KK, VV, SRCID>, RecordId<KK, SRCID>> relationEntityPersister, Function<K, KK> keyMapper, Function<V, VV> valueMapper) {
            this.relationEntityPersister = relationEntityPersister;
            this.keyMapper = keyMapper;
            this.valueMapper = valueMapper;
        }

        @Override
        public void update(Iterable<? extends Duo<KeyValueRecord<K, V, SRCID>, KeyValueRecord<K, V, SRCID>>> differencesIterable, boolean allColumnsStatement) {
            this.relationEntityPersister.update((Iterable)Iterables.stream(differencesIterable).map(keyValueRecordKeyValueRecordDuo -> {
                KeyValueRecord left = (KeyValueRecord)keyValueRecordKeyValueRecordDuo.getLeft();
                KeyValueRecord right = (KeyValueRecord)keyValueRecordKeyValueRecordDuo.getRight();
                return new Duo(new KeyValueRecord(left.getId().getId(), this.keyMapper.apply(left.getKey()), this.valueMapper.apply(left.getValue())), new KeyValueRecord(right.getId().getId(), this.keyMapper.apply(right.getKey()), this.valueMapper.apply(right.getValue())));
            }).collect(Collectors.toSet()), allColumnsStatement);
        }

        @Override
        public void delete(Iterable<? extends KeyValueRecord<K, V, SRCID>> entities) {
            this.relationEntityPersister.delete((Iterable)Iterables.stream(entities).map(entity -> new KeyValueRecord(entity.getId().getId(), this.keyMapper.apply(entity.getKey()), this.valueMapper.apply(entity.getValue()))).collect(Collectors.toSet()));
        }

        @Override
        public void insert(Iterable<? extends KeyValueRecord<K, V, SRCID>> entities) {
            this.relationEntityPersister.insert((Iterable)Iterables.stream(entities).map(entity -> new KeyValueRecord(entity.getId().getId(), this.keyMapper.apply(entity.getKey()), this.valueMapper.apply(entity.getValue()))).collect(Collectors.toSet()));
        }

        @Override
        public void persist(Iterable<? extends KeyValueRecord<K, V, SRCID>> entities) {
            this.relationEntityPersister.persist((Iterable)Iterables.stream(entities).map(entity -> new KeyValueRecord(entity.getId().getId(), this.keyMapper.apply(entity.getKey()), this.valueMapper.apply(entity.getValue()))).collect(Collectors.toSet()));
        }

        @Override
        public void updateById(Iterable<? extends KeyValueRecord<K, V, SRCID>> entities) {
            this.relationEntityPersister.updateById((Iterable)Iterables.stream(entities).map(entity -> new KeyValueRecord(entity.getId().getId(), this.keyMapper.apply(entity.getKey()), this.valueMapper.apply(entity.getValue()))).collect(Collectors.toSet()));
        }

        @Override
        public boolean isNew(KeyValueRecord<K, V, SRCID> entity) {
            return false;
        }
    }
}

