/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.runtime.load;

import java.util.Collection;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.codefilarete.stalactite.dsl.PolymorphismPolicy;
import org.codefilarete.stalactite.engine.runtime.ConfiguredRelationalPersister;
import org.codefilarete.stalactite.engine.runtime.load.EntityInflater;
import org.codefilarete.stalactite.engine.runtime.load.EntityJoinTree;
import org.codefilarete.stalactite.engine.runtime.load.EntityTreeInflater;
import org.codefilarete.stalactite.engine.runtime.load.JoinNode;
import org.codefilarete.stalactite.engine.runtime.load.JoinRoot;
import org.codefilarete.stalactite.engine.runtime.load.JoinRowConsumer;
import org.codefilarete.stalactite.mapping.EntityMapping;
import org.codefilarete.stalactite.mapping.RowTransformer;
import org.codefilarete.stalactite.query.model.Selectable;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.stalactite.sql.result.ColumnedRow;
import org.codefilarete.tool.Duo;
import org.codefilarete.tool.Reflections;
import org.codefilarete.tool.collection.Arrays;
import org.codefilarete.tool.collection.Collections;
import org.codefilarete.tool.collection.Iterables;
import org.codefilarete.tool.collection.KeepOrderSet;

public class SingleTableRootJoinNode<C, I, T extends Table<T>, DTYPE>
extends JoinRoot<C, I, T> {
    private final Set<? extends ConfiguredRelationalPersister<C, I>> subPersisters;
    private final Set<Column<T, ?>> allColumnsInHierarchy;
    private final Column<T, DTYPE> discriminatorColumn;
    private final PolymorphismPolicy.SingleTablePolymorphism<C, DTYPE> polymorphismPolicy;

    public SingleTableRootJoinNode(EntityJoinTree<C, I> tree, ConfiguredRelationalPersister<C, I> mainPersister, Set<? extends ConfiguredRelationalPersister<C, I>> subPersisters, Column<T, DTYPE> discriminatorColumn, PolymorphismPolicy.SingleTablePolymorphism<C, DTYPE> polymorphismPolicy) {
        super(tree, new EntityInflater.EntityMappingAdapter(mainPersister.getMapping()), mainPersister.getMainTable());
        this.subPersisters = subPersisters;
        this.discriminatorColumn = discriminatorColumn;
        this.polymorphismPolicy = polymorphismPolicy;
        this.allColumnsInHierarchy = (Set)Collections.cat((Collection[])new Collection[]{Arrays.asList((Object[])new ConfiguredRelationalPersister[]{mainPersister}), subPersisters}).stream().flatMap(persister -> persister.getMainTable().getColumns().stream()).collect(Collectors.toCollection(KeepOrderSet::new));
    }

    @Override
    public Set<Selectable<?>> getColumnsToSelect() {
        return this.allColumnsInHierarchy;
    }

    @Override
    public JoinRowConsumer.RootJoinRowConsumer<C> toConsumer(JoinNode<C, T> joinNode) {
        Supplier<ColumnedRow> decoderProvider = () -> EntityTreeInflater.currentContext().getDecoder(joinNode);
        Set subEntityConsumer = this.subPersisters.stream().map(subPersister -> {
            EntityMapping mapping = subPersister.getMapping();
            return new SubPersisterConsumer(arg_0 -> SingleTableRootJoinNode.lambda$null$2(mapping, (Supplier)decoderProvider, arg_0), mapping.getClassToPersist(), mapping.getRowTransformer());
        }).collect(Collectors.toSet());
        BiConsumer<Object, ColumnedRow> rowConsumptionListener = this.getConsumptionListener() == null ? null : (rootEntity, row) -> this.getConsumptionListener().onNodeConsumption(rootEntity, (ColumnedRow)decoderProvider.get());
        return new SingleTablePolymorphicJoinRootRowConsumer(joinNode, subEntityConsumer, rowConsumptionListener, this.polymorphismPolicy, row -> ((ColumnedRow)decoderProvider.get()).get(this.discriminatorColumn));
    }

    private static /* synthetic */ Object lambda$null$2(EntityMapping mapping, Supplier decoderProvider, ColumnedRow row) {
        return mapping.getIdMapping().getIdentifierAssembler().assemble((ColumnedRow)decoderProvider.get());
    }

    static class SingleTablePolymorphicJoinRootRowConsumer<C, I, DTYPE>
    implements JoinRowConsumer.RootJoinRowConsumer<C> {
        private final Set<SubPersisterConsumer<C, I>> subConsumers;
        private final JoinNode<C, ?> joinNode;
        @Nullable
        private final BiConsumer<C, ColumnedRow> consumptionListener;
        private final PolymorphismPolicy.SingleTablePolymorphism<C, DTYPE> polymorphismPolicy;
        private final Function<ColumnedRow, DTYPE> discriminatorValueReader;

        private SingleTablePolymorphicJoinRootRowConsumer(JoinNode<C, ?> node, Set<SubPersisterConsumer<C, I>> subConsumers, @Nullable BiConsumer<C, ColumnedRow> consumptionListener, PolymorphismPolicy.SingleTablePolymorphism<C, DTYPE> polymorphismPolicy, Function<ColumnedRow, DTYPE> discriminatorValueReader) {
            this.subConsumers = subConsumers;
            this.joinNode = node;
            this.consumptionListener = consumptionListener;
            this.polymorphismPolicy = polymorphismPolicy;
            this.discriminatorValueReader = discriminatorValueReader;
        }

        public JoinNode<C, ?> getNode() {
            return this.joinNode;
        }

        @Override
        public C createRootInstance(ColumnedRow row, EntityTreeInflater.TreeInflationContext context) {
            Duo subInflater = this.findSubInflater(row);
            Object result = subInflater == null ? null : context.giveEntityFromCache(((SubPersisterConsumer)subInflater.getRight()).subEntityType, subInflater.getLeft(), () -> ((SubPersisterConsumer)subInflater.getRight()).subEntityFactory.transform(row));
            if (this.consumptionListener != null) {
                this.consumptionListener.accept(result, row);
            }
            return (C)result;
        }

        @Nullable
        public Duo<I, SubPersisterConsumer<C, I>> findSubInflater(ColumnedRow row) {
            Class<C> subEntityClass = this.polymorphismPolicy.getClass(this.discriminatorValueReader.apply(row));
            Duo subClassRowConsumer = Iterables.find(this.subConsumers, subConsumer -> ((SubPersisterConsumer)subConsumer).subEntityType, subEntityClass::equals);
            SubPersisterConsumer subIdentifierConsumer = (SubPersisterConsumer)subClassRowConsumer.getLeft();
            return new Duo(subIdentifierConsumer.identifierAssembler.apply(row), (Object)subIdentifierConsumer);
        }

        public String toString() {
            return Reflections.toString(this.getClass());
        }
    }

    static class SubPersisterConsumer<C, I> {
        private final Function<ColumnedRow, I> identifierAssembler;
        private final Class<C> subEntityType;
        private final RowTransformer<C> subEntityFactory;

        private SubPersisterConsumer(Function<ColumnedRow, I> identifierAssembler, Class<C> subEntityType, RowTransformer<C> subEntityFactory) {
            this.identifierAssembler = identifierAssembler;
            this.subEntityType = subEntityType;
            this.subEntityFactory = subEntityFactory;
        }
    }
}

