/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.spring.repository.query;

import org.codefilarete.stalactite.engine.runtime.AdvancedEntityPersister;
import org.codefilarete.stalactite.spring.repository.query.StalactiteLimitRepositoryQuery;
import org.springframework.data.domain.Pageable;
import org.springframework.data.repository.query.Parameters;
import org.springframework.data.repository.query.ParametersParameterAccessor;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.data.repository.query.RepositoryQuery;
import org.springframework.data.repository.query.parser.PartTree;

public class PartTreeStalactiteLimitingQuery<C, R>
implements RepositoryQuery {
    private final StalactiteLimitRepositoryQuery<C, R> delegate;

    public PartTreeStalactiteLimitingQuery(QueryMethod method, AdvancedEntityPersister<C, ?> entityPersister, PartTree tree, StalactiteLimitRepositoryQuery<C, R> delegate) {
        this.delegate = delegate;
    }

    public R execute(Object[] parameters) {
        StalactiteParametersParameterAccessor smartParameters = new StalactiteParametersParameterAccessor(this.getQueryMethod().getParameters(), parameters);
        Pageable pageable = smartParameters.getPageable();
        if (this.delegate.getQueryMethod().isSliceQuery() && pageable.getPageNumber() == 0) {
            this.delegate.limit(pageable.getPageSize() + 1);
        } else {
            this.delegate.limit(pageable.getPageSize(), (int)pageable.getOffset());
        }
        return this.delegate.execute(parameters);
    }

    public QueryMethod getQueryMethod() {
        return this.delegate.getQueryMethod();
    }

    public static class StalactiteParametersParameterAccessor
    extends ParametersParameterAccessor {
        public StalactiteParametersParameterAccessor(Parameters<?, ?> parameters, Object[] values) {
            super(parameters, values);
        }

        public Object[] getValues() {
            return super.getValues();
        }
    }
}

