/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.spring.repository.query;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.codefilarete.stalactite.engine.runtime.AdvancedEntityPersister;
import org.codefilarete.stalactite.spring.repository.query.PartTreeStalactiteCountProjection;
import org.codefilarete.stalactite.spring.repository.query.PartTreeStalactiteDelete;
import org.codefilarete.stalactite.spring.repository.query.PartTreeStalactiteExistsProjection;
import org.codefilarete.stalactite.spring.repository.query.PartTreeStalactitePagedQuery;
import org.codefilarete.stalactite.spring.repository.query.PartTreeStalactiteProjection;
import org.codefilarete.stalactite.spring.repository.query.PartTreeStalactiteQuery;
import org.codefilarete.stalactite.spring.repository.query.QueryMethodValidator;
import org.codefilarete.stalactite.sql.result.Accumulator;
import org.codefilarete.stalactite.sql.result.Accumulators;
import org.springframework.data.domain.Slice;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.repository.core.NamedQueries;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.query.QueryLookupStrategy;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.data.repository.query.RepositoryQuery;
import org.springframework.data.repository.query.parser.PartTree;

public class CreateQueryLookupStrategy<T>
implements QueryLookupStrategy {
    private final AdvancedEntityPersister<T, ?> entityPersister;

    public CreateQueryLookupStrategy(AdvancedEntityPersister<T, ?> entityPersister) {
        this.entityPersister = entityPersister;
    }

    public RepositoryQuery resolveQuery(Method method, RepositoryMetadata metadata, ProjectionFactory factory, NamedQueries namedQueries) {
        PartTree partTree = new PartTree(method.getName(), this.entityPersister.getClassToPersist());
        QueryMethod queryMethod = new QueryMethod(method, metadata, factory);
        new QueryMethodValidator(partTree, queryMethod).validate();
        if (partTree.isDelete()) {
            return new PartTreeStalactiteDelete<T>(queryMethod, this.entityPersister, partTree);
        }
        if (partTree.isCountProjection()) {
            return new PartTreeStalactiteCountProjection<T>(queryMethod, this.entityPersister, partTree);
        }
        if (partTree.isExistsProjection()) {
            return new PartTreeStalactiteExistsProjection<T>(queryMethod, this.entityPersister, partTree);
        }
        if (queryMethod.getResultProcessor().getReturnedType().isProjecting() && factory.getProjectionInformation(queryMethod.getReturnedObjectType()).isClosed()) {
            return new PartTreeStalactiteProjection(queryMethod, this.entityPersister, partTree, factory);
        }
        if (queryMethod.isPageQuery() || queryMethod.isSliceQuery()) {
            return this.createPageableQuery(queryMethod, partTree);
        }
        Accumulator accumulator = queryMethod.isCollectionQuery() ? Accumulators.toKeepingOrderSet() : Accumulators.getFirstUnique();
        return new PartTreeStalactiteQuery(queryMethod, this.entityPersister, partTree, accumulator);
    }

    private <R extends Slice<P>, P> PartTreeStalactitePagedQuery<T, R, P> createPageableQuery(QueryMethod queryMethod, PartTree partTree) {
        Accumulator accumulator1 = new Accumulator<T, Collection<T>, List<P>>(){

            public Supplier<Collection<T>> supplier() {
                return ArrayList::new;
            }

            public BiConsumer<Collection<T>, T> aggregator() {
                return Collection::add;
            }

            public Function<Collection<T>, List<P>> finisher() {
                return cs -> (List)cs;
            }
        };
        PartTreeStalactiteQuery tListPartTreeStalactiteQuery = new PartTreeStalactiteQuery(queryMethod, this.entityPersister, partTree, accumulator1);
        return new PartTreeStalactitePagedQuery(queryMethod, this.entityPersister, partTree, tListPartTreeStalactiteQuery);
    }
}

