/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine;

import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.assertj.core.api.Assertions;
import org.codefilarete.stalactite.engine.ColumnOptions;
import org.codefilarete.stalactite.engine.EntityMappingConfiguration;
import org.codefilarete.stalactite.engine.EntityMappingConfigurationProvider;
import org.codefilarete.stalactite.engine.EntityPersister;
import org.codefilarete.stalactite.engine.MappingEase;
import org.codefilarete.stalactite.engine.PersistenceContext;
import org.codefilarete.stalactite.engine.model.Timestamp;
import org.codefilarete.stalactite.sql.Dialect;
import org.codefilarete.stalactite.sql.HSQLDBDialectBuilder;
import org.codefilarete.stalactite.sql.ddl.DDLDeployer;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.stalactite.sql.result.Accumulators;
import org.codefilarete.stalactite.sql.test.HSQLDBInMemoryDataSource;
import org.codefilarete.tool.Nullable;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class FluentEntityMappingConfigurationSupportPostInsertIdentifierTest {
    private Dialect dialect = HSQLDBDialectBuilder.defaultHSQLDBDialect();
    private DataSource dataSource = new HSQLDBInMemoryDataSource();
    private PersistenceContext persistenceContext;

    @BeforeEach
    public void initTest() {
        this.persistenceContext = new PersistenceContext(this.dataSource, this.dialect);
    }

    @Test
    void insert_basic() {
        EntityPersister carPersister = MappingEase.entityBuilder(Car.class, Long.TYPE).mapKey(AbstractVehicle::getId, (ColumnOptions.IdentifierPolicy)ColumnOptions.IdentifierPolicy.databaseAutoIncrement()).map(Car::getModel).build(this.persistenceContext);
        DDLDeployer ddlDeployer = new DDLDeployer(this.persistenceContext);
        ddlDeployer.deployDDL();
        Car dummyCar = new Car();
        dummyCar.setModel("Renault");
        carPersister.insert((Object)dummyCar);
        PersistenceContext.ExecutableBeanPropertyQueryMapper carExecutableQuery = this.persistenceContext.newQuery((CharSequence)"select id, model from Car", Car.class).mapKey(Car::new, "id", Long.TYPE).map("model", Car::setModel);
        Set allCars = (Set)carExecutableQuery.execute(Accumulators.toSet());
        Assertions.assertThat((Collection)allCars).containsExactly((Object[])new Car[]{dummyCar});
        Car loadedCar = (Car)carPersister.select((Object)1L);
        Assertions.assertThat((Object)loadedCar).isEqualTo((Object)dummyCar);
    }

    @Test
    void insert_oneToOne() {
        EntityPersister carPersister = MappingEase.entityBuilder(Car.class, Long.TYPE).mapKey(AbstractVehicle::getId, (ColumnOptions.IdentifierPolicy)ColumnOptions.IdentifierPolicy.databaseAutoIncrement()).map(Car::getModel).mapOneToOne(Vehicle::getEngine, (EntityMappingConfigurationProvider)MappingEase.entityBuilder(Engine.class, Long.TYPE).mapKey(Engine::getId, (ColumnOptions.IdentifierPolicy)ColumnOptions.IdentifierPolicy.databaseAutoIncrement()).map(Engine::getModel)).build(this.persistenceContext);
        DDLDeployer ddlDeployer = new DDLDeployer(this.persistenceContext);
        ddlDeployer.deployDDL();
        Car dummyCar = new Car();
        dummyCar.setModel("Renault");
        dummyCar.setEngine(new Engine("XFE45K-TRE"));
        carPersister.insert((Object)dummyCar);
        Assertions.assertThat((Long)dummyCar.getEngine().getId()).isNotNull();
        PersistenceContext.ExecutableBeanPropertyQueryMapper carExecutableQuery = this.persistenceContext.newQuery((CharSequence)"select id, model from Car", Car.class).mapKey(Car::new, "id", Long.TYPE).map("model", Car::setModel);
        Set allCars = (Set)carExecutableQuery.execute(Accumulators.toSet());
        Assertions.assertThat((Collection)allCars).containsExactly((Object[])new Car[]{dummyCar});
        Car loadedCar = (Car)carPersister.select((Object)1L);
        Assertions.assertThat((Object)loadedCar).isEqualTo((Object)dummyCar);
        Assertions.assertThat((Object)loadedCar.getEngine()).isEqualTo((Object)dummyCar.getEngine());
    }

    @Test
    void multipleInheritance() {
        EntityMappingConfiguration inheritanceConfiguration = MappingEase.entityBuilder(AbstractVehicle.class, Long.TYPE).mapKey(AbstractVehicle::getId, (ColumnOptions.IdentifierPolicy)ColumnOptions.IdentifierPolicy.databaseAutoIncrement()).getConfiguration();
        EntityMappingConfiguration inheritanceConfiguration2 = MappingEase.entityBuilder(Vehicle.class, Long.TYPE).mapSuperClass(inheritanceConfiguration).getConfiguration();
        EntityPersister carPersister = MappingEase.entityBuilder(Car.class, Long.TYPE).map(Car::getModel).mapSuperClass(inheritanceConfiguration2).build(this.persistenceContext);
        Assertions.assertThat((Collection)DDLDeployer.collectTables((PersistenceContext)this.persistenceContext).stream().map(Table::getName).collect(Collectors.toSet())).containsExactly((Object[])new String[]{"Car"});
        DDLDeployer ddlDeployer = new DDLDeployer(this.persistenceContext);
        ddlDeployer.deployDDL();
        Car dummyCar = new Car(1L);
        dummyCar.setModel("Renault");
        carPersister.insert((Object)dummyCar);
        PersistenceContext.ExecutableBeanPropertyQueryMapper carExecutableQuery = this.persistenceContext.newQuery((CharSequence)"select id, model from Car", Car.class).mapKey(Car::new, "id", Long.TYPE).map("model", Car::setModel);
        Set allCars = (Set)carExecutableQuery.execute(Accumulators.toSet());
        Assertions.assertThat((Collection)allCars).containsExactly((Object[])new Car[]{dummyCar});
        Car loadedCar = (Car)carPersister.select((Object)1L);
        Assertions.assertThat((Object)loadedCar).isEqualTo((Object)dummyCar);
    }

    @Test
    void multipleInheritance_joinedTables() {
        EntityMappingConfiguration inheritanceConfiguration = MappingEase.entityBuilder(AbstractVehicle.class, Long.TYPE).mapKey(AbstractVehicle::getId, (ColumnOptions.IdentifierPolicy)ColumnOptions.IdentifierPolicy.databaseAutoIncrement()).getConfiguration();
        EntityMappingConfiguration inheritanceConfiguration2 = MappingEase.entityBuilder(Vehicle.class, Long.TYPE).mapSuperClass(inheritanceConfiguration).withJoinedTable().getConfiguration();
        EntityPersister carPersister = MappingEase.entityBuilder(Car.class, Long.TYPE).map(Car::getModel).mapSuperClass(inheritanceConfiguration2).withJoinedTable().build(this.persistenceContext);
        Assertions.assertThat((Collection)DDLDeployer.collectTables((PersistenceContext)this.persistenceContext).stream().map(Table::getName).collect(Collectors.toSet())).containsExactlyInAnyOrder((Object[])new String[]{"Car", "Vehicle", "AbstractVehicle"});
        DDLDeployer ddlDeployer = new DDLDeployer(this.persistenceContext);
        ddlDeployer.deployDDL();
        Car dummyCar = new Car(null);
        dummyCar.setModel("Renault");
        carPersister.insert((Object)dummyCar);
        PersistenceContext.ExecutableBeanPropertyQueryMapper carExecutableQuery = this.persistenceContext.newQuery((CharSequence)"select id, model from Car", Car.class).mapKey(Car::new, "id", Long.TYPE).map("model", Car::setModel);
        Set allCars = (Set)carExecutableQuery.execute(Accumulators.toSet());
        Assertions.assertThat((Collection)allCars).containsExactly((Object[])new Car[]{dummyCar});
        Car loadedCar = (Car)carPersister.select((Object)1L);
        Assertions.assertThat((Object)loadedCar).isEqualTo((Object)dummyCar);
    }

    static class Engine {
        private Long id;
        private String model;

        public Engine() {
        }

        public Engine(String model) {
            this.model = model;
        }

        public Long getId() {
            return this.id;
        }

        public String getModel() {
            return this.model;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Engine engine = (Engine)o;
            return Objects.equals(this.id, engine.id);
        }

        public int hashCode() {
            return this.id != null ? this.id.hashCode() : 0;
        }

        public String toString() {
            return "Engine{id=" + this.id + '}';
        }
    }

    static class Car
    extends Vehicle {
        private String model;

        public Car() {
        }

        public Car(Long id) {
            super(id);
        }

        public String getModel() {
            return this.model;
        }

        public void setModel(String model) {
            this.model = model;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Car car = (Car)o;
            return Objects.equals(this.model, car.model);
        }

        public String toString() {
            return "Car{id=" + this.getId() + ", color=" + Nullable.nullable((Object)this.getColor()).map(Color::getRgb).get() + ", model='" + this.model + "'}";
        }
    }

    static class Color {
        private int rgb;

        public Color() {
        }

        public Color(int rgb) {
            this.rgb = rgb;
        }

        public int getRgb() {
            return this.rgb;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Color color = (Color)o;
            return this.rgb == color.rgb;
        }

        public int hashCode() {
            return Objects.hash(this.rgb);
        }
    }

    static class Vehicle
    extends AbstractVehicle {
        private Color color;
        private Engine engine;

        public Vehicle(Long id) {
            super(id);
        }

        public Vehicle() {
        }

        public Color getColor() {
            return this.color;
        }

        public void setColor(Color color) {
            this.color = color;
        }

        public Engine getEngine() {
            return this.engine;
        }

        public void setEngine(Engine engine) {
            this.engine = engine;
        }
    }

    static abstract class AbstractVehicle {
        private Long id;
        private Timestamp timestamp;

        public AbstractVehicle() {
        }

        private AbstractVehicle(Long id) {
            this.id = id;
        }

        public Long getId() {
            return this.id;
        }

        public Timestamp getTimestamp() {
            return this.timestamp;
        }

        public void setTimestamp(Timestamp timestamp) {
            this.timestamp = timestamp;
        }
    }
}

