/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.configurer;

import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.assertj.core.api.Assertions;
import org.codefilarete.reflection.Accessor;
import org.codefilarete.reflection.AccessorDefinition;
import org.codefilarete.reflection.Accessors;
import org.codefilarete.reflection.Mutator;
import org.codefilarete.reflection.PropertyAccessor;
import org.codefilarete.stalactite.engine.AssociationTableNamingStrategy;
import org.codefilarete.stalactite.engine.ForeignKeyNamingStrategy;
import org.codefilarete.stalactite.engine.configurer.AssociationRecordMapping;
import org.codefilarete.stalactite.engine.configurer.DefaultComposedIdentifierAssembler;
import org.codefilarete.stalactite.engine.model.City;
import org.codefilarete.stalactite.engine.model.Country;
import org.codefilarete.stalactite.engine.runtime.AssociationRecord;
import org.codefilarete.stalactite.engine.runtime.AssociationTable;
import org.codefilarete.stalactite.mapping.id.assembly.IdentifierAssembler;
import org.codefilarete.stalactite.mapping.id.assembly.SingleIdentifierAssembler;
import org.codefilarete.stalactite.query.model.Selectable;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.PrimaryKey;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.stalactite.sql.result.ColumnedRow;
import org.codefilarete.stalactite.sql.result.MapBasedColumnedRow;
import org.codefilarete.tool.collection.Maps;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;

class AssociationRecordMappingTest {
    AssociationRecordMappingTest() {
    }

    static class MavenProject {
        private String groupId;
        private String artifactId;
        private String version;
        private Set<MavenProject> dependencies;

        public MavenProject() {
        }

        public MavenProject(String groupId, String artifactId, String version) {
            this.groupId = groupId;
            this.artifactId = artifactId;
            this.version = version;
        }

        public String getGroupId() {
            return this.groupId;
        }

        public void setGroupId(String groupId) {
            this.groupId = groupId;
        }

        public String getArtifactId() {
            return this.artifactId;
        }

        public void setArtifactId(String artifactId) {
            this.artifactId = artifactId;
        }

        public String getVersion() {
            return this.version;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        public Set<MavenProject> getDependencies() {
            return this.dependencies;
        }

        public void setDependencies(Set<MavenProject> dependencies) {
            this.dependencies = dependencies;
        }

        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MavenProject that = (MavenProject)o;
            return Objects.equals(this.groupId, that.groupId) && Objects.equals(this.artifactId, that.artifactId) && Objects.equals(this.version, that.version);
        }

        public int hashCode() {
            return Objects.hash(this.groupId, this.artifactId, this.version);
        }

        public String toString() {
            return "MavenProject{version='" + this.version + '\'' + ", artifactId='" + this.artifactId + '\'' + ", groupId='" + this.groupId + '\'' + '}';
        }
    }

    @Nested
    class CompositeKey {
        CompositeKey() {
        }

        @Test
        <ASSOCIATIONTABLE extends AssociationTable<ASSOCIATIONTABLE, LEFTTABLE, RIGHTTABLE, MavenProject, MavenProject>, LEFTTABLE extends Table<LEFTTABLE>, RIGHTTABLE extends Table<RIGHTTABLE>> void write_read() {
            Table leftTable = new Table("leftTable");
            Column leftTableGroupIdColumn = leftTable.addColumn("groupId", String.class).primaryKey();
            Column leftTableArtefactIdColumn = leftTable.addColumn("artefactId", String.class).primaryKey();
            Column leftTableVersionColumn = leftTable.addColumn("version", String.class).primaryKey();
            PrimaryKey leftTablePrimaryKey = leftTable.getPrimaryKey();
            Table rightTable = new Table("rightTable");
            Column rightTableGroupIdColumn = rightTable.addColumn("groupId", String.class).primaryKey();
            Column rightTableArtefactIdColumn = rightTable.addColumn("artefactId", String.class).primaryKey();
            Column rightTableVersionColumn = rightTable.addColumn("version", String.class).primaryKey();
            PrimaryKey rightTablePrimaryKey = rightTable.getPrimaryKey();
            AssociationTable associationTable = new AssociationTable(null, "associationTable", leftTablePrimaryKey, rightTablePrimaryKey, new AccessorDefinition(MavenProject.class, "dependencies", MavenProject.class), AssociationTableNamingStrategy.DEFAULT, ForeignKeyNamingStrategy.DEFAULT, true, true);
            Maps.ChainingHashMap leftMapping = Maps.forHashMap(PropertyAccessor.class, Column.class).add((Object)new PropertyAccessor((Accessor)Accessors.accessorByMethodReference(MavenProject::getGroupId), (Mutator)Accessors.mutatorByMethodReference(MavenProject::setGroupId)), (Object)leftTableGroupIdColumn).add((Object)new PropertyAccessor((Accessor)Accessors.accessorByMethodReference(MavenProject::getArtifactId), (Mutator)Accessors.mutatorByMethodReference(MavenProject::setArtifactId)), (Object)leftTableArtefactIdColumn).add((Object)new PropertyAccessor((Accessor)Accessors.accessorByMethodReference(MavenProject::getVersion), (Mutator)Accessors.mutatorByMethodReference(MavenProject::setVersion)), (Object)leftTableVersionColumn);
            Maps.ChainingHashMap rightMapping = Maps.forHashMap(PropertyAccessor.class, Column.class).add((Object)new PropertyAccessor((Accessor)Accessors.accessorByMethodReference(MavenProject::getGroupId), (Mutator)Accessors.mutatorByMethodReference(MavenProject::setGroupId)), (Object)rightTableGroupIdColumn).add((Object)new PropertyAccessor((Accessor)Accessors.accessorByMethodReference(MavenProject::getArtifactId), (Mutator)Accessors.mutatorByMethodReference(MavenProject::setArtifactId)), (Object)rightTableArtefactIdColumn).add((Object)new PropertyAccessor((Accessor)Accessors.accessorByMethodReference(MavenProject::getVersion), (Mutator)Accessors.mutatorByMethodReference(MavenProject::setVersion)), (Object)rightTableVersionColumn);
            AssociationRecordMapping testInstance = new AssociationRecordMapping(associationTable, (IdentifierAssembler)new DefaultComposedIdentifierAssembler(leftTable, MavenProject.class, (Map)leftMapping), (IdentifierAssembler)new DefaultComposedIdentifierAssembler(rightTable, MavenProject.class, (Map)rightMapping));
            Map insertValues = testInstance.getInsertValues((Object)new AssociationRecord((Object)new MavenProject("a", "b", "c"), (Object)new MavenProject("x", "y", "z")));
            Assertions.assertThat(insertValues.get(associationTable.getLeftIdentifierColumnMapping().get(leftTableGroupIdColumn))).isEqualTo((Object)"a");
            Assertions.assertThat(insertValues.get(associationTable.getLeftIdentifierColumnMapping().get(leftTableArtefactIdColumn))).isEqualTo((Object)"b");
            Assertions.assertThat(insertValues.get(associationTable.getLeftIdentifierColumnMapping().get(leftTableVersionColumn))).isEqualTo((Object)"c");
            Assertions.assertThat(insertValues.get(associationTable.getRightIdentifierColumnMapping().get(rightTableGroupIdColumn))).isEqualTo((Object)"x");
            Assertions.assertThat(insertValues.get(associationTable.getRightIdentifierColumnMapping().get(rightTableArtefactIdColumn))).isEqualTo((Object)"y");
            Assertions.assertThat(insertValues.get(associationTable.getRightIdentifierColumnMapping().get(rightTableVersionColumn))).isEqualTo((Object)"z");
            MapBasedColumnedRow row = new MapBasedColumnedRow();
            row.add((Selectable)associationTable.getColumn("leftTable_groupId"), (Object)"a");
            row.add((Selectable)associationTable.getColumn("leftTable_artefactId"), (Object)"b");
            row.add((Selectable)associationTable.getColumn("leftTable_version"), (Object)"c");
            row.add((Selectable)associationTable.getColumn("dependencies_groupId"), (Object)"x");
            row.add((Selectable)associationTable.getColumn("dependencies_artefactId"), (Object)"y");
            row.add((Selectable)associationTable.getColumn("dependencies_version"), (Object)"z");
            AssociationRecord readAssociationRecord = (AssociationRecord)testInstance.getRowTransformer().transform((ColumnedRow)row);
            Assertions.assertThat((Object)readAssociationRecord.getLeft()).isEqualTo((Object)new MavenProject("a", "b", "c"));
            Assertions.assertThat((Object)readAssociationRecord.getRight()).isEqualTo((Object)new MavenProject("x", "y", "z"));
        }
    }

    @Nested
    class SingleColumnKey {
        SingleColumnKey() {
        }

        @Test
        <ASSOCIATIONTABLE extends AssociationTable<ASSOCIATIONTABLE, LEFTTABLE, RIGHTTABLE, Integer, Integer>, LEFTTABLE extends Table<LEFTTABLE>, RIGHTTABLE extends Table<RIGHTTABLE>> void write_read() {
            Table leftTable = new Table("leftTable");
            Column leftTableIdColumn = leftTable.addColumn("id", Integer.TYPE).primaryKey();
            PrimaryKey leftTablePrimaryKey = leftTable.getPrimaryKey();
            Table rightTable = new Table("rightTable");
            Column rightTableIdColumn = rightTable.addColumn("id", Integer.TYPE).primaryKey();
            PrimaryKey rightTablePrimaryKey = rightTable.getPrimaryKey();
            AssociationTable associationTable = new AssociationTable(null, "associationTable", leftTablePrimaryKey, rightTablePrimaryKey, new AccessorDefinition(Country.class, "cities", City.class), AssociationTableNamingStrategy.DEFAULT, ForeignKeyNamingStrategy.DEFAULT, true, true);
            AssociationRecordMapping testInstance = new AssociationRecordMapping(associationTable, (IdentifierAssembler)new SingleIdentifierAssembler(leftTableIdColumn), (IdentifierAssembler)new SingleIdentifierAssembler(rightTableIdColumn));
            Map insertValues = testInstance.getInsertValues((Object)new AssociationRecord((Object)42, (Object)666));
            Assertions.assertThat(insertValues.get(associationTable.getLeftIdentifierColumnMapping().get(leftTableIdColumn))).isEqualTo((Object)42);
            Assertions.assertThat(insertValues.get(associationTable.getRightIdentifierColumnMapping().get(rightTableIdColumn))).isEqualTo((Object)666);
            MapBasedColumnedRow row = new MapBasedColumnedRow();
            row.add((Selectable)associationTable.getColumn("leftTable_id"), (Object)42);
            row.add((Selectable)associationTable.getColumn("cities_id"), (Object)666);
            AssociationRecord readAssociationRecord = (AssociationRecord)testInstance.getRowTransformer().transform((ColumnedRow)row);
            Assertions.assertThat((Object)readAssociationRecord.getLeft()).isEqualTo((Object)42);
            Assertions.assertThat((Object)readAssociationRecord.getRight()).isEqualTo((Object)666);
        }
    }
}

