/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine;

import java.util.function.Consumer;
import java.util.function.Function;
import org.codefilarete.stalactite.engine.PropertyOptions;
import org.codefilarete.stalactite.mapping.id.sequence.DatabaseSequenceSettings;
import org.codefilarete.stalactite.mapping.id.sequence.hilo.PooledHiLoSequenceStorageOptions;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.stalactite.sql.statement.binder.ParameterBinder;
import org.codefilarete.tool.Strings;
import org.codefilarete.tool.function.Converter;
import org.codefilarete.tool.function.Sequence;

public interface ColumnOptions<O>
extends PropertyOptions<O> {
    @Override
    public ColumnOptions<O> mandatory();

    @Override
    public ColumnOptions<O> setByConstructor();

    @Override
    public ColumnOptions<O> readonly();

    @Override
    public ColumnOptions<O> columnName(String var1);

    @Override
    public ColumnOptions<O> column(Column<? extends Table, ? extends O> var1);

    @Override
    public ColumnOptions<O> fieldName(String var1);

    @Override
    public ColumnOptions<O> readConverter(Converter<O, O> var1);

    @Override
    public ColumnOptions<O> writeConverter(Converter<O, O> var1);

    @Override
    public <V> PropertyOptions<O> sqlBinder(ParameterBinder<V> var1);

    public static class AlreadyAssignedIdentifierPolicySupport<C, I>
    implements AlreadyAssignedIdentifierPolicy<C, I> {
        private final Consumer<C> markAsPersistedFunction;
        private final Function<C, Boolean> isPersistedFunction;

        public AlreadyAssignedIdentifierPolicySupport(Consumer<C> markAsPersistedFunction, Function<C, Boolean> isPersistedFunction) {
            this.markAsPersistedFunction = markAsPersistedFunction;
            this.isPersistedFunction = isPersistedFunction;
        }

        @Override
        public Consumer<C> getMarkAsPersistedFunction() {
            return this.markAsPersistedFunction;
        }

        @Override
        public Function<C, Boolean> getIsPersistedFunction() {
            return this.isPersistedFunction;
        }
    }

    public static interface AlreadyAssignedIdentifierPolicy<C, I>
    extends IdentifierPolicy<I> {
        public Consumer<C> getMarkAsPersistedFunction();

        public Function<C, Boolean> getIsPersistedFunction();
    }

    public static interface DatabaseSequenceNamingStrategy {
        public static final DatabaseSequenceNamingStrategy HIBERNATE_DEFAULT;
        public static final DatabaseSequenceNamingStrategy DEFAULT;

        public String giveName(Class<?> var1);

        static {
            DEFAULT = HIBERNATE_DEFAULT = entityType -> Strings.capitalize((CharSequence)entityType.getSimpleName()) + "_seq";
        }
    }

    public static class DatabaseSequenceIdentifierPolicySupport
    implements BeforeInsertIdentifierPolicy<Long> {
        private final DatabaseSequenceNamingStrategy databaseSequenceNamingStrategy;
        private final DatabaseSequenceSettings databaseSequenceSettings;

        public DatabaseSequenceIdentifierPolicySupport() {
            this(DatabaseSequenceNamingStrategy.DEFAULT);
        }

        public DatabaseSequenceIdentifierPolicySupport(DatabaseSequenceNamingStrategy databaseSequenceNamingStrategy) {
            this(databaseSequenceNamingStrategy, new DatabaseSequenceSettings(Integer.valueOf(1), Integer.valueOf(1)));
        }

        public DatabaseSequenceIdentifierPolicySupport(DatabaseSequenceNamingStrategy databaseSequenceNamingStrategy, DatabaseSequenceSettings databaseSequenceSettings) {
            this.databaseSequenceNamingStrategy = databaseSequenceNamingStrategy;
            this.databaseSequenceSettings = databaseSequenceSettings;
        }

        public DatabaseSequenceNamingStrategy getDatabaseSequenceNamingStrategy() {
            return this.databaseSequenceNamingStrategy;
        }

        public DatabaseSequenceSettings getDatabaseSequenceSettings() {
            return this.databaseSequenceSettings;
        }
    }

    public static class PooledHiLoSequenceIdentifierPolicySupport
    implements BeforeInsertIdentifierPolicy<Long> {
        private final PooledHiLoSequenceStorageOptions storageOptions;

        public PooledHiLoSequenceIdentifierPolicySupport() {
            this.storageOptions = PooledHiLoSequenceStorageOptions.DEFAULT;
        }

        public PooledHiLoSequenceIdentifierPolicySupport(PooledHiLoSequenceStorageOptions sequenceStorageOptions) {
            this.storageOptions = sequenceStorageOptions;
        }

        public PooledHiLoSequenceStorageOptions getStorageOptions() {
            return this.storageOptions;
        }
    }

    public static class BeforeInsertIdentifierPolicySupport<I>
    implements BeforeInsertIdentifierPolicy<I> {
        private final Sequence<I> sequence;

        public BeforeInsertIdentifierPolicySupport(Sequence<I> sequence) {
            this.sequence = sequence;
        }

        public Sequence<I> getSequence() {
            return this.sequence;
        }
    }

    public static interface BeforeInsertIdentifierPolicy<I>
    extends IdentifierPolicy<I> {
    }

    public static class GeneratedKeysPolicySupport<I>
    implements GeneratedKeysPolicy<I> {
    }

    public static interface GeneratedKeysPolicy<I>
    extends IdentifierPolicy<I> {
    }

    public static interface IdentifierPolicy<ID> {
        public static <I> GeneratedKeysPolicy<I> databaseAutoIncrement() {
            return new GeneratedKeysPolicySupport();
        }

        public static BeforeInsertIdentifierPolicy<Long> pooledHiLoSequence() {
            return new PooledHiLoSequenceIdentifierPolicySupport();
        }

        public static BeforeInsertIdentifierPolicy<Long> pooledHiLoSequence(PooledHiLoSequenceStorageOptions sequenceStorageOptions) {
            return new PooledHiLoSequenceIdentifierPolicySupport(sequenceStorageOptions);
        }

        public static BeforeInsertIdentifierPolicy<Long> databaseSequence(DatabaseSequenceNamingStrategy namingStrategy) {
            return new DatabaseSequenceIdentifierPolicySupport(namingStrategy);
        }

        public static BeforeInsertIdentifierPolicy<Long> databaseSequence(String name) {
            return new DatabaseSequenceIdentifierPolicySupport(entityType -> name);
        }

        public static BeforeInsertIdentifierPolicy<Long> databaseSequence(DatabaseSequenceNamingStrategy namingStrategy, DatabaseSequenceSettings databaseSequenceSettings) {
            return new DatabaseSequenceIdentifierPolicySupport(namingStrategy, databaseSequenceSettings);
        }

        public static BeforeInsertIdentifierPolicy<Long> databaseSequence(String name, DatabaseSequenceSettings databaseSequenceSettings) {
            return new DatabaseSequenceIdentifierPolicySupport(entityType -> name, databaseSequenceSettings);
        }

        public static <I> BeforeInsertIdentifierPolicy<I> pooledHiLoSequence(Sequence<I> sequence) {
            return new BeforeInsertIdentifierPolicySupport<I>(sequence);
        }

        public static <C, I> AlreadyAssignedIdentifierPolicy<C, I> alreadyAssigned(Consumer<C> markAsPersistedFunction, Function<C, Boolean> isPersistedFunction) {
            return new AlreadyAssignedIdentifierPolicySupport(markAsPersistedFunction, isPersistedFunction);
        }
    }
}

