/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.spring.repository.query;

import java.util.List;
import java.util.function.Supplier;
import org.codefilarete.stalactite.spring.repository.query.QueryResultWindower;
import org.codefilarete.stalactite.spring.repository.query.StalactiteLimitRepositoryQuery;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.SliceImpl;

class SliceResultWindower<C, I, R, P>
extends QueryResultWindower<C, I, R, P> {
    SliceResultWindower(StalactiteLimitRepositoryQuery<C, I> delegate, Supplier<List<P>> resultSupplier) {
        super(delegate, (accessor, result) -> {
            int pageSize = 0;
            Pageable pageable = accessor.getPageable();
            if (pageable.isPaged()) {
                pageSize = pageable.getPageSize();
            }
            boolean hasNext = pageable.isPaged() && result.size() > pageSize;
            return new SliceImpl(hasNext ? result.subList(0, pageSize) : result, pageable, hasNext);
        }, resultSupplier);
    }
}

