/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.spring.repository.query;

import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.codefilarete.reflection.Accessor;
import org.codefilarete.reflection.AccessorByMember;
import org.codefilarete.reflection.AccessorChain;
import org.codefilarete.reflection.Accessors;
import org.codefilarete.stalactite.engine.EntityPersister;
import org.codefilarete.stalactite.engine.runtime.AdvancedEntityPersister;
import org.codefilarete.stalactite.engine.runtime.ProjectionQueryCriteriaSupport;
import org.codefilarete.stalactite.engine.runtime.query.AggregateAccessPointToColumnMapping;
import org.codefilarete.stalactite.engine.runtime.query.EntityCriteriaSupport;
import org.codefilarete.stalactite.query.model.LogicalOperator;
import org.codefilarete.stalactite.query.model.Select;
import org.codefilarete.stalactite.query.model.Selectable;
import org.codefilarete.stalactite.spring.repository.query.AbstractDerivedQuery;
import org.codefilarete.stalactite.spring.repository.query.PageResultWindower;
import org.codefilarete.stalactite.spring.repository.query.PartTreeStalactiteCountProjection;
import org.codefilarete.stalactite.spring.repository.query.QueryResultWindower;
import org.codefilarete.stalactite.spring.repository.query.SliceResultWindower;
import org.codefilarete.stalactite.spring.repository.query.StalactiteLimitRepositoryQuery;
import org.codefilarete.stalactite.sql.result.Accumulator;
import org.codefilarete.tool.Nullable;
import org.codefilarete.tool.collection.Iterables;
import org.codefilarete.tool.collection.KeepOrderSet;
import org.codefilarete.tool.function.Hanger;
import org.codefilarete.tool.trace.MutableInt;
import org.springframework.data.domain.Sort;
import org.springframework.data.mapping.PropertyPath;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.projection.EntityProjection;
import org.springframework.data.projection.EntityProjectionIntrospector;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.relational.core.mapping.RelationalMappingContext;
import org.springframework.data.repository.query.ParameterAccessor;
import org.springframework.data.repository.query.ParametersParameterAccessor;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.data.repository.query.parser.Part;
import org.springframework.data.repository.query.parser.PartTree;

class PartTreeStalactiteProjection<C, R>
implements StalactiteLimitRepositoryQuery<C, R> {
    private final QueryMethod method;
    private final AdvancedEntityPersister<C, ?> entityPersister;
    private final PartTree tree;
    private final Accumulator<Function<Selectable<Object>, Object>, List<Object[]>, List<Object[]>> accumulator;
    private final DerivedQuery<C> query;
    private final Consumer<Select> selectConsumer;
    private Function<List<Object[]>, R> rowProjectionAdapter;

    public <O> PartTreeStalactiteProjection(QueryMethod method, AdvancedEntityPersister<C, ?> entityPersister, PartTree tree, ProjectionFactory factory) {
        this.method = method;
        this.entityPersister = entityPersister;
        this.tree = tree;
        EntityProjectionIntrospector.ProjectionPredicate predicate = (returnType, domainType) -> !domainType.isAssignableFrom(returnType) && !returnType.isAssignableFrom(domainType);
        EntityProjectionIntrospector entityProjectionIntrospector = EntityProjectionIntrospector.create((ProjectionFactory)factory, (EntityProjectionIntrospector.ProjectionPredicate)predicate, (MappingContext)new RelationalMappingContext());
        EntityProjection introspect = entityProjectionIntrospector.introspect(method.getReturnedObjectType(), entityPersister.getClassToPersist());
        LinkedHashSet propertiesAccessors = new LinkedHashSet();
        introspect.forEachRecursive(propertyProjection -> {
            AccessorChain accessorChain = new AccessorChain();
            List collect = propertyProjection.getPropertyPath().stream().collect(Collectors.toList());
            if (collect.size() >= 2) {
                collect = Iterables.cutTail(collect);
            }
            collect.forEach(propertyPath -> propertyPath.forEach(propertyPath1 -> accessorChain.add((Accessor)Accessors.accessor((Class)propertyPath1.getOwningType().getType(), (String)propertyPath1.getSegment(), (Class)propertyPath1.getType()))));
            propertiesAccessors.add(accessorChain.getAccessors());
        });
        AggregateAccessPointToColumnMapping aggregateColumnMapping = entityPersister.getEntityFinder().newCriteriaSupport().getEntityCriteriaSupport().getAggregateColumnMapping();
        final Hanger.Holder selectHolder = new Hanger.Holder();
        this.selectConsumer = select -> {
            select.clear();
            selectHolder.set(select);
            MutableInt aliasCounter = new MutableInt(0);
            propertiesAccessors.forEach(property -> {
                Selectable selectable = aggregateColumnMapping.giveColumn(property);
                select.add(selectable, "prop_" + aliasCounter.increment());
            });
        };
        this.accumulator = new Accumulator<Function<Selectable<Object>, Object>, List<Object[]>, List<Object[]>>(){

            public Supplier<List<Object[]>> supplier() {
                return LinkedList::new;
            }

            public BiConsumer<List<Object[]>, Function<Selectable<Object>, Object>> aggregator() {
                return (resultSet, selectableObjectFunction) -> {
                    Select selectables = (Select)selectHolder.get();
                    KeepOrderSet columns = selectables.getColumns();
                    Object[] row = new Object[columns.size()];
                    resultSet.add(row);
                    int i = 0;
                    for (Selectable selectable : columns) {
                        row[i++] = selectableObjectFunction.apply(selectable);
                    }
                };
            }

            public Function<List<Object[]>, List<Object[]>> finisher() {
                return Function.identity();
            }
        };
        try {
            this.query = new DerivedQuery(entityPersister, tree);
            if (tree.getSort().isSorted()) {
                tree.getSort().iterator().forEachRemaining(order -> {
                    PropertyPath propertyPath = PropertyPath.from((String)order.getProperty(), (Class)entityPersister.getClassToPersist());
                    AccessorChain orderProperty = this.query.convertToAccessorChain(propertyPath);
                    this.query.executableProjectionQuery.getQueryPageSupport().orderBy(orderProperty, order.getDirection() == Sort.Direction.ASC ? EntityPersister.OrderByChain.Order.ASC : EntityPersister.OrderByChain.Order.DESC, order.isIgnoreCase());
                });
            }
            Nullable.nullable((Object)tree.getMaxResults()).invoke(arg_0 -> ((ProjectionQueryCriteriaSupport.ProjectionQueryPageSupport)this.query.executableProjectionQuery.getQueryPageSupport()).limit(arg_0));
        }
        catch (RuntimeException o_O) {
            throw new IllegalArgumentException(String.format("Failed to create query for method %s! %s", method, o_O.getMessage()), o_O);
        }
    }

    public DerivedQuery<C> getQuery() {
        return this.query;
    }

    @Override
    public R execute(Object[] parameters) {
        this.query.criteriaChain.consume(parameters);
        final ProjectionQueryCriteriaSupport<C, ?> derivedQueryToUse = this.handleDynamicSort(parameters);
        Supplier resultSupplier = () -> (List)derivedQueryToUse.wrapIntoExecutable().execute(this.accumulator);
        QueryResultWindower queryResultWindower = this.method.isSliceQuery() ? new SliceResultWindower(this, resultSupplier) : (this.method.isPageQuery() ? new PageResultWindower(this, new PartTreeStalactiteCountProjection<C>(this.method, this.entityPersister, this.tree), resultSupplier) : new QueryResultWindower<C, Object, R, Object[]>(null, null, null){

            @Override
            R adaptExecution(Object[] parameters) {
                return derivedQueryToUse.wrapIntoExecutable().execute(PartTreeStalactiteProjection.this.accumulator);
            }
        });
        Object adaptation = queryResultWindower.adaptExecution(parameters);
        if (this.method.getParameters().hasDynamicProjection()) {
            return (R)this.method.getResultProcessor().withDynamicProjection((ParameterAccessor)new ParametersParameterAccessor(this.method.getParameters(), parameters)).processResult(adaptation);
        }
        return (R)this.method.getResultProcessor().processResult(adaptation);
    }

    private ProjectionQueryCriteriaSupport<C, ?> handleDynamicSort(Object[] parameters) {
        ProjectionQueryCriteriaSupport derivedQueryToUse;
        ParametersParameterAccessor parameterHelper = new ParametersParameterAccessor(this.getQueryMethod().getParameters(), parameters);
        if (parameterHelper.getSort().isSorted()) {
            DerivedQuery derivedQuery = new DerivedQuery(this.query.executableProjectionQuery);
            Class declaringClass = this.getQueryMethod().getEntityInformation().getJavaType();
            parameterHelper.getSort().stream().forEachOrdered(order -> {
                AccessorByMember accessor = Accessors.accessor((Class)declaringClass, (String)order.getProperty());
                derivedQuery.dynamicSortSupport.orderBy(new AccessorChain(new Accessor[]{accessor}), order.getDirection() == Sort.Direction.ASC ? EntityPersister.OrderByChain.Order.ASC : EntityPersister.OrderByChain.Order.DESC, order.isIgnoreCase());
            });
            derivedQueryToUse = derivedQuery.executableProjectionQuery.copyFor(derivedQuery.dynamicSortSupport);
        } else {
            derivedQueryToUse = this.query.executableProjectionQuery;
        }
        return derivedQueryToUse;
    }

    public QueryMethod getQueryMethod() {
        return this.method;
    }

    @Override
    public void limit(int count) {
        this.query.executableProjectionQuery.getQueryPageSupport().limit(count);
    }

    @Override
    public void limit(int count, Integer offset) {
        this.query.executableProjectionQuery.getQueryPageSupport().limit(count, offset);
    }

    private class DerivedQuery<T>
    extends AbstractDerivedQuery<T> {
        protected final ProjectionQueryCriteriaSupport<T, ?> executableProjectionQuery;
        protected final ProjectionQueryCriteriaSupport.ProjectionQueryPageSupport<T> dynamicSortSupport = new ProjectionQueryCriteriaSupport.ProjectionQueryPageSupport();
        private EntityCriteriaSupport<T> currentSupport;

        private DerivedQuery(AdvancedEntityPersister<T, ?> entityPersister, PartTree tree) {
            this.executableProjectionQuery = entityPersister.newProjectionCriteriaSupport(PartTreeStalactiteProjection.this.selectConsumer);
            tree.forEach(this::append);
        }

        private DerivedQuery(ProjectionQueryCriteriaSupport<T, ?> executableProjectionQuery) {
            this.executableProjectionQuery = executableProjectionQuery;
        }

        private void append(PartTree.OrPart part) {
            Iterator iterator;
            this.currentSupport = this.executableProjectionQuery.getEntityCriteriaSupport();
            boolean nested = false;
            if (part.stream().count() > 1L) {
                nested = true;
                this.currentSupport = this.currentSupport.beginNested();
            }
            if ((iterator = part.iterator()).hasNext()) {
                this.append((Part)iterator.next(), LogicalOperator.OR);
            }
            iterator.forEachRemaining(p -> this.append((Part)p, LogicalOperator.AND));
            if (nested) {
                this.currentSupport = this.currentSupport.endNested();
            }
        }

        private void append(Part part, LogicalOperator orOrAnd) {
            AccessorChain getter = this.convertToAccessorChain(part.getProperty());
            AbstractDerivedQuery.Criterion criterion = this.convertToCriterion(part.getType(), part.shouldIgnoreCase() != Part.IgnoreCaseType.NEVER);
            this.currentSupport.add(orOrAnd, getter.getAccessors(), criterion.operator);
            this.criteriaChain.criteria.add(criterion);
        }
    }
}

