/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.spring.repository.query.nativ;

import java.util.HashMap;
import java.util.Map;
import org.codefilarete.stalactite.engine.runtime.AdvancedEntityPersister;
import org.codefilarete.stalactite.engine.runtime.RelationalEntityFinder;
import org.codefilarete.stalactite.spring.repository.query.AbstractRepositoryQuery;
import org.codefilarete.stalactite.spring.repository.query.nativ.NativeQueryMethod;
import org.codefilarete.stalactite.sql.ConnectionProvider;
import org.codefilarete.stalactite.sql.Dialect;
import org.codefilarete.stalactite.sql.result.Accumulator;
import org.codefilarete.stalactite.sql.statement.binder.PreparedStatementWriter;
import org.springframework.core.ResolvableType;
import org.springframework.data.relational.repository.query.RelationalParameters;
import org.springframework.data.repository.query.ParametersParameterAccessor;

public class SqlNativeRepositoryQuery<C>
extends AbstractRepositoryQuery {
    private static final String PARAMETER_NEEDS_TO_BE_NAMED = "For queries with named parameters you need to provide names for method parameters. Use @Param for query method parameters, or when on Java 8+ use the javac flag -parameters.";
    private final String sql;
    private final Accumulator<C, ?, ?> accumulator;
    private final Dialect dialect;
    private final RelationalEntityFinder<C, ?, ?> relationalEntityFinder;

    public SqlNativeRepositoryQuery(NativeQueryMethod queryMethod, String sql, AdvancedEntityPersister<C, ?> entityPersister, Accumulator<C, ?, ?> accumulator, Dialect dialect, ConnectionProvider connectionProvider) {
        super(queryMethod);
        this.sql = sql;
        this.accumulator = accumulator;
        this.dialect = dialect;
        if (queryMethod.isSliceQuery()) {
            throw new UnsupportedOperationException("Slice queries are not supported using string-based queries. Offending method: " + (Object)((Object)queryMethod));
        }
        if (queryMethod.isPageQuery()) {
            throw new UnsupportedOperationException("Page queries are not supported using string-based queries. Offending method: " + (Object)((Object)queryMethod));
        }
        this.relationalEntityFinder = new RelationalEntityFinder(entityPersister.getEntityJoinTree(), connectionProvider, dialect, true);
    }

    @Override
    public NativeQueryMethod getQueryMethod() {
        return (NativeQueryMethod)super.getQueryMethod();
    }

    public Object execute(Object[] parameters) {
        ParametersParameterAccessor accessor = new ParametersParameterAccessor(this.queryMethod.getParameters(), parameters);
        return this.accumulator.collect((Iterable)this.relationalEntityFinder.selectFromQueryBean(this.sql, this.getValues(accessor), this.bindParameters(accessor)));
    }

    private Map<String, PreparedStatementWriter<?>> bindParameters(ParametersParameterAccessor accessor) {
        HashMap result = new HashMap();
        RelationalParameters bindableParameters = (RelationalParameters)this.getQueryMethod().getParameters().getBindableParameters();
        for (RelationalParameters.RelationalParameter bindableParameter : bindableParameters) {
            Class<Object> valueType;
            String parameterName = (String)bindableParameter.getName().orElseThrow(() -> new IllegalStateException(PARAMETER_NEEDS_TO_BE_NAMED));
            Object value = accessor.getBindableValue(bindableParameter.getIndex());
            if (value instanceof Iterable) {
                ResolvableType resolvableType = bindableParameter.getResolvableType();
                valueType = resolvableType.getGeneric(new int[]{0}).resolve();
            } else {
                valueType = value.getClass().isArray() ? value.getClass().getComponentType() : value.getClass();
            }
            PreparedStatementWriter writer = this.dialect.getColumnBinderRegistry().getWriter(valueType);
            result.put(parameterName, writer);
        }
        return result;
    }
}

