/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.runtime;

import java.sql.ResultSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.codefilarete.reflection.Accessor;
import org.codefilarete.reflection.AccessorChain;
import org.codefilarete.reflection.ValueAccessPoint;
import org.codefilarete.stalactite.engine.runtime.AbstractPolymorphismPersister;
import org.codefilarete.stalactite.engine.runtime.ConfiguredRelationalPersister;
import org.codefilarete.stalactite.engine.runtime.load.EntityJoinTree;
import org.codefilarete.stalactite.engine.runtime.load.EntityTreeInflater;
import org.codefilarete.stalactite.engine.runtime.load.EntityTreeQueryBuilder;
import org.codefilarete.stalactite.engine.runtime.query.EntityCriteriaSupport;
import org.codefilarete.stalactite.mapping.AccessorWrapperIdAccessor;
import org.codefilarete.stalactite.mapping.EntityMapping;
import org.codefilarete.stalactite.query.ConfiguredEntityCriteria;
import org.codefilarete.stalactite.query.EntityFinder;
import org.codefilarete.stalactite.query.builder.QuerySQLBuilderFactory;
import org.codefilarete.stalactite.query.model.ConditionalOperator;
import org.codefilarete.stalactite.query.model.GroupBy;
import org.codefilarete.stalactite.query.model.Having;
import org.codefilarete.stalactite.query.model.Limit;
import org.codefilarete.stalactite.query.model.Operators;
import org.codefilarete.stalactite.query.model.OrderBy;
import org.codefilarete.stalactite.query.model.Query;
import org.codefilarete.stalactite.query.model.Select;
import org.codefilarete.stalactite.query.model.Selectable;
import org.codefilarete.stalactite.query.model.Where;
import org.codefilarete.stalactite.sql.ConnectionProvider;
import org.codefilarete.stalactite.sql.Dialect;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.stalactite.sql.result.Accumulator;
import org.codefilarete.stalactite.sql.result.ColumnedRow;
import org.codefilarete.stalactite.sql.result.ColumnedRowIterator;
import org.codefilarete.stalactite.sql.statement.PreparedSQL;
import org.codefilarete.stalactite.sql.statement.ReadOperation;
import org.codefilarete.stalactite.sql.statement.SQLExecutionException;
import org.codefilarete.stalactite.sql.statement.SQLOperation;
import org.codefilarete.stalactite.sql.statement.SQLStatement;
import org.codefilarete.stalactite.sql.statement.binder.ResultSetReader;
import org.codefilarete.tool.collection.Iterables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPolymorphicEntityFinder<C, I, T extends Table<T>>
implements EntityFinder<C, I> {
    protected final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    protected final EntityJoinTree<C, I> mainEntityJoinTree;
    protected final Map<Class<C>, ConfiguredRelationalPersister<C, I>> persisterPerSubclass;
    protected final ConnectionProvider connectionProvider;
    protected final Dialect dialect;
    protected final boolean hasSubPolymorphicPersister;
    private final AccessorChain<C, I> entityIdAccessor;
    private final EntityMapping<C, I, T> mainMapping;
    private SQLOperation.SQLOperationListener<?> operationListener;

    protected AbstractPolymorphicEntityFinder(ConfiguredRelationalPersister<C, I> mainPersister, Map<? extends Class<C>, ? extends ConfiguredRelationalPersister<C, I>> persisterPerSubclass, ConnectionProvider connectionProvider, Dialect dialect) {
        this.mainEntityJoinTree = mainPersister.getEntityJoinTree();
        this.persisterPerSubclass = persisterPerSubclass;
        this.connectionProvider = connectionProvider;
        this.dialect = dialect;
        this.hasSubPolymorphicPersister = Iterables.find(persisterPerSubclass.values(), subPersister -> subPersister instanceof AbstractPolymorphismPersister) != null;
        this.mainMapping = mainPersister.getMapping();
        AccessorWrapperIdAccessor idAccessor = (AccessorWrapperIdAccessor)this.mainMapping.getIdMapping().getIdAccessor();
        this.entityIdAccessor = new AccessorChain(new Accessor[]{idAccessor.getIdAccessor()});
    }

    @Override
    public void setOperationListener(SQLOperation.SQLOperationListener<?> operationListener) {
        this.operationListener = operationListener;
    }

    @Override
    public Set<C> select(ConfiguredEntityCriteria where, OrderBy orderBy, Limit limit, Map<String, Object> valuesPerParam) {
        if (where.hasCollectionCriteria()) {
            return this.selectIn2Phases(where, orderBy, limit);
        }
        return this.selectWithSingleQuery(where, orderBy, limit);
    }

    public abstract Set<C> selectIn2Phases(ConfiguredEntityCriteria var1, OrderBy var2, Limit var3);

    public abstract Set<C> selectWithSingleQuery(ConfiguredEntityCriteria var1, OrderBy var2, Limit var3);

    protected abstract Query getAggregateQueryTemplate();

    protected EntityCriteriaSupport<C> newWhereIdClause(Iterable<I> ids) {
        return (EntityCriteriaSupport)new EntityCriteriaSupport<C>(this.mainEntityJoinTree, true).and((ValueAccessPoint)this.entityIdAccessor, (ConditionalOperator)Operators.in(ids));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Set<C> selectWithSingleQuery(Query queryClone, EntityTreeQueryBuilder.EntityTreeQuery<C> entityTreeQuery, Dialect dialect, ConnectionProvider connectionProvider) {
        QuerySQLBuilderFactory.QuerySQLBuilder sqlQueryBuilder = dialect.getQuerySQLBuilderFactory().queryBuilder(queryClone);
        EntityTreeInflater<C> inflater = entityTreeQuery.getInflater();
        PreparedSQL preparedSQL = sqlQueryBuilder.toPreparableSQL().toPreparedSQL(new HashMap());
        try (ReadOperation readOperation = dialect.getReadOperationFactory().createInstance((SQLStatement)preparedSQL, connectionProvider);){
            readOperation.setListener(this.operationListener);
            ResultSet resultSet = readOperation.execute();
            ColumnedRowIterator rowIterator = new ColumnedRowIterator(resultSet, entityTreeQuery.getSelectParameterBinders(), entityTreeQuery.getColumnAliases());
            Set<C> set = inflater.transform(() -> AbstractPolymorphicEntityFinder.lambda$selectWithSingleQuery$1((Iterator)rowIterator), 50);
            return set;
        }
        catch (RuntimeException e) {
            throw new SQLExecutionException(preparedSQL.getSQL(), (Throwable)e);
        }
    }

    @Override
    public <R, O> R selectProjection(Consumer<Select> selectAdapter, Accumulator<? super Function<Selectable<O>, O>, Object, R> accumulator, ConfiguredEntityCriteria where, boolean distinct, OrderBy orderBy, Limit limit) {
        Query queryClone = new Query(new Select(), this.getAggregateQueryTemplate().getFromDelegate(), new Where(), new GroupBy(), new Having(), orderBy, limit);
        QuerySQLBuilderFactory.QuerySQLBuilder sqlQueryBuilder = this.dialect.getQuerySQLBuilderFactory().queryBuilder(queryClone, where.getCriteria());
        selectAdapter.accept(queryClone.getSelectDelegate());
        Map columnReaders = Iterables.map((Iterable)queryClone.getColumns(), Function.identity(), selectable -> this.dialect.getColumnBinderRegistry().getBinder(selectable.getJavaType()));
        PreparedSQL preparedSQL = sqlQueryBuilder.toPreparableSQL().toPreparedSQL(new HashMap());
        return this.readProjection(preparedSQL, columnReaders, queryClone.getAliases(), accumulator);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected <R, O> R readProjection(PreparedSQL preparedSQL, Map<Selectable<?>, ResultSetReader<?>> columnReaders, Map<Selectable<?>, String> aliases, Accumulator<? super Function<Selectable<O>, O>, Object, R> accumulator) {
        try (ReadOperation closeableOperation = this.dialect.getReadOperationFactory().createInstance((SQLStatement)preparedSQL, this.connectionProvider);){
            ColumnedRowIterator rowIterator = new ColumnedRowIterator(closeableOperation.execute(), columnReaders, aliases);
            Object object = accumulator.collect((Iterable)Iterables.stream((Iterator)rowIterator).map(row -> arg_0 -> ((ColumnedRow)row).get(arg_0)).collect(Collectors.toList()));
            return (R)object;
        }
        catch (RuntimeException e) {
            throw new SQLExecutionException(preparedSQL.getSQL(), (Throwable)e);
        }
    }

    private static /* synthetic */ Iterator lambda$selectWithSingleQuery$1(Iterator rowIterator) {
        return rowIterator;
    }
}

