/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.runtime.query;

import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.codefilarete.reflection.AbstractReflector;
import org.codefilarete.reflection.Accessor;
import org.codefilarete.reflection.AccessorByMember;
import org.codefilarete.reflection.AccessorByMethodReference;
import org.codefilarete.reflection.AccessorChain;
import org.codefilarete.reflection.AccessorDefinition;
import org.codefilarete.reflection.Accessors;
import org.codefilarete.reflection.MethodReferenceDispatcher;
import org.codefilarete.reflection.MutatorByMethodReference;
import org.codefilarete.reflection.ReversibleMutator;
import org.codefilarete.reflection.ValueAccessPoint;
import org.codefilarete.stalactite.engine.EntityPersister;
import org.codefilarete.stalactite.engine.ExecutableQuery;
import org.codefilarete.stalactite.engine.runtime.RelationalEntityPersister;
import org.codefilarete.stalactite.engine.runtime.query.EntityCriteriaSupport;
import org.codefilarete.stalactite.query.ConfiguredEntityCriteria;
import org.codefilarete.stalactite.query.EntityFinder;
import org.codefilarete.stalactite.query.RelationalEntityCriteria;
import org.codefilarete.stalactite.query.model.Limit;
import org.codefilarete.stalactite.query.model.Operators;
import org.codefilarete.stalactite.query.model.OrderBy;
import org.codefilarete.stalactite.query.model.OrderByChain;
import org.codefilarete.stalactite.query.model.Selectable;
import org.codefilarete.stalactite.query.model.operator.LowerCase;
import org.codefilarete.stalactite.sql.result.Accumulator;
import org.codefilarete.tool.Nullable;
import org.codefilarete.tool.VisibleForTesting;
import org.codefilarete.tool.collection.Arrays;
import org.codefilarete.tool.collection.KeepOrderSet;
import org.danekja.java.util.function.serializable.SerializableBiConsumer;
import org.danekja.java.util.function.serializable.SerializableFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityQueryCriteriaSupport<C, I> {
    public static final Logger LOGGER = LoggerFactory.getLogger(EntityQueryCriteriaSupport.class);
    private final EntityFinder<C, I> entityFinder;
    private final EntityCriteriaSupport<C> entityCriteriaSupport;
    private final EntityQueryPageSupport<C> queryPageSupport;

    public EntityQueryCriteriaSupport(EntityFinder<C, I> entityFinder, EntityCriteriaSupport<C> source) {
        this.entityFinder = entityFinder;
        this.entityCriteriaSupport = new EntityCriteriaSupport<C>(source);
        this.queryPageSupport = new EntityQueryPageSupport();
    }

    private EntityQueryCriteriaSupport(EntityFinder<C, I> entityFinder, EntityCriteriaSupport<C> entityCriteriaSupport, EntityQueryPageSupport<C> queryPageSupport) {
        this.entityFinder = entityFinder;
        this.entityCriteriaSupport = entityCriteriaSupport;
        this.queryPageSupport = queryPageSupport;
    }

    public EntityQueryCriteriaSupport<C, I> copyFor(EntityQueryPageSupport<C> otherPageSupport) {
        return new EntityQueryCriteriaSupport<C, I>(this.entityFinder, this.entityCriteriaSupport, ((EntityQueryPageSupport)this.queryPageSupport).merge((EntityQueryPageSupport)otherPageSupport));
    }

    public EntityCriteriaSupport<C> getEntityCriteriaSupport() {
        return this.entityCriteriaSupport;
    }

    public EntityQueryPageSupport<C> getQueryPageSupport() {
        return this.queryPageSupport;
    }

    public RelationalEntityPersister.ExecutableEntityQueryCriteria<C, ?> wrapIntoExecutable() {
        HashMap<String, Object> values = new HashMap<String, Object>();
        MethodReferenceDispatcher methodDispatcher = new MethodReferenceDispatcher();
        return (RelationalEntityPersister.ExecutableEntityQueryCriteria)methodDispatcher.redirect(ExecutableQuery::execute, this.wrapGraphLoad(values)).redirect(EntityPersister.ExecutableEntityQuery::set, (s, object) -> values.put((String)s, object)).redirect(EntityPersister.OrderByChain.class, this.queryPageSupport, true).redirect(EntityPersister.LimitAware.class, this.queryPageSupport, true).redirect(RelationalEntityCriteria.class, this.entityCriteriaSupport, true).redirect(ConfiguredEntityCriteria::getCriteria, this.entityCriteriaSupport::getCriteria).redirect(ConfiguredEntityCriteria::hasCollectionCriteria, this.entityCriteriaSupport::hasCollectionCriteria).build(ConfiguredExecutableEntityQueryCriteria.class);
    }

    public <R> Function<Accumulator<C, Collection<C>, R>, R> wrapGraphLoad(Map<String, Object> values) {
        if (((EntityQueryPageSupport)this.queryPageSupport).getLimit() != null && this.entityCriteriaSupport.hasCollectionCriteria()) {
            throw new UnsupportedOperationException("Can't limit query when entity graph contains Collection relations");
        }
        if (this.entityCriteriaSupport.hasCollectionCriteria() && !((EntityQueryPageSupport)this.queryPageSupport).getOrderBy().isEmpty()) {
            return accumulatorParam -> {
                LOGGER.debug("Sorting loaded entities in memory");
                Set<C> loadedEntities = this.entityFinder.select(this.entityCriteriaSupport, new OrderBy(), ((EntityQueryPageSupport)this.queryPageSupport).getLimit(), values);
                TreeSet<C> sortedResult = new TreeSet<C>(EntityQueryCriteriaSupport.buildComparator((KeepOrderSet<EntityQueryPageSupport.OrderByItem>)((EntityQueryPageSupport)this.queryPageSupport).getOrderBy()));
                sortedResult.addAll(loadedEntities);
                return accumulatorParam.collect(sortedResult);
            };
        }
        return accumulatorParam -> {
            OrderBy orderBy = new OrderBy();
            ((EntityQueryPageSupport)this.queryPageSupport).getOrderBy().forEach(duo -> {
                LowerCase column = this.entityCriteriaSupport.getAggregateColumnMapping().giveColumn(duo.getProperty());
                orderBy.add((Selectable)(duo.isIgnoreCase() ? Operators.lowerCase(column) : column), duo.getDirection() == EntityPersister.OrderByChain.Order.ASC ? OrderByChain.Order.ASC : OrderByChain.Order.DESC);
            });
            Set<C> select = this.entityFinder.select(this.entityCriteriaSupport, orderBy, ((EntityQueryPageSupport)this.queryPageSupport).getLimit(), values);
            return accumulatorParam.collect(select);
        };
    }

    @VisibleForTesting
    static <C> Comparator<C> buildComparator(KeepOrderSet<EntityQueryPageSupport.OrderByItem> orderBy) {
        Nullable result = Nullable.nullable((Object)null);
        orderBy.forEach(orderByPawn -> {
            Comparator<Object> comparator;
            AccessorChain<Object, Comparable> propertyAccessor = orderByPawn.propertyAsAccessorChain();
            if (orderByPawn.isIgnoreCase()) {
                AccessorChain<Object, Comparable> stringAccessor = propertyAccessor;
                comparator = Comparator.comparing(arg_0 -> stringAccessor.get(arg_0), Comparator.nullsLast(String.CASE_INSENSITIVE_ORDER));
            } else {
                comparator = Comparator.comparing(arg_0 -> propertyAccessor.get(arg_0), Comparator.nullsLast(Comparator.naturalOrder()));
            }
            if (orderByPawn.getDirection() == EntityPersister.OrderByChain.Order.DESC) {
                comparator = comparator.reversed();
            }
            if (result.isPresent()) {
                Comparator<Object> finalComparator = comparator;
                result.map(c -> c.thenComparing(finalComparator));
            } else {
                result.set(comparator);
            }
        });
        return (Comparator)result.get();
    }

    private static <C, T> Accessor<C, T> toAccessor(ValueAccessPoint<C> valueAccessPoint) {
        if (valueAccessPoint instanceof Accessor) {
            return (Accessor)valueAccessPoint;
        }
        if (valueAccessPoint instanceof ReversibleMutator) {
            return ((ReversibleMutator)valueAccessPoint).toAccessor();
        }
        AccessorDefinition accessorDefinition = AccessorDefinition.giveDefinition(valueAccessPoint);
        AccessorByMember accessor = Accessors.accessor((Class)accessorDefinition.getDeclaringClass(), (String)accessorDefinition.getName(), (Class)accessorDefinition.getMemberType());
        return accessor;
    }

    public static class EntityQueryPageSupport<C>
    implements EntityPersister.OrderByChain<C, EntityQueryPageSupport<C>>,
    EntityPersister.LimitAware<EntityQueryPageSupport<C>> {
        private Limit limit;
        private final KeepOrderSet<OrderByItem> orderBy = new KeepOrderSet();

        private Limit getLimit() {
            return this.limit;
        }

        private KeepOrderSet<OrderByItem> getOrderBy() {
            return this.orderBy;
        }

        public EntityQueryPageSupport<C> limit(int count) {
            this.limit = new Limit(Integer.valueOf(count));
            return this;
        }

        public EntityQueryPageSupport<C> limit(int count, Integer offset) {
            this.limit = new Limit(Integer.valueOf(count), offset);
            return this;
        }

        public EntityQueryPageSupport<C> orderBy(SerializableFunction<C, ?> getter, EntityPersister.OrderByChain.Order order) {
            AccessorByMethodReference methodReference = new AccessorByMethodReference(getter);
            this.orderBy.add((Object)new OrderByItem(Arrays.asList((Object[])new AccessorByMethodReference[]{methodReference}), order, false));
            this.assertAccessorIsNotIterable((ValueAccessPoint)methodReference, methodReference.getPropertyType());
            return this;
        }

        public EntityQueryPageSupport<C> orderBy(SerializableBiConsumer<C, ?> setter, EntityPersister.OrderByChain.Order order) {
            MutatorByMethodReference methodReference = new MutatorByMethodReference(setter);
            this.orderBy.add((Object)new OrderByItem(Arrays.asList((Object[])new MutatorByMethodReference[]{methodReference}), order, false));
            this.assertAccessorIsNotIterable((ValueAccessPoint)methodReference, methodReference.getPropertyType());
            return this;
        }

        public EntityQueryPageSupport<C> orderBy(AccessorChain<C, ?> getter, EntityPersister.OrderByChain.Order order) {
            return this.orderBy(getter, order, false);
        }

        public EntityQueryPageSupport<C> orderBy(AccessorChain<C, ?> getter, EntityPersister.OrderByChain.Order order, boolean ignoreCase) {
            this.orderBy.add((Object)new OrderByItem(getter.getAccessors(), order, ignoreCase));
            getter.getAccessors().forEach(accessor -> this.assertAccessorIsNotIterable((ValueAccessPoint)accessor, AccessorDefinition.giveDefinition((ValueAccessPoint)accessor).getMemberType()));
            return this;
        }

        private void assertAccessorIsNotIterable(ValueAccessPoint valueAccessPoint, Class memberType) {
            if (Iterable.class.isAssignableFrom(memberType)) {
                throw new IllegalArgumentException("OrderBy clause on a Collection property is unsupported due to eventual inconsistency with Collection nature : " + (valueAccessPoint instanceof AbstractReflector ? ((AbstractReflector)valueAccessPoint).getDescription() : AccessorDefinition.giveDefinition((ValueAccessPoint)valueAccessPoint)).toString());
            }
        }

        private EntityQueryPageSupport<C> merge(EntityQueryPageSupport<C> other) {
            EntityQueryPageSupport<C> duplicate = new EntityQueryPageSupport<C>();
            if (this.getLimit() != null) {
                duplicate.limit(this.getLimit().getCount(), this.getLimit().getOffset());
            }
            duplicate.orderBy.addAll(this.orderBy);
            if (super.getLimit() != null) {
                duplicate.limit(super.getLimit().getCount(), super.getLimit().getOffset());
            }
            duplicate.orderBy.addAll(other.orderBy);
            return duplicate;
        }

        public static class OrderByItem {
            private final List<? extends ValueAccessPoint<?>> property;
            private final EntityPersister.OrderByChain.Order direction;
            private final boolean ignoreCase;

            public OrderByItem(List<? extends ValueAccessPoint<?>> property, EntityPersister.OrderByChain.Order direction, boolean ignoreCase) {
                this.property = property;
                this.direction = direction;
                this.ignoreCase = ignoreCase;
            }

            public List<? extends ValueAccessPoint<?>> getProperty() {
                return this.property;
            }

            public EntityPersister.OrderByChain.Order getDirection() {
                return this.direction;
            }

            public boolean isIgnoreCase() {
                return this.ignoreCase;
            }

            public AccessorChain<Object, Comparable> propertyAsAccessorChain() {
                AccessorChain result;
                if (this.property.size() == 1) {
                    ValueAccessPoint<?> valueAccessPoint = this.property.get(0);
                    if (valueAccessPoint instanceof Accessor) {
                        result = new AccessorChain(new Accessor[]{(Accessor)valueAccessPoint});
                    } else {
                        AccessorDefinition accessorDefinition = AccessorDefinition.giveDefinition(valueAccessPoint);
                        result = new AccessorChain(new Accessor[]{Accessors.accessor((Class)accessorDefinition.getDeclaringClass(), (String)accessorDefinition.getName(), (Class)accessorDefinition.getMemberType())});
                    }
                } else {
                    result = new AccessorChain(this.property.stream().map(x$0 -> EntityQueryCriteriaSupport.toAccessor(x$0)).collect(Collectors.toList()));
                }
                result.setNullValueHandler(AccessorChain.RETURN_NULL);
                return result;
            }
        }
    }

    private static interface ConfiguredExecutableEntityQueryCriteria<C>
    extends ConfiguredEntityCriteria,
    RelationalEntityPersister.ExecutableEntityQueryCriteria<C, ConfiguredExecutableEntityQueryCriteria<C>> {
    }
}

