/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.query.builder;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.codefilarete.stalactite.query.builder.DMLNameProvider;
import org.codefilarete.stalactite.query.builder.SQLAppender;
import org.codefilarete.stalactite.query.builder.StringSQLAppender;
import org.codefilarete.stalactite.query.model.Fromable;
import org.codefilarete.stalactite.query.model.Placeholder;
import org.codefilarete.stalactite.query.model.Selectable;
import org.codefilarete.stalactite.query.model.ValuedVariable;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.statement.ExpandableSQL;
import org.codefilarete.stalactite.sql.statement.ExpandableStatement;
import org.codefilarete.stalactite.sql.statement.PreparedSQL;
import org.codefilarete.stalactite.sql.statement.SQLParameterParser;
import org.codefilarete.stalactite.sql.statement.SQLStatement;
import org.codefilarete.stalactite.sql.statement.binder.ColumnBinderRegistry;
import org.codefilarete.stalactite.sql.statement.binder.ParameterBinder;
import org.codefilarete.tool.Reflections;
import org.codefilarete.tool.trace.MutableInt;

public class ExpandableSQLAppender
implements SQLAppender {
    private final List<Object> sqlSnippets = new ArrayList<Object>();
    private final DMLNameProvider dmlNameProvider;
    private StringSQLAppender currentSQLSnippet;
    private final ColumnBinderRegistry parameterBinderRegistry;
    private final Map<String, ParameterBinder> parameterBinders;
    private final Map<String, Object> values;
    private final MutableInt paramCounter;

    public ExpandableSQLAppender(ColumnBinderRegistry parameterBinderRegistry, DMLNameProvider dmlNameProvider) {
        this.dmlNameProvider = dmlNameProvider;
        this.parameterBinderRegistry = parameterBinderRegistry;
        this.parameterBinders = new HashMap<String, ParameterBinder>();
        this.values = new HashMap<String, Object>();
        this.paramCounter = new MutableInt();
        this.initCurrentSqlSnippet();
    }

    private ExpandableSQLAppender(DMLNameProvider dmlNameProvider, ColumnBinderRegistry parameterBinderRegistry, Map<String, ParameterBinder> parameterBinders, Map<String, Object> values, MutableInt paramCounter) {
        this.dmlNameProvider = dmlNameProvider;
        this.parameterBinderRegistry = parameterBinderRegistry;
        this.parameterBinders = parameterBinders;
        this.values = values;
        this.paramCounter = paramCounter;
        this.initCurrentSqlSnippet();
    }

    public List<Object> getSqlSnippets() {
        return this.sqlSnippets;
    }

    public Map<String, Object> getValues() {
        return this.values;
    }

    @Override
    public SQLAppender cat(String s, String ... ss) {
        this.currentSQLSnippet.cat(s, ss);
        return this;
    }

    @Override
    public <V> SQLAppender catValue(@Nullable Selectable<V> column, Object value) {
        ParameterBinder<V> parameterBinder = column == null ? this.getParameterBinderFromRegistry(value) : (column instanceof Column ? this.parameterBinderRegistry.getBinder((Column)column) : this.parameterBinderRegistry.getBinder(column.getJavaType()));
        return this.catValue(value, parameterBinder);
    }

    @Override
    public SQLAppender catValue(Object variable) {
        if (variable instanceof ValuedVariable) {
            Object value = ((ValuedVariable)variable).getValue();
            if (value instanceof Selectable) {
                this.currentSQLSnippet.catColumn((Selectable)value);
            } else {
                this.addPlaceholder(value, this.getParameterBinderFromRegistry(value));
            }
        } else if (variable instanceof Placeholder) {
            this.addPlaceholder((Placeholder)variable);
        } else {
            this.addPlaceholder(variable, this.getParameterBinderFromRegistry(variable));
        }
        return this;
    }

    private ParameterBinder<?> getParameterBinderFromRegistry(Object value) {
        Object parameterBinder;
        if (value instanceof ValuedVariable) {
            parameterBinder = this.getParameterBinderFromRegistry(((ValuedVariable)value).getValue());
        } else if (value instanceof Placeholder) {
            parameterBinder = this.parameterBinderRegistry.getBinder(((Placeholder)value).getValueType());
        } else {
            Class<?> binderType = value.getClass().isArray() ? value.getClass().getComponentType() : value.getClass();
            parameterBinder = this.parameterBinderRegistry.getBinder(binderType);
        }
        return parameterBinder;
    }

    private SQLAppender catValue(Object value, ParameterBinder<?> binderSupplier) {
        if (value instanceof ValuedVariable) {
            Object innerValue = ((ValuedVariable)value).getValue();
            if (innerValue instanceof Selectable) {
                this.currentSQLSnippet.catColumn((Selectable)innerValue);
            } else {
                this.addPlaceholder(innerValue, binderSupplier);
            }
        } else if (value instanceof Placeholder) {
            this.addPlaceholder((Placeholder)value);
        } else {
            this.addPlaceholder(value, binderSupplier);
        }
        return this;
    }

    private void addPlaceholder(Placeholder<?, ?> variable) {
        this.sqlSnippets.add(variable);
        this.parameterBinders.put(variable.getName(), this.parameterBinderRegistry.getBinder(variable.getValueType()));
        this.initCurrentSqlSnippet();
    }

    private void addPlaceholder(Object value, ParameterBinder<?> binderSupplier) {
        String paramName = String.valueOf(this.paramCounter.increment());
        this.sqlSnippets.add(new Placeholder(paramName, binderSupplier.getColumnType()));
        this.parameterBinders.put(paramName, binderSupplier);
        this.values.put(paramName, value);
        this.initCurrentSqlSnippet();
    }

    protected void initCurrentSqlSnippet() {
        this.currentSQLSnippet = new StringSQLAppender(this.dmlNameProvider);
        this.sqlSnippets.add(this.currentSQLSnippet);
    }

    @Override
    public SQLAppender catColumn(Selectable<?> column) {
        this.currentSQLSnippet.catColumn((Selectable)column);
        return this;
    }

    @Override
    public SQLAppender catTable(Fromable table) {
        this.currentSQLSnippet.catTable(table);
        return this;
    }

    @Override
    public SQLAppender removeLastChars(int length) {
        this.currentSQLSnippet.removeLastChars(length);
        return this;
    }

    @Override
    public String getSQL() {
        StringBuilder result = new StringBuilder();
        this.visitSQLSnippets(placeholder -> result.append(":").append(placeholder.getName()), sqlAppender -> result.append(sqlAppender.getSQL()), subSQLAppender -> result.append(subSQLAppender.getSQL()));
        return result.toString();
    }

    private void visitSQLSnippets(Consumer<Placeholder<?, ?>> placeholderConsumer, Consumer<StringSQLAppender> sqlAppenderConsumer, Consumer<SQLAppender.DefaultSubSQLAppender> subSQLAppenderConsumer) {
        this.sqlSnippets.forEach(sqlSnippet -> {
            if (sqlSnippet instanceof Placeholder) {
                placeholderConsumer.accept((Placeholder)sqlSnippet);
            } else if (sqlSnippet instanceof StringSQLAppender) {
                sqlAppenderConsumer.accept((StringSQLAppender)sqlSnippet);
            } else if (sqlSnippet instanceof SQLAppender.DefaultSubSQLAppender) {
                subSQLAppenderConsumer.accept((SQLAppender.DefaultSubSQLAppender)sqlSnippet);
            } else {
                throw new IllegalStateException("Unsupported SQL snippet: " + (sqlSnippet == null ? "null" : Reflections.toString(sqlSnippet.getClass())));
            }
        });
    }

    @Override
    public SQLAppender.SubSQLAppender newSubPart(DMLNameProvider dmlNameProvider) {
        SQLAppender.DefaultSubSQLAppender result = new SQLAppender.DefaultSubSQLAppender(new ExpandableSQLAppender(dmlNameProvider, this.parameterBinderRegistry, this.parameterBinders, this.values, this.paramCounter)){

            @Override
            public SQLAppender close() {
                ExpandableSQLAppender.this.initCurrentSqlSnippet();
                return ExpandableSQLAppender.this;
            }
        };
        this.sqlSnippets.add(result);
        return result;
    }

    public PreparedSQL toPreparedSQL(Map<String, Object> values) {
        HashMap<String, Object> mergedValues = new HashMap<String, Object>(this.getValues());
        mergedValues.putAll(values);
        this.unwrapVariables(mergedValues);
        Map valuesSizes = ExpandableSQL.sizes(mergedValues);
        final SQLParameterParser.ParsedSQL parsedSQL = new SQLParameterParser.ParsedSQL();
        class ParsedSQLHelper {
            ParsedSQLHelper() {
            }

            void add(ExpandableSQLAppender appender) {
                appender.visitSQLSnippets(this::add, this::add, subSQLAppender -> this.add((ExpandableSQLAppender)subSQLAppender.getDelegate()));
            }

            void add(Placeholder variable) {
                parsedSQL.addParam(variable.getName());
            }

            void add(StringSQLAppender sqlSnippet) {
                parsedSQL.addSqlSnippet((CharSequence)sqlSnippet.getSQL());
            }
        }
        new ParsedSQLHelper().add(this);
        ExpandableSQL expandableSQL = new ExpandableSQL(parsedSQL, valuesSizes);
        String placeholderSql = expandableSQL.getPreparedSQL();
        HashMap placeholderBinders = new HashMap();
        HashMap placeholderValues = new HashMap();
        mergedValues.forEach((paramName, value) -> {
            int[] markIndexes;
            ExpandableSQL.ExpandableParameter expandableParameter = (ExpandableSQL.ExpandableParameter)expandableSQL.getExpandableParameters().get(paramName);
            if (expandableParameter == null) {
                throw new SQLStatement.BindingException("No parameter found in SQL for value named '" + paramName + "' : " + placeholderSql);
            }
            for (int markIndex : markIndexes = expandableParameter.getMarkIndexes()) {
                placeholderBinders.put(markIndex, this.parameterBinders.get(paramName));
            }
            ExpandableStatement.adaptIterablePlaceholders((Object)value, (int[])markIndexes, placeholderValues::put);
        });
        PreparedSQL result = new PreparedSQL(placeholderSql, placeholderBinders);
        result.setValues(placeholderValues);
        return result;
    }

    private void unwrapVariables(Map<String, Object> mergedValues) {
        mergedValues.entrySet().forEach(entry -> {
            if (entry.getValue() instanceof ValuedVariable) {
                entry.setValue(((ValuedVariable)entry.getValue()).getValue());
            }
        });
    }
}

