/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.sql.result;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import org.assertj.core.api.Assertions;
import org.codefilarete.stalactite.sql.result.NoopResultSet;
import org.codefilarete.tool.Reflections;
import org.codefilarete.tool.bean.MethodIterator;
import org.junit.jupiter.api.Test;

public class NoopResultSetTest {
    @Test
    public void allMethodsReturnDefaultValue() {
        NoopResultSet testInstance = new NoopResultSet();
        MethodIterator methodIterator = new MethodIterator(NoopResultSet.class, Object.class);
        Iterable methods = () -> methodIterator;
        int methodCount = 0;
        for (Method method : methods) {
            Object invocationResult;
            if (method.getReturnType() == Void.class) continue;
            try {
                Object[] args = new Object[method.getParameterCount()];
                Class<?>[] parameterTypes = method.getParameterTypes();
                for (int i = 0; i < parameterTypes.length; ++i) {
                    Class<?> arg = parameterTypes[i];
                    args[i] = arg.isArray() ? Array.newInstance(arg.getComponentType(), 0) : Reflections.PRIMITIVE_DEFAULT_VALUES.getOrDefault(arg, null);
                }
                invocationResult = method.invoke((Object)testInstance, args);
                ++methodCount;
            }
            catch (IllegalArgumentException | ReflectiveOperationException e) {
                throw new RuntimeException("Error executing " + Reflections.toString((Method)method), e);
            }
            if (method.getReturnType().isArray()) {
                Assertions.assertThat((boolean)invocationResult.getClass().isArray()).isTrue();
                Assertions.assertThat(invocationResult.getClass().getComponentType()).isEqualTo(method.getReturnType().getComponentType());
                continue;
            }
            Assertions.assertThat((Object)invocationResult).isEqualTo(Reflections.PRIMITIVE_DEFAULT_VALUES.get(method.getReturnType()));
        }
        Assertions.assertThat((int)methodCount).isEqualTo(191);
    }
}

