/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.spring.repository.query.bean;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.codefilarete.stalactite.engine.EntityPersister;
import org.codefilarete.stalactite.spring.repository.StalactiteRepository;
import org.codefilarete.stalactite.spring.repository.query.BeanQuery;
import org.codefilarete.stalactite.spring.repository.query.bean.BeanQueryMethod;
import org.codefilarete.stalactite.spring.repository.query.bean.BeanRepositoryQuery;
import org.codefilarete.stalactite.sql.result.Accumulator;
import org.codefilarete.stalactite.sql.result.Accumulators;
import org.codefilarete.tool.Reflections;
import org.codefilarete.tool.VisibleForTesting;
import org.codefilarete.tool.collection.Arrays;
import org.codefilarete.tool.collection.Iterables;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.repository.core.NamedQueries;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.query.QueryLookupStrategy;
import org.springframework.data.repository.query.RepositoryQuery;

public class BeanQueryLookupStrategy<C>
implements QueryLookupStrategy {
    private final ListableBeanFactory beanFactory;

    public BeanQueryLookupStrategy(ListableBeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    public RepositoryQuery resolveQuery(Method method, RepositoryMetadata metadata, ProjectionFactory factory, NamedQueries namedQueries) {
        EntityPersister.ExecutableEntityQuery<C, ?> executableEntityQuery = this.findSQL(method);
        if (executableEntityQuery != null) {
            BeanQueryMethod queryMethod = new BeanQueryMethod(method, metadata, factory);
            Accumulator accumulator = queryMethod.isCollectionQuery() ? Accumulators.toKeepingOrderSet() : Accumulators.getFirstUnique();
            return new BeanRepositoryQuery<C>(queryMethod, executableEntityQuery, accumulator);
        }
        return null;
    }

    @Nullable
    @VisibleForTesting
    EntityPersister.ExecutableEntityQuery<C, ?> findSQL(Method method) {
        class BeanQueryMetadata {
            private final String beanName;
            private final EntityPersister.ExecutableEntityQuery bean;
            private final BeanQuery queryAnnotation;

            BeanQueryMetadata(String beanName, EntityPersister.ExecutableEntityQuery bean, BeanQuery queryAnnotation) {
                this.beanName = beanName;
                this.bean = bean;
                this.queryAnnotation = queryAnnotation;
            }

            boolean isDefault() {
                return this.isFor(StalactiteRepository.class);
            }

            boolean isFor(Class<? extends StalactiteRepository> repositoryClass) {
                return this.queryAnnotation.repositoryClass().equals(repositoryClass);
            }
        }
        Map beansWithAnnotation = this.beanFactory.getBeansWithAnnotation(BeanQuery.class);
        Set queryMetadataSet = beansWithAnnotation.entrySet().stream().map(entry -> new BeanQueryMetadata((String)entry.getKey(), (EntityPersister.ExecutableEntityQuery)entry.getValue(), (BeanQuery)this.beanFactory.findAnnotationOnBean((String)entry.getKey(), BeanQuery.class))).filter(metadata -> ((BeanQueryMetadata)metadata).beanName.equals(method.getName()) || Arrays.asList((Object[])((BeanQueryMetadata)metadata).queryAnnotation.name()).contains(method.getName()) || ((BeanQueryMetadata)metadata).queryAnnotation.method().equals(method.getName())).collect(Collectors.toSet());
        switch (queryMetadataSet.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return ((BeanQueryMetadata)Iterables.first(queryMetadataSet)).bean;
            }
        }
        Set defaultBeans = queryMetadataSet.stream().filter(BeanQueryMetadata::isDefault).collect(Collectors.toSet());
        Set dedicatedBeans = queryMetadataSet.stream().filter(metadata -> metadata.isFor(method.getDeclaringClass())).collect(Collectors.toSet());
        if (dedicatedBeans.size() == 1) {
            return ((BeanQueryMetadata)Iterables.first(dedicatedBeans)).bean;
        }
        if (defaultBeans.size() == 1) {
            return ((BeanQueryMetadata)Iterables.first(defaultBeans)).bean;
        }
        throw new UnsupportedOperationException("Multiple beans found matching method " + Reflections.toString((Method)method) + ": " + Iterables.collect(queryMetadataSet, metadata -> ((BeanQueryMetadata)metadata).beanName, HashSet::new) + ", but none for repository type " + Reflections.toString(method.getDeclaringClass()) + ": " + Iterables.collect(queryMetadataSet, metadata -> Reflections.toString(((BeanQueryMetadata)metadata).queryAnnotation.repositoryClass()), ArrayList::new));
    }
}

