/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.runtime.load;

import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.codefilarete.stalactite.engine.runtime.load.AbstractJoinNode;
import org.codefilarete.stalactite.engine.runtime.load.EntityJoinTree;
import org.codefilarete.stalactite.engine.runtime.load.EntityTreeInflater;
import org.codefilarete.stalactite.engine.runtime.load.JoinNode;
import org.codefilarete.stalactite.engine.runtime.load.JoinRoot;
import org.codefilarete.stalactite.engine.runtime.load.JoinRowConsumer;
import org.codefilarete.stalactite.query.model.From;
import org.codefilarete.stalactite.query.model.Fromable;
import org.codefilarete.stalactite.query.model.Query;
import org.codefilarete.stalactite.query.model.Selectable;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.Key;
import org.codefilarete.stalactite.sql.statement.binder.ParameterBinder;
import org.codefilarete.stalactite.sql.statement.binder.ResultSetReader;
import org.codefilarete.stalactite.sql.statement.binder.ResultSetReaderRegistry;
import org.codefilarete.tool.Duo;
import org.codefilarete.tool.StringAppender;
import org.codefilarete.tool.Strings;
import org.codefilarete.tool.VisibleForTesting;
import org.codefilarete.tool.collection.IdentityMap;
import org.codefilarete.tool.collection.Iterables;

public class EntityTreeQueryBuilder<C> {
    private final EntityJoinTree<C, Object> tree;
    private final ResultSetReaderRegistry parameterBinderProvider;
    private final AliasBuilder aliasBuilder = new AliasBuilder();

    public EntityTreeQueryBuilder(EntityJoinTree<C, ?> tree, ResultSetReaderRegistry parameterBinderProvider) {
        this.tree = tree;
        this.parameterBinderProvider = parameterBinderProvider;
    }

    public EntityTreeQuery<C> buildSelectQuery() {
        Query query = new Query();
        HashMap selectParameterBinders = new HashMap();
        ResultHelper resultHelper = new ResultHelper(query, this.parameterBinderProvider, this.aliasBuilder, selectParameterBinders);
        JoinRoot<C, Object, ?> joinRoot = this.tree.getRoot();
        query.getFromDelegate().setRoot(joinRoot.getTable());
        resultHelper.addColumnsToSelectClause(joinRoot, this.aliasBuilder.buildTableAlias(joinRoot));
        resultHelper.applyJoinTree(this.tree);
        EntityTreeInflater entityTreeInflater = new EntityTreeInflater(resultHelper.buildConsumerTree(this.tree));
        return new EntityTreeQuery(query, selectParameterBinders, entityTreeInflater);
    }

    @VisibleForTesting
    Duo<Fromable, IdentityHashMap<? extends Selectable<?>, ? extends Selectable<?>>> cloneTable(JoinNode joinNode) {
        return new Duo(joinNode.getTable(), joinNode.getOriginalColumnsToLocalOnes());
    }

    private static class AliasBuilder {
        private AliasBuilder() {
        }

        public String buildTableAlias(JoinRoot joinRoot) {
            return this.giveTableAlias(joinRoot);
        }

        private String giveTableAlias(JoinNode node) {
            return (String)Strings.preventEmpty((CharSequence)node.getTableAlias(), (CharSequence)node.getTable().getName());
        }

        public String buildTableAlias(AbstractJoinNode joinNode) {
            StringAppender aliasBuilder = new StringAppender(){

                public StringAppender cat(Object o) {
                    if (o instanceof AbstractJoinNode) {
                        AbstractJoinNode localNode = (AbstractJoinNode)o;
                        return super.cat((Object)this.giveTableAlias(localNode));
                    }
                    return super.cat(o);
                }
            };
            List nodeParents = Iterables.copy((Iterator)new AbstractJoinNode.JoinNodeHierarchyIterator(joinNode));
            Collections.reverse(nodeParents);
            aliasBuilder.ccat((Iterable)nodeParents, (Object)"_");
            return aliasBuilder.toString();
        }

        public String buildColumnAlias(String tableAlias, Selectable selectableColumn) {
            return tableAlias + "_" + selectableColumn.getExpression();
        }
    }

    public static class EntityTreeQuery<C> {
        private final Query query;
        private final Map<Selectable<?>, ParameterBinder<?>> selectParameterBinders;
        private final EntityTreeInflater<C> entityTreeInflater;

        private EntityTreeQuery(Query query, Map<Selectable<?>, ParameterBinder<?>> selectParameterBinders, EntityTreeInflater<C> entityTreeInflater) {
            this.selectParameterBinders = selectParameterBinders;
            this.query = query;
            this.entityTreeInflater = entityTreeInflater;
        }

        public Query getQuery() {
            return this.query;
        }

        public Map<Selectable<?>, ParameterBinder<?>> getSelectParameterBinders() {
            return this.selectParameterBinders;
        }

        public Map<Selectable<?>, String> getColumnAliases() {
            return this.query.getAliases();
        }

        public EntityTreeInflater<C> getInflater() {
            return this.entityTreeInflater;
        }
    }

    private static class ResultHelper {
        private final ResultSetReaderRegistry parameterBinderProvider;
        private final AliasBuilder aliasBuilder;
        private final Query query;
        private final Map<Selectable<?>, ResultSetReader<?>> selectParameterBinders;
        private final IdentityMap<Selectable<?>, String> columnAliases = new IdentityMap();

        private ResultHelper(Query query, ResultSetReaderRegistry parameterBinderProvider, AliasBuilder aliasBuilder, Map<? extends Selectable<?>, ? extends ResultSetReader<?>> selectParameterBinders) {
            this.parameterBinderProvider = parameterBinderProvider;
            this.aliasBuilder = aliasBuilder;
            this.query = query;
            this.selectParameterBinders = selectParameterBinders;
        }

        private <JOINTYPE> void applyJoinTree(EntityJoinTree<?, ?> tree) {
            From targetFrom = this.query.getFromDelegate();
            tree.foreachJoin(join -> {
                String tableAlias = this.aliasBuilder.buildTableAlias((AbstractJoinNode)join);
                this.addColumnsToSelectClause((JoinNode)join, tableAlias);
                Key leftJoinColumn = join.getLeftJoinLink();
                Key rightJoinColumn = join.getRightJoinLink();
                Object tableClone = join.getRightTable();
                targetFrom.setAlias(tableClone, tableAlias);
                switch (join.getJoinType()) {
                    case INNER: {
                        targetFrom.innerJoin(leftJoinColumn, rightJoinColumn);
                        break;
                    }
                    case OUTER: {
                        targetFrom.leftOuterJoin(leftJoinColumn, rightJoinColumn);
                    }
                }
            });
        }

        private <T1 extends Fromable> void addColumnsToSelectClause(JoinNode<?, T1> joinNode, String tableAlias) {
            Set<Selectable<?>> selectableColumns = joinNode.getColumnsToSelect();
            for (Selectable<?> selectableColumn : selectableColumns) {
                Selectable<?> columnClone = joinNode.getOriginalColumnsToLocalOnes().get(selectableColumn);
                String alias = this.aliasBuilder.buildColumnAlias(tableAlias, selectableColumn);
                this.query.select(columnClone, alias);
                ResultSetReader reader = selectableColumn instanceof Column ? this.parameterBinderProvider.getReader((Object)((Column)selectableColumn)) : this.parameterBinderProvider.getReader(selectableColumn.getJavaType());
                this.selectParameterBinders.put(columnClone, reader);
                this.columnAliases.put(columnClone, (Object)alias);
            }
        }

        private EntityTreeInflater.ConsumerNode buildConsumerTree(EntityJoinTree<?, ?> tree) {
            JoinRoot<?, ?, ?> root = tree.getRoot();
            EntityTreeInflater.ConsumerNode consumerRoot = new EntityTreeInflater.ConsumerNode(tree.getRoot().toConsumer(root));
            tree.foreachJoinWithDepth(consumerRoot, (targetOwner, currentNode) -> {
                JoinRowConsumer consumer = currentNode.toConsumer(currentNode);
                EntityTreeInflater.ConsumerNode consumerNode = new EntityTreeInflater.ConsumerNode(consumer);
                targetOwner.addConsumer(consumerNode);
                return consumerNode;
            });
            return consumerRoot;
        }
    }
}

