/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine;

import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import javax.sql.DataSource;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.codefilarete.stalactite.dsl.MappingConfigurationException;
import org.codefilarete.stalactite.dsl.MappingEase;
import org.codefilarete.stalactite.dsl.embeddable.EmbeddableMappingConfigurationProvider;
import org.codefilarete.stalactite.dsl.embeddable.FluentEmbeddableMappingBuilder;
import org.codefilarete.stalactite.engine.EntityPersister;
import org.codefilarete.stalactite.engine.FluentEntityMappingConfigurationSupportTest;
import org.codefilarete.stalactite.engine.PersistenceContext;
import org.codefilarete.stalactite.engine.model.Timestamp;
import org.codefilarete.stalactite.id.Identifier;
import org.codefilarete.stalactite.id.StatefulIdentifierAlreadyAssignedIdentifierPolicy;
import org.codefilarete.stalactite.sql.Dialect;
import org.codefilarete.stalactite.sql.HSQLDBDialectBuilder;
import org.codefilarete.stalactite.sql.ddl.DDLDeployer;
import org.codefilarete.stalactite.sql.ddl.Size;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.stalactite.sql.statement.binder.DefaultParameterBinders;
import org.codefilarete.stalactite.sql.statement.binder.LambdaParameterBinder;
import org.codefilarete.stalactite.sql.statement.binder.NullAwareParameterBinder;
import org.codefilarete.stalactite.sql.statement.binder.ParameterBinder;
import org.codefilarete.stalactite.sql.statement.binder.PreparedStatementWriter;
import org.codefilarete.stalactite.sql.statement.binder.ResultSetReader;
import org.codefilarete.stalactite.sql.test.HSQLDBInMemoryDataSource;
import org.codefilarete.tool.Dates;
import org.codefilarete.tool.collection.Iterables;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;

public class FluentEntityMappingConfigurationSupportEmbedTest {
    private static final Class<Identifier<UUID>> UUID_TYPE = Identifier.class;
    private final Dialect dialect = HSQLDBDialectBuilder.defaultHSQLDBDialect();
    private final DataSource dataSource = new HSQLDBInMemoryDataSource();
    private PersistenceContext persistenceContext;

    @BeforeEach
    void initTest() {
        this.dialect.getDmlGenerator().sortColumnsAlphabetically();
        this.dialect.getColumnBinderRegistry().register(Identifier.class, Identifier.identifierBinder(DefaultParameterBinders.LONG_PRIMITIVE_BINDER));
        this.dialect.getSqlTypeRegistry().put(Identifier.class, "int");
        this.persistenceContext = new PersistenceContext(this.dataSource, this.dialect);
    }

    @Test
    void happyPath() {
        Table totoTable = new Table("Toto");
        Column idColumn = totoTable.addColumn("id", UUID_TYPE);
        Column creationDate = totoTable.addColumn("creationDate", Date.class);
        Column modificationDate = totoTable.addColumn("modificationDate", Date.class);
        this.dialect.getColumnBinderRegistry().register(idColumn, Identifier.identifierBinder(DefaultParameterBinders.UUID_BINDER));
        this.dialect.getSqlTypeRegistry().put(idColumn, "VARCHAR(255)");
        FluentEmbeddableMappingBuilder.FluentEmbeddableMappingBuilderPropertyOptions timestampMapping = MappingEase.embeddableBuilder(Timestamp.class).map(Timestamp::getCreationDate).map(Timestamp::getModificationDate);
        EntityPersister persister = MappingEase.entityBuilder(FluentEntityMappingConfigurationSupportTest.Toto.class, UUID_TYPE).onTable(totoTable).mapKey(FluentEntityMappingConfigurationSupportTest.Toto::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.UUID_ALREADY_ASSIGNED).map(FluentEntityMappingConfigurationSupportTest.Toto::getName).embed(FluentEntityMappingConfigurationSupportTest.Toto::getTimestamp, (EmbeddableMappingConfigurationProvider)timestampMapping).build(this.persistenceContext);
        DDLDeployer ddlDeployer = new DDLDeployer(this.persistenceContext);
        ddlDeployer.deployDDL();
        FluentEntityMappingConfigurationSupportTest.Toto toto = new FluentEntityMappingConfigurationSupportTest.Toto();
        toto.setTimestamp(new Timestamp(Dates.nowAsDate(), null));
        persister.insert((Object)toto);
        List select = this.persistenceContext.select(Timestamp::new, creationDate, modificationDate);
        Assertions.assertThat((Object)Iterables.first((List)select)).isEqualTo((Object)toto.getTimestamp());
        FluentEntityMappingConfigurationSupportTest.Toto loadedToto = (FluentEntityMappingConfigurationSupportTest.Toto)persister.select(toto.getId());
        Assertions.assertThat((Object)loadedToto.getTimestamp()).isEqualTo((Object)toto.getTimestamp());
    }

    @Test
    void mappingDefinedTwice_throwsException() {
        Table totoTable = new Table("Toto");
        Column idColumn = totoTable.addColumn("id", UUID_TYPE);
        this.dialect.getColumnBinderRegistry().register(idColumn, Identifier.identifierBinder(DefaultParameterBinders.UUID_BINDER));
        this.dialect.getSqlTypeRegistry().put(idColumn, "VARCHAR(255)");
        FluentEmbeddableMappingBuilder.FluentEmbeddableMappingBuilderPropertyOptions timestampMapping = MappingEase.embeddableBuilder(Timestamp.class).map(Timestamp::getCreationDate).map(Timestamp::getModificationDate).map(Timestamp::setModificationDate);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.lambda$mappingDefinedTwice_throwsException$0((EmbeddableMappingConfigurationProvider)timestampMapping)).isInstanceOf(MappingConfigurationException.class)).hasMessage("Mapping is already defined by method Timestamp::getModificationDate");
    }

    @Test
    void exclude() {
        Table totoTable = new Table("Toto");
        Column idColumn = totoTable.addColumn("id", UUID_TYPE);
        this.dialect.getColumnBinderRegistry().register(idColumn, Identifier.identifierBinder(DefaultParameterBinders.UUID_BINDER));
        this.dialect.getSqlTypeRegistry().put(idColumn, "VARCHAR(255)");
        FluentEmbeddableMappingBuilder.FluentEmbeddableMappingBuilderPropertyOptions timestampMapping = MappingEase.embeddableBuilder(Timestamp.class).map(Timestamp::getCreationDate).columnName("creation").map(Timestamp::getModificationDate);
        EntityPersister persister = MappingEase.entityBuilder(FluentEntityMappingConfigurationSupportTest.Toto.class, UUID_TYPE).onTable(totoTable).mapKey(FluentEntityMappingConfigurationSupportTest.Toto::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.UUID_ALREADY_ASSIGNED).map(FluentEntityMappingConfigurationSupportTest.Toto::getName).embed(FluentEntityMappingConfigurationSupportTest.Toto::getTimestamp, (EmbeddableMappingConfigurationProvider)timestampMapping).exclude(Timestamp::getCreationDate).build(this.persistenceContext);
        Map map = totoTable.mapColumnsOnName();
        Assertions.assertThat(map.get("creationDate")).isNull();
        DDLDeployer ddlDeployer = new DDLDeployer(this.persistenceContext);
        ddlDeployer.deployDDL();
        FluentEntityMappingConfigurationSupportTest.Toto toto = new FluentEntityMappingConfigurationSupportTest.Toto();
        toto.setTimestamp(new Timestamp(Dates.nowAsDate(), null));
        persister.insert((Object)toto);
        FluentEntityMappingConfigurationSupportTest.Toto loadedToto = (FluentEntityMappingConfigurationSupportTest.Toto)persister.select(toto.getId());
        Assertions.assertThat((Object)loadedToto.getTimestamp()).isNull();
    }

    @Test
    void overrideColumn() {
        Table totoTable = new Table("Toto");
        Column idColumn = totoTable.addColumn("id", UUID_TYPE);
        Column creationDate = totoTable.addColumn("createdAt", Date.class);
        Column modificationDate = totoTable.addColumn("modificationDate", Date.class);
        this.dialect.getColumnBinderRegistry().register(idColumn, Identifier.identifierBinder(DefaultParameterBinders.UUID_BINDER));
        this.dialect.getSqlTypeRegistry().put(idColumn, "VARCHAR(255)");
        FluentEmbeddableMappingBuilder.FluentEmbeddableMappingBuilderPropertyOptions timestampMapping = MappingEase.embeddableBuilder(Timestamp.class).map(Timestamp::getCreationDate).columnName("creation").map(Timestamp::getModificationDate);
        EntityPersister persister = MappingEase.entityBuilder(FluentEntityMappingConfigurationSupportTest.Toto.class, UUID_TYPE).onTable(totoTable).mapKey(FluentEntityMappingConfigurationSupportTest.Toto::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.UUID_ALREADY_ASSIGNED).map(FluentEntityMappingConfigurationSupportTest.Toto::getName).embed(FluentEntityMappingConfigurationSupportTest.Toto::getTimestamp, (EmbeddableMappingConfigurationProvider)timestampMapping).override(Timestamp::getCreationDate, creationDate).build(this.persistenceContext);
        Map map = totoTable.mapColumnsOnName();
        Assertions.assertThat(map.get("creationDate")).isNull();
        DDLDeployer ddlDeployer = new DDLDeployer(this.persistenceContext);
        ddlDeployer.deployDDL();
        FluentEntityMappingConfigurationSupportTest.Toto toto = new FluentEntityMappingConfigurationSupportTest.Toto();
        toto.setTimestamp(new Timestamp(Dates.nowAsDate(), null));
        persister.insert((Object)toto);
        List select = this.persistenceContext.select(Timestamp::new, creationDate, modificationDate);
        Assertions.assertThat((Object)Iterables.first((List)select)).isEqualTo((Object)toto.getTimestamp());
        FluentEntityMappingConfigurationSupportTest.Toto loadedToto = (FluentEntityMappingConfigurationSupportTest.Toto)persister.select(toto.getId());
        Assertions.assertThat((Object)loadedToto.getTimestamp()).isEqualTo((Object)toto.getTimestamp());
    }

    private /* synthetic */ void lambda$mappingDefinedTwice_throwsException$0(EmbeddableMappingConfigurationProvider timestampMapping) throws Throwable {
        MappingEase.entityBuilder(FluentEntityMappingConfigurationSupportTest.Toto.class, UUID_TYPE).mapKey(FluentEntityMappingConfigurationSupportTest.Toto::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.UUID_ALREADY_ASSIGNED).map(FluentEntityMappingConfigurationSupportTest.Toto::getName).embed(FluentEntityMappingConfigurationSupportTest.Toto::getTimestamp, timestampMapping).build(this.persistenceContext);
    }

    @Nested
    class OverrideName {
        OverrideName() {
        }

        @Test
        void happyPath() {
            Table totoTable = new Table("Toto");
            Column idColumn = totoTable.addColumn("id", UUID_TYPE);
            Column creationDate = totoTable.addColumn("createdAt", Date.class);
            Column modificationDate = totoTable.addColumn("modificationDate", Date.class);
            FluentEntityMappingConfigurationSupportEmbedTest.this.dialect.getColumnBinderRegistry().register(idColumn, Identifier.identifierBinder(DefaultParameterBinders.UUID_BINDER));
            FluentEntityMappingConfigurationSupportEmbedTest.this.dialect.getSqlTypeRegistry().put(idColumn, "VARCHAR(255)");
            FluentEmbeddableMappingBuilder.FluentEmbeddableMappingBuilderPropertyOptions timestampMapping = MappingEase.embeddableBuilder(Timestamp.class).map(Timestamp::getCreationDate).map(Timestamp::getModificationDate);
            EntityPersister persister = MappingEase.entityBuilder(FluentEntityMappingConfigurationSupportTest.Toto.class, (Class)UUID_TYPE).onTable(totoTable).mapKey(FluentEntityMappingConfigurationSupportTest.Toto::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.UUID_ALREADY_ASSIGNED).map(FluentEntityMappingConfigurationSupportTest.Toto::getName).embed(FluentEntityMappingConfigurationSupportTest.Toto::getTimestamp, (EmbeddableMappingConfigurationProvider)timestampMapping).overrideName(Timestamp::getCreationDate, "createdAt").build(FluentEntityMappingConfigurationSupportEmbedTest.this.persistenceContext);
            Map columnsByName = totoTable.mapColumnsOnName();
            Assertions.assertThat(columnsByName.get("creationDate")).isNull();
            DDLDeployer ddlDeployer = new DDLDeployer(FluentEntityMappingConfigurationSupportEmbedTest.this.persistenceContext);
            ddlDeployer.deployDDL();
            FluentEntityMappingConfigurationSupportTest.Toto toto = new FluentEntityMappingConfigurationSupportTest.Toto();
            toto.setTimestamp(new Timestamp(Dates.nowAsDate(), null));
            persister.insert((Object)toto);
            List select = FluentEntityMappingConfigurationSupportEmbedTest.this.persistenceContext.select(Timestamp::new, creationDate, modificationDate);
            Assertions.assertThat((Object)Iterables.first((List)select)).isEqualTo((Object)toto.getTimestamp());
            FluentEntityMappingConfigurationSupportTest.Toto loadedToto = (FluentEntityMappingConfigurationSupportTest.Toto)persister.select(toto.getId());
            Assertions.assertThat((Object)loadedToto.getTimestamp()).isEqualTo((Object)toto.getTimestamp());
        }

        @Test
        void nameAlreadyExists_throwsException() {
            Table totoTable = new Table("Toto");
            Column idColumn = totoTable.addColumn("id", UUID_TYPE);
            FluentEntityMappingConfigurationSupportEmbedTest.this.dialect.getColumnBinderRegistry().register(idColumn, Identifier.identifierBinder(DefaultParameterBinders.UUID_BINDER));
            FluentEntityMappingConfigurationSupportEmbedTest.this.dialect.getSqlTypeRegistry().put(idColumn, "VARCHAR(255)");
            FluentEmbeddableMappingBuilder.FluentEmbeddableMappingBuilderPropertyOptions timestampMapping = MappingEase.embeddableBuilder(Timestamp.class).map(Timestamp::getCreationDate).map(Timestamp::getModificationDate);
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.lambda$nameAlreadyExists_throwsException$0((EmbeddableMappingConfigurationProvider)timestampMapping)).isInstanceOf(MappingConfigurationException.class)).hasMessage("Column 'modificationDate' of mapping 'Timestamp::getCreationDate' is already targeted by 'Timestamp::getModificationDate'");
        }

        @Test
        void nameIsAlreadyOverridden_nameIsOverwritten() {
            Table totoTable = new Table("Toto");
            Column idColumn = totoTable.addColumn("id", UUID_TYPE);
            Column creationDate = totoTable.addColumn("createdAt", Date.class);
            Column modificationDate = totoTable.addColumn("modificationDate", Date.class);
            FluentEntityMappingConfigurationSupportEmbedTest.this.dialect.getColumnBinderRegistry().register(idColumn, Identifier.identifierBinder(DefaultParameterBinders.UUID_BINDER));
            FluentEntityMappingConfigurationSupportEmbedTest.this.dialect.getSqlTypeRegistry().put(idColumn, "VARCHAR(255)");
            FluentEmbeddableMappingBuilder.FluentEmbeddableMappingBuilderPropertyOptions timestampMapping = MappingEase.embeddableBuilder(Timestamp.class).map(Timestamp::getCreationDate).columnName("creation").map(Timestamp::getModificationDate);
            EntityPersister persister = MappingEase.entityBuilder(FluentEntityMappingConfigurationSupportTest.Toto.class, (Class)UUID_TYPE).onTable(totoTable).mapKey(FluentEntityMappingConfigurationSupportTest.Toto::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.UUID_ALREADY_ASSIGNED).map(FluentEntityMappingConfigurationSupportTest.Toto::getName).embed(FluentEntityMappingConfigurationSupportTest.Toto::getTimestamp, (EmbeddableMappingConfigurationProvider)timestampMapping).overrideName(Timestamp::getCreationDate, "createdAt").build(FluentEntityMappingConfigurationSupportEmbedTest.this.persistenceContext);
            DDLDeployer ddlDeployer = new DDLDeployer(FluentEntityMappingConfigurationSupportEmbedTest.this.persistenceContext);
            ddlDeployer.deployDDL();
            FluentEntityMappingConfigurationSupportTest.Toto toto = new FluentEntityMappingConfigurationSupportTest.Toto();
            toto.setTimestamp(new Timestamp(Dates.nowAsDate(), null));
            persister.insert((Object)toto);
            List select = FluentEntityMappingConfigurationSupportEmbedTest.this.persistenceContext.select(Timestamp::new, creationDate, modificationDate);
            Assertions.assertThat((Object)Iterables.first((List)select)).isEqualTo((Object)toto.getTimestamp());
            FluentEntityMappingConfigurationSupportTest.Toto loadedToto = (FluentEntityMappingConfigurationSupportTest.Toto)persister.select(toto.getId());
            Assertions.assertThat((Object)loadedToto.getTimestamp()).isEqualTo((Object)toto.getTimestamp());
        }

        private /* synthetic */ void lambda$nameAlreadyExists_throwsException$0(EmbeddableMappingConfigurationProvider timestampMapping) throws Throwable {
            MappingEase.entityBuilder(FluentEntityMappingConfigurationSupportTest.Toto.class, (Class)UUID_TYPE).mapKey(FluentEntityMappingConfigurationSupportTest.Toto::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.UUID_ALREADY_ASSIGNED).map(FluentEntityMappingConfigurationSupportTest.Toto::getName).embed(FluentEntityMappingConfigurationSupportTest.Toto::getTimestamp, timestampMapping).overrideName(Timestamp::getCreationDate, "modificationDate").build(FluentEntityMappingConfigurationSupportEmbedTest.this.persistenceContext);
        }
    }

    @Nested
    class WithMappedSuperClass {
        WithMappedSuperClass() {
        }

        @Test
        void happyPath() {
            Table totoTable = new Table("Toto");
            Column idColumn = totoTable.addColumn("id", UUID_TYPE);
            Column creationDate = totoTable.addColumn("creationDate", Date.class);
            Column modificationDate = totoTable.addColumn("modificationDate", Date.class);
            Column localeColumn = totoTable.addColumn("locale", Locale.class);
            FluentEntityMappingConfigurationSupportEmbedTest.this.dialect.getColumnBinderRegistry().register(idColumn, Identifier.identifierBinder(DefaultParameterBinders.UUID_BINDER));
            FluentEntityMappingConfigurationSupportEmbedTest.this.dialect.getSqlTypeRegistry().put(idColumn, "VARCHAR(255)");
            FluentEntityMappingConfigurationSupportEmbedTest.this.dialect.getColumnBinderRegistry().register(Locale.class, (ParameterBinder)new NullAwareParameterBinder((ParameterBinder)new LambdaParameterBinder((ResultSetReader)new ResultSetReader.LambdaResultSetReader((resultSet, columnName) -> Locale.forLanguageTag(resultSet.getString((String)columnName)), Locale.class), (PreparedStatementWriter)new PreparedStatementWriter.LambdaPreparedStatementWriter((preparedStatement, valueIndex, value) -> preparedStatement.setString((int)valueIndex, value.toLanguageTag()), Locale.class))));
            FluentEntityMappingConfigurationSupportEmbedTest.this.dialect.getSqlTypeRegistry().put(Locale.class, "VARCHAR(20)");
            FluentEmbeddableMappingBuilder.FluentEmbeddableMappingBuilderPropertyOptions timestampMapping = MappingEase.embeddableBuilder(Timestamp.class).map(Timestamp::getCreationDate).map(Timestamp::getModificationDate);
            FluentEmbeddableMappingBuilder timestampWithLocaleMapping = MappingEase.embeddableBuilder(FluentEntityMappingConfigurationSupportTest.TimestampWithLocale.class).map(FluentEntityMappingConfigurationSupportTest.TimestampWithLocale::getLocale).mapSuperClass((EmbeddableMappingConfigurationProvider)timestampMapping);
            EntityPersister persister = MappingEase.entityBuilder(FluentEntityMappingConfigurationSupportTest.Toto.class, (Class)UUID_TYPE).onTable(totoTable).mapKey(FluentEntityMappingConfigurationSupportTest.Toto::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.UUID_ALREADY_ASSIGNED).map(FluentEntityMappingConfigurationSupportTest.Toto::getName).embed(FluentEntityMappingConfigurationSupportTest.Toto::getTimestamp, (EmbeddableMappingConfigurationProvider)timestampWithLocaleMapping).build(FluentEntityMappingConfigurationSupportEmbedTest.this.persistenceContext);
            DDLDeployer ddlDeployer = new DDLDeployer(FluentEntityMappingConfigurationSupportEmbedTest.this.persistenceContext);
            ddlDeployer.deployDDL();
            FluentEntityMappingConfigurationSupportTest.Toto toto = new FluentEntityMappingConfigurationSupportTest.Toto();
            toto.setTimestamp(new FluentEntityMappingConfigurationSupportTest.TimestampWithLocale(Dates.nowAsDate(), null, Locale.US));
            persister.insert((Object)toto);
            List select = FluentEntityMappingConfigurationSupportEmbedTest.this.persistenceContext.select(FluentEntityMappingConfigurationSupportTest.TimestampWithLocale::new, creationDate, modificationDate, localeColumn);
            Assertions.assertThat((Object)Iterables.first((List)select)).isEqualTo((Object)toto.getTimestamp());
            FluentEntityMappingConfigurationSupportTest.Toto loadedToto = (FluentEntityMappingConfigurationSupportTest.Toto)persister.select(toto.getId());
            Assertions.assertThat((Object)loadedToto.getTimestamp()).isEqualTo((Object)toto.getTimestamp());
        }

        @Test
        void withMappedSuperClassAndOverride_schemaGeneration() {
            Table totoTable = new Table("Toto");
            Column idColumn = totoTable.addColumn("id", UUID_TYPE);
            Column modificationDate = totoTable.addColumn("modificationTime", Date.class);
            FluentEntityMappingConfigurationSupportEmbedTest.this.dialect.getColumnBinderRegistry().register(idColumn, Identifier.identifierBinder(DefaultParameterBinders.UUID_BINDER));
            FluentEntityMappingConfigurationSupportEmbedTest.this.dialect.getSqlTypeRegistry().put(idColumn, "VARCHAR(255)");
            FluentEntityMappingConfigurationSupportEmbedTest.this.dialect.getColumnBinderRegistry().register(Locale.class, (ParameterBinder)new NullAwareParameterBinder((ParameterBinder)new LambdaParameterBinder((ResultSetReader)new ResultSetReader.LambdaResultSetReader((resultSet, columnName) -> Locale.forLanguageTag(resultSet.getString((String)columnName)), Locale.class), (PreparedStatementWriter)new PreparedStatementWriter.LambdaPreparedStatementWriter((preparedStatement, valueIndex, value) -> preparedStatement.setString((int)valueIndex, value.toLanguageTag()), Locale.class))));
            FluentEntityMappingConfigurationSupportEmbedTest.this.dialect.getSqlTypeRegistry().put(Locale.class, "VARCHAR(20)");
            FluentEmbeddableMappingBuilder.FluentEmbeddableMappingBuilderPropertyOptions timestampMapping = MappingEase.embeddableBuilder(Timestamp.class).map(Timestamp::getCreationDate).map(Timestamp::getModificationDate);
            FluentEmbeddableMappingBuilder timestampWithLocaleMapping = MappingEase.embeddableBuilder(FluentEntityMappingConfigurationSupportTest.TimestampWithLocale.class).map(FluentEntityMappingConfigurationSupportTest.TimestampWithLocale::getLocale).mapSuperClass((EmbeddableMappingConfigurationProvider)timestampMapping);
            EntityPersister persister = MappingEase.entityBuilder(FluentEntityMappingConfigurationSupportTest.Toto.class, (Class)UUID_TYPE).onTable(totoTable).mapKey(FluentEntityMappingConfigurationSupportTest.Toto::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.UUID_ALREADY_ASSIGNED).map(FluentEntityMappingConfigurationSupportTest.Toto::getName).embed(FluentEntityMappingConfigurationSupportTest.Toto::getTimestamp, (EmbeddableMappingConfigurationProvider)timestampWithLocaleMapping).override(Timestamp::getModificationDate, modificationDate).build(FluentEntityMappingConfigurationSupportEmbedTest.this.persistenceContext);
            DDLDeployer ddlDeployer = new DDLDeployer(FluentEntityMappingConfigurationSupportEmbedTest.this.persistenceContext);
            ddlDeployer.deployDDL();
            Assertions.assertThat(totoTable.getColumns().stream().map(Column::getName)).containsExactlyInAnyOrder((Object[])new String[]{"id", "name", "creationDate", "modificationTime", "locale"});
        }

        @Test
        void withMappedSuperClassAndOverrideName_schemaGeneration() {
            Table totoTable = new Table("Toto");
            Column idColumn = totoTable.addColumn("id", UUID_TYPE);
            FluentEntityMappingConfigurationSupportEmbedTest.this.dialect.getColumnBinderRegistry().register(idColumn, Identifier.identifierBinder(DefaultParameterBinders.UUID_BINDER));
            FluentEntityMappingConfigurationSupportEmbedTest.this.dialect.getSqlTypeRegistry().put(idColumn, "VARCHAR(255)");
            FluentEntityMappingConfigurationSupportEmbedTest.this.dialect.getColumnBinderRegistry().register(Locale.class, (ParameterBinder)new NullAwareParameterBinder((ParameterBinder)new LambdaParameterBinder((ResultSetReader)new ResultSetReader.LambdaResultSetReader((resultSet, columnName) -> Locale.forLanguageTag(resultSet.getString((String)columnName)), Locale.class), (PreparedStatementWriter)new PreparedStatementWriter.LambdaPreparedStatementWriter((preparedStatement, valueIndex, value) -> preparedStatement.setString((int)valueIndex, value.toLanguageTag()), Locale.class))));
            FluentEntityMappingConfigurationSupportEmbedTest.this.dialect.getSqlTypeRegistry().put(Locale.class, "VARCHAR(20)");
            FluentEmbeddableMappingBuilder.FluentEmbeddableMappingBuilderPropertyOptions timestampMapping = MappingEase.embeddableBuilder(Timestamp.class).map(Timestamp::getCreationDate).map(Timestamp::getModificationDate);
            FluentEmbeddableMappingBuilder timestampWithLocaleMapping = MappingEase.embeddableBuilder(FluentEntityMappingConfigurationSupportTest.TimestampWithLocale.class).map(FluentEntityMappingConfigurationSupportTest.TimestampWithLocale::getLocale).mapSuperClass((EmbeddableMappingConfigurationProvider)timestampMapping);
            EntityPersister persister = MappingEase.entityBuilder(FluentEntityMappingConfigurationSupportTest.Toto.class, (Class)UUID_TYPE).onTable(totoTable).mapKey(FluentEntityMappingConfigurationSupportTest.Toto::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.UUID_ALREADY_ASSIGNED).map(FluentEntityMappingConfigurationSupportTest.Toto::getName).embed(FluentEntityMappingConfigurationSupportTest.Toto::getTimestamp, (EmbeddableMappingConfigurationProvider)timestampWithLocaleMapping).overrideName(Timestamp::getModificationDate, "modificationTime").build(FluentEntityMappingConfigurationSupportEmbedTest.this.persistenceContext);
            DDLDeployer ddlDeployer = new DDLDeployer(FluentEntityMappingConfigurationSupportEmbedTest.this.persistenceContext);
            ddlDeployer.deployDDL();
            Assertions.assertThat(totoTable.getColumns().stream().map(Column::getName)).containsExactlyInAnyOrder((Object[])new String[]{"id", "name", "creationDate", "modificationTime", "locale"});
        }

        @Test
        void withMappedSuperClassAndOverrideSize_schemaGeneration() {
            Table totoTable = new Table("Toto");
            Column idColumn = totoTable.addColumn("id", UUID_TYPE);
            FluentEntityMappingConfigurationSupportEmbedTest.this.dialect.getColumnBinderRegistry().register(idColumn, Identifier.identifierBinder(DefaultParameterBinders.UUID_BINDER));
            FluentEntityMappingConfigurationSupportEmbedTest.this.dialect.getSqlTypeRegistry().put(idColumn, "VARCHAR(255)");
            FluentEntityMappingConfigurationSupportEmbedTest.this.dialect.getColumnBinderRegistry().register(Locale.class, (ParameterBinder)new NullAwareParameterBinder((ParameterBinder)new LambdaParameterBinder((ResultSetReader)new ResultSetReader.LambdaResultSetReader((resultSet, columnName) -> Locale.forLanguageTag(resultSet.getString((String)columnName)), Locale.class), (PreparedStatementWriter)new PreparedStatementWriter.LambdaPreparedStatementWriter((preparedStatement, valueIndex, value) -> preparedStatement.setString((int)valueIndex, value.toLanguageTag()), Locale.class))));
            FluentEntityMappingConfigurationSupportEmbedTest.this.dialect.getSqlTypeRegistry().put(Locale.class, "VARCHAR(20)");
            FluentEmbeddableMappingBuilder.FluentEmbeddableMappingBuilderPropertyOptions timestampMapping = MappingEase.embeddableBuilder(Timestamp.class).map(Timestamp::getCreationDate).map(Timestamp::getModificationDate).map(Timestamp::getReadonlyProperty);
            FluentEmbeddableMappingBuilder timestampWithLocaleMapping = MappingEase.embeddableBuilder(FluentEntityMappingConfigurationSupportTest.TimestampWithLocale.class).map(FluentEntityMappingConfigurationSupportTest.TimestampWithLocale::getLocale).mapSuperClass((EmbeddableMappingConfigurationProvider)timestampMapping);
            EntityPersister persister = MappingEase.entityBuilder(FluentEntityMappingConfigurationSupportTest.Toto.class, (Class)UUID_TYPE).onTable(totoTable).mapKey(FluentEntityMappingConfigurationSupportTest.Toto::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.UUID_ALREADY_ASSIGNED).map(FluentEntityMappingConfigurationSupportTest.Toto::getName).embed(FluentEntityMappingConfigurationSupportTest.Toto::getTimestamp, (EmbeddableMappingConfigurationProvider)timestampWithLocaleMapping).overrideSize(Timestamp::getReadonlyProperty, (Size)Size.length((int)42)).build(FluentEntityMappingConfigurationSupportEmbedTest.this.persistenceContext);
            DDLDeployer ddlDeployer = new DDLDeployer(FluentEntityMappingConfigurationSupportEmbedTest.this.persistenceContext);
            ddlDeployer.deployDDL();
            Assertions.assertThat(totoTable.getColumns().stream().map(Column::getName)).containsExactlyInAnyOrder((Object[])new String[]{"id", "name", "creationDate", "modificationDate", "readonlyProperty", "locale"});
            Assertions.assertThat((Object)((Column)Iterables.map((Iterable)totoTable.getColumns(), Column::getName).get("readonlyProperty")).getSize()).usingRecursiveComparison().isEqualTo((Object)Size.length((int)42));
        }

        @Test
        void withMappedSuperClassAndOverride_crud() {
            Table totoTable = new Table("Toto");
            Column idColumn = totoTable.addColumn("id", UUID_TYPE);
            Column creationDate = totoTable.addColumn("creationDate", Date.class);
            Column modificationDate = totoTable.addColumn("modificationTime", Date.class);
            Column localeColumn = totoTable.addColumn("locale", Locale.class);
            FluentEntityMappingConfigurationSupportEmbedTest.this.dialect.getColumnBinderRegistry().register(idColumn, Identifier.identifierBinder(DefaultParameterBinders.UUID_BINDER));
            FluentEntityMappingConfigurationSupportEmbedTest.this.dialect.getSqlTypeRegistry().put(idColumn, "VARCHAR(255)");
            FluentEntityMappingConfigurationSupportEmbedTest.this.dialect.getColumnBinderRegistry().register(Locale.class, (ParameterBinder)new NullAwareParameterBinder((ParameterBinder)new LambdaParameterBinder((ResultSetReader)new ResultSetReader.LambdaResultSetReader((resultSet, columnName) -> Locale.forLanguageTag(resultSet.getString((String)columnName)), Locale.class), (PreparedStatementWriter)new PreparedStatementWriter.LambdaPreparedStatementWriter((preparedStatement, valueIndex, value) -> preparedStatement.setString((int)valueIndex, value.toLanguageTag()), Locale.class))));
            FluentEntityMappingConfigurationSupportEmbedTest.this.dialect.getSqlTypeRegistry().put(Locale.class, "VARCHAR(20)");
            FluentEmbeddableMappingBuilder.FluentEmbeddableMappingBuilderPropertyOptions timestampMapping = MappingEase.embeddableBuilder(Timestamp.class).map(Timestamp::getCreationDate).map(Timestamp::getModificationDate);
            FluentEmbeddableMappingBuilder timestampWithLocaleMapping = MappingEase.embeddableBuilder(FluentEntityMappingConfigurationSupportTest.TimestampWithLocale.class).map(FluentEntityMappingConfigurationSupportTest.TimestampWithLocale::getLocale).mapSuperClass((EmbeddableMappingConfigurationProvider)timestampMapping);
            EntityPersister persister = MappingEase.entityBuilder(FluentEntityMappingConfigurationSupportTest.Toto.class, (Class)UUID_TYPE).onTable(totoTable).mapKey(FluentEntityMappingConfigurationSupportTest.Toto::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.UUID_ALREADY_ASSIGNED).map(FluentEntityMappingConfigurationSupportTest.Toto::getName).embed(FluentEntityMappingConfigurationSupportTest.Toto::getTimestamp, (EmbeddableMappingConfigurationProvider)timestampWithLocaleMapping).override(Timestamp::getModificationDate, modificationDate).build(FluentEntityMappingConfigurationSupportEmbedTest.this.persistenceContext);
            DDLDeployer ddlDeployer = new DDLDeployer(FluentEntityMappingConfigurationSupportEmbedTest.this.persistenceContext);
            ddlDeployer.deployDDL();
            FluentEntityMappingConfigurationSupportTest.Toto toto = new FluentEntityMappingConfigurationSupportTest.Toto();
            toto.setTimestamp(new FluentEntityMappingConfigurationSupportTest.TimestampWithLocale(Dates.nowAsDate(), null, Locale.US));
            persister.insert((Object)toto);
            List select = FluentEntityMappingConfigurationSupportEmbedTest.this.persistenceContext.select(FluentEntityMappingConfigurationSupportTest.TimestampWithLocale::new, creationDate, modificationDate, localeColumn);
            Assertions.assertThat((Object)Iterables.first((List)select)).isEqualTo((Object)toto.getTimestamp());
            FluentEntityMappingConfigurationSupportTest.Toto loadedToto = (FluentEntityMappingConfigurationSupportTest.Toto)persister.select(toto.getId());
            Assertions.assertThat((Object)loadedToto.getTimestamp()).isEqualTo((Object)toto.getTimestamp());
        }
    }
}

