/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.runtime.singletable;

import java.sql.ResultSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.codefilarete.stalactite.engine.PolymorphismPolicy;
import org.codefilarete.stalactite.engine.runtime.AbstractPolymorphicEntityFinder;
import org.codefilarete.stalactite.engine.runtime.ColumnCloneAwareOrderBy;
import org.codefilarete.stalactite.engine.runtime.ConfiguredRelationalPersister;
import org.codefilarete.stalactite.engine.runtime.load.EntityJoinTree;
import org.codefilarete.stalactite.engine.runtime.load.EntityTreeQueryBuilder;
import org.codefilarete.stalactite.engine.runtime.load.SingleTableRootJoinNode;
import org.codefilarete.stalactite.mapping.id.assembly.IdentifierAssembler;
import org.codefilarete.stalactite.query.ConfiguredEntityCriteria;
import org.codefilarete.stalactite.query.builder.QuerySQLBuilderFactory;
import org.codefilarete.stalactite.query.model.LimitAware;
import org.codefilarete.stalactite.query.model.OrderByChain;
import org.codefilarete.stalactite.query.model.Query;
import org.codefilarete.stalactite.query.model.Selectable;
import org.codefilarete.stalactite.sql.ConnectionProvider;
import org.codefilarete.stalactite.sql.Dialect;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.PrimaryKey;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.stalactite.sql.result.ColumnedRow;
import org.codefilarete.stalactite.sql.result.ColumnedRowIterator;
import org.codefilarete.stalactite.sql.statement.PreparedSQL;
import org.codefilarete.stalactite.sql.statement.ReadOperation;
import org.codefilarete.stalactite.sql.statement.SQLExecutionException;
import org.codefilarete.stalactite.sql.statement.SQLStatement;
import org.codefilarete.stalactite.sql.statement.binder.ResultSetReader;
import org.codefilarete.stalactite.sql.statement.binder.ResultSetReaderRegistry;
import org.codefilarete.tool.VisibleForTesting;
import org.codefilarete.tool.collection.KeepOrderMap;
import org.codefilarete.tool.collection.KeepOrderSet;

public class SingleTablePolymorphismEntityFinder<C, I, T extends Table<T>, DTYPE>
extends AbstractPolymorphicEntityFinder<C, I, T> {
    @VisibleForTesting
    static final String DISCRIMINATOR_ALIAS = "DISCRIMINATOR";
    private final IdentifierAssembler<I, T> identifierAssembler;
    private final Column<T, DTYPE> discriminatorColumn;
    private final PolymorphismPolicy.SingleTablePolymorphism<C, DTYPE> polymorphismPolicy;
    private final EntityJoinTree<C, I> singleLoadEntityJoinTree;

    public SingleTablePolymorphismEntityFinder(ConfiguredRelationalPersister<C, I> mainPersister, Map<? extends Class<C>, ? extends ConfiguredRelationalPersister<C, I>> persisterPerSubclass, Column<T, DTYPE> discriminatorColumn, PolymorphismPolicy.SingleTablePolymorphism<C, DTYPE> polymorphismPolicy, ConnectionProvider connectionProvider, Dialect dialect) {
        super(mainPersister, persisterPerSubclass, connectionProvider, dialect);
        this.identifierAssembler = mainPersister.getMapping().getIdMapping().getIdentifierAssembler();
        this.discriminatorColumn = discriminatorColumn;
        this.polymorphismPolicy = polymorphismPolicy;
        this.singleLoadEntityJoinTree = this.buildSingleLoadEntityJoinTree(mainPersister, persisterPerSubclass);
    }

    private SingleLoadEntityJoinTree<C, I, DTYPE> buildSingleLoadEntityJoinTree(ConfiguredRelationalPersister<C, I> mainPersister, Map<? extends Class<C>, ? extends ConfiguredRelationalPersister<C, I>> persisterPerSubclass) {
        SingleLoadEntityJoinTree result = new SingleLoadEntityJoinTree(mainPersister, new HashSet<ConfiguredRelationalPersister<C, I>>(persisterPerSubclass.values()), this.discriminatorColumn, this.polymorphismPolicy);
        mainPersister.getEntityJoinTree().projectTo(result, "ROOT");
        persisterPerSubclass.values().forEach(subPersister -> subPersister.getEntityJoinTree().projectTo(result, "ROOT"));
        return result;
    }

    @Override
    public Set<C> selectWithSingleQuery(ConfiguredEntityCriteria where, Consumer<OrderByChain<?>> orderByClauseConsumer, Consumer<LimitAware<?>> limitAwareConsumer) {
        this.LOGGER.debug("Finding entities in a single query with criteria {}", (Object)where);
        if (this.hasSubPolymorphicPersister) {
            this.LOGGER.debug("Single query was asked but due to sub-polymorphism the query is made in 2 phases");
            return this.selectIn2Phases(where, orderByClauseConsumer, limitAwareConsumer);
        }
        return super.selectWithSingleQuery(where, orderByClauseConsumer, limitAwareConsumer, this.singleLoadEntityJoinTree, this.dialect, this.connectionProvider);
    }

    @Override
    public Set<C> selectIn2Phases(ConfiguredEntityCriteria where, Consumer<OrderByChain<?>> orderByClauseConsumer, Consumer<LimitAware<?>> limitAwareConsumer) {
        this.LOGGER.debug("Finding entities in 2-phases query with criteria {}", (Object)where);
        EntityTreeQueryBuilder.EntityTreeQuery entityTreeQuery = new EntityTreeQueryBuilder(this.mainEntityJoinTree, (ResultSetReaderRegistry)this.dialect.getColumnBinderRegistry()).buildSelectQuery();
        Query query = entityTreeQuery.getQuery();
        QuerySQLBuilderFactory.QuerySQLBuilder sqlQueryBuilder = this.dialect.getQuerySQLBuilderFactory().queryBuilder(query, where.getCriteria(), entityTreeQuery.getColumnClones());
        query.getSelectDelegate().clear();
        PrimaryKey pk = ((Table)this.mainEntityJoinTree.getRoot().getTable()).getPrimaryKey();
        pk.getColumns().forEach(column -> query.select((Selectable)column, column.getAlias()));
        query.select(this.discriminatorColumn, DISCRIMINATOR_ALIAS);
        HashMap columnReaders = new HashMap();
        Map aliases = query.getAliases();
        query.getColumns().forEach(selectable -> {
            ResultSetReader cfr_ignored_0 = (ResultSetReader)columnReaders.put((Selectable<?>)selectable, (ResultSetReader<?>)this.dialect.getColumnBinderRegistry().getBinder((Object)((Column)selectable)));
        });
        orderByClauseConsumer.accept(new ColumnCloneAwareOrderBy(query.orderBy(), entityTreeQuery.getColumnClones()));
        limitAwareConsumer.accept((LimitAware<?>)query.orderBy());
        Map<Class, Set<I>> idsPerSubtype = this.readIds(sqlQueryBuilder.toPreparableSQL().toPreparedSQL(new HashMap()), columnReaders, query.getAliases());
        Set ids = idsPerSubtype.values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
        if (this.hasSubPolymorphicPersister) {
            this.LOGGER.debug("Asking sub-polymorphic persisters to load the entities");
            HashSet result = new HashSet();
            idsPerSubtype.forEach((k, v) -> result.addAll(((ConfiguredRelationalPersister)this.persisterPerSubclass.get(k)).select((Iterable)v)));
            return result;
        }
        return this.selectWithSingleQuery(this.newWhereIdClause(ids), orderByChain -> {}, limitAware -> {});
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map<Class, Set<I>> readIds(PreparedSQL preparedSQL, Map<Selectable<?>, ResultSetReader<?>> columnReaders, Map<Selectable<?>, String> aliases) {
        try (ReadOperation closeableOperation = this.dialect.getReadOperationFactory().createInstance((SQLStatement)preparedSQL, this.connectionProvider);){
            ResultSet resultSet = closeableOperation.execute();
            ColumnedRowIterator rowIterator = new ColumnedRowIterator(resultSet, columnReaders, aliases);
            KeepOrderMap result = new KeepOrderMap();
            rowIterator.forEachRemaining(arg_0 -> this.lambda$readIds$7((Map)result, arg_0));
            KeepOrderMap keepOrderMap = result;
            return keepOrderMap;
        }
        catch (RuntimeException e) {
            throw new SQLExecutionException(preparedSQL.getSQL(), (Throwable)e);
        }
    }

    private /* synthetic */ void lambda$readIds$7(Map result, ColumnedRow row) {
        Object dtype = row.get(this.discriminatorColumn);
        Object id = this.identifierAssembler.assemble(row);
        result.computeIfAbsent(this.polymorphismPolicy.getClass(dtype), k -> new KeepOrderSet()).add(id);
    }

    private static class SingleLoadEntityJoinTree<C, I, DTYPE>
    extends EntityJoinTree<C, I> {
        public <T extends Table<T>> SingleLoadEntityJoinTree(ConfiguredRelationalPersister<C, I> mainPersister, Set<? extends ConfiguredRelationalPersister<C, I>> subPersisters, Column<T, DTYPE> discriminatorColumn, PolymorphismPolicy.SingleTablePolymorphism<C, DTYPE> polymorphismPolicy) {
            super((EntityJoinTree<C, I> self) -> new SingleTableRootJoinNode(self, mainPersister, subPersisters, discriminatorColumn, polymorphismPolicy));
        }
    }
}

