/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.runtime.onetomany;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.codefilarete.stalactite.engine.diff.AbstractDiff;
import org.codefilarete.stalactite.engine.diff.IndexedDiff;
import org.codefilarete.stalactite.engine.listener.SelectListener;
import org.codefilarete.stalactite.engine.listener.SelectListenerCollection;
import org.codefilarete.stalactite.engine.runtime.AssociationRecordPersister;
import org.codefilarete.stalactite.engine.runtime.CollectionUpdater;
import org.codefilarete.stalactite.engine.runtime.ConfiguredRelationalPersister;
import org.codefilarete.stalactite.engine.runtime.IndexedAssociationRecord;
import org.codefilarete.stalactite.engine.runtime.IndexedAssociationRecordInsertionCascader;
import org.codefilarete.stalactite.engine.runtime.IndexedAssociationTable;
import org.codefilarete.stalactite.engine.runtime.load.AbstractJoinNode;
import org.codefilarete.stalactite.engine.runtime.load.EntityJoinTree;
import org.codefilarete.stalactite.engine.runtime.load.EntityTreeInflater;
import org.codefilarete.stalactite.engine.runtime.load.JoinNode;
import org.codefilarete.stalactite.engine.runtime.onetomany.AbstractOneToManyWithAssociationTableEngine;
import org.codefilarete.stalactite.engine.runtime.onetomany.IndexedAssociationTableManyRelationDescriptor;
import org.codefilarete.stalactite.engine.runtime.onetomany.OneToManyWithIndexedAssociationTableEngine;
import org.codefilarete.stalactite.engine.runtime.onetomany.OneToManyWithMappedAssociationEngine;
import org.codefilarete.stalactite.mapping.EntityMapping;
import org.codefilarete.stalactite.mapping.RowTransformer;
import org.codefilarete.stalactite.query.model.Fromable;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.stalactite.sql.result.ColumnedRow;
import org.codefilarete.stalactite.sql.statement.WriteOperationFactory;
import org.codefilarete.tool.Duo;
import org.codefilarete.tool.Nullable;
import org.codefilarete.tool.collection.Iterables;
import org.codefilarete.tool.collection.PairIterator;

public class OneToManyWithIndexedAssociationTableEngine<SRC, TRGT, SRCID, TRGTID, C extends Collection<TRGT>, LEFTTABLE extends Table<LEFTTABLE>, RIGHTTABLE extends Table<RIGHTTABLE>, ASSOCIATIONTABLE extends IndexedAssociationTable<ASSOCIATIONTABLE, LEFTTABLE, RIGHTTABLE, SRCID, TRGTID>>
extends AbstractOneToManyWithAssociationTableEngine<SRC, TRGT, SRCID, TRGTID, C, IndexedAssociationRecord, ASSOCIATIONTABLE> {
    private final Column<ASSOCIATIONTABLE, Integer> indexColumn;

    public OneToManyWithIndexedAssociationTableEngine(ConfiguredRelationalPersister<SRC, SRCID> sourcePersister, ConfiguredRelationalPersister<TRGT, TRGTID> targetPersister, IndexedAssociationTableManyRelationDescriptor<SRC, TRGT, C, SRCID> manyRelationDescriptor, AssociationRecordPersister<IndexedAssociationRecord, ASSOCIATIONTABLE> associationPersister, Column<ASSOCIATIONTABLE, Integer> indexColumn, WriteOperationFactory writeOperationFactory) {
        super(sourcePersister, targetPersister, manyRelationDescriptor, associationPersister, writeOperationFactory);
        this.indexColumn = indexColumn;
    }

    public IndexedAssociationTableManyRelationDescriptor<SRC, TRGT, C, SRCID> getManyRelationDescriptor() {
        return (IndexedAssociationTableManyRelationDescriptor)super.getManyRelationDescriptor();
    }

    @Override
    public void addSelectCascade(ConfiguredRelationalPersister<SRC, SRCID> sourcePersister, boolean loadSeparately) {
        this.addIndexSelection(loadSeparately);
        SelectListenerCollection targetSelectListener = this.targetPersister.getPersisterListener().getSelectListener();
        sourcePersister.addSelectListener(new SelectListener<SRC, SRCID>((SelectListener)targetSelectListener){
            final /* synthetic */ SelectListener val$targetSelectListener;
            {
                this.val$targetSelectListener = selectListener;
            }

            public void beforeSelect(Iterable<SRCID> ids) {
                this.val$targetSelectListener.beforeSelect(Collections.emptyList());
            }

            public void afterSelect(Set<? extends SRC> result) {
                Set collect = Iterables.stream(result).flatMap(src -> (Stream)Nullable.nullable(OneToManyWithIndexedAssociationTableEngine.this.manyRelationDescriptor.getCollectionGetter().apply(src)).map(Collection::stream).getOr(Stream.empty())).collect(Collectors.toSet());
                this.val$targetSelectListener.afterSelect(collect);
            }

            public void onSelectError(Iterable<SRCID> ids, RuntimeException exception) {
                this.val$targetSelectListener.onSelectError(Collections.emptyList(), exception);
            }
        });
    }

    private void addIndexSelection(boolean loadSeparately) {
        String associationTableJoinNodeName = this.sourcePersister.getEntityJoinTree().addPassiveJoin("ROOT", ((IndexedAssociationTable)this.associationPersister.getMainTable()).getOneSideKey(), ((IndexedAssociationTable)this.associationPersister.getMainTable()).getOneSideForeignKey(), EntityJoinTree.JoinType.OUTER, ((IndexedAssociationTable)this.associationPersister.getMainTable()).getColumns());
        String rightEntityJoinName = this.targetPersister.joinAsMany(associationTableJoinNodeName, this.sourcePersister, this.manyRelationDescriptor.getCollectionProvider(), ((IndexedAssociationTable)this.associationPersister.getMainTable()).getManySideForeignKey(), ((IndexedAssociationTable)this.associationPersister.getMainTable()).getManySideKey(), this.manyRelationDescriptor.getRelationFixer(), columnedRow -> {
            Object identifier = this.targetPersister.getMapping().getIdMapping().getIdentifierAssembler().assemble(columnedRow);
            JoinNode<?, Fromable> join = this.sourcePersister.getEntityJoinTree().getJoin(associationTableJoinNodeName);
            ColumnedRow rowDecoder = EntityTreeInflater.currentContext().getDecoder(join);
            Integer targetEntityIndex = (Integer)rowDecoder.get(this.indexColumn);
            return identifier + "-" + targetEntityIndex;
        }, true, loadSeparately);
        RowTransformer associationRecordProvider = this.associationPersister.getMapping().getRowTransformer();
        this.sourcePersister.addSelectListener(new SelectListener<SRC, SRCID>(){

            public void beforeSelect(Iterable<SRCID> ids) {
                OneToManyWithIndexedAssociationTableEngine.this.getRelationFixer().init();
            }

            public void afterSelect(Set<? extends SRC> result) {
                OneToManyWithIndexedAssociationTableEngine.this.getRelationFixer().applySort(result);
                this.cleanContext();
            }

            public void onSelectError(Iterable<SRCID> ids, RuntimeException exception) {
                this.cleanContext();
            }

            private void cleanContext() {
                OneToManyWithIndexedAssociationTableEngine.this.getRelationFixer().clear();
            }
        });
        AbstractJoinNode join = (AbstractJoinNode)this.sourcePersister.getEntityJoinTree().getJoin(rightEntityJoinName);
        JoinNode<?, Fromable> associationTableJoinNode = this.sourcePersister.getEntityJoinTree().getJoin(associationTableJoinNodeName);
        join.setConsumptionListener((trgt, columnValueProvider) -> {
            IndexedAssociationRecord associationRecord = (IndexedAssociationRecord)associationRecordProvider.transform(EntityTreeInflater.currentContext().getDecoder(associationTableJoinNode));
            ((IndexedAssociationTableManyRelationDescriptor.InMemoryRelationHolder)this.manyRelationDescriptor.getRelationFixer()).addIndex(associationRecord.getLeft(), trgt, associationRecord.getIndex());
        });
    }

    private IndexedAssociationTableManyRelationDescriptor.InMemoryRelationHolder getRelationFixer() {
        return ((IndexedAssociationTableManyRelationDescriptor)this.getManyRelationDescriptor()).getRelationFixer();
    }

    @Override
    public void addUpdateCascade(boolean shouldDeleteRemoved, boolean maintainAssociationOnly, ConfiguredRelationalPersister<TRGT, TRGTID> targetPersister) {
        CollectionUpdater collectionUpdater = new CollectionUpdater<SRC, TRGT, C>(this.manyRelationDescriptor.getCollectionGetter(), targetPersister, null, shouldDeleteRemoved){

            protected AssociationTableUpdateContext newUpdateContext(Duo<SRC, SRC> updatePayload) {
                return new AssociationTableUpdateContext(updatePayload);
            }

            @Override
            protected void onHeldElements(CollectionUpdater.UpdateContext updateContext, AbstractDiff<TRGT> diff) {
                super.onHeldElements(updateContext, diff);
                IndexedDiff indexedDiff = (IndexedDiff)diff;
                Set minus = Iterables.minus(indexedDiff.getReplacerIndexes(), indexedDiff.getSourceIndexes());
                Integer index = (Integer)Iterables.first((Iterable)minus);
                if (index != null) {
                    Object leftIdentifier = updateContext.getPayload().getLeft();
                    PairIterator diffIndexIterator = new PairIterator(indexedDiff.getReplacerIndexes(), indexedDiff.getSourceIndexes());
                    diffIndexIterator.forEachRemaining(d -> {
                        if (!((Integer)d.getLeft()).equals(d.getRight())) {
                            ((AssociationTableUpdateContext)updateContext).getAssociationRecordsToBeUpdated().add((Duo<IndexedAssociationRecord, IndexedAssociationRecord>)new Duo((Object)OneToManyWithIndexedAssociationTableEngine.this.newRecord(leftIdentifier, diff.getSourceInstance(), (int)((Integer)d.getLeft())), (Object)OneToManyWithIndexedAssociationTableEngine.this.newRecord(leftIdentifier, diff.getSourceInstance(), (int)((Integer)d.getRight()))));
                        }
                    });
                }
            }

            @Override
            protected Set<? extends AbstractDiff<TRGT>> diff(Collection<TRGT> modified, Collection<TRGT> unmodified) {
                return this.getDiffer().diffOrdered(unmodified, modified);
            }

            @Override
            protected void onAddedElements(CollectionUpdater.UpdateContext updateContext, AbstractDiff<TRGT> diff) {
                super.onAddedElements(updateContext, diff);
                Object leftIdentifier = updateContext.getPayload().getLeft();
                ((IndexedDiff)diff).getReplacerIndexes().forEach(idx -> ((AssociationTableUpdateContext)updateContext).getAssociationRecordsToBeInserted().add((IndexedAssociationRecord)OneToManyWithIndexedAssociationTableEngine.this.newRecord(leftIdentifier, diff.getReplacingInstance(), (int)idx)));
            }

            @Override
            protected void onRemovedElements(CollectionUpdater.UpdateContext updateContext, AbstractDiff<TRGT> diff) {
                super.onRemovedElements(updateContext, diff);
                Object leftIdentifier = updateContext.getPayload().getLeft();
                ((IndexedDiff)diff).getSourceIndexes().forEach(idx -> ((AssociationTableUpdateContext)updateContext).getAssociationRecordsToBeDeleted().add((IndexedAssociationRecord)OneToManyWithIndexedAssociationTableEngine.this.newRecord(leftIdentifier, diff.getSourceInstance(), (int)idx)));
            }

            @Override
            protected void updateTargets(CollectionUpdater.UpdateContext updateContext, boolean allColumnsStatement) {
                super.updateTargets(updateContext, allColumnsStatement);
                List<Duo<IndexedAssociationRecord, IndexedAssociationRecord>> associationRecordsToBeUpdated = ((AssociationTableUpdateContext)updateContext).getAssociationRecordsToBeUpdated();
                OneToManyWithIndexedAssociationTableEngine.this.associationPersister.delete(Iterables.collectToList(associationRecordsToBeUpdated, Duo::getRight));
                OneToManyWithIndexedAssociationTableEngine.this.associationPersister.insert(Iterables.collectToList(associationRecordsToBeUpdated, Duo::getLeft));
            }

            @Override
            protected void insertTargets(CollectionUpdater.UpdateContext updateContext) {
                super.insertTargets(updateContext);
                OneToManyWithIndexedAssociationTableEngine.this.associationPersister.insert(((AssociationTableUpdateContext)updateContext).getAssociationRecordsToBeInserted());
            }

            @Override
            protected void deleteTargets(CollectionUpdater.UpdateContext updateContext) {
                OneToManyWithIndexedAssociationTableEngine.this.associationPersister.delete(((AssociationTableUpdateContext)updateContext).getAssociationRecordsToBeDeleted());
                super.deleteTargets(updateContext);
            }

            class AssociationTableUpdateContext
            extends CollectionUpdater.UpdateContext {
                private final List<IndexedAssociationRecord> associationRecordsToBeInserted;
                private final List<IndexedAssociationRecord> associationRecordsToBeDeleted;
                private final List<Duo<IndexedAssociationRecord, IndexedAssociationRecord>> associationRecordsToBeUpdated;

                public AssociationTableUpdateContext(Duo<SRC, SRC> updatePayload) {
                    super(updatePayload);
                    this.associationRecordsToBeInserted = new ArrayList<IndexedAssociationRecord>();
                    this.associationRecordsToBeDeleted = new ArrayList<IndexedAssociationRecord>();
                    this.associationRecordsToBeUpdated = new ArrayList<Duo<IndexedAssociationRecord, IndexedAssociationRecord>>();
                }

                public List<IndexedAssociationRecord> getAssociationRecordsToBeInserted() {
                    return this.associationRecordsToBeInserted;
                }

                public List<IndexedAssociationRecord> getAssociationRecordsToBeDeleted() {
                    return this.associationRecordsToBeDeleted;
                }

                public List<Duo<IndexedAssociationRecord, IndexedAssociationRecord>> getAssociationRecordsToBeUpdated() {
                    return this.associationRecordsToBeUpdated;
                }
            }
        };
        if (!maintainAssociationOnly) {
            this.persisterListener.addUpdateListener(new OneToManyWithMappedAssociationEngine.AfterUpdateTrigger(collectionUpdater));
        }
    }

    protected IndexedAssociationRecordInsertionCascader<SRC, TRGT, SRCID, TRGTID, C> newRecordInsertionCascader(Function<SRC, C> collectionGetter, AssociationRecordPersister<IndexedAssociationRecord, ASSOCIATIONTABLE> associationPersister, EntityMapping<SRC, SRCID, ?> mappingStrategy, EntityMapping<TRGT, TRGTID, ?> targetStrategy) {
        return new IndexedAssociationRecordInsertionCascader<SRC, TRGT, SRCID, TRGTID, C>(associationPersister, collectionGetter, mappingStrategy, targetStrategy);
    }

    @Override
    protected IndexedAssociationRecord newRecord(SRC e, TRGT target, int index) {
        return new IndexedAssociationRecord(this.sourcePersister.getMapping().getId(e), this.targetPersister.getMapping().getId(target), index);
    }
}

