/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.runtime;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.codefilarete.reflection.Accessor;
import org.codefilarete.reflection.ValueAccessPoint;
import org.codefilarete.stalactite.engine.EntityPersister;
import org.codefilarete.stalactite.engine.PersistExecutor;
import org.codefilarete.stalactite.engine.runtime.AdvancedEntityPersister;
import org.codefilarete.stalactite.engine.runtime.AlreadyAssignedIdentifierPersistExecutor;
import org.codefilarete.stalactite.engine.runtime.BeanPersister;
import org.codefilarete.stalactite.engine.runtime.ConfiguredPersister;
import org.codefilarete.stalactite.engine.runtime.ConfiguredRelationalPersister;
import org.codefilarete.stalactite.engine.runtime.DeleteExecutor;
import org.codefilarete.stalactite.engine.runtime.EntityCriteriaSupport;
import org.codefilarete.stalactite.engine.runtime.EntityGraphSelector;
import org.codefilarete.stalactite.engine.runtime.EntityMappingTreeSelectExecutor;
import org.codefilarete.stalactite.engine.runtime.EntityQueryCriteriaSupport;
import org.codefilarete.stalactite.engine.runtime.InsertExecutor;
import org.codefilarete.stalactite.engine.runtime.PersisterListenerWrapper;
import org.codefilarete.stalactite.engine.runtime.ProjectionQueryCriteriaSupport;
import org.codefilarete.stalactite.engine.runtime.RelationalEntityPersister;
import org.codefilarete.stalactite.engine.runtime.UpdateExecutor;
import org.codefilarete.stalactite.engine.runtime.load.EntityInflater;
import org.codefilarete.stalactite.engine.runtime.load.EntityJoinTree;
import org.codefilarete.stalactite.mapping.ClassMapping;
import org.codefilarete.stalactite.mapping.EntityMapping;
import org.codefilarete.stalactite.mapping.id.manager.AlreadyAssignedIdentifierManager;
import org.codefilarete.stalactite.query.EntityFinder;
import org.codefilarete.stalactite.query.model.Select;
import org.codefilarete.stalactite.sql.ConnectionConfiguration;
import org.codefilarete.stalactite.sql.ConnectionProvider;
import org.codefilarete.stalactite.sql.Dialect;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.Key;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.stalactite.sql.result.Accumulators;
import org.codefilarete.stalactite.sql.result.BeanRelationFixer;
import org.codefilarete.stalactite.sql.result.ColumnedRow;
import org.codefilarete.tool.Duo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleRelationalEntityPersister<C, I, T extends Table<T>>
extends PersisterListenerWrapper<C, I>
implements ConfiguredRelationalPersister<C, I>,
AdvancedEntityPersister<C, I> {
    protected final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    private final BeanPersister<C, I, T> persister;
    private final EntityFinder<C, I> entityFinder;
    private final EntityCriteriaSupport<C> criteriaSupport;
    private final EntityMappingTreeSelectExecutor<C, I, T> selectGraphExecutor;
    private final PersistExecutor<C> persistExecutor;

    public SimpleRelationalEntityPersister(ClassMapping<C, I, T> mainMappingStrategy, Dialect dialect, ConnectionConfiguration connectionConfiguration) {
        this(new BeanPersister(mainMappingStrategy, dialect, connectionConfiguration), dialect, connectionConfiguration);
    }

    public SimpleRelationalEntityPersister(BeanPersister<C, I, T> persister, Dialect dialect, ConnectionConfiguration connectionConfiguration) {
        this.persister = persister;
        this.criteriaSupport = new EntityCriteriaSupport(persister.getMapping());
        this.selectGraphExecutor = this.newSelectExecutor(persister.getMapping(), connectionConfiguration.getConnectionProvider(), dialect);
        this.entityFinder = this.newEntitySelectExecutor(dialect);
        this.persistExecutor = persister.getMapping().getIdMapping().getIdentifierInsertionManager() instanceof AlreadyAssignedIdentifierManager ? new AlreadyAssignedIdentifierPersistExecutor((ConfiguredPersister)this) : new PersistExecutor.DefaultPersistExecutor((EntityPersister)this);
    }

    protected EntityMappingTreeSelectExecutor<C, I, T> newSelectExecutor(EntityMapping<C, I, T> mappingStrategy, ConnectionProvider connectionProvider, Dialect dialect) {
        return new EntityMappingTreeSelectExecutor<C, I, T>(mappingStrategy, dialect, connectionProvider);
    }

    protected EntityFinder<C, I> newEntitySelectExecutor(Dialect dialect) {
        return new EntityGraphSelector(this.getEntityJoinTree(), this.persister.getConnectionProvider(), dialect);
    }

    @Override
    public Column getColumn(List<? extends ValueAccessPoint<?>> accessorChain) {
        return this.criteriaSupport.getRootConfiguration().giveColumn(accessorChain);
    }

    public EntityMappingTreeSelectExecutor<C, I, T> getEntityMappingTreeSelectExecutor() {
        return this.selectGraphExecutor;
    }

    public I getId(C entity) {
        return (I)this.persister.getId(entity);
    }

    @Override
    public T getMainTable() {
        return (T)this.persister.getMainTable();
    }

    public InsertExecutor<C, I, T> getInsertExecutor() {
        return this.persister.getInsertExecutor();
    }

    public UpdateExecutor<C, I, T> getUpdateExecutor() {
        return this.persister.getUpdateExecutor();
    }

    public EntityMappingTreeSelectExecutor<C, I, T> getSelectExecutor() {
        return this.selectGraphExecutor;
    }

    public DeleteExecutor<C, I, T> getDeleteExecutor() {
        return this.persister.getDeleteExecutor();
    }

    @Override
    public EntityJoinTree<C, I> getEntityJoinTree() {
        return this.getEntityMappingTreeSelectExecutor().getEntityJoinTree();
    }

    public EntityMapping<C, I, T> getMapping() {
        return this.persister.getMapping();
    }

    public Set<Table<?>> giveImpliedTables() {
        return this.getEntityJoinTree().giveTables();
    }

    @Override
    public RelationalEntityPersister.ExecutableEntityQueryCriteria<C, ?> selectWhere() {
        return this.newCriteriaSupport().wrapIntoExecutable();
    }

    @Override
    public EntityQueryCriteriaSupport<C, I> newCriteriaSupport() {
        return new EntityQueryCriteriaSupport<C, I>(this.criteriaSupport, this.entityFinder, this.getPersisterListener());
    }

    public EntityPersister.ExecutableProjectionQuery<C, ?> selectProjectionWhere(Consumer<Select> selectAdapter) {
        ProjectionQueryCriteriaSupport<C, I> projectionSupport = new ProjectionQueryCriteriaSupport<C, I>(this.criteriaSupport, this.entityFinder, selectAdapter);
        return projectionSupport.wrapIntoExecutable();
    }

    public Set<C> selectAll() {
        return (Set)this.selectWhere().execute(Accumulators.toSet());
    }

    public boolean isNew(C entity) {
        return this.persister.isNew(entity);
    }

    public Class<C> getClassToPersist() {
        return this.persister.getClassToPersist();
    }

    @Override
    public void registerRelation(ValueAccessPoint<C> relation, ConfiguredRelationalPersister<?, ?> persister) {
        this.criteriaSupport.registerRelation(relation, persister);
    }

    @Override
    public <SRC, T1 extends Table<T1>, T2 extends Table<T2>, SRCID, JOINID> String joinAsOne(RelationalEntityPersister<SRC, SRCID> sourcePersister, Accessor<SRC, C> propertyAccessor, Key<T1, JOINID> leftColumn, Key<T2, JOINID> rightColumn, String rightTableAlias, BeanRelationFixer<SRC, C> beanRelationFixer, boolean optional, boolean loadSeparately) {
        EntityInflater.EntityMappingAdapter<C, I, T> strategy = new EntityInflater.EntityMappingAdapter<C, I, T>(this.getMapping());
        String createdJoinNodeName = sourcePersister.getEntityJoinTree().addRelationJoin("ROOT", strategy, propertyAccessor, leftColumn, rightColumn, rightTableAlias, optional ? EntityJoinTree.JoinType.OUTER : EntityJoinTree.JoinType.INNER, beanRelationFixer, Collections.emptySet());
        this.copyRootJoinsTo(sourcePersister.getEntityJoinTree(), createdJoinNodeName);
        return createdJoinNodeName;
    }

    @Override
    public <SRC, T1 extends Table<T1>, T2 extends Table<T2>, SRCID, JOINID> String joinAsMany(String joinName, RelationalEntityPersister<SRC, SRCID> sourcePersister, Accessor<SRC, ?> propertyAccessor, Key<T1, JOINID> leftColumn, Key<T2, JOINID> rightColumn, BeanRelationFixer<SRC, C> beanRelationFixer, @Nullable Function<ColumnedRow, Object> relationIdentifierProvider, Set<? extends Column<T2, ?>> selectableColumns, boolean optional, boolean loadSeparately) {
        String createdJoinNodeName = sourcePersister.getEntityJoinTree().addRelationJoin(joinName, new EntityInflater.EntityMappingAdapter<C, I, T>(this.getMapping()), propertyAccessor, leftColumn, rightColumn, null, optional ? EntityJoinTree.JoinType.OUTER : EntityJoinTree.JoinType.INNER, beanRelationFixer, selectableColumns, relationIdentifierProvider);
        this.copyRootJoinsTo(sourcePersister.getEntityJoinTree(), createdJoinNodeName);
        return createdJoinNodeName;
    }

    @Override
    public <E, ID> void copyRootJoinsTo(EntityJoinTree<E, ID> entityJoinTree, String joinName) {
        this.getEntityJoinTree().projectTo(entityJoinTree, joinName);
    }

    protected void doPersist(Iterable<? extends C> entities) {
        this.persistExecutor.persist(entities);
    }

    protected Set<C> doSelect(Iterable<I> ids) {
        this.LOGGER.debug("selecting entities {}", ids);
        return this.selectGraphExecutor.select(ids);
    }

    public void doDelete(Iterable<? extends C> entities) {
        this.persister.delete(entities);
    }

    public void doDeleteById(Iterable<? extends C> entities) {
        this.persister.deleteById(entities);
    }

    public void doInsert(Iterable<? extends C> entities) {
        this.persister.insert(entities);
    }

    public void doUpdateById(Iterable<? extends C> entities) {
        this.persister.updateById(entities);
    }

    public void doUpdate(Iterable<? extends Duo<C, C>> differencesIterable, boolean allColumnsStatement) {
        this.persister.update(differencesIterable, allColumnsStatement);
    }
}

