/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.runtime;

import java.sql.ResultSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.codefilarete.reflection.Accessor;
import org.codefilarete.reflection.AccessorChain;
import org.codefilarete.stalactite.engine.runtime.AbstractPolymorphismPersister;
import org.codefilarete.stalactite.engine.runtime.ColumnCloneAwareOrderBy;
import org.codefilarete.stalactite.engine.runtime.ConfiguredRelationalPersister;
import org.codefilarete.stalactite.engine.runtime.EntityCriteriaSupport;
import org.codefilarete.stalactite.engine.runtime.load.EntityJoinTree;
import org.codefilarete.stalactite.engine.runtime.load.EntityTreeInflater;
import org.codefilarete.stalactite.engine.runtime.load.EntityTreeQueryBuilder;
import org.codefilarete.stalactite.mapping.AccessorWrapperIdAccessor;
import org.codefilarete.stalactite.mapping.EntityMapping;
import org.codefilarete.stalactite.query.ConfiguredEntityCriteria;
import org.codefilarete.stalactite.query.EntityFinder;
import org.codefilarete.stalactite.query.builder.QuerySQLBuilderFactory;
import org.codefilarete.stalactite.query.model.ConditionalOperator;
import org.codefilarete.stalactite.query.model.CriteriaChain;
import org.codefilarete.stalactite.query.model.LimitAware;
import org.codefilarete.stalactite.query.model.Operators;
import org.codefilarete.stalactite.query.model.OrderByChain;
import org.codefilarete.stalactite.query.model.Query;
import org.codefilarete.stalactite.query.model.Select;
import org.codefilarete.stalactite.query.model.Selectable;
import org.codefilarete.stalactite.sql.ConnectionProvider;
import org.codefilarete.stalactite.sql.Dialect;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.stalactite.sql.result.Accumulator;
import org.codefilarete.stalactite.sql.result.ColumnedRow;
import org.codefilarete.stalactite.sql.result.ColumnedRowIterator;
import org.codefilarete.stalactite.sql.statement.PreparedSQL;
import org.codefilarete.stalactite.sql.statement.ReadOperation;
import org.codefilarete.stalactite.sql.statement.SQLExecutionException;
import org.codefilarete.stalactite.sql.statement.SQLStatement;
import org.codefilarete.stalactite.sql.statement.binder.ResultSetReader;
import org.codefilarete.stalactite.sql.statement.binder.ResultSetReaderRegistry;
import org.codefilarete.tool.collection.Iterables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPolymorphicEntityFinder<C, I, T extends Table<T>>
implements EntityFinder<C, I> {
    protected final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    protected final EntityJoinTree<C, I> mainEntityJoinTree;
    protected final Map<Class<C>, ConfiguredRelationalPersister<C, I>> persisterPerSubclass;
    protected final ConnectionProvider connectionProvider;
    protected final Dialect dialect;
    protected final boolean hasSubPolymorphicPersister;
    private final AccessorChain<C, I> entityIdAccessor;
    private final EntityMapping<C, I, T> mainMapping;

    protected AbstractPolymorphicEntityFinder(ConfiguredRelationalPersister<C, I> mainPersister, Map<? extends Class<C>, ? extends ConfiguredRelationalPersister<C, I>> persisterPerSubclass, ConnectionProvider connectionProvider, Dialect dialect) {
        this.mainEntityJoinTree = mainPersister.getEntityJoinTree();
        this.persisterPerSubclass = persisterPerSubclass;
        this.connectionProvider = connectionProvider;
        this.dialect = dialect;
        this.hasSubPolymorphicPersister = Iterables.find(persisterPerSubclass.values(), subPersister -> subPersister instanceof AbstractPolymorphismPersister) != null;
        this.mainMapping = mainPersister.getMapping();
        AccessorWrapperIdAccessor idAccessor = (AccessorWrapperIdAccessor)this.mainMapping.getIdMapping().getIdAccessor();
        this.entityIdAccessor = new AccessorChain(new Accessor[]{idAccessor.getIdAccessor()});
    }

    @Override
    public Set<C> select(ConfiguredEntityCriteria where, Consumer<OrderByChain<?>> orderByClauseConsumer, Consumer<LimitAware<?>> limitAwareConsumer, Map<String, Object> valuesPerParam) {
        if (where.hasCollectionCriteria()) {
            return this.selectIn2Phases(where, orderByClauseConsumer, limitAwareConsumer);
        }
        return this.selectWithSingleQuery(where, orderByClauseConsumer, limitAwareConsumer);
    }

    public abstract Set<C> selectIn2Phases(ConfiguredEntityCriteria var1, Consumer<OrderByChain<?>> var2, Consumer<LimitAware<?>> var3);

    public abstract Set<C> selectWithSingleQuery(ConfiguredEntityCriteria var1, Consumer<OrderByChain<?>> var2, Consumer<LimitAware<?>> var3);

    protected EntityCriteriaSupport<C> newWhereIdClause(Iterable<I> ids) {
        return new EntityCriteriaSupport<C>(this.mainMapping).and((AccessorChain)this.entityIdAccessor, (ConditionalOperator)Operators.in(ids));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Set<C> selectWithSingleQuery(ConfiguredEntityCriteria where, Consumer<OrderByChain<?>> orderByClauseConsumer, Consumer<LimitAware<?>> limitAwareConsumer, EntityJoinTree<C, I> entityJoinTree, Dialect dialect, ConnectionProvider connectionProvider) {
        EntityTreeQueryBuilder.EntityTreeQuery<C> entityTreeQuery = new EntityTreeQueryBuilder<C>(entityJoinTree, (ResultSetReaderRegistry)dialect.getColumnBinderRegistry()).buildSelectQuery();
        Query query = entityTreeQuery.getQuery();
        orderByClauseConsumer.accept(new ColumnCloneAwareOrderBy(query.orderBy(), entityTreeQuery.getColumnClones()));
        limitAwareConsumer.accept((LimitAware<?>)query.orderBy());
        QuerySQLBuilderFactory.QuerySQLBuilder sqlQueryBuilder = dialect.getQuerySQLBuilderFactory().queryBuilder(query, where.getCriteria(), entityTreeQuery.getColumnClones());
        EntityTreeInflater<C> inflater = entityTreeQuery.getInflater();
        PreparedSQL preparedSQL = sqlQueryBuilder.toPreparableSQL().toPreparedSQL(new HashMap());
        try (ReadOperation readOperation = dialect.getReadOperationFactory().createInstance((SQLStatement)preparedSQL, connectionProvider);){
            ResultSet resultSet = readOperation.execute();
            ColumnedRowIterator rowIterator = new ColumnedRowIterator(resultSet, entityTreeQuery.getSelectParameterBinders(), entityTreeQuery.getColumnAliases());
            Set<C> set = inflater.transform(() -> AbstractPolymorphicEntityFinder.lambda$selectWithSingleQuery$1((Iterator)rowIterator), 50);
            return set;
        }
        catch (RuntimeException e) {
            throw new SQLExecutionException(preparedSQL.getSQL(), (Throwable)e);
        }
    }

    @Override
    public <R, O> R selectProjection(Consumer<Select> selectAdapter, Accumulator<? super Function<Selectable<O>, O>, Object, R> accumulator, CriteriaChain where, boolean distinct, Consumer<OrderByChain<?>> orderByClauseConsumer, Consumer<LimitAware<?>> limitAwareConsumer) {
        EntityTreeQueryBuilder.EntityTreeQuery<C> entityTreeQuery = new EntityTreeQueryBuilder<C>(this.mainEntityJoinTree, (ResultSetReaderRegistry)this.dialect.getColumnBinderRegistry()).buildSelectQuery();
        Query query = entityTreeQuery.getQuery();
        query.getSelectDelegate().setDistinct(distinct);
        QuerySQLBuilderFactory.QuerySQLBuilder sqlQueryBuilder = this.dialect.getQuerySQLBuilderFactory().queryBuilder(query, (Iterable)where, entityTreeQuery.getColumnClones());
        selectAdapter.accept(query.getSelectDelegate());
        Map columnReaders = Iterables.map((Iterable)query.getColumns(), Function.identity(), selectable -> this.dialect.getColumnBinderRegistry().getBinder(selectable.getJavaType()));
        PreparedSQL preparedSQL = sqlQueryBuilder.toPreparableSQL().toPreparedSQL(new HashMap());
        return this.readProjection(preparedSQL, columnReaders, query.getAliases(), accumulator);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected <R, O> R readProjection(PreparedSQL preparedSQL, Map<Selectable<?>, ResultSetReader<?>> columnReaders, Map<Selectable<?>, String> aliases, Accumulator<? super Function<Selectable<O>, O>, Object, R> accumulator) {
        try (ReadOperation closeableOperation = this.dialect.getReadOperationFactory().createInstance((SQLStatement)preparedSQL, this.connectionProvider);){
            ColumnedRowIterator rowIterator = new ColumnedRowIterator(closeableOperation.execute(), columnReaders, aliases);
            Object object = accumulator.collect((Iterable)Iterables.stream((Iterator)rowIterator).map(row -> arg_0 -> ((ColumnedRow)row).get(arg_0)).collect(Collectors.toList()));
            return (R)object;
        }
        catch (RuntimeException e) {
            throw new SQLExecutionException(preparedSQL.getSQL(), (Throwable)e);
        }
    }

    private static /* synthetic */ Iterator lambda$selectWithSingleQuery$1(Iterator rowIterator) {
        return rowIterator;
    }
}

