/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.runtime.load;

import javax.annotation.Nullable;
import org.codefilarete.stalactite.engine.runtime.load.AbstractJoinNode;
import org.codefilarete.stalactite.engine.runtime.load.EntityJoinTree;
import org.codefilarete.stalactite.engine.runtime.load.EntityMerger;
import org.codefilarete.stalactite.engine.runtime.load.JoinNode;
import org.codefilarete.stalactite.engine.runtime.load.JoinRowConsumer;
import org.codefilarete.stalactite.mapping.RowTransformer;
import org.codefilarete.stalactite.query.model.Fromable;
import org.codefilarete.stalactite.sql.ddl.structure.Key;
import org.codefilarete.stalactite.sql.result.ColumnedRow;
import org.codefilarete.tool.Reflections;

public class MergeJoinNode<C, T1 extends Fromable, T2 extends Fromable, I>
extends AbstractJoinNode<C, T1, T2, I> {
    private final EntityMerger<C> merger;

    public MergeJoinNode(JoinNode<?, T1> parent, Key<T1, I> leftJoinColumn, Key<T2, I> rightJoinColumn, EntityJoinTree.JoinType joinType, @Nullable String tableAlias, EntityMerger<C> merger) {
        super(parent, leftJoinColumn, rightJoinColumn, joinType, merger.getSelectableColumns(), tableAlias);
        this.merger = merger;
    }

    public EntityMerger<C> getMerger() {
        return this.merger;
    }

    public MergeJoinRowConsumer<C> toConsumer(JoinNode<C, T2> joinNode) {
        return new MergeJoinRowConsumer<C>((MergeJoinNode)joinNode, this.merger.getRowTransformer());
    }

    public static class MergeJoinRowConsumer<C>
    implements JoinRowConsumer {
        private final MergeJoinNode<C, ?, ?, ?> node;
        protected final RowTransformer<C> merger;

        public MergeJoinRowConsumer(MergeJoinNode<C, ?, ?, ?> node, RowTransformer<C> merger) {
            this.node = node;
            this.merger = merger;
        }

        public MergeJoinNode<C, ?, ?, ?> getNode() {
            return this.node;
        }

        void mergeProperties(C parentJoinEntity, ColumnedRow row) {
            this.merger.applyRowToBean(row, parentJoinEntity);
        }

        public String toString() {
            return Reflections.toString(this.getClass());
        }
    }
}

