/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.configurer.elementcollection;

import org.codefilarete.reflection.PropertyAccessor;

public class ElementRecord<TRGT, ID> {
    static final PropertyAccessor<ElementRecord<Object, Object>, Object> IDENTIFIER_ACCESSOR = PropertyAccessor.fromMethodReference(ElementRecord::getId, ElementRecord::setId);
    static final PropertyAccessor<ElementRecord<Object, Object>, Object> ELEMENT_ACCESSOR = PropertyAccessor.fromMethodReference(ElementRecord::getElement, ElementRecord::setElement);
    private ID id;
    private TRGT element;
    private boolean persisted = false;

    public ElementRecord() {
    }

    public ElementRecord(ID id, TRGT element) {
        this.setId(id);
        this.element = element;
    }

    public boolean isNew() {
        return !this.persisted;
    }

    public boolean isPersisted() {
        return this.persisted;
    }

    public void markAsPersisted() {
        this.persisted = true;
    }

    public ElementRecord<TRGT, ID> setPersisted(boolean persisted) {
        this.persisted = persisted;
        return this;
    }

    public ID getId() {
        return this.id;
    }

    public void setId(ID id) {
        this.id = id;
        this.persisted = true;
    }

    public TRGT getElement() {
        return this.element;
    }

    public void setElement(TRGT element) {
        this.element = element;
    }

    public int footprint() {
        int result = this.id.hashCode();
        result = 31 * result + this.element.hashCode();
        return result;
    }
}

