/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.stream.Stream;
import javax.sql.DataSource;
import org.assertj.core.api.AbstractCollectionAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.codefilarete.stalactite.engine.CascadeOptions;
import org.codefilarete.stalactite.engine.ColumnOptions;
import org.codefilarete.stalactite.engine.EmbeddableMappingConfigurationProvider;
import org.codefilarete.stalactite.engine.EntityMappingConfigurationProvider;
import org.codefilarete.stalactite.engine.EntityPersister;
import org.codefilarete.stalactite.engine.FluentEmbeddableMappingBuilder;
import org.codefilarete.stalactite.engine.FluentEntityMappingBuilder;
import org.codefilarete.stalactite.engine.JdbcForeignKey;
import org.codefilarete.stalactite.engine.MappingEase;
import org.codefilarete.stalactite.engine.PartialRepresentation;
import org.codefilarete.stalactite.engine.PersistenceContext;
import org.codefilarete.stalactite.engine.PolymorphismPolicy;
import org.codefilarete.stalactite.engine.SubEntityMappingConfigurationProvider;
import org.codefilarete.stalactite.engine.idprovider.LongProvider;
import org.codefilarete.stalactite.engine.listener.DeleteListener;
import org.codefilarete.stalactite.engine.listener.InsertListener;
import org.codefilarete.stalactite.engine.listener.PersistListener;
import org.codefilarete.stalactite.engine.listener.SelectListener;
import org.codefilarete.stalactite.engine.listener.UpdateListener;
import org.codefilarete.stalactite.engine.model.AbstractVehicle;
import org.codefilarete.stalactite.engine.model.Car;
import org.codefilarete.stalactite.engine.model.City;
import org.codefilarete.stalactite.engine.model.Color;
import org.codefilarete.stalactite.engine.model.Country;
import org.codefilarete.stalactite.engine.model.Engine;
import org.codefilarete.stalactite.engine.model.Person;
import org.codefilarete.stalactite.engine.model.Timestamp;
import org.codefilarete.stalactite.engine.model.Town;
import org.codefilarete.stalactite.engine.model.Truck;
import org.codefilarete.stalactite.engine.model.Vehicle;
import org.codefilarete.stalactite.engine.model.Village;
import org.codefilarete.stalactite.id.AbstractIdentifier;
import org.codefilarete.stalactite.id.Identifier;
import org.codefilarete.stalactite.id.PersistableIdentifier;
import org.codefilarete.stalactite.id.PersistedIdentifier;
import org.codefilarete.stalactite.id.StatefulIdentifierAlreadyAssignedIdentifierPolicy;
import org.codefilarete.stalactite.query.model.ConditionalOperator;
import org.codefilarete.stalactite.query.model.Operators;
import org.codefilarete.stalactite.sql.ConnectionProvider;
import org.codefilarete.stalactite.sql.Dialect;
import org.codefilarete.stalactite.sql.HSQLDBDialectBuilder;
import org.codefilarete.stalactite.sql.ddl.DDLDeployer;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.stalactite.sql.result.Accumulators;
import org.codefilarete.stalactite.sql.result.ResultSetIterator;
import org.codefilarete.stalactite.sql.statement.binder.DefaultParameterBinders;
import org.codefilarete.stalactite.sql.statement.binder.LambdaParameterBinder;
import org.codefilarete.stalactite.sql.statement.binder.NullAwareParameterBinder;
import org.codefilarete.stalactite.sql.statement.binder.ParameterBinder;
import org.codefilarete.stalactite.sql.test.HSQLDBInMemoryDataSource;
import org.codefilarete.tool.Duo;
import org.codefilarete.tool.Nullable;
import org.codefilarete.tool.StringAppender;
import org.codefilarete.tool.collection.Arrays;
import org.codefilarete.tool.collection.Iterables;
import org.codefilarete.tool.function.Functions;
import org.codefilarete.trace.ObjectPrinterBuilder;
import org.danekja.java.util.function.serializable.SerializableFunction;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

class FluentEntityMappingConfigurationSupportPolymorphismWithRelationTest {
    private static final Dialect DIALECT = HSQLDBDialectBuilder.defaultHSQLDBDialect();
    private PersistenceContext persistenceContext;

    FluentEntityMappingConfigurationSupportPolymorphismWithRelationTest() {
    }

    @BeforeAll
    static void initBinders() {
        DIALECT.getColumnBinderRegistry().register(Identifier.class, Identifier.identifierBinder(DefaultParameterBinders.LONG_PRIMITIVE_BINDER));
        DIALECT.getSqlTypeRegistry().put(Identifier.class, "int");
        DIALECT.getColumnBinderRegistry().register(Color.class, (ParameterBinder)new NullAwareParameterBinder((ParameterBinder)new LambdaParameterBinder(DefaultParameterBinders.INTEGER_PRIMITIVE_BINDER, Color::new, Color::getRgb)));
        DIALECT.getSqlTypeRegistry().put(Color.class, "int");
    }

    @BeforeEach
    public void beforeTest() {
        this.persistenceContext = new PersistenceContext((DataSource)new HSQLDBInMemoryDataSource(), DIALECT);
    }

    static Object[][] polymorphicOneToOne_data() {
        PersistenceContext persistenceContext1 = new PersistenceContext((DataSource)new HSQLDBInMemoryDataSource(), DIALECT);
        PersistenceContext persistenceContext2 = new PersistenceContext((DataSource)new HSQLDBInMemoryDataSource(), DIALECT);
        PersistenceContext persistenceContext3 = new PersistenceContext((DataSource)new HSQLDBInMemoryDataSource(), DIALECT);
        Object[][] result = new Object[][]{{"single table", MappingEase.entityBuilder(Vehicle.class, Identifier.LONG_TYPE).mapKey(AbstractVehicle::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).mapOneToOne(Vehicle::getEngine, (EntityMappingConfigurationProvider)MappingEase.entityBuilder(Engine.class, Identifier.LONG_TYPE).mapKey(Engine::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED)).mapPolymorphism((PolymorphismPolicy)PolymorphismPolicy.singleTable().addSubClass((SubEntityMappingConfigurationProvider)MappingEase.subentityBuilder(Car.class).map(Car::getModel), (Object)"CAR").addSubClass((SubEntityMappingConfigurationProvider)MappingEase.subentityBuilder(Truck.class).map(Vehicle::getColor), (Object)"TRUCK")).build(persistenceContext1), persistenceContext1.getConnectionProvider()}, {"joined tables", MappingEase.entityBuilder(Vehicle.class, Identifier.LONG_TYPE).mapKey(AbstractVehicle::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).mapOneToOne(Vehicle::getEngine, (EntityMappingConfigurationProvider)MappingEase.entityBuilder(Engine.class, Identifier.LONG_TYPE).mapKey(Engine::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED)).mapPolymorphism((PolymorphismPolicy)PolymorphismPolicy.joinTable().addSubClass((SubEntityMappingConfigurationProvider)MappingEase.subentityBuilder(Car.class).map(Car::getModel)).addSubClass((SubEntityMappingConfigurationProvider)MappingEase.subentityBuilder(Truck.class).map(Vehicle::getColor))).build(persistenceContext2), persistenceContext2.getConnectionProvider()}, {"table per class", MappingEase.entityBuilder(Vehicle.class, Identifier.LONG_TYPE).mapKey(AbstractVehicle::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).mapOneToOne(Vehicle::getEngine, (EntityMappingConfigurationProvider)MappingEase.entityBuilder(Engine.class, Identifier.LONG_TYPE).mapKey(Engine::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED)).mapPolymorphism((PolymorphismPolicy)PolymorphismPolicy.tablePerClass().addSubClass((SubEntityMappingConfigurationProvider)MappingEase.subentityBuilder(Car.class).map(Car::getModel)).addSubClass((SubEntityMappingConfigurationProvider)MappingEase.subentityBuilder(Truck.class).map(Vehicle::getColor))).build(persistenceContext3), persistenceContext3.getConnectionProvider()}};
        new DDLDeployer(persistenceContext1).deployDDL();
        new DDLDeployer(persistenceContext2).deployDDL();
        new DDLDeployer(persistenceContext3).deployDDL();
        return result;
    }

    @ParameterizedTest(name="{0}")
    @MethodSource(value={"polymorphicOneToOne_data"})
    void crudPolymorphicOneToOne(String testDisplayName, EntityPersister<AbstractVehicle, Identifier<Long>> persister, ConnectionProvider connectionProvider) throws SQLException {
        Car dummyCar = new Car(1L);
        dummyCar.setModel("Renault");
        dummyCar.setEngine(new Engine(100L));
        Truck dummyTruck = new Truck(2L);
        dummyTruck.setColor(new Color(42));
        persister.insert((Iterable)Arrays.asList((Object[])new Vehicle[]{dummyCar, dummyTruck}));
        Car dummyCarModified = new Car(1L);
        dummyCarModified.setModel("Peugeot");
        dummyCarModified.setEngine(new Engine(200L));
        Truck dummyTruckModified = new Truck(2L);
        dummyTruckModified.setColor(new Color(99));
        persister.update((Object)dummyCarModified, (Object)dummyCar, true);
        persister.update((Object)dummyTruckModified, (Object)dummyTruck, true);
        connectionProvider.giveConnection().commit();
        persister.delete((Object)dummyCarModified);
        persister.delete((Object)dummyTruckModified);
        connectionProvider.giveConnection().rollback();
        persister.delete((Iterable)Arrays.asList((Object[])new Vehicle[]{dummyCarModified, dummyTruckModified}));
        connectionProvider.giveConnection().rollback();
        Assertions.assertThat((Object)persister.select(dummyTruck.getId())).isEqualTo((Object)dummyTruckModified);
        Assertions.assertThat((Object)persister.select(dummyCar.getId())).isEqualTo((Object)dummyCarModified);
        Assertions.assertThat(new HashSet(persister.select((Iterable)Arrays.asSet((Object[])new Identifier[]{dummyCar.getId(), dummyTruck.getId()})))).isEqualTo((Object)Arrays.asSet((Object[])new Vehicle[]{dummyCarModified, dummyTruckModified}));
    }

    static Object[][] polymorphism_trunkHasOneToMany_data() {
        PersistenceContext persistenceContext1 = new PersistenceContext((DataSource)new HSQLDBInMemoryDataSource(), DIALECT);
        PersistenceContext persistenceContext2 = new PersistenceContext((DataSource)new HSQLDBInMemoryDataSource(), DIALECT);
        PersistenceContext persistenceContext3 = new PersistenceContext((DataSource)new HSQLDBInMemoryDataSource(), DIALECT);
        FluentEntityMappingBuilder.FluentMappingBuilderPropertyOptions personMappingBuilder = MappingEase.entityBuilder(Person.class, Identifier.LONG_TYPE).mapKey(Person::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Person::getName);
        FluentEntityMappingBuilder.FluentMappingBuilderPropertyOptions cityMappingBuilder = MappingEase.entityBuilder(City.class, Identifier.LONG_TYPE).mapKey(City::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(City::getName);
        Object[][] result = new Object[][]{{"single table", MappingEase.entityBuilder(Country.class, Identifier.LONG_TYPE).mapKey(Country::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Country::getName).map(Country::getDescription).mapOneToOne(Country::getPresident, (EntityMappingConfigurationProvider)personMappingBuilder).mapOneToMany(Country::getCities, (EntityMappingConfigurationProvider)cityMappingBuilder).mappedBy(City::setCountry).mapPolymorphism((PolymorphismPolicy)PolymorphismPolicy.singleTable().addSubClass((SubEntityMappingConfigurationProvider)MappingEase.subentityBuilder(Republic.class).map(Republic::getDeputeCount), (Object)"Republic")).build(persistenceContext1)}, {"joined tables", MappingEase.entityBuilder(Country.class, Identifier.LONG_TYPE).mapKey(Country::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Country::getName).map(Country::getDescription).mapOneToOne(Country::getPresident, (EntityMappingConfigurationProvider)personMappingBuilder).mapOneToMany(Country::getCities, (EntityMappingConfigurationProvider)cityMappingBuilder).mappedBy(City::setCountry).mapPolymorphism((PolymorphismPolicy)PolymorphismPolicy.joinTable().addSubClass((SubEntityMappingConfigurationProvider)MappingEase.subentityBuilder(Republic.class).map(Republic::getDeputeCount))).build(persistenceContext2)}, {"table per class", MappingEase.entityBuilder(Country.class, Identifier.LONG_TYPE).mapKey(Country::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Country::getName).map(Country::getDescription).mapOneToOne(Country::getPresident, (EntityMappingConfigurationProvider)personMappingBuilder).mapOneToMany(Country::getCities, (EntityMappingConfigurationProvider)cityMappingBuilder).mappedBy(City::setCountry).mapPolymorphism((PolymorphismPolicy)PolymorphismPolicy.tablePerClass().addSubClass((SubEntityMappingConfigurationProvider)MappingEase.subentityBuilder(Republic.class).map(Republic::getDeputeCount))).build(persistenceContext3)}};
        new DDLDeployer(persistenceContext1).deployDDL();
        new DDLDeployer(persistenceContext2).deployDDL();
        new DDLDeployer(persistenceContext3).deployDDL();
        return result;
    }

    @ParameterizedTest(name="{0}")
    @MethodSource(value={"polymorphism_trunkHasOneToMany_data"})
    void crud_polymorphism_trunkHasOneToMany(String testDisplayName, EntityPersister<Country, Identifier<Long>> countryPersister) {
        LongProvider countryIdProvider = new LongProvider();
        Republic dummyCountry = new Republic(new PersistableIdentifier<Object>(countryIdProvider.giveNewIdentifier()));
        dummyCountry.setDeputeCount(250);
        dummyCountry.setName("France");
        Person person = new Person((Long)new LongProvider().giveNewIdentifier());
        person.setName("French president");
        dummyCountry.setPresident(person);
        LongProvider cityIdentifierProvider = new LongProvider();
        City capital = new City((Long)cityIdentifierProvider.giveNewIdentifier());
        capital.setName("Paris");
        dummyCountry.addCity(capital);
        countryPersister.insert((Object)dummyCountry);
        Republic persistedCountry = (Republic)countryPersister.select(dummyCountry.getId());
        Assertions.assertThat(persistedCountry.getId()).isEqualTo(new PersistedIdentifier<Long>(0L));
        Assertions.assertThat((String)persistedCountry.getPresident().getName()).isEqualTo("French president");
        Assertions.assertThat((String)((City)Iterables.first(persistedCountry.getCities())).getName()).isEqualTo("Paris");
        Assertions.assertThat((int)persistedCountry.getDeputeCount()).isEqualTo(250);
        Assertions.assertThat((boolean)persistedCountry.getPresident().getId().isPersisted()).isTrue();
        Assertions.assertThat((boolean)((City)Iterables.first(persistedCountry.getCities())).getId().isPersisted()).isTrue();
        persistedCountry.getPresident().setName("New french president");
        City grenoble = new City((Long)cityIdentifierProvider.giveNewIdentifier());
        grenoble.setName("Grenoble");
        persistedCountry.addCity(grenoble);
        countryPersister.update((Object)persistedCountry, (Object)dummyCountry, true);
        persistedCountry = (Republic)countryPersister.select(dummyCountry.getId());
        Assertions.assertThat(persistedCountry.getId()).isEqualTo(new PersistedIdentifier<Long>(0L));
        Assertions.assertThat((String)persistedCountry.getPresident().getName()).isEqualTo("New french president");
        Assertions.assertThat(persistedCountry.getCities()).extracting(City::getName).containsExactlyInAnyOrder((Object[])new String[]{"Grenoble", "Paris"});
        Assertions.assertThat((boolean)persistedCountry.getPresident().getId().isPersisted()).isTrue();
        Assertions.assertThat((boolean)((City)Iterables.first(persistedCountry.getCities())).getId().isPersisted()).isTrue();
    }

    static Object[][] polymorphism_subClassHasOneToOne_data() {
        PersistenceContext persistenceContext1 = new PersistenceContext((DataSource)new HSQLDBInMemoryDataSource(), DIALECT);
        PersistenceContext persistenceContext2 = new PersistenceContext((DataSource)new HSQLDBInMemoryDataSource(), DIALECT);
        PersistenceContext persistenceContext3 = new PersistenceContext((DataSource)new HSQLDBInMemoryDataSource(), DIALECT);
        Object[][] result = new Object[][]{{"single table / one-to-one with mapped association", MappingEase.entityBuilder(Vehicle.class, Identifier.LONG_TYPE).mapKey(AbstractVehicle::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).mapOneToOne(Vehicle::getEngine, (EntityMappingConfigurationProvider)MappingEase.entityBuilder(Engine.class, Identifier.LONG_TYPE).mapKey(Engine::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED)).mapPolymorphism((PolymorphismPolicy)PolymorphismPolicy.singleTable().addSubClass((SubEntityMappingConfigurationProvider)MappingEase.subentityBuilder(Car.class).map(Car::getModel).mapOneToOne(Car::getRadio, (EntityMappingConfigurationProvider)MappingEase.entityBuilder(Car.Radio.class, String.class).mapKey(Car.Radio::getSerialNumber, (ColumnOptions.IdentifierPolicy)ColumnOptions.IdentifierPolicy.alreadyAssigned(Car.Radio::markAsPersisted, Car.Radio::isPersisted)).map(Car.Radio::getModel)).mappedBy(Car.AbstractRadio::getCar), (Object)"CAR").addSubClass((SubEntityMappingConfigurationProvider)MappingEase.subentityBuilder(Truck.class).map(Vehicle::getColor), (Object)"TRUCK")).build(persistenceContext1), persistenceContext1.getConnectionProvider()}, {"joined tables / one-to-one with mapped association", MappingEase.entityBuilder(Vehicle.class, Identifier.LONG_TYPE).mapKey(AbstractVehicle::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).mapPolymorphism((PolymorphismPolicy)PolymorphismPolicy.joinTable().addSubClass((SubEntityMappingConfigurationProvider)MappingEase.subentityBuilder(Car.class).map(Car::getModel).mapOneToOne(Car::getRadio, (EntityMappingConfigurationProvider)MappingEase.entityBuilder(Car.Radio.class, String.class).mapKey(Car.Radio::getSerialNumber, (ColumnOptions.IdentifierPolicy)ColumnOptions.IdentifierPolicy.alreadyAssigned(Car.Radio::markAsPersisted, Car.Radio::isPersisted)).map(Car.Radio::getModel)).mappedBy(Car.AbstractRadio::getCar)).addSubClass((SubEntityMappingConfigurationProvider)MappingEase.subentityBuilder(Truck.class).map(Vehicle::getColor))).build(persistenceContext2), persistenceContext2.getConnectionProvider()}, {"table per class / one-to-one with mapped association", MappingEase.entityBuilder(Vehicle.class, Identifier.LONG_TYPE).mapKey(AbstractVehicle::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).mapPolymorphism((PolymorphismPolicy)PolymorphismPolicy.tablePerClass().addSubClass((SubEntityMappingConfigurationProvider)MappingEase.subentityBuilder(Car.class).map(Car::getModel).mapOneToOne(Car::getRadio, (EntityMappingConfigurationProvider)MappingEase.entityBuilder(Car.Radio.class, String.class).mapKey(Car.Radio::getSerialNumber, (ColumnOptions.IdentifierPolicy)ColumnOptions.IdentifierPolicy.alreadyAssigned(Car.Radio::markAsPersisted, Car.Radio::isPersisted)).map(Car.Radio::getModel)).mappedBy(Car.AbstractRadio::getCar)).addSubClass((SubEntityMappingConfigurationProvider)MappingEase.subentityBuilder(Truck.class).map(Vehicle::getColor))).build(persistenceContext3), persistenceContext3.getConnectionProvider()}};
        new DDLDeployer(persistenceContext1).deployDDL();
        new DDLDeployer(persistenceContext2).deployDDL();
        new DDLDeployer(persistenceContext3).deployDDL();
        return result;
    }

    @ParameterizedTest(name="{0}")
    @MethodSource(value={"polymorphism_subClassHasOneToOne_data"})
    void crud_polymorphism_subClassHasOneToOne(String testDisplayName, EntityPersister<AbstractVehicle, Identifier<Long>> persister, ConnectionProvider connectionProvider) throws SQLException {
        Car dummyCar = new Car(1L);
        dummyCar.setModel("Renault");
        dummyCar.setRadio(new Car.Radio("XYZ-ABC-01"));
        Truck dummyTruck = new Truck(2L);
        dummyTruck.setColor(new Color(42));
        persister.insert((Iterable)Arrays.asList((Object[])new Vehicle[]{dummyCar, dummyTruck}));
        Car dummyCarModified = new Car(1L);
        dummyCarModified.setModel("Peugeot");
        dummyCarModified.setRadio(new Car.Radio("XYZ-ABC-02"));
        Truck dummyTruckModified = new Truck(2L);
        dummyTruckModified.setColor(new Color(99));
        persister.update((Object)dummyCarModified, (Object)dummyCar, true);
        persister.update((Object)dummyTruckModified, (Object)dummyTruck, true);
        connectionProvider.giveConnection().commit();
        persister.delete((Object)dummyCarModified);
        persister.delete((Object)dummyTruckModified);
        connectionProvider.giveConnection().rollback();
        persister.delete((Iterable)Arrays.asList((Object[])new Vehicle[]{dummyCarModified, dummyTruckModified}));
        connectionProvider.giveConnection().rollback();
        Assertions.assertThat((Object)persister.select(dummyTruck.getId())).isEqualTo((Object)dummyTruckModified);
        AbstractVehicle selectedCar = (AbstractVehicle)persister.select(dummyCar.getId());
        Assertions.assertThat((Object)selectedCar).isEqualTo((Object)dummyCarModified);
        Assertions.assertThat((boolean)((Car)selectedCar).getRadio().isPersisted()).isTrue();
        Assertions.assertThat((Object)((Car)selectedCar).getRadio()).isEqualTo((Object)dummyCarModified.getRadio());
        Assertions.assertThat(new HashSet(persister.select((Iterable)Arrays.asSet((Object[])new Identifier[]{dummyCar.getId(), dummyTruck.getId()})))).isEqualTo((Object)Arrays.asSet((Object[])new Vehicle[]{dummyCarModified, dummyTruckModified}));
    }

    static Object[][] polymorphism_subClassHasOneToMany_data() {
        PersistenceContext persistenceContext1 = new PersistenceContext((DataSource)new HSQLDBInMemoryDataSource(), DIALECT);
        PersistenceContext persistenceContext2 = new PersistenceContext((DataSource)new HSQLDBInMemoryDataSource(), DIALECT);
        PersistenceContext persistenceContext3 = new PersistenceContext((DataSource)new HSQLDBInMemoryDataSource(), DIALECT);
        PersistenceContext persistenceContext4 = new PersistenceContext((DataSource)new HSQLDBInMemoryDataSource(), DIALECT);
        PersistenceContext persistenceContext5 = new PersistenceContext((DataSource)new HSQLDBInMemoryDataSource(), DIALECT);
        PersistenceContext persistenceContext6 = new PersistenceContext((DataSource)new HSQLDBInMemoryDataSource(), DIALECT);
        PersistenceContext persistenceContext7 = new PersistenceContext((DataSource)new HSQLDBInMemoryDataSource(), DIALECT);
        Table wheelTable1 = new Table("Wheel");
        Column indexColumn1 = wheelTable1.addColumn("idx", Integer.class);
        Table wheelTable2 = new Table("Wheel");
        Column indexColumn2 = wheelTable2.addColumn("idx", Integer.class);
        Table wheelTable3 = new Table("Wheel");
        Column indexColumn3 = wheelTable3.addColumn("idx", Integer.class);
        Table wheelTable4 = new Table("Wheel");
        Column indexColumn4 = wheelTable4.addColumn("idx", Integer.class);
        Table wheelTable5 = new Table("Wheel");
        Column indexColumn5 = wheelTable5.addColumn("idx", Integer.class);
        Object[][] result = new Object[][]{{"single table / one-to-many with association table", MappingEase.entityBuilder(Vehicle.class, Identifier.LONG_TYPE).mapKey(AbstractVehicle::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).mapOneToOne(Vehicle::getEngine, (EntityMappingConfigurationProvider)MappingEase.entityBuilder(Engine.class, Identifier.LONG_TYPE).mapKey(Engine::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED)).mapPolymorphism((PolymorphismPolicy)PolymorphismPolicy.singleTable().addSubClass((SubEntityMappingConfigurationProvider)MappingEase.subentityBuilder(Car.class).map(Car::getModel).mapOneToMany(Vehicle::getWheels, (EntityMappingConfigurationProvider)MappingEase.entityBuilder(Vehicle.Wheel.class, String.class).mapKey(Vehicle.Wheel::getSerialNumber, (ColumnOptions.IdentifierPolicy)ColumnOptions.IdentifierPolicy.alreadyAssigned(Vehicle.Wheel::markAsPersisted, Vehicle.Wheel::isPersisted)).map(Vehicle.Wheel::getModel)).reverselySetBy(Vehicle.Wheel::setVehicle), (Object)"CAR").addSubClass((SubEntityMappingConfigurationProvider)MappingEase.subentityBuilder(Truck.class).map(Vehicle::getColor), (Object)"TRUCK")).build(persistenceContext1), persistenceContext1.getConnectionProvider()}, {"single table / one-to-many with mapped association", MappingEase.entityBuilder(Vehicle.class, Identifier.LONG_TYPE).mapKey(AbstractVehicle::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).mapOneToOne(Vehicle::getEngine, (EntityMappingConfigurationProvider)MappingEase.entityBuilder(Engine.class, Identifier.LONG_TYPE).mapKey(Engine::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED)).mapPolymorphism((PolymorphismPolicy)PolymorphismPolicy.singleTable().addSubClass((SubEntityMappingConfigurationProvider)MappingEase.subentityBuilder(Car.class).map(Car::getModel).mapOneToMany(Vehicle::getWheels, (EntityMappingConfigurationProvider)MappingEase.entityBuilder(Vehicle.Wheel.class, String.class).mapKey(Vehicle.Wheel::getSerialNumber, (ColumnOptions.IdentifierPolicy)ColumnOptions.IdentifierPolicy.alreadyAssigned(Vehicle.Wheel::markAsPersisted, Vehicle.Wheel::isPersisted)).map(Vehicle.Wheel::getModel)).indexedBy(indexColumn1).mappedBy(Vehicle.Wheel::setVehicle), (Object)"CAR").addSubClass((SubEntityMappingConfigurationProvider)MappingEase.subentityBuilder(Truck.class).map(Vehicle::getColor), (Object)"TRUCK")).build(persistenceContext2), persistenceContext2.getConnectionProvider()}, {"joined tables / one-to-many with association table", MappingEase.entityBuilder(Vehicle.class, Identifier.LONG_TYPE).mapKey(AbstractVehicle::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).mapPolymorphism((PolymorphismPolicy)PolymorphismPolicy.joinTable().addSubClass((SubEntityMappingConfigurationProvider)MappingEase.subentityBuilder(Car.class).map(Car::getModel).mapOneToMany(Vehicle::getWheels, (EntityMappingConfigurationProvider)MappingEase.entityBuilder(Vehicle.Wheel.class, String.class).mapKey(Vehicle.Wheel::getSerialNumber, (ColumnOptions.IdentifierPolicy)ColumnOptions.IdentifierPolicy.alreadyAssigned(Vehicle.Wheel::markAsPersisted, Vehicle.Wheel::isPersisted)).map(Vehicle.Wheel::getModel)).reverselySetBy(Vehicle.Wheel::setVehicle)).addSubClass((SubEntityMappingConfigurationProvider)MappingEase.subentityBuilder(Truck.class).map(Vehicle::getColor))).build(persistenceContext3), persistenceContext3.getConnectionProvider()}, {"joined tables / one-to-many with mapped association", MappingEase.entityBuilder(Vehicle.class, Identifier.LONG_TYPE).mapKey(AbstractVehicle::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).mapPolymorphism((PolymorphismPolicy)PolymorphismPolicy.joinTable().addSubClass((SubEntityMappingConfigurationProvider)MappingEase.subentityBuilder(Car.class).map(Car::getModel).mapOneToMany(Vehicle::getWheels, (EntityMappingConfigurationProvider)MappingEase.entityBuilder(Vehicle.Wheel.class, String.class).mapKey(Vehicle.Wheel::getSerialNumber, (ColumnOptions.IdentifierPolicy)ColumnOptions.IdentifierPolicy.alreadyAssigned(Vehicle.Wheel::markAsPersisted, Vehicle.Wheel::isPersisted)).map(Vehicle.Wheel::getModel)).indexedBy(indexColumn2).mappedBy(Vehicle.Wheel::setVehicle)).addSubClass((SubEntityMappingConfigurationProvider)MappingEase.subentityBuilder(Truck.class).map(Vehicle::getColor))).build(persistenceContext4), persistenceContext4.getConnectionProvider()}, {"joined tables / one-to-many with mapped association / association is defined as common property", MappingEase.entityBuilder(Vehicle.class, Identifier.LONG_TYPE).mapKey(AbstractVehicle::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).mapOneToMany(Vehicle::getWheels, (EntityMappingConfigurationProvider)MappingEase.entityBuilder(Vehicle.Wheel.class, String.class).mapKey(Vehicle.Wheel::getSerialNumber, (ColumnOptions.IdentifierPolicy)ColumnOptions.IdentifierPolicy.alreadyAssigned(Vehicle.Wheel::markAsPersisted, Vehicle.Wheel::isPersisted)).map(Vehicle.Wheel::getModel)).indexedBy(indexColumn4).mappedBy(Vehicle.Wheel::setVehicle).mapPolymorphism((PolymorphismPolicy)PolymorphismPolicy.joinTable().addSubClass((SubEntityMappingConfigurationProvider)MappingEase.subentityBuilder(Car.class).map(Car::getModel)).addSubClass((SubEntityMappingConfigurationProvider)MappingEase.subentityBuilder(Truck.class).map(Vehicle::getColor))).build(persistenceContext5), persistenceContext5.getConnectionProvider()}, {"table per class / one-to-many with association table", MappingEase.entityBuilder(Vehicle.class, Identifier.LONG_TYPE).mapKey(AbstractVehicle::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).mapPolymorphism((PolymorphismPolicy)PolymorphismPolicy.tablePerClass().addSubClass((SubEntityMappingConfigurationProvider)MappingEase.subentityBuilder(Car.class).map(Car::getModel).mapOneToMany(Vehicle::getWheels, (EntityMappingConfigurationProvider)MappingEase.entityBuilder(Vehicle.Wheel.class, String.class).mapKey(Vehicle.Wheel::getSerialNumber, (ColumnOptions.IdentifierPolicy)ColumnOptions.IdentifierPolicy.alreadyAssigned(Vehicle.Wheel::markAsPersisted, Vehicle.Wheel::isPersisted)).map(Vehicle.Wheel::getModel)).reverselySetBy(Vehicle.Wheel::setVehicle)).addSubClass((SubEntityMappingConfigurationProvider)MappingEase.subentityBuilder(Truck.class).map(Vehicle::getColor))).build(persistenceContext6), persistenceContext6.getConnectionProvider()}, {"table per class / one-to-many with mapped association", MappingEase.entityBuilder(Vehicle.class, Identifier.LONG_TYPE).mapKey(AbstractVehicle::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).mapPolymorphism((PolymorphismPolicy)PolymorphismPolicy.tablePerClass().addSubClass((SubEntityMappingConfigurationProvider)MappingEase.subentityBuilder(Car.class).map(Car::getModel).mapOneToMany(Vehicle::getWheels, (EntityMappingConfigurationProvider)MappingEase.entityBuilder(Vehicle.Wheel.class, String.class).mapKey(Vehicle.Wheel::getSerialNumber, (ColumnOptions.IdentifierPolicy)ColumnOptions.IdentifierPolicy.alreadyAssigned(Vehicle.Wheel::markAsPersisted, Vehicle.Wheel::isPersisted)).map(Vehicle.Wheel::getModel)).indexedBy(indexColumn5).mappedBy(Vehicle.Wheel::setVehicle)).addSubClass((SubEntityMappingConfigurationProvider)MappingEase.subentityBuilder(Truck.class).map(Vehicle::getColor))).build(persistenceContext7), persistenceContext7.getConnectionProvider()}};
        new DDLDeployer(persistenceContext1).deployDDL();
        new DDLDeployer(persistenceContext2).deployDDL();
        new DDLDeployer(persistenceContext3).deployDDL();
        new DDLDeployer(persistenceContext4).deployDDL();
        new DDLDeployer(persistenceContext5).deployDDL();
        new DDLDeployer(persistenceContext6).deployDDL();
        new DDLDeployer(persistenceContext7).deployDDL();
        return result;
    }

    @ParameterizedTest(name="{0}")
    @MethodSource(value={"polymorphism_subClassHasOneToMany_data"})
    void crud_polymorphism_subClassHasOneToMany(String testDisplayName, EntityPersister<AbstractVehicle, Identifier<Long>> persister, ConnectionProvider connectionProvider) throws SQLException {
        Car dummyCar = new Car(1L);
        dummyCar.setModel("Renault");
        dummyCar.addWheel(new Vehicle.Wheel("XYZ-ABC-01"));
        Truck dummyTruck = new Truck(2L);
        dummyTruck.setColor(new Color(42));
        persister.insert((Iterable)Arrays.asList((Object[])new Vehicle[]{dummyCar, dummyTruck}));
        Car dummyCarModified = new Car(1L);
        dummyCarModified.setModel("Peugeot");
        dummyCarModified.addWheel(new Vehicle.Wheel("XYZ-ABC-02"));
        Truck dummyTruckModified = new Truck(2L);
        dummyTruckModified.setColor(new Color(99));
        persister.update((Object)dummyCarModified, (Object)dummyCar, true);
        persister.update((Object)dummyTruckModified, (Object)dummyTruck, true);
        connectionProvider.giveConnection().commit();
        persister.delete((Object)dummyCarModified);
        persister.delete((Object)dummyTruckModified);
        connectionProvider.giveConnection().rollback();
        persister.delete((Iterable)Arrays.asList((Object[])new Vehicle[]{dummyCarModified, dummyTruckModified}));
        connectionProvider.giveConnection().rollback();
        Assertions.assertThat((Object)persister.select(dummyTruck.getId())).isEqualTo((Object)dummyTruckModified);
        AbstractVehicle selectedCar = (AbstractVehicle)persister.select(dummyCar.getId());
        dummyCarModified.getWheels().forEach(w -> w.setVehicle(dummyCarModified));
        Assertions.assertThat((Object)selectedCar).isEqualTo((Object)dummyCarModified);
        ((Car)selectedCar).getWheels().forEach(wheel -> Assertions.assertThat((boolean)wheel.isPersisted()).isTrue());
        Assertions.assertThat(((Car)selectedCar).getWheels()).isEqualTo(dummyCarModified.getWheels());
        Assertions.assertThat((Collection)persister.select((Iterable)Arrays.asSet((Object[])new Identifier[]{dummyCar.getId(), dummyTruck.getId()}))).containsExactlyInAnyOrder((Object[])new AbstractVehicle[]{dummyCarModified, dummyTruckModified});
    }

    @Test
    void build_joinedTables_oneToManyWithMappedAssociation_eachSubclassRedeclaresSameAssociation_throwsException() {
        FluentEntityMappingBuilder vehicleMappingBuilder = MappingEase.entityBuilder(Vehicle.class, Identifier.LONG_TYPE).mapKey(AbstractVehicle::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).mapPolymorphism((PolymorphismPolicy)PolymorphismPolicy.joinTable().addSubClass((SubEntityMappingConfigurationProvider)MappingEase.subentityBuilder(Car.class).map(Car::getModel).mapOneToMany(Vehicle::getWheels, (EntityMappingConfigurationProvider)MappingEase.entityBuilder(Vehicle.Wheel.class, String.class).mapKey(Vehicle.Wheel::getSerialNumber, (ColumnOptions.IdentifierPolicy)ColumnOptions.IdentifierPolicy.alreadyAssigned(Vehicle.Wheel::markAsPersisted, Vehicle.Wheel::isPersisted)).map(Vehicle.Wheel::getModel)).mappedBy(Vehicle.Wheel::setVehicle)).addSubClass((SubEntityMappingConfigurationProvider)MappingEase.subentityBuilder(Truck.class).map(Vehicle::getColor).mapOneToMany(Vehicle::getWheels, (EntityMappingConfigurationProvider)MappingEase.entityBuilder(Vehicle.Wheel.class, String.class).mapKey(Vehicle.Wheel::getSerialNumber, (ColumnOptions.IdentifierPolicy)ColumnOptions.IdentifierPolicy.alreadyAssigned(Vehicle.Wheel::markAsPersisted, Vehicle.Wheel::isPersisted)).map(Vehicle.Wheel::getModel)).mappedBy(Vehicle.Wheel::setVehicle)));
        PersistenceContext persistenceContext5 = new PersistenceContext((DataSource)new HSQLDBInMemoryDataSource(), DIALECT);
        Assertions.assertThatCode(() -> vehicleMappingBuilder.build(persistenceContext5)).hasMessage("A foreign key with same source columns but different referenced columns already exist : 'FK_Wheel_vehicleId_Car_id' <Wheel.vehicleId -> Car.id> vs wanted new one 'FK_Wheel_vehicleId_Truck_id' <Wheel.vehicleId -> Truck.id>");
    }

    static Object[][] crud_polymorphism_subClassHasElementCollection() {
        PersistenceContext persistenceContext1 = new PersistenceContext((DataSource)new HSQLDBInMemoryDataSource(), DIALECT);
        PersistenceContext persistenceContext2 = new PersistenceContext((DataSource)new HSQLDBInMemoryDataSource(), DIALECT);
        PersistenceContext persistenceContext3 = new PersistenceContext((DataSource)new HSQLDBInMemoryDataSource(), DIALECT);
        Object[][] result = new Object[][]{{"single table", MappingEase.entityBuilder(Vehicle.class, Identifier.LONG_TYPE).mapKey(AbstractVehicle::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).mapPolymorphism((PolymorphismPolicy)PolymorphismPolicy.singleTable().addSubClass((SubEntityMappingConfigurationProvider)MappingEase.subentityBuilder(Car.class).map(Car::getModel).mapCollection(Car::getPlates, String.class), (Object)"CAR").addSubClass((SubEntityMappingConfigurationProvider)MappingEase.subentityBuilder(Truck.class).map(Vehicle::getColor), (Object)"TRUCK")).build(persistenceContext1), persistenceContext1, PolymorphismType.SINGLE_TABLE}, {"joined tables", MappingEase.entityBuilder(Vehicle.class, Identifier.LONG_TYPE).mapKey(AbstractVehicle::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).mapPolymorphism((PolymorphismPolicy)PolymorphismPolicy.joinTable().addSubClass((SubEntityMappingConfigurationProvider)MappingEase.subentityBuilder(Car.class).map(Car::getModel).mapCollection(Car::getPlates, String.class)).addSubClass((SubEntityMappingConfigurationProvider)MappingEase.subentityBuilder(Truck.class).map(Vehicle::getColor))).build(persistenceContext2), persistenceContext2, PolymorphismType.JOIN_TABLE}, {"table per class", MappingEase.entityBuilder(Vehicle.class, Identifier.LONG_TYPE).mapKey(AbstractVehicle::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).mapPolymorphism((PolymorphismPolicy)PolymorphismPolicy.tablePerClass().addSubClass((SubEntityMappingConfigurationProvider)MappingEase.subentityBuilder(Car.class).map(Car::getModel).mapCollection(Car::getPlates, String.class)).addSubClass((SubEntityMappingConfigurationProvider)MappingEase.subentityBuilder(Truck.class).map(Vehicle::getColor))).build(persistenceContext3), persistenceContext3, PolymorphismType.TABLE_PER_CLASS}};
        new DDLDeployer(persistenceContext1).deployDDL();
        new DDLDeployer(persistenceContext2).deployDDL();
        new DDLDeployer(persistenceContext3).deployDDL();
        return result;
    }

    @ParameterizedTest(name="{0}")
    @MethodSource
    void crud_polymorphism_subClassHasElementCollection(String testDisplayName, EntityPersister<AbstractVehicle, Identifier<Long>> persister, PersistenceContext persistenceContext, PolymorphismType polymorphismType) throws SQLException {
        Car dummyCar = new Car(1L);
        dummyCar.setModel("Renault");
        dummyCar.addPlate("XYZ-ABC-01");
        Truck dummyTruck = new Truck(2L);
        dummyTruck.setColor(new Color(42));
        persister.insert((Iterable)Arrays.asList((Object[])new Vehicle[]{dummyCar, dummyTruck}));
        Car dummyCarModified = new Car(1L);
        dummyCarModified.setModel("Peugeot");
        dummyCarModified.addPlate("XYZ-ABC-02");
        Truck dummyTruckModified = new Truck(2L);
        dummyTruckModified.setColor(new Color(99));
        persister.update((Object)dummyCarModified, (Object)dummyCar, true);
        persister.update((Object)dummyTruckModified, (Object)dummyTruck, true);
        persistenceContext.getConnectionProvider().giveConnection().commit();
        persister.delete((Iterable)Arrays.asList((Object[])new Vehicle[]{dummyCarModified, dummyTruckModified}));
        String sql = null;
        switch (polymorphismType) {
            case SINGLE_TABLE: {
                sql = "select count(*) as cnt from Car_plates";
                break;
            }
            case JOIN_TABLE: {
                sql = "select count(*) as cnt from Car_plates";
                break;
            }
            case TABLE_PER_CLASS: {
                sql = "select count(*) as cnt from Car_plates";
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        Integer plateCount = (Integer)Nullable.nullable((Object)sql).map(query -> (Integer)persistenceContext.newQuery((CharSequence)query, Integer.TYPE).mapKey("cnt", Integer.TYPE).execute(Accumulators.getFirst())).getOr((Object)0);
        Assertions.assertThat((Integer)plateCount).isEqualTo(0);
        persistenceContext.getConnectionProvider().giveConnection().rollback();
        Assertions.assertThat((Object)persister.select(dummyTruck.getId())).isEqualTo((Object)dummyTruckModified);
        AbstractVehicle selectedCar = (AbstractVehicle)persister.select(dummyCar.getId());
        Assertions.assertThat((Object)selectedCar).isEqualTo((Object)dummyCarModified);
        Assertions.assertThat(((Car)selectedCar).getPlates()).containsExactlyInAnyOrder((Object[])new String[]{"XYZ-ABC-02"});
        Assertions.assertThat((Collection)persister.select((Iterable)Arrays.asSet((Object[])new Identifier[]{dummyCar.getId(), dummyTruck.getId()}))).containsExactlyInAnyOrder((Object[])new AbstractVehicle[]{dummyCarModified, dummyTruckModified});
    }

    static EntityPersister<Person, Identifier<Long>> generateOneToPolymorphicOneTestCase(PolymorphismType type, boolean ownedByReverseSide, boolean fetchSeparately, PersistenceContext persistenceContext) {
        FluentEmbeddableMappingBuilder.FluentEmbeddableMappingBuilderEmbeddableMappingConfigurationImportedEmbedOptions timestampedPersistentBeanMapping = MappingEase.embeddableBuilder(Person.class).map(Person::getName).embed(Person::getTimestamp, (EmbeddableMappingConfigurationProvider)MappingEase.embeddableBuilder(Timestamp.class).map(Timestamp::getCreationDate).map(Timestamp::getModificationDate));
        FluentEntityMappingBuilder vehicleConfiguration = MappingEase.entityBuilder(Vehicle.class, Identifier.LONG_TYPE).mapKey(AbstractVehicle::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Vehicle::getColor).mapPolymorphism(FluentEntityMappingConfigurationSupportPolymorphismWithRelationTest.giveVehiclePolymorphismPolicy(type));
        FluentEntityMappingBuilder.FluentMappingBuilderOneToOneOptions persisterConfiguration = MappingEase.entityBuilder(Person.class, Identifier.LONG_TYPE).mapKey(Person::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).mapOneToOne(Person::getVehicle, (EntityMappingConfigurationProvider)vehicleConfiguration).cascading(CascadeOptions.RelationMode.ALL_ORPHAN_REMOVAL);
        persisterConfiguration.mapSuperClass((EmbeddableMappingConfigurationProvider)timestampedPersistentBeanMapping);
        if (ownedByReverseSide) {
            persisterConfiguration.mappedBy(Vehicle::getOwner);
        }
        if (fetchSeparately) {
            persisterConfiguration.fetchSeparately();
        }
        EntityPersister result = persisterConfiguration.build(persistenceContext);
        DDLDeployer ddlDeployer = new DDLDeployer(persistenceContext);
        ddlDeployer.deployDDL();
        vehicleConfiguration.build(persistenceContext);
        return result;
    }

    static PolymorphismPolicy<Vehicle> giveVehiclePolymorphismPolicy(PolymorphismType type) {
        switch (type) {
            case SINGLE_TABLE: {
                return PolymorphismPolicy.singleTable().addSubClass((SubEntityMappingConfigurationProvider)MappingEase.subentityBuilder(Truck.class), (Object)"T").addSubClass((SubEntityMappingConfigurationProvider)MappingEase.subentityBuilder(Car.class), (Object)"C");
            }
            case JOIN_TABLE: {
                return PolymorphismPolicy.joinTable().addSubClass((SubEntityMappingConfigurationProvider)MappingEase.subentityBuilder(Truck.class)).addSubClass((SubEntityMappingConfigurationProvider)MappingEase.subentityBuilder(Car.class));
            }
            case TABLE_PER_CLASS: {
                return PolymorphismPolicy.tablePerClass().addSubClass((SubEntityMappingConfigurationProvider)MappingEase.subentityBuilder(Truck.class)).addSubClass((SubEntityMappingConfigurationProvider)MappingEase.subentityBuilder(Car.class));
            }
        }
        throw new UnsupportedOperationException();
    }

    public static Stream<Object[]> oneToPolymorphicOne_crud() {
        return Stream.of(PolymorphismType.values()).flatMap(type -> Stream.of(true, false).flatMap(withAssociationTable -> Stream.of(true, false).filter(x -> type != PolymorphismType.TABLE_PER_CLASS || withAssociationTable != false).map(fetchSeparately -> {
            PersistenceContext persistenceContext = new PersistenceContext((DataSource)new HSQLDBInMemoryDataSource(), DIALECT);
            String testCaseName = new StringAppender().ccat(new Object[]{withAssociationTable != false ? "association table" : "relation owned by table", fetchSeparately != false ? "fetch separately" : "query with join", type, ", "}).toString();
            return new Object[]{testCaseName, FluentEntityMappingConfigurationSupportPolymorphismWithRelationTest.generateOneToPolymorphicOneTestCase(type, withAssociationTable, fetchSeparately, persistenceContext), persistenceContext, withAssociationTable, type == PolymorphismType.TABLE_PER_CLASS};
        })));
    }

    @ParameterizedTest(name="{0}")
    @MethodSource
    void oneToPolymorphicOne_crud(String displayName, EntityPersister<Person, Identifier<Long>> testInstance, PersistenceContext persistenceContext, boolean withAssociationTable, boolean isTablePerClass) {
        Person person = new Person(1L);
        Car car = new Car(42L);
        car.setColor(new Color(17));
        person.setVehicle(car);
        testInstance.insert((Object)person);
        Person loadedPerson = (Person)testInstance.select(person.getId());
        Assertions.assertThat((Object)loadedPerson).isEqualTo((Object)person);
        person.setTimestamp(new Timestamp());
        testInstance.update((Object)person, (Object)loadedPerson, true);
        loadedPerson = (Person)testInstance.select(person.getId());
        ObjectPrinterBuilder.ObjectPrinter vehiclePrinter = new ObjectPrinterBuilder().addProperty(AbstractVehicle::getId).addProperty(Object::getClass).withPrinter(AbstractIdentifier.class, Functions.chain(AbstractIdentifier::getDelegate, String::valueOf)).build();
        ObjectPrinterBuilder.ObjectPrinter personPrinter = new ObjectPrinterBuilder().addProperty(Person::getId).addProperty(Person::getName).addProperty(Person::getTimestamp).addProperty(Person::getVehicle).withPrinter(AbstractIdentifier.class, Functions.chain(AbstractIdentifier::getDelegate, String::valueOf)).withPrinter(Vehicle.class, arg_0 -> ((ObjectPrinterBuilder.ObjectPrinter)vehiclePrinter).toString(arg_0)).build();
        ((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)loadedPerson).usingComparator(Comparator.comparing(arg_0 -> ((ObjectPrinterBuilder.ObjectPrinter)personPrinter).toString(arg_0)))).withRepresentation(new PartialRepresentation<Person>(Person.class, personPrinter))).isEqualTo((Object)person);
        Assertions.assertThat((Object)loadedPerson.getVehicle().getOwner()).isEqualTo((Object)loadedPerson);
        person.setVehicle(new Truck(666L));
        testInstance.update((Object)person, (Object)loadedPerson, true);
        loadedPerson = (Person)testInstance.select(person.getId());
        ((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)loadedPerson).usingComparator(Comparator.comparing(arg_0 -> ((ObjectPrinterBuilder.ObjectPrinter)personPrinter).toString(arg_0)))).withRepresentation(new PartialRepresentation<Person>(Person.class, personPrinter))).isEqualTo((Object)person);
        Assertions.assertThat((Object)persistenceContext.getPersister(Vehicle.class).select(new PersistedIdentifier<Long>(42L))).isNull();
        person.setVehicle(null);
        testInstance.update((Object)person, (Object)loadedPerson, true);
        loadedPerson = (Person)testInstance.select(person.getId());
        Assertions.assertThat((Object)loadedPerson).isEqualTo((Object)person);
        Assertions.assertThat((Object)persistenceContext.getPersister(Vehicle.class).select(new PersistedIdentifier<Long>(666L))).isNull();
        person.setVehicle(new Truck(17L));
        testInstance.update((Object)person, (Object)loadedPerson, true);
        loadedPerson = (Person)testInstance.select(person.getId());
        Assertions.assertThat((Object)loadedPerson).isEqualTo((Object)person);
        testInstance.delete((Object)person);
        Assertions.assertThat((Object)testInstance.select(person.getId())).isNull();
        Assertions.assertThat((Object)persistenceContext.getPersister(Vehicle.class).select(new PersistedIdentifier<Long>(17L))).isNull();
    }

    static EntityPersister<Country, Identifier<Long>> generateOneToManyTestCase(PolymorphismType type, boolean withAssociationTable, boolean fetchSeparately, PersistenceContext persistenceContext) {
        FluentEmbeddableMappingBuilder.FluentEmbeddableMappingBuilderEmbeddableMappingConfigurationImportedEmbedOptions timestampedPersistentBeanMapping = MappingEase.embeddableBuilder(Country.class).map(Country::getName).embed(Country::getTimestamp, (EmbeddableMappingConfigurationProvider)MappingEase.embeddableBuilder(Timestamp.class).map(Timestamp::getCreationDate).map(Timestamp::getModificationDate));
        FluentEntityMappingBuilder cityConfiguration = MappingEase.entityBuilder(City.class, Identifier.LONG_TYPE).mapKey(City::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(City::getName).mapPolymorphism(FluentEntityMappingConfigurationSupportPolymorphismWithRelationTest.givePolymorphismPolicy(type));
        FluentEntityMappingBuilder.FluentMappingBuilderOneToManyOptions persisterConfiguration = MappingEase.entityBuilder(Country.class, Identifier.LONG_TYPE).mapKey(Country::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).mapOneToMany(Country::getCities, (EntityMappingConfigurationProvider)cityConfiguration).cascading(CascadeOptions.RelationMode.ALL);
        persisterConfiguration.mapSuperClass((EmbeddableMappingConfigurationProvider)timestampedPersistentBeanMapping);
        if (withAssociationTable) {
            persisterConfiguration.reverselySetBy(City::setCountry);
        } else {
            persisterConfiguration.mappedBy(City::getCountry);
        }
        if (fetchSeparately) {
            persisterConfiguration.fetchSeparately();
        }
        return persisterConfiguration.build(persistenceContext);
    }

    static PolymorphismPolicy<City> givePolymorphismPolicy(PolymorphismType type) {
        switch (type) {
            case SINGLE_TABLE: {
                return PolymorphismPolicy.singleTable().addSubClass((SubEntityMappingConfigurationProvider)MappingEase.subentityBuilder(Village.class).map(Village::getBarCount), (Object)"V").addSubClass((SubEntityMappingConfigurationProvider)MappingEase.subentityBuilder(Town.class).map(Town::getDiscotecCount), (Object)"T");
            }
            case JOIN_TABLE: {
                return PolymorphismPolicy.joinTable().addSubClass((SubEntityMappingConfigurationProvider)MappingEase.subentityBuilder(Village.class).map(Village::getBarCount)).addSubClass((SubEntityMappingConfigurationProvider)MappingEase.subentityBuilder(Town.class).map(Town::getDiscotecCount));
            }
            case TABLE_PER_CLASS: {
                return PolymorphismPolicy.tablePerClass().addSubClass((SubEntityMappingConfigurationProvider)MappingEase.subentityBuilder(Village.class).map(Village::getBarCount)).addSubClass((SubEntityMappingConfigurationProvider)MappingEase.subentityBuilder(Town.class).map(Town::getDiscotecCount));
            }
        }
        throw new UnsupportedOperationException();
    }

    public static Stream<Object[]> oneToPolymorphicMany_crud() {
        return Stream.of(PolymorphismType.values()).flatMap(type -> Stream.of(true, false).flatMap(withAssociationTable -> Stream.of(true, false).map(fetchSeparately -> {
            PersistenceContext persistenceContext = new PersistenceContext((DataSource)new HSQLDBInMemoryDataSource(), DIALECT);
            String testCaseName = new StringAppender().ccat(new Object[]{withAssociationTable != false ? "association table" : "relation owned by table", fetchSeparately != false ? "fetch separately" : "query with join", type, ", "}).toString();
            return new Object[]{testCaseName, FluentEntityMappingConfigurationSupportPolymorphismWithRelationTest.generateOneToManyTestCase(type, withAssociationTable, fetchSeparately, persistenceContext), persistenceContext, withAssociationTable, type == PolymorphismType.TABLE_PER_CLASS};
        })));
    }

    @ParameterizedTest(name="{0}")
    @MethodSource
    void oneToPolymorphicMany_crud(String displayName, EntityPersister<Country, Identifier<Long>> testInstance, PersistenceContext persistenceContext, boolean withAssociationTable, boolean isTablePerClass) {
        PersistenceContext.ExecutableBeanPropertyQueryMapper longExecutableQuery;
        DDLDeployer ddlDeployer = new DDLDeployer(persistenceContext);
        ddlDeployer.deployDDL();
        Country country = new Country(1L);
        Village grenoble = new Village(42L);
        grenoble.setName("Grenoble");
        country.addCity(grenoble);
        testInstance.insert((Object)country);
        Country loadedCountry = (Country)testInstance.select(country.getId());
        Assertions.assertThat((Object)loadedCountry).isEqualTo((Object)country);
        ObjectPrinterBuilder.ObjectPrinter countryPrinter = new ObjectPrinterBuilder().addProperty(Country::getId).addProperty(Country::getName).addProperty(Country::getTimestamp).withPrinter(AbstractIdentifier.class, Functions.chain(AbstractIdentifier::getDelegate, String::valueOf)).build();
        ObjectPrinterBuilder.ObjectPrinter cityPrinter = new ObjectPrinterBuilder().addProperty(City::getId).addProperty(Village::getBarCount).addProperty(Town::getDiscotecCount).addProperty(City::getName).addProperty(City::getCountry).withPrinter(AbstractIdentifier.class, Functions.chain(AbstractIdentifier::getDelegate, String::valueOf)).withPrinter(Country.class, arg_0 -> ((ObjectPrinterBuilder.ObjectPrinter)countryPrinter).toString(arg_0)).build();
        ((AbstractCollectionAssert)((AbstractCollectionAssert)Assertions.assertThat(loadedCountry.getCities()).usingElementComparator(Comparator.comparing(arg_0 -> ((ObjectPrinterBuilder.ObjectPrinter)cityPrinter).toString(arg_0)))).withRepresentation(new PartialRepresentation<City>(City.class, cityPrinter))).isEqualTo(country.getCities());
        Assertions.assertThat(loadedCountry.getCities()).extracting(City::getCountry).containsExactlyInAnyOrder((Object[])new Country[]{loadedCountry});
        Town lyon = new Town(17L);
        lyon.setDiscotecCount(123);
        lyon.setName("Lyon");
        country.addCity(lyon);
        grenoble.setBarCount(51);
        testInstance.update((Object)country, (Object)loadedCountry, true);
        loadedCountry = (Country)testInstance.select(country.getId());
        Assertions.assertThat(loadedCountry.getCities()).containsExactlyInAnyOrder((Object[])new City[]{grenoble, lyon});
        Assertions.assertThat(loadedCountry.getCities()).extracting(City::getCountry).containsExactlyInAnyOrder((Object[])new Country[]{loadedCountry, loadedCountry});
        Country modifiedCountry = new Country(country.getId());
        modifiedCountry.addCity((City)Iterables.first(country.getCities()));
        testInstance.update((Object)modifiedCountry, (Object)country, false);
        if (withAssociationTable) {
            longExecutableQuery = persistenceContext.newQuery((CharSequence)"select Country_Id from Country_cities", Long.class).mapKey("Country_Id", Long.class);
            Set cityCountryIds = (Set)longExecutableQuery.execute(Accumulators.toSet());
            Assertions.assertThat(new HashSet(cityCountryIds)).containsExactlyInAnyOrder((Object[])new Long[]{(Long)country.getId().getDelegate()});
        } else if (isTablePerClass) {
            longExecutableQuery = persistenceContext.newQuery((CharSequence)"select CountryId from Town union all select CountryId from Village", Long.class).mapKey("CountryId", Long.class);
            Set cityCountryIds = (Set)longExecutableQuery.execute(Accumulators.toSet());
            Assertions.assertThat(new HashSet(cityCountryIds)).containsExactlyInAnyOrder((Object[])new Long[]{(Long)country.getId().getDelegate(), null});
        } else {
            longExecutableQuery = persistenceContext.newQuery((CharSequence)"select CountryId from City", Long.class).mapKey("CountryId", Long.class);
            Set cityCountryIds = (Set)longExecutableQuery.execute(Accumulators.toSet());
            Assertions.assertThat(new HashSet(cityCountryIds)).containsExactlyInAnyOrder((Object[])new Long[]{(Long)country.getId().getDelegate(), null});
        }
        testInstance.delete((Object)modifiedCountry);
        String sql = isTablePerClass ? "select * from Town union select * from Village" : "select * from City";
        Set select = (Set)persistenceContext.newQuery((CharSequence)sql, City.class).mapKey(City::new, "id", Long.TYPE, "name", String.class).execute(Accumulators.toSet());
        Assertions.assertThat((Collection)select).hasSize(2);
    }

    private static class Republic
    extends Country {
        private Person primeMinister;
        private int deputeCount;

        public Republic() {
        }

        public Republic(Identifier<Long> id) {
            super(id);
        }

        public Person getPrimeMinister() {
            return this.primeMinister;
        }

        public void setPrimeMinister(Person primeMinister) {
            this.primeMinister = primeMinister;
        }

        public int getDeputeCount() {
            return this.deputeCount;
        }

        public void setDeputeCount(int deputeCount) {
            this.deputeCount = deputeCount;
        }
    }

    @Nested
    class OneToPolymorphicMany {
        OneToPolymorphicMany() {
        }

        @Test
        void oneToTablePerClass_crud_ownedByReverseSide_foreignKeysAreCreated() throws SQLException {
            FluentEmbeddableMappingBuilder.FluentEmbeddableMappingBuilderEmbeddableMappingConfigurationImportedEmbedOptions timestampedPersistentBeanMapping = MappingEase.embeddableBuilder(Country.class).map(Country::getName).embed(Country::getTimestamp, (EmbeddableMappingConfigurationProvider)MappingEase.embeddableBuilder(Timestamp.class).map(Timestamp::getCreationDate).map(Timestamp::getModificationDate));
            FluentEntityMappingBuilder cityConfiguration = MappingEase.entityBuilder(City.class, Identifier.LONG_TYPE).mapKey(City::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(City::getName).mapPolymorphism((PolymorphismPolicy)PolymorphismPolicy.tablePerClass().addSubClass((SubEntityMappingConfigurationProvider)MappingEase.subentityBuilder(Village.class).map(Village::getBarCount)).addSubClass((SubEntityMappingConfigurationProvider)MappingEase.subentityBuilder(Town.class).map(Town::getDiscotecCount)));
            EntityPersister testInstance = MappingEase.entityBuilder(Country.class, Identifier.LONG_TYPE).mapKey(Country::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).mapOneToMany(Country::getCities, (EntityMappingConfigurationProvider)cityConfiguration).mappedBy(City::getCountry).cascading(CascadeOptions.RelationMode.ALL).mapSuperClass((EmbeddableMappingConfigurationProvider)timestampedPersistentBeanMapping).build(FluentEntityMappingConfigurationSupportPolymorphismWithRelationTest.this.persistenceContext);
            DDLDeployer ddlDeployer = new DDLDeployer(FluentEntityMappingConfigurationSupportPolymorphismWithRelationTest.this.persistenceContext);
            ddlDeployer.deployDDL();
            Connection currentConnection = FluentEntityMappingConfigurationSupportPolymorphismWithRelationTest.this.persistenceContext.getConnectionProvider().giveConnection();
            ResultSetIterator<JdbcForeignKey> fkVillageIterator = new ResultSetIterator<JdbcForeignKey>(currentConnection.getMetaData().getImportedKeys(null, null, "VILLAGE")){

                public JdbcForeignKey convert(ResultSet rs) throws SQLException {
                    return new JdbcForeignKey(rs.getString("FK_NAME"), rs.getString("FKTABLE_NAME"), rs.getString("FKCOLUMN_NAME"), rs.getString("PKTABLE_NAME"), rs.getString("PKCOLUMN_NAME"));
                }
            };
            JdbcForeignKey foundForeignKey = (JdbcForeignKey)Iterables.first((Iterator)fkVillageIterator);
            JdbcForeignKey expectedForeignKey = new JdbcForeignKey("FK_VILLAGE_COUNTRYID_COUNTRY_ID", "VILLAGE", "COUNTRYID", "COUNTRY", "ID");
            Assertions.assertThat((String)foundForeignKey.getSignature()).isEqualTo(expectedForeignKey.getSignature());
            ResultSetIterator<JdbcForeignKey> fkTownIterator = new ResultSetIterator<JdbcForeignKey>(currentConnection.getMetaData().getImportedKeys(null, null, "TOWN")){

                public JdbcForeignKey convert(ResultSet rs) throws SQLException {
                    return new JdbcForeignKey(rs.getString("FK_NAME"), rs.getString("FKTABLE_NAME"), rs.getString("FKCOLUMN_NAME"), rs.getString("PKTABLE_NAME"), rs.getString("PKCOLUMN_NAME"));
                }
            };
            foundForeignKey = (JdbcForeignKey)Iterables.first((Iterator)fkTownIterator);
            expectedForeignKey = new JdbcForeignKey("FK_TOWN_COUNTRYID_COUNTRY_ID", "TOWN", "COUNTRYID", "COUNTRY", "ID");
            Assertions.assertThat((String)foundForeignKey.getSignature()).isEqualTo(expectedForeignKey.getSignature());
        }

        @Test
        void oneToTablePerClass_crud_ownedByReverseSide() {
            FluentEmbeddableMappingBuilder.FluentEmbeddableMappingBuilderEmbeddableMappingConfigurationImportedEmbedOptions timestampedPersistentBeanMapping = MappingEase.embeddableBuilder(Country.class).map(Country::getName).embed(Country::getTimestamp, (EmbeddableMappingConfigurationProvider)MappingEase.embeddableBuilder(Timestamp.class).map(Timestamp::getCreationDate).map(Timestamp::getModificationDate));
            FluentEntityMappingBuilder cityConfiguration = MappingEase.entityBuilder(City.class, Identifier.LONG_TYPE).mapKey(City::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(City::getName).mapPolymorphism((PolymorphismPolicy)PolymorphismPolicy.tablePerClass().addSubClass((SubEntityMappingConfigurationProvider)MappingEase.subentityBuilder(Village.class).map(Village::getBarCount)).addSubClass((SubEntityMappingConfigurationProvider)MappingEase.subentityBuilder(Town.class).map(Town::getDiscotecCount)));
            EntityPersister testInstance = MappingEase.entityBuilder(Country.class, Identifier.LONG_TYPE).mapKey(Country::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).mapOneToMany(Country::getCities, (EntityMappingConfigurationProvider)cityConfiguration).mappedBy(City::getCountry).cascading(CascadeOptions.RelationMode.ALL).mapSuperClass((EmbeddableMappingConfigurationProvider)timestampedPersistentBeanMapping).build(FluentEntityMappingConfigurationSupportPolymorphismWithRelationTest.this.persistenceContext);
            DDLDeployer ddlDeployer = new DDLDeployer(FluentEntityMappingConfigurationSupportPolymorphismWithRelationTest.this.persistenceContext);
            ddlDeployer.deployDDL();
            Country country = new Country(1L);
            Village grenoble = new Village(42L);
            grenoble.setName("Grenoble");
            country.addCity(grenoble);
            testInstance.insert((Object)country);
            Country loadedCountry = (Country)testInstance.select(country.getId());
            Assertions.assertThat((Object)loadedCountry).isEqualTo((Object)country);
            ObjectPrinterBuilder.ObjectPrinter countryPrinter = new ObjectPrinterBuilder().addProperty(Country::getId).addProperty(Country::getName).addProperty(Country::getTimestamp).withPrinter(AbstractIdentifier.class, Functions.chain(AbstractIdentifier::getDelegate, String::valueOf)).build();
            ObjectPrinterBuilder.ObjectPrinter cityPrinter = new ObjectPrinterBuilder().addProperty(City::getId).addProperty(Village::getBarCount).addProperty(Town::getDiscotecCount).addProperty(City::getName).addProperty(City::getCountry).withPrinter(AbstractIdentifier.class, Functions.chain(AbstractIdentifier::getDelegate, String::valueOf)).withPrinter(Country.class, arg_0 -> ((ObjectPrinterBuilder.ObjectPrinter)countryPrinter).toString(arg_0)).build();
            ((AbstractCollectionAssert)Assertions.assertThat(loadedCountry.getCities()).usingElementComparator(Comparator.comparing(arg_0 -> ((ObjectPrinterBuilder.ObjectPrinter)cityPrinter).toString(arg_0)))).isEqualTo(country.getCities());
            Assertions.assertThat(loadedCountry.getCities()).extracting(City::getCountry).containsExactlyInAnyOrder((Object[])new Country[]{loadedCountry});
            Town lyon = new Town(17L);
            lyon.setDiscotecCount(123);
            lyon.setName("Lyon");
            country.addCity(lyon);
            grenoble.setBarCount(51);
            testInstance.update((Object)country, (Object)loadedCountry, true);
            loadedCountry = (Country)testInstance.select(country.getId());
            Assertions.assertThat(loadedCountry.getCities()).containsExactlyInAnyOrder((Object[])new City[]{grenoble, lyon});
            Assertions.assertThat(loadedCountry.getCities()).extracting(City::getCountry).containsExactlyInAnyOrder((Object[])new Country[]{loadedCountry, loadedCountry});
            Country modifiedCountry = new Country((Long)country.getId().getDelegate());
            modifiedCountry.addCity((City)Iterables.first(country.getCities()));
            testInstance.update((Object)modifiedCountry, (Object)country, false);
            PersistenceContext.ExecutableBeanPropertyQueryMapper longExecutableQuery1 = FluentEntityMappingConfigurationSupportPolymorphismWithRelationTest.this.persistenceContext.newQuery((CharSequence)"select countryId from Town union all select countryId from Village", Long.class).mapKey((SerializableFunction & Serializable)i -> i, "countryId", Long.class);
            Set cityCountryIds = (Set)longExecutableQuery1.execute(Accumulators.toSet());
            Assertions.assertThat((Collection)cityCountryIds).containsExactlyInAnyOrder((Object[])new Long[]{(Long)country.getId().getDelegate(), null});
            testInstance.delete((Object)modifiedCountry);
            PersistenceContext.ExecutableBeanPropertyQueryMapper longExecutableQuery = FluentEntityMappingConfigurationSupportPolymorphismWithRelationTest.this.persistenceContext.newQuery((CharSequence)"select id from Town union all select id from Village", Long.class).mapKey((SerializableFunction & Serializable)i -> i, "id", Long.class);
            Set cityIds = (Set)longExecutableQuery.execute(Accumulators.toSet());
            Assertions.assertThat((Collection)cityIds).containsExactlyInAnyOrder((Object[])new Long[]{(Long)grenoble.getId().getDelegate(), (Long)lyon.getId().getDelegate()});
        }
    }

    private static enum PolymorphismType {
        SINGLE_TABLE,
        JOIN_TABLE,
        TABLE_PER_CLASS;

    }

    @Nested
    class OneToPolymorphicOne {
        OneToPolymorphicOne() {
        }

        @Test
        void oneToJoinedTable_crud() {
            FluentEmbeddableMappingBuilder.FluentEmbeddableMappingBuilderEmbeddableMappingConfigurationImportedEmbedOptions timestampedPersistentBeanMapping = MappingEase.embeddableBuilder(Person.class).map(Person::getName).embed(Person::getTimestamp, (EmbeddableMappingConfigurationProvider)MappingEase.embeddableBuilder(Timestamp.class).map(Timestamp::getCreationDate).map(Timestamp::getModificationDate));
            FluentEntityMappingBuilder vehicleConfiguration = MappingEase.entityBuilder(Vehicle.class, Identifier.LONG_TYPE).mapKey(AbstractVehicle::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).mapPolymorphism((PolymorphismPolicy)PolymorphismPolicy.joinTable().addSubClass((SubEntityMappingConfigurationProvider)MappingEase.subentityBuilder(Truck.class)).addSubClass((SubEntityMappingConfigurationProvider)MappingEase.subentityBuilder(Car.class)));
            EntityPersister vehiclePersister = vehicleConfiguration.build(FluentEntityMappingConfigurationSupportPolymorphismWithRelationTest.this.persistenceContext);
            EntityPersister testInstance = MappingEase.entityBuilder(Person.class, Identifier.LONG_TYPE).mapKey(Person::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).mapOneToOne(Person::getVehicle, (EntityMappingConfigurationProvider)vehicleConfiguration).cascading(CascadeOptions.RelationMode.ALL_ORPHAN_REMOVAL).mapSuperClass((EmbeddableMappingConfigurationProvider)timestampedPersistentBeanMapping).build(FluentEntityMappingConfigurationSupportPolymorphismWithRelationTest.this.persistenceContext);
            DDLDeployer ddlDeployer = new DDLDeployer(FluentEntityMappingConfigurationSupportPolymorphismWithRelationTest.this.persistenceContext);
            ddlDeployer.deployDDL();
            Person person = new Person(1L);
            person.setVehicle(new Car(42L));
            testInstance.insert((Object)person);
            Person loadedPerson = (Person)testInstance.select(person.getId());
            Assertions.assertThat((Object)loadedPerson).isEqualTo((Object)person);
            person.setTimestamp(new Timestamp());
            testInstance.update((Object)person, (Object)loadedPerson, true);
            loadedPerson = (Person)testInstance.select(person.getId());
            Assertions.assertThat((Object)loadedPerson).isEqualTo((Object)person);
            person.setVehicle(new Truck(666L));
            testInstance.update((Object)person, (Object)loadedPerson, true);
            loadedPerson = (Person)testInstance.select(person.getId());
            Assertions.assertThat((Object)loadedPerson).isEqualTo((Object)person);
            Assertions.assertThat((Object)vehiclePersister.select(new PersistedIdentifier<Long>(42L))).isNull();
            person.setVehicle(null);
            testInstance.update((Object)person, (Object)loadedPerson, true);
            loadedPerson = (Person)testInstance.select(person.getId());
            Assertions.assertThat((Object)loadedPerson).isEqualTo((Object)person);
            Assertions.assertThat((Object)vehiclePersister.select(new PersistedIdentifier<Long>(666L))).isNull();
            person.setVehicle(new Truck(17L));
            testInstance.update((Object)person, (Object)loadedPerson, true);
            loadedPerson = (Person)testInstance.select(person.getId());
            Assertions.assertThat((Object)loadedPerson).isEqualTo((Object)person);
            testInstance.delete((Object)person);
            Assertions.assertThat((Object)testInstance.select(person.getId())).isNull();
            Assertions.assertThat((Object)vehiclePersister.select(new PersistedIdentifier<Long>(17L))).isNull();
        }

        @Test
        void oneToJoinedTable_crud_ownedByReverseSide() {
            FluentEmbeddableMappingBuilder.FluentEmbeddableMappingBuilderEmbeddableMappingConfigurationImportedEmbedOptions timestampedPersistentBeanMapping = MappingEase.embeddableBuilder(Person.class).map(Person::getName).embed(Person::getTimestamp, (EmbeddableMappingConfigurationProvider)MappingEase.embeddableBuilder(Timestamp.class).map(Timestamp::getCreationDate).map(Timestamp::getModificationDate));
            FluentEntityMappingBuilder vehicleConfiguration = MappingEase.entityBuilder(Vehicle.class, Identifier.LONG_TYPE).mapKey(AbstractVehicle::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).mapPolymorphism((PolymorphismPolicy)PolymorphismPolicy.joinTable().addSubClass((SubEntityMappingConfigurationProvider)MappingEase.subentityBuilder(Truck.class)).addSubClass((SubEntityMappingConfigurationProvider)MappingEase.subentityBuilder(Car.class)));
            EntityPersister testInstance = MappingEase.entityBuilder(Person.class, Identifier.LONG_TYPE).mapKey(Person::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).mapOneToOne(Person::getVehicle, (EntityMappingConfigurationProvider)vehicleConfiguration).mappedBy(Vehicle::getOwner).cascading(CascadeOptions.RelationMode.ALL_ORPHAN_REMOVAL).mapSuperClass((EmbeddableMappingConfigurationProvider)timestampedPersistentBeanMapping).build(FluentEntityMappingConfigurationSupportPolymorphismWithRelationTest.this.persistenceContext);
            DDLDeployer ddlDeployer = new DDLDeployer(FluentEntityMappingConfigurationSupportPolymorphismWithRelationTest.this.persistenceContext);
            ddlDeployer.deployDDL();
            EntityPersister vehiclePersister = vehicleConfiguration.build(FluentEntityMappingConfigurationSupportPolymorphismWithRelationTest.this.persistenceContext);
            Person person = new Person(1L);
            person.setVehicle(new Car(42L));
            testInstance.insert((Object)person);
            Person loadedPerson = (Person)testInstance.select(person.getId());
            Assertions.assertThat((Object)loadedPerson).isEqualTo((Object)person);
            person.setTimestamp(new Timestamp());
            testInstance.update((Object)person, (Object)loadedPerson, true);
            loadedPerson = (Person)testInstance.select(person.getId());
            Assertions.assertThat((Object)loadedPerson).isEqualTo((Object)person);
            person.setVehicle(new Truck(666L));
            testInstance.update((Object)person, (Object)loadedPerson, true);
            loadedPerson = (Person)testInstance.select(person.getId());
            Assertions.assertThat((Object)loadedPerson).isEqualTo((Object)person);
            Assertions.assertThat((Object)vehiclePersister.select(new PersistedIdentifier<Long>(42L))).isNull();
            person.setVehicle(null);
            testInstance.update((Object)person, (Object)loadedPerson, true);
            loadedPerson = (Person)testInstance.select(person.getId());
            Assertions.assertThat((Object)loadedPerson).isEqualTo((Object)person);
            Assertions.assertThat((Object)vehiclePersister.select(new PersistedIdentifier<Long>(666L))).isNull();
            person.setVehicle(new Truck(17L));
            testInstance.update((Object)person, (Object)loadedPerson, true);
            loadedPerson = (Person)testInstance.select(person.getId());
            Assertions.assertThat((Object)loadedPerson).isEqualTo((Object)person);
            testInstance.delete((Object)person);
            Assertions.assertThat((Object)testInstance.select(person.getId())).isNull();
            Assertions.assertThat((Object)vehiclePersister.select(new PersistedIdentifier<Long>(17L))).isNull();
        }

        @Test
        void oneToSingleTable_crud() {
            FluentEmbeddableMappingBuilder.FluentEmbeddableMappingBuilderEmbeddableMappingConfigurationImportedEmbedOptions timestampedPersistentBeanMapping = MappingEase.embeddableBuilder(Person.class).map(Person::getName).embed(Person::getTimestamp, (EmbeddableMappingConfigurationProvider)MappingEase.embeddableBuilder(Timestamp.class).map(Timestamp::getCreationDate).map(Timestamp::getModificationDate));
            FluentEntityMappingBuilder vehicleConfiguration = MappingEase.entityBuilder(Vehicle.class, Identifier.LONG_TYPE).mapKey(AbstractVehicle::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Vehicle::getColor).mapPolymorphism((PolymorphismPolicy)PolymorphismPolicy.singleTable().addSubClass((SubEntityMappingConfigurationProvider)MappingEase.subentityBuilder(Truck.class), (Object)"T").addSubClass((SubEntityMappingConfigurationProvider)MappingEase.subentityBuilder(Car.class), (Object)"C"));
            EntityPersister vehiclePersister = vehicleConfiguration.build(FluentEntityMappingConfigurationSupportPolymorphismWithRelationTest.this.persistenceContext);
            EntityPersister testInstance = MappingEase.entityBuilder(Person.class, Identifier.LONG_TYPE).mapKey(Person::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).mapOneToOne(Person::getVehicle, (EntityMappingConfigurationProvider)vehicleConfiguration).cascading(CascadeOptions.RelationMode.ALL_ORPHAN_REMOVAL).mapSuperClass((EmbeddableMappingConfigurationProvider)timestampedPersistentBeanMapping).build(FluentEntityMappingConfigurationSupportPolymorphismWithRelationTest.this.persistenceContext);
            DDLDeployer ddlDeployer = new DDLDeployer(FluentEntityMappingConfigurationSupportPolymorphismWithRelationTest.this.persistenceContext);
            ddlDeployer.deployDDL();
            Person person = new Person(1L);
            Car car = new Car(42L);
            car.setColor(new Color(17));
            person.setVehicle(car);
            testInstance.insert((Object)person);
            Person loadedPerson = (Person)testInstance.select(person.getId());
            Assertions.assertThat((Object)loadedPerson).isEqualTo((Object)person);
            person.setTimestamp(new Timestamp());
            testInstance.update((Object)person, (Object)loadedPerson, true);
            loadedPerson = (Person)testInstance.select(person.getId());
            ObjectPrinterBuilder.ObjectPrinter vehiclePrinter = new ObjectPrinterBuilder().addProperty(AbstractVehicle::getId).addProperty(Object::getClass).withPrinter(AbstractIdentifier.class, Functions.chain(AbstractIdentifier::getDelegate, String::valueOf)).build();
            ObjectPrinterBuilder.ObjectPrinter personPrinter = new ObjectPrinterBuilder().addProperty(Person::getId).addProperty(Person::getName).addProperty(Person::getTimestamp).withPrinter(AbstractIdentifier.class, Functions.chain(AbstractIdentifier::getDelegate, String::valueOf)).withPrinter(Vehicle.class, arg_0 -> ((ObjectPrinterBuilder.ObjectPrinter)vehiclePrinter).toString(arg_0)).build();
            ((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)loadedPerson).usingComparator(Comparator.comparing(arg_0 -> ((ObjectPrinterBuilder.ObjectPrinter)personPrinter).toString(arg_0)))).withRepresentation(new PartialRepresentation<Person>(Person.class, personPrinter))).isEqualTo((Object)person);
            Assertions.assertThat((Object)loadedPerson.getVehicle().getOwner()).isEqualTo((Object)loadedPerson);
            person.setVehicle(new Truck(666L));
            testInstance.update((Object)person, (Object)loadedPerson, true);
            loadedPerson = (Person)testInstance.select(person.getId());
            ((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)loadedPerson).usingComparator(Comparator.comparing(arg_0 -> ((ObjectPrinterBuilder.ObjectPrinter)personPrinter).toString(arg_0)))).withRepresentation(new PartialRepresentation<Person>(Person.class, personPrinter))).isEqualTo((Object)person);
            Assertions.assertThat((Object)vehiclePersister.select(new PersistedIdentifier<Long>(42L))).isNull();
            person.setVehicle(null);
            testInstance.update((Object)person, (Object)loadedPerson, true);
            loadedPerson = (Person)testInstance.select(person.getId());
            Assertions.assertThat((Object)loadedPerson).isEqualTo((Object)person);
            Assertions.assertThat((Object)vehiclePersister.select(new PersistedIdentifier<Long>(666L))).isNull();
            person.setVehicle(new Truck(17L));
            testInstance.update((Object)person, (Object)loadedPerson, true);
            loadedPerson = (Person)testInstance.select(person.getId());
            Assertions.assertThat((Object)loadedPerson).isEqualTo((Object)person);
            testInstance.delete((Object)person);
            Assertions.assertThat((Object)testInstance.select(person.getId())).isNull();
            Assertions.assertThat((Object)vehiclePersister.select(new PersistedIdentifier<Long>(17L))).isNull();
        }

        @Test
        void oneToSingleTable_crud_ownedByReverseSide() {
            FluentEmbeddableMappingBuilder.FluentEmbeddableMappingBuilderEmbeddableMappingConfigurationImportedEmbedOptions timestampedPersistentBeanMapping = MappingEase.embeddableBuilder(Person.class).map(Person::getName).embed(Person::getTimestamp, (EmbeddableMappingConfigurationProvider)MappingEase.embeddableBuilder(Timestamp.class).map(Timestamp::getCreationDate).map(Timestamp::getModificationDate));
            FluentEntityMappingBuilder vehicleConfiguration = MappingEase.entityBuilder(Vehicle.class, Identifier.LONG_TYPE).mapKey(AbstractVehicle::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Vehicle::getColor).mapPolymorphism((PolymorphismPolicy)PolymorphismPolicy.singleTable().addSubClass((SubEntityMappingConfigurationProvider)MappingEase.subentityBuilder(Truck.class), (Object)"T").addSubClass((SubEntityMappingConfigurationProvider)MappingEase.subentityBuilder(Car.class), (Object)"C"));
            EntityPersister testInstance = MappingEase.entityBuilder(Person.class, Identifier.LONG_TYPE).mapKey(Person::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).mapOneToOne(Person::getVehicle, (EntityMappingConfigurationProvider)vehicleConfiguration).cascading(CascadeOptions.RelationMode.ALL_ORPHAN_REMOVAL).mappedBy(Vehicle::getOwner).mapSuperClass((EmbeddableMappingConfigurationProvider)timestampedPersistentBeanMapping).build(FluentEntityMappingConfigurationSupportPolymorphismWithRelationTest.this.persistenceContext);
            DDLDeployer ddlDeployer = new DDLDeployer(FluentEntityMappingConfigurationSupportPolymorphismWithRelationTest.this.persistenceContext);
            ddlDeployer.deployDDL();
            EntityPersister vehiclePersister = vehicleConfiguration.build(FluentEntityMappingConfigurationSupportPolymorphismWithRelationTest.this.persistenceContext);
            Person person = new Person(1L);
            Car car = new Car(42L);
            car.setColor(new Color(17));
            person.setVehicle(car);
            testInstance.insert((Object)person);
            Person loadedPerson = (Person)testInstance.select(person.getId());
            Assertions.assertThat((Object)loadedPerson).isEqualTo((Object)person);
            person.setTimestamp(new Timestamp());
            testInstance.update((Object)person, (Object)loadedPerson, true);
            loadedPerson = (Person)testInstance.select(person.getId());
            ObjectPrinterBuilder.ObjectPrinter vehiclePrinter = new ObjectPrinterBuilder().addProperty(AbstractVehicle::getId).addProperty(Object::getClass).withPrinter(AbstractIdentifier.class, Functions.chain(AbstractIdentifier::getDelegate, String::valueOf)).build();
            ObjectPrinterBuilder.ObjectPrinter personPrinter = new ObjectPrinterBuilder().addProperty(Person::getId).addProperty(Person::getName).addProperty(Person::getTimestamp).withPrinter(AbstractIdentifier.class, Functions.chain(AbstractIdentifier::getDelegate, String::valueOf)).withPrinter(Vehicle.class, arg_0 -> ((ObjectPrinterBuilder.ObjectPrinter)vehiclePrinter).toString(arg_0)).build();
            ((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)loadedPerson).usingComparator(Comparator.comparing(arg_0 -> ((ObjectPrinterBuilder.ObjectPrinter)personPrinter).toString(arg_0)))).withRepresentation(new PartialRepresentation<Person>(Person.class, personPrinter))).isEqualTo((Object)person);
            Assertions.assertThat((Object)loadedPerson.getVehicle().getOwner()).isEqualTo((Object)loadedPerson);
            person.setVehicle(new Truck(666L));
            testInstance.update((Object)person, (Object)loadedPerson, true);
            loadedPerson = (Person)testInstance.select(person.getId());
            ((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)loadedPerson).usingComparator(Comparator.comparing(arg_0 -> ((ObjectPrinterBuilder.ObjectPrinter)personPrinter).toString(arg_0)))).withRepresentation(new PartialRepresentation<Person>(Person.class, personPrinter))).isEqualTo((Object)person);
            Assertions.assertThat((Object)vehiclePersister.select(new PersistedIdentifier<Long>(42L))).isNull();
            person.setVehicle(null);
            testInstance.update((Object)person, (Object)loadedPerson, true);
            loadedPerson = (Person)testInstance.select(person.getId());
            Assertions.assertThat((Object)loadedPerson).isEqualTo((Object)person);
            Assertions.assertThat((Object)vehiclePersister.select(new PersistedIdentifier<Long>(666L))).isNull();
            person.setVehicle(new Truck(17L));
            testInstance.update((Object)person, (Object)loadedPerson, true);
            loadedPerson = (Person)testInstance.select(person.getId());
            Assertions.assertThat((Object)loadedPerson).isEqualTo((Object)person);
            testInstance.delete((Object)person);
            Assertions.assertThat((Object)testInstance.select(person.getId())).isNull();
            Assertions.assertThat((Object)vehiclePersister.select(new PersistedIdentifier<Long>(17L))).isNull();
        }
    }

    @Nested
    class TablePerClassWithOneToOne {
        TablePerClassWithOneToOne() {
        }

        @Test
        void oneSubClass() {
            EntityPersister abstractVehiclePersister = MappingEase.entityBuilder(Vehicle.class, Identifier.LONG_TYPE).mapKey(AbstractVehicle::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).mapOneToOne(Vehicle::getEngine, (EntityMappingConfigurationProvider)MappingEase.entityBuilder(Engine.class, Identifier.LONG_TYPE).mapKey(Engine::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED)).cascading(CascadeOptions.RelationMode.ALL_ORPHAN_REMOVAL).mapPolymorphism((PolymorphismPolicy)PolymorphismPolicy.tablePerClass().addSubClass((SubEntityMappingConfigurationProvider)MappingEase.subentityBuilder(Car.class).map(AbstractVehicle::getId).map(Car::getModel).map(Vehicle::getColor))).build(FluentEntityMappingConfigurationSupportPolymorphismWithRelationTest.this.persistenceContext);
            HashSet tables = (HashSet)Iterables.collect((Iterable)DDLDeployer.collectTables((PersistenceContext)FluentEntityMappingConfigurationSupportPolymorphismWithRelationTest.this.persistenceContext), Table::getName, HashSet::new);
            Assertions.assertThat((Collection)tables).containsExactlyInAnyOrder((Object[])new String[]{"Car", "Engine"});
            Assertions.assertThat((Collection)FluentEntityMappingConfigurationSupportPolymorphismWithRelationTest.this.persistenceContext.getPersisters()).extracting(EntityPersister::getClassToPersist).containsExactlyInAnyOrder((Object[])new Class[]{Vehicle.class});
            DDLDeployer ddlDeployer = new DDLDeployer(FluentEntityMappingConfigurationSupportPolymorphismWithRelationTest.this.persistenceContext);
            ddlDeployer.deployDDL();
            Car dummyCar = new Car(1L);
            dummyCar.setModel("Renault");
            dummyCar.setEngine(new Engine(100L));
            dummyCar.setColor(new Color(666));
            abstractVehiclePersister.insert((Object)dummyCar);
            PersistenceContext.ExecutableBeanPropertyQueryMapper modelQuery = FluentEntityMappingConfigurationSupportPolymorphismWithRelationTest.this.persistenceContext.newQuery((CharSequence)"select * from car", String.class).mapKey("model", String.class);
            Set allCars = (Set)modelQuery.execute(Accumulators.toSet());
            Assertions.assertThat((Collection)allCars).containsExactly((Object[])new String[]{"Renault"});
            dummyCar.setModel("Peugeot");
            abstractVehiclePersister.persist((Object)dummyCar);
            Set existingModels = (Set)modelQuery.execute(Accumulators.toSet());
            Assertions.assertThat((Collection)existingModels).containsExactly((Object[])new String[]{"Peugeot"});
            AbstractVehicle loadedCar = (AbstractVehicle)abstractVehiclePersister.select(new PersistedIdentifier<Long>(1L));
            Assertions.assertThat((Object)loadedCar).isEqualTo((Object)dummyCar);
            abstractVehiclePersister.delete((Object)dummyCar);
            existingModels = (Set)modelQuery.execute(Accumulators.toSet());
            Assertions.assertThat((Collection)existingModels).isEmpty();
            PersistenceContext.ExecutableBeanPropertyQueryMapper engineQuery = FluentEntityMappingConfigurationSupportPolymorphismWithRelationTest.this.persistenceContext.newQuery((CharSequence)"select id from Engine", Long.class).mapKey("id", Long.class);
            Assertions.assertThat((Collection)((Collection)engineQuery.execute(Accumulators.toSet()))).isEmpty();
        }

        @Test
        void twoSubClasses() {
            EntityPersister abstractVehiclePersister = MappingEase.entityBuilder(Vehicle.class, Identifier.LONG_TYPE).mapKey(AbstractVehicle::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).mapOneToOne(Vehicle::getEngine, (EntityMappingConfigurationProvider)MappingEase.entityBuilder(Engine.class, Identifier.LONG_TYPE).mapKey(Engine::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED)).cascading(CascadeOptions.RelationMode.ALL_ORPHAN_REMOVAL).mapPolymorphism((PolymorphismPolicy)PolymorphismPolicy.tablePerClass().addSubClass((SubEntityMappingConfigurationProvider)MappingEase.subentityBuilder(Car.class).map(Car::getModel).map(Vehicle::getColor)).addSubClass((SubEntityMappingConfigurationProvider)MappingEase.subentityBuilder(Truck.class).map(Vehicle::getColor))).build(FluentEntityMappingConfigurationSupportPolymorphismWithRelationTest.this.persistenceContext);
            HashSet tables = (HashSet)Iterables.collect((Iterable)DDLDeployer.collectTables((PersistenceContext)FluentEntityMappingConfigurationSupportPolymorphismWithRelationTest.this.persistenceContext), Table::getName, HashSet::new);
            Assertions.assertThat((Collection)tables).containsExactlyInAnyOrder((Object[])new String[]{"Car", "Truck", "Engine"});
            Assertions.assertThat((Collection)FluentEntityMappingConfigurationSupportPolymorphismWithRelationTest.this.persistenceContext.getPersisters()).extracting(EntityPersister::getClassToPersist).containsExactlyInAnyOrder((Object[])new Class[]{Vehicle.class});
            DDLDeployer ddlDeployer = new DDLDeployer(FluentEntityMappingConfigurationSupportPolymorphismWithRelationTest.this.persistenceContext);
            ddlDeployer.deployDDL();
            Car dummyCar = new Car(1L);
            dummyCar.setModel("Renault");
            dummyCar.setEngine(new Engine(100L));
            dummyCar.setColor(new Color(666));
            Truck dummyTruck = new Truck(2L);
            dummyCar.setEngine(new Engine(200L));
            dummyTruck.setColor(new Color(42));
            abstractVehiclePersister.insert((Iterable)Arrays.asList((Object[])new Vehicle[]{dummyCar, dummyTruck}));
            PersistenceContext.ExecutableBeanPropertyQueryMapper carIdQuery = FluentEntityMappingConfigurationSupportPolymorphismWithRelationTest.this.persistenceContext.newQuery((CharSequence)"select id from car", Integer.class).mapKey("id", Integer.class);
            Set carIds = (Set)carIdQuery.execute(Accumulators.toSet());
            Assertions.assertThat((Collection)carIds).containsExactly((Object[])new Integer[]{1});
            PersistenceContext.ExecutableBeanPropertyQueryMapper truckIdQuery = FluentEntityMappingConfigurationSupportPolymorphismWithRelationTest.this.persistenceContext.newQuery((CharSequence)"select id from truck", Integer.class).mapKey("id", Integer.class);
            Set truckIds = (Set)truckIdQuery.execute(Accumulators.toSet());
            Assertions.assertThat((Collection)truckIds).containsExactly((Object[])new Integer[]{2});
            dummyCar.setModel("Peugeot");
            abstractVehiclePersister.persist((Object)dummyCar);
            AbstractVehicle loadedVehicle = (AbstractVehicle)abstractVehiclePersister.select(new PersistedIdentifier<Long>(1L));
            Assertions.assertThat((Object)loadedVehicle).isEqualTo((Object)dummyCar);
            loadedVehicle = (AbstractVehicle)abstractVehiclePersister.select(new PersistedIdentifier<Long>(2L));
            Assertions.assertThat((Object)loadedVehicle).isEqualTo((Object)dummyTruck);
            Set loadedVehicles = abstractVehiclePersister.selectAll();
            Assertions.assertThat((Collection)loadedVehicles).containsExactlyInAnyOrder((Object[])new Vehicle[]{dummyCar, dummyTruck});
            abstractVehiclePersister.delete((Iterable)Arrays.asList((Object[])new Vehicle[]{dummyCar, dummyTruck}));
            PersistenceContext.ExecutableBeanPropertyQueryMapper carQuery = FluentEntityMappingConfigurationSupportPolymorphismWithRelationTest.this.persistenceContext.newQuery((CharSequence)("select count(*) as carCount from car where id = " + dummyCar.getId().getDelegate()), Integer.class).mapKey("carCount", Integer.class);
            Integer carCount = (Integer)Iterables.first((Iterable)((Iterable)carQuery.execute(Accumulators.toSet())));
            Assertions.assertThat((Integer)carCount).isEqualTo(0);
            PersistenceContext.ExecutableBeanPropertyQueryMapper truckQuery = FluentEntityMappingConfigurationSupportPolymorphismWithRelationTest.this.persistenceContext.newQuery((CharSequence)("select count(*) as truckCount from car where id = " + dummyTruck.getId().getDelegate()), Integer.class).mapKey("truckCount", Integer.class);
            Integer truckCount = (Integer)Iterables.first((Iterable)((Iterable)truckQuery.execute(Accumulators.toSet())));
            Assertions.assertThat((Integer)truckCount).isEqualTo(0);
            PersistenceContext.ExecutableBeanPropertyQueryMapper engineQuery = FluentEntityMappingConfigurationSupportPolymorphismWithRelationTest.this.persistenceContext.newQuery((CharSequence)"select id from Engine", Long.class).mapKey("id", Long.class);
            Assertions.assertThat((Collection)((Collection)engineQuery.execute(Accumulators.toSet()))).isEmpty();
        }

        @Test
        void twoSubClasses_withCommonProperties() {
            EntityPersister abstractVehiclePersister = MappingEase.entityBuilder(Vehicle.class, Identifier.LONG_TYPE).mapKey(AbstractVehicle::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Vehicle::getColor).mapOneToOne(Vehicle::getEngine, (EntityMappingConfigurationProvider)MappingEase.entityBuilder(Engine.class, Identifier.LONG_TYPE).mapKey(Engine::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED)).cascading(CascadeOptions.RelationMode.ALL_ORPHAN_REMOVAL).mapPolymorphism((PolymorphismPolicy)PolymorphismPolicy.tablePerClass().addSubClass((SubEntityMappingConfigurationProvider)MappingEase.subentityBuilder(Car.class).map(Car::getModel)).addSubClass((SubEntityMappingConfigurationProvider)MappingEase.subentityBuilder(Truck.class))).build(FluentEntityMappingConfigurationSupportPolymorphismWithRelationTest.this.persistenceContext);
            HashSet tables = (HashSet)Iterables.collect((Iterable)DDLDeployer.collectTables((PersistenceContext)FluentEntityMappingConfigurationSupportPolymorphismWithRelationTest.this.persistenceContext), Table::getName, HashSet::new);
            Assertions.assertThat((Collection)tables).containsExactlyInAnyOrder((Object[])new String[]{"Car", "Truck", "Engine"});
            Assertions.assertThat((Collection)FluentEntityMappingConfigurationSupportPolymorphismWithRelationTest.this.persistenceContext.getPersisters()).extracting(EntityPersister::getClassToPersist).containsExactlyInAnyOrder((Object[])new Class[]{Vehicle.class});
            DDLDeployer ddlDeployer = new DDLDeployer(FluentEntityMappingConfigurationSupportPolymorphismWithRelationTest.this.persistenceContext);
            ddlDeployer.deployDDL();
            Car dummyCar = new Car(1L);
            dummyCar.setModel("Renault");
            dummyCar.setEngine(new Engine(100L));
            dummyCar.setColor(new Color(666));
            Truck dummyTruck = new Truck(2L);
            dummyCar.setEngine(new Engine(200L));
            dummyTruck.setColor(new Color(42));
            abstractVehiclePersister.insert((Iterable)Arrays.asList((Object[])new Vehicle[]{dummyCar, dummyTruck}));
            PersistenceContext.ExecutableBeanPropertyQueryMapper carIdQuery = FluentEntityMappingConfigurationSupportPolymorphismWithRelationTest.this.persistenceContext.newQuery((CharSequence)"select id from car", Integer.class).mapKey("id", Integer.class);
            Set carIds = (Set)carIdQuery.execute(Accumulators.toSet());
            Assertions.assertThat((Collection)carIds).containsExactly((Object[])new Integer[]{1});
            PersistenceContext.ExecutableBeanPropertyQueryMapper truckIdQuery = FluentEntityMappingConfigurationSupportPolymorphismWithRelationTest.this.persistenceContext.newQuery((CharSequence)"select id from truck", Integer.class).mapKey("id", Integer.class);
            Set truckIds = (Set)truckIdQuery.execute(Accumulators.toSet());
            Assertions.assertThat((Collection)truckIds).containsExactly((Object[])new Integer[]{2});
            dummyCar.setModel("Peugeot");
            abstractVehiclePersister.persist((Object)dummyCar);
            Vehicle loadedVehicle = (Vehicle)abstractVehiclePersister.select(new PersistedIdentifier<Long>(1L));
            Assertions.assertThat((Object)loadedVehicle).isEqualTo((Object)dummyCar);
            loadedVehicle = (Vehicle)abstractVehiclePersister.select(new PersistedIdentifier<Long>(2L));
            Assertions.assertThat((Object)loadedVehicle).isEqualTo((Object)dummyTruck);
            EntityPersister.ExecutableEntityQuery vehicleExecutableQuery1 = abstractVehiclePersister.selectWhere(Vehicle::getColor, (ConditionalOperator)Operators.eq((Object)new Color(42)));
            Set loadedVehicles = (Set)vehicleExecutableQuery1.execute(Accumulators.toSet());
            Assertions.assertThat((Collection)loadedVehicles).containsExactlyInAnyOrder((Object[])new Vehicle[]{dummyTruck});
            EntityPersister.ExecutableEntityQuery vehicleExecutableQuery = abstractVehiclePersister.selectWhere(Vehicle::getColor, (ConditionalOperator)Operators.eq((Object)new Color(666)));
            loadedVehicles = (Set)vehicleExecutableQuery.execute(Accumulators.toSet());
            Assertions.assertThat((Collection)loadedVehicles).containsExactlyInAnyOrder((Object[])new Vehicle[]{dummyCar});
            abstractVehiclePersister.delete((Iterable)Arrays.asList((Object[])new Vehicle[]{dummyCar, dummyTruck}));
            PersistenceContext.ExecutableBeanPropertyQueryMapper carQuery = FluentEntityMappingConfigurationSupportPolymorphismWithRelationTest.this.persistenceContext.newQuery((CharSequence)("select count(*) as carCount from car where id = " + dummyCar.getId().getDelegate()), Integer.class).mapKey("carCount", Integer.class);
            Integer carCount = (Integer)Iterables.first((Iterable)((Iterable)carQuery.execute(Accumulators.toSet())));
            Assertions.assertThat((Integer)carCount).isEqualTo(0);
            PersistenceContext.ExecutableBeanPropertyQueryMapper truckQuery = FluentEntityMappingConfigurationSupportPolymorphismWithRelationTest.this.persistenceContext.newQuery((CharSequence)("select count(*) as truckCount from truck where id = " + dummyTruck.getId().getDelegate()), Integer.class).mapKey("truckCount", Integer.class);
            Integer truckCount = (Integer)Iterables.first((Iterable)((Iterable)truckQuery.execute(Accumulators.toSet())));
            Assertions.assertThat((Integer)truckCount).isEqualTo(0);
            PersistenceContext.ExecutableBeanPropertyQueryMapper engineQuery = FluentEntityMappingConfigurationSupportPolymorphismWithRelationTest.this.persistenceContext.newQuery((CharSequence)"select id from Engine", Long.class).mapKey("id", Long.class);
            Assertions.assertThat((Collection)((Collection)engineQuery.execute(Accumulators.toSet()))).isEmpty();
        }

        @Test
        void listenersAreNotified() {
            EntityPersister abstractVehiclePersister = MappingEase.entityBuilder(Vehicle.class, Identifier.LONG_TYPE).mapKey(AbstractVehicle::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).mapOneToOne(Vehicle::getEngine, (EntityMappingConfigurationProvider)MappingEase.entityBuilder(Engine.class, Identifier.LONG_TYPE).mapKey(Engine::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED)).cascading(CascadeOptions.RelationMode.ALL_ORPHAN_REMOVAL).mapPolymorphism((PolymorphismPolicy)PolymorphismPolicy.tablePerClass().addSubClass((SubEntityMappingConfigurationProvider)MappingEase.subentityBuilder(Car.class).map(Car::getModel).map(Vehicle::getColor))).build(FluentEntityMappingConfigurationSupportPolymorphismWithRelationTest.this.persistenceContext);
            DDLDeployer ddlDeployer = new DDLDeployer(FluentEntityMappingConfigurationSupportPolymorphismWithRelationTest.this.persistenceContext);
            ddlDeployer.deployDDL();
            Car dummyCar = new Car(1L);
            dummyCar.setModel("Renault");
            dummyCar.setColor(new Color(666));
            PersistListener persistListenerMock = (PersistListener)Mockito.mock(PersistListener.class);
            InsertListener insertListenerMock = (InsertListener)Mockito.mock(InsertListener.class);
            UpdateListener updateListenerMock = (UpdateListener)Mockito.mock(UpdateListener.class);
            SelectListener selectListenerMock = (SelectListener)Mockito.mock(SelectListener.class);
            DeleteListener deleteListenerMock = (DeleteListener)Mockito.mock(DeleteListener.class);
            abstractVehiclePersister.addPersistListener(persistListenerMock);
            abstractVehiclePersister.addInsertListener(insertListenerMock);
            abstractVehiclePersister.addUpdateListener(updateListenerMock);
            abstractVehiclePersister.addSelectListener(selectListenerMock);
            abstractVehiclePersister.addDeleteListener(deleteListenerMock);
            abstractVehiclePersister.insert((Object)dummyCar);
            ((InsertListener)Mockito.verify((Object)insertListenerMock)).beforeInsert((Iterable)Arrays.asList((Object[])new Car[]{dummyCar}));
            ((InsertListener)Mockito.verify((Object)insertListenerMock)).afterInsert((Iterable)Arrays.asList((Object[])new Car[]{dummyCar}));
            abstractVehiclePersister.update((Object)dummyCar, (Object)dummyCar, true);
            ((UpdateListener)Mockito.verify((Object)updateListenerMock)).beforeUpdate((Iterable)ArgumentMatchers.any(), ArgumentMatchers.eq((boolean)true));
            ((UpdateListener)Mockito.verify((Object)updateListenerMock)).afterUpdate((Iterable)ArgumentMatchers.any(), ArgumentMatchers.eq((boolean)true));
            abstractVehiclePersister.delete((Object)dummyCar);
            ((DeleteListener)Mockito.verify((Object)deleteListenerMock)).beforeDelete((Iterable)Arrays.asList((Object[])new Car[]{dummyCar}));
            ((DeleteListener)Mockito.verify((Object)deleteListenerMock)).afterDelete((Iterable)Arrays.asList((Object[])new Car[]{dummyCar}));
            Mockito.clearInvocations((Object[])new Object[]{insertListenerMock, updateListenerMock, selectListenerMock});
            dummyCar = new Car(1L);
            dummyCar.setModel("Renault");
            dummyCar.setColor(new Color(666));
            abstractVehiclePersister.persist((Object)dummyCar);
            ((PersistListener)Mockito.verify((Object)persistListenerMock)).beforePersist((Iterable)Arrays.asHashSet((Object[])new Car[]{dummyCar}));
            ((PersistListener)Mockito.verify((Object)persistListenerMock)).afterPersist((Iterable)Arrays.asHashSet((Object[])new Car[]{dummyCar}));
            ((InsertListener)Mockito.verify((Object)insertListenerMock)).beforeInsert((Iterable)Arrays.asList((Object[])new Car[]{dummyCar}));
            ((InsertListener)Mockito.verify((Object)insertListenerMock)).afterInsert((Iterable)Arrays.asList((Object[])new Car[]{dummyCar}));
            ((SelectListener)Mockito.verify((Object)selectListenerMock)).beforeSelect((Iterable)Arrays.asHashSet((Object[])new Identifier[]{dummyCar.getId()}));
            ((SelectListener)Mockito.verify((Object)selectListenerMock, (VerificationMode)Mockito.times((int)2))).afterSelect(Collections.emptySet());
            Mockito.clearInvocations((Object[])new SelectListener[]{selectListenerMock});
            dummyCar.setModel("Peugeot");
            abstractVehiclePersister.persist((Object)dummyCar);
            ((UpdateListener)Mockito.verify((Object)updateListenerMock)).beforeUpdate((Iterable)ArgumentMatchers.any(), ArgumentMatchers.eq((boolean)true));
            ((UpdateListener)Mockito.verify((Object)updateListenerMock)).afterUpdate((Iterable)ArgumentMatchers.any(), ArgumentMatchers.eq((boolean)true));
            ((SelectListener)Mockito.verify((Object)selectListenerMock)).beforeSelect((Iterable)Arrays.asHashSet((Object[])new Identifier[]{dummyCar.getId()}));
            dummyCar.setModel("Renault");
            ((SelectListener)Mockito.verify((Object)selectListenerMock, (VerificationMode)Mockito.times((int)2))).afterSelect((Set)Arrays.asHashSet((Object[])new Car[]{dummyCar}));
            Mockito.clearInvocations((Object[])new SelectListener[]{selectListenerMock});
            AbstractVehicle loadedCar = (AbstractVehicle)abstractVehiclePersister.select(new PersistedIdentifier<Long>(1L));
            ((SelectListener)Mockito.verify((Object)selectListenerMock)).beforeSelect((Iterable)Arrays.asHashSet((Object[])new PersistedIdentifier[]{new PersistedIdentifier<Long>(1L)}));
            ((SelectListener)Mockito.verify((Object)selectListenerMock, (VerificationMode)Mockito.times((int)2))).afterSelect((Set)Arrays.asHashSet((Object[])new AbstractVehicle[]{loadedCar}));
        }
    }

    @Nested
    class JoinTableWithOneToOne {
        JoinTableWithOneToOne() {
        }

        @Test
        void oneSubClass() {
            EntityPersister abstractVehiclePersister = MappingEase.entityBuilder(Vehicle.class, Identifier.LONG_TYPE).mapKey(AbstractVehicle::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).mapOneToOne(Vehicle::getEngine, (EntityMappingConfigurationProvider)MappingEase.entityBuilder(Engine.class, Identifier.LONG_TYPE).mapKey(Engine::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED)).cascading(CascadeOptions.RelationMode.ALL_ORPHAN_REMOVAL).mapPolymorphism((PolymorphismPolicy)PolymorphismPolicy.joinTable().addSubClass((SubEntityMappingConfigurationProvider)MappingEase.subentityBuilder(Car.class).map(Car::getModel).map(Vehicle::getColor))).build(FluentEntityMappingConfigurationSupportPolymorphismWithRelationTest.this.persistenceContext);
            HashSet tables = (HashSet)Iterables.collect((Iterable)DDLDeployer.collectTables((PersistenceContext)FluentEntityMappingConfigurationSupportPolymorphismWithRelationTest.this.persistenceContext), Table::getName, HashSet::new);
            Assertions.assertThat((Collection)tables).containsExactlyInAnyOrder((Object[])new String[]{"Vehicle", "Car", "Engine"});
            Assertions.assertThat((Collection)FluentEntityMappingConfigurationSupportPolymorphismWithRelationTest.this.persistenceContext.getPersisters()).extracting(EntityPersister::getClassToPersist).containsExactlyInAnyOrder((Object[])new Class[]{Vehicle.class});
            DDLDeployer ddlDeployer = new DDLDeployer(FluentEntityMappingConfigurationSupportPolymorphismWithRelationTest.this.persistenceContext);
            ddlDeployer.deployDDL();
            Car dummyCar = new Car(1L);
            dummyCar.setModel("Renault");
            dummyCar.setEngine(new Engine(100L));
            dummyCar.setColor(new Color(666));
            abstractVehiclePersister.insert((Object)dummyCar);
            PersistenceContext.ExecutableBeanPropertyQueryMapper modelQuery = FluentEntityMappingConfigurationSupportPolymorphismWithRelationTest.this.persistenceContext.newQuery((CharSequence)"select * from Vehicle left outer join car on Vehicle.id = car.id", String.class).mapKey("model", String.class);
            Set allCars = (Set)modelQuery.execute(Accumulators.toSet());
            Assertions.assertThat((Collection)allCars).containsExactly((Object[])new String[]{"Renault"});
            dummyCar.setModel("Peugeot");
            abstractVehiclePersister.persist((Object)dummyCar);
            Set existingModels = (Set)modelQuery.execute(Accumulators.toSet());
            Assertions.assertThat((Collection)existingModels).containsExactly((Object[])new String[]{"Peugeot"});
            AbstractVehicle loadedCar = (AbstractVehicle)abstractVehiclePersister.select(new PersistedIdentifier<Long>(1L));
            Assertions.assertThat((Object)loadedCar).isEqualTo((Object)dummyCar);
            abstractVehiclePersister.delete((Object)dummyCar);
            existingModels = (Set)modelQuery.execute(Accumulators.toSet());
            Assertions.assertThat((Collection)existingModels).isEmpty();
            PersistenceContext.ExecutableBeanPropertyQueryMapper engineQuery = FluentEntityMappingConfigurationSupportPolymorphismWithRelationTest.this.persistenceContext.newQuery((CharSequence)"select id from Engine", Long.class).mapKey("id", Long.class);
            Assertions.assertThat((Collection)((Collection)engineQuery.execute(Accumulators.toSet()))).isEmpty();
        }

        @Test
        void twoSubClasses() {
            EntityPersister abstractVehiclePersister = MappingEase.entityBuilder(Vehicle.class, Identifier.LONG_TYPE).mapKey(AbstractVehicle::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).mapOneToOne(Vehicle::getEngine, (EntityMappingConfigurationProvider)MappingEase.entityBuilder(Engine.class, Identifier.LONG_TYPE).mapKey(Engine::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED)).cascading(CascadeOptions.RelationMode.ALL_ORPHAN_REMOVAL).mapPolymorphism((PolymorphismPolicy)PolymorphismPolicy.joinTable().addSubClass((SubEntityMappingConfigurationProvider)MappingEase.subentityBuilder(Car.class).map(AbstractVehicle::getId).map(Car::getModel).map(Vehicle::getColor)).addSubClass((SubEntityMappingConfigurationProvider)MappingEase.subentityBuilder(Truck.class).map(AbstractVehicle::getId).map(Vehicle::getColor))).build(FluentEntityMappingConfigurationSupportPolymorphismWithRelationTest.this.persistenceContext);
            HashSet tables = (HashSet)Iterables.collect((Iterable)DDLDeployer.collectTables((PersistenceContext)FluentEntityMappingConfigurationSupportPolymorphismWithRelationTest.this.persistenceContext), Table::getName, HashSet::new);
            Assertions.assertThat((Collection)tables).containsExactlyInAnyOrder((Object[])new String[]{"Vehicle", "Car", "Truck", "Engine"});
            Assertions.assertThat((Collection)FluentEntityMappingConfigurationSupportPolymorphismWithRelationTest.this.persistenceContext.getPersisters()).extracting(EntityPersister::getClassToPersist).containsExactlyInAnyOrder((Object[])new Class[]{Vehicle.class});
            DDLDeployer ddlDeployer = new DDLDeployer(FluentEntityMappingConfigurationSupportPolymorphismWithRelationTest.this.persistenceContext);
            ddlDeployer.deployDDL();
            Car dummyCar = new Car(1L);
            dummyCar.setModel("Renault");
            dummyCar.setEngine(new Engine(100L));
            dummyCar.setColor(new Color(666));
            Truck dummyTruck = new Truck(2L);
            dummyCar.setEngine(new Engine(200L));
            dummyTruck.setColor(new Color(42));
            abstractVehiclePersister.insert((Iterable)Arrays.asList((Object[])new Vehicle[]{dummyCar, dummyTruck}));
            PersistenceContext.ExecutableBeanPropertyQueryMapper vehicleIdQuery = FluentEntityMappingConfigurationSupportPolymorphismWithRelationTest.this.persistenceContext.newQuery((CharSequence)"select id from Vehicle", Integer.class).mapKey("id", Integer.class);
            Set vehicleIds = (Set)vehicleIdQuery.execute(Accumulators.toSet());
            Assertions.assertThat((Collection)vehicleIds).containsExactly((Object[])new Integer[]{1, 2});
            PersistenceContext.ExecutableBeanPropertyQueryMapper carIdQuery = FluentEntityMappingConfigurationSupportPolymorphismWithRelationTest.this.persistenceContext.newQuery((CharSequence)"select id from car", Integer.class).mapKey("id", Integer.class);
            Set carIds = (Set)carIdQuery.execute(Accumulators.toSet());
            Assertions.assertThat((Collection)carIds).containsExactly((Object[])new Integer[]{1});
            PersistenceContext.ExecutableBeanPropertyQueryMapper truckIdQuery = FluentEntityMappingConfigurationSupportPolymorphismWithRelationTest.this.persistenceContext.newQuery((CharSequence)"select id from truck", Integer.class).mapKey("id", Integer.class);
            Set truckIds = (Set)truckIdQuery.execute(Accumulators.toSet());
            Assertions.assertThat((Collection)truckIds).containsExactly((Object[])new Integer[]{2});
            dummyCar.setModel("Peugeot");
            abstractVehiclePersister.persist((Object)dummyCar);
            AbstractVehicle loadedVehicle = (AbstractVehicle)abstractVehiclePersister.select(new PersistedIdentifier<Long>(1L));
            Assertions.assertThat((Object)loadedVehicle).isEqualTo((Object)dummyCar);
            loadedVehicle = (AbstractVehicle)abstractVehiclePersister.select(new PersistedIdentifier<Long>(2L));
            Assertions.assertThat((Object)loadedVehicle).isEqualTo((Object)dummyTruck);
            Set loadedVehicles = abstractVehiclePersister.selectAll();
            Assertions.assertThat((Collection)loadedVehicles).containsExactlyInAnyOrder((Object[])new Vehicle[]{dummyCar, dummyTruck});
            abstractVehiclePersister.delete((Iterable)Arrays.asList((Object[])new Vehicle[]{dummyCar, dummyTruck}));
            PersistenceContext.ExecutableBeanPropertyQueryMapper vehicleQuery = FluentEntityMappingConfigurationSupportPolymorphismWithRelationTest.this.persistenceContext.newQuery((CharSequence)("select count(*) as vehicleCount from Vehicle where id in (" + dummyCar.getId().getDelegate() + ", " + (Long)dummyTruck.getId().getDelegate() + ")"), Integer.class).mapKey("vehicleCount", Integer.class);
            Integer vehicleCount = (Integer)Iterables.first((Iterable)((Iterable)vehicleQuery.execute(Accumulators.toSet())));
            Assertions.assertThat((Integer)vehicleCount).isEqualTo(0);
            PersistenceContext.ExecutableBeanPropertyQueryMapper carQuery = FluentEntityMappingConfigurationSupportPolymorphismWithRelationTest.this.persistenceContext.newQuery((CharSequence)("select count(*) as carCount from car where id = " + dummyCar.getId().getDelegate()), Integer.class).mapKey("carCount", Integer.class);
            Integer carCount = (Integer)Iterables.first((Iterable)((Iterable)carQuery.execute(Accumulators.toSet())));
            Assertions.assertThat((Integer)carCount).isEqualTo(0);
            PersistenceContext.ExecutableBeanPropertyQueryMapper truckQuery = FluentEntityMappingConfigurationSupportPolymorphismWithRelationTest.this.persistenceContext.newQuery((CharSequence)("select count(*) as truckCount from car where id = " + dummyTruck.getId().getDelegate()), Integer.class).mapKey("truckCount", Integer.class);
            Integer truckCount = (Integer)Iterables.first((Iterable)((Iterable)truckQuery.execute(Accumulators.toSet())));
            Assertions.assertThat((Integer)truckCount).isEqualTo(0);
            PersistenceContext.ExecutableBeanPropertyQueryMapper engineQuery = FluentEntityMappingConfigurationSupportPolymorphismWithRelationTest.this.persistenceContext.newQuery((CharSequence)"select id from Engine", Long.class).mapKey("id", Long.class);
            Assertions.assertThat((Collection)((Collection)engineQuery.execute(Accumulators.toSet()))).isEmpty();
        }

        @Test
        void twoSubClasses_withCommonProperties() {
            EntityPersister abstractVehiclePersister = MappingEase.entityBuilder(Vehicle.class, Identifier.LONG_TYPE).mapKey(AbstractVehicle::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Vehicle::getColor).mapOneToOne(Vehicle::getEngine, (EntityMappingConfigurationProvider)MappingEase.entityBuilder(Engine.class, Identifier.LONG_TYPE).mapKey(Engine::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED)).cascading(CascadeOptions.RelationMode.ALL_ORPHAN_REMOVAL).mapPolymorphism((PolymorphismPolicy)PolymorphismPolicy.joinTable().addSubClass((SubEntityMappingConfigurationProvider)MappingEase.subentityBuilder(Car.class).map(Car::getModel)).addSubClass((SubEntityMappingConfigurationProvider)MappingEase.subentityBuilder(Truck.class))).build(FluentEntityMappingConfigurationSupportPolymorphismWithRelationTest.this.persistenceContext);
            HashSet tables = (HashSet)Iterables.collect((Iterable)DDLDeployer.collectTables((PersistenceContext)FluentEntityMappingConfigurationSupportPolymorphismWithRelationTest.this.persistenceContext), Table::getName, HashSet::new);
            Assertions.assertThat((Collection)tables).containsExactlyInAnyOrder((Object[])new String[]{"Vehicle", "Car", "Truck", "Engine"});
            Assertions.assertThat((Collection)FluentEntityMappingConfigurationSupportPolymorphismWithRelationTest.this.persistenceContext.getPersisters()).extracting(EntityPersister::getClassToPersist).containsExactlyInAnyOrder((Object[])new Class[]{Vehicle.class});
            DDLDeployer ddlDeployer = new DDLDeployer(FluentEntityMappingConfigurationSupportPolymorphismWithRelationTest.this.persistenceContext);
            ddlDeployer.deployDDL();
            Car dummyCar = new Car(1L);
            dummyCar.setModel("Renault");
            dummyCar.setEngine(new Engine(100L));
            dummyCar.setColor(new Color(666));
            Truck dummyTruck = new Truck(2L);
            dummyCar.setEngine(new Engine(200L));
            dummyTruck.setColor(new Color(42));
            abstractVehiclePersister.insert((Iterable)Arrays.asList((Object[])new Vehicle[]{dummyCar, dummyTruck}));
            PersistenceContext.ExecutableBeanPropertyQueryMapper vehicleIdQuery = FluentEntityMappingConfigurationSupportPolymorphismWithRelationTest.this.persistenceContext.newQuery((CharSequence)"select id from Vehicle", Integer.class).mapKey("id", Integer.class);
            Set vehicleIds = (Set)vehicleIdQuery.execute(Accumulators.toSet());
            Assertions.assertThat((Collection)vehicleIds).containsExactly((Object[])new Integer[]{1, 2});
            PersistenceContext.ExecutableBeanPropertyQueryMapper carIdQuery = FluentEntityMappingConfigurationSupportPolymorphismWithRelationTest.this.persistenceContext.newQuery((CharSequence)"select id from car", Integer.class).mapKey("id", Integer.class);
            Set carIds = (Set)carIdQuery.execute(Accumulators.toSet());
            Assertions.assertThat((Collection)carIds).containsExactly((Object[])new Integer[]{1});
            PersistenceContext.ExecutableBeanPropertyQueryMapper truckIdQuery = FluentEntityMappingConfigurationSupportPolymorphismWithRelationTest.this.persistenceContext.newQuery((CharSequence)"select id from truck", Integer.class).mapKey("id", Integer.class);
            Set truckIds = (Set)truckIdQuery.execute(Accumulators.toSet());
            Assertions.assertThat((Collection)truckIds).containsExactly((Object[])new Integer[]{2});
            dummyCar.setModel("Peugeot");
            abstractVehiclePersister.persist((Object)dummyCar);
            Vehicle loadedVehicle = (Vehicle)abstractVehiclePersister.select(new PersistedIdentifier<Long>(1L));
            Assertions.assertThat((Object)loadedVehicle).isEqualTo((Object)dummyCar);
            dummyCar.setColor(new Color(256));
            abstractVehiclePersister.update((Object)dummyCar, (Object)loadedVehicle, false);
            loadedVehicle = (Vehicle)abstractVehiclePersister.select(new PersistedIdentifier<Long>(2L));
            Assertions.assertThat((Object)loadedVehicle).isEqualTo((Object)dummyTruck);
            EntityPersister.ExecutableEntityQuery vehicleExecutableQuery1 = abstractVehiclePersister.selectWhere(Vehicle::getColor, (ConditionalOperator)Operators.eq((Object)new Color(42)));
            Set loadedVehicles = (Set)vehicleExecutableQuery1.execute(Accumulators.toSet());
            Assertions.assertThat((Collection)loadedVehicles).containsExactlyInAnyOrder((Object[])new Vehicle[]{dummyTruck});
            EntityPersister.ExecutableEntityQuery vehicleExecutableQuery = abstractVehiclePersister.selectWhere(Vehicle::getColor, (ConditionalOperator)Operators.eq((Object)new Color(256)));
            loadedVehicles = (Set)vehicleExecutableQuery.execute(Accumulators.toSet());
            Assertions.assertThat((Collection)loadedVehicles).containsExactlyInAnyOrder((Object[])new Vehicle[]{dummyCar});
            abstractVehiclePersister.delete((Iterable)Arrays.asList((Object[])new Vehicle[]{dummyCar, dummyTruck}));
            PersistenceContext.ExecutableBeanPropertyQueryMapper carQuery = FluentEntityMappingConfigurationSupportPolymorphismWithRelationTest.this.persistenceContext.newQuery((CharSequence)("select count(*) as carCount from Vehicle where id = " + dummyCar.getId().getDelegate()), Integer.class).mapKey("carCount", Integer.class);
            Integer carCount = (Integer)Iterables.first((Iterable)((Iterable)carQuery.execute(Accumulators.toSet())));
            Assertions.assertThat((Integer)carCount).isEqualTo(0);
            PersistenceContext.ExecutableBeanPropertyQueryMapper truckQuery = FluentEntityMappingConfigurationSupportPolymorphismWithRelationTest.this.persistenceContext.newQuery((CharSequence)("select count(*) as truckCount from Vehicle where id = " + dummyTruck.getId().getDelegate()), Integer.class).mapKey("truckCount", Integer.class);
            Integer truckCount = (Integer)Iterables.first((Iterable)((Iterable)truckQuery.execute(Accumulators.toSet())));
            Assertions.assertThat((Integer)truckCount).isEqualTo(0);
            PersistenceContext.ExecutableBeanPropertyQueryMapper engineQuery = FluentEntityMappingConfigurationSupportPolymorphismWithRelationTest.this.persistenceContext.newQuery((CharSequence)"select id from Engine", Long.class).mapKey("id", Long.class);
            Assertions.assertThat((Collection)((Collection)engineQuery.execute(Accumulators.toSet()))).isEmpty();
        }

        @Test
        void listenersAreNotified() {
            EntityPersister abstractVehiclePersister = MappingEase.entityBuilder(Vehicle.class, Identifier.LONG_TYPE).mapKey(AbstractVehicle::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).mapOneToOne(Vehicle::getEngine, (EntityMappingConfigurationProvider)MappingEase.entityBuilder(Engine.class, Identifier.LONG_TYPE).mapKey(Engine::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED)).cascading(CascadeOptions.RelationMode.ALL_ORPHAN_REMOVAL).mapPolymorphism((PolymorphismPolicy)PolymorphismPolicy.joinTable().addSubClass((SubEntityMappingConfigurationProvider)MappingEase.subentityBuilder(Car.class).map(Car::getModel).map(Vehicle::getColor))).build(FluentEntityMappingConfigurationSupportPolymorphismWithRelationTest.this.persistenceContext);
            DDLDeployer ddlDeployer = new DDLDeployer(FluentEntityMappingConfigurationSupportPolymorphismWithRelationTest.this.persistenceContext);
            ddlDeployer.deployDDL();
            Car dummyCar = new Car(1L);
            dummyCar.setModel("Renault");
            dummyCar.setColor(new Color(666));
            PersistListener persistListenerMock = (PersistListener)Mockito.mock(PersistListener.class);
            InsertListener insertListenerMock = (InsertListener)Mockito.mock(InsertListener.class);
            UpdateListener updateListenerMock = (UpdateListener)Mockito.mock(UpdateListener.class);
            SelectListener selectListenerMock = (SelectListener)Mockito.mock(SelectListener.class);
            DeleteListener deleteListenerMock = (DeleteListener)Mockito.mock(DeleteListener.class);
            abstractVehiclePersister.addPersistListener(persistListenerMock);
            abstractVehiclePersister.addInsertListener(insertListenerMock);
            abstractVehiclePersister.addUpdateListener(updateListenerMock);
            abstractVehiclePersister.addSelectListener(selectListenerMock);
            abstractVehiclePersister.addDeleteListener(deleteListenerMock);
            abstractVehiclePersister.insert((Object)dummyCar);
            ((InsertListener)Mockito.verify((Object)insertListenerMock)).beforeInsert((Iterable)Arrays.asList((Object[])new Car[]{dummyCar}));
            ((InsertListener)Mockito.verify((Object)insertListenerMock)).afterInsert((Iterable)Arrays.asList((Object[])new Car[]{dummyCar}));
            abstractVehiclePersister.update((Object)dummyCar, (Object)dummyCar, true);
            ((UpdateListener)Mockito.verify((Object)updateListenerMock)).beforeUpdate((Iterable)ArgumentMatchers.any(), ArgumentMatchers.eq((boolean)true));
            ((UpdateListener)Mockito.verify((Object)updateListenerMock)).afterUpdate((Iterable)ArgumentMatchers.any(), ArgumentMatchers.eq((boolean)true));
            abstractVehiclePersister.delete((Object)dummyCar);
            ((DeleteListener)Mockito.verify((Object)deleteListenerMock)).beforeDelete((Iterable)Arrays.asList((Object[])new Car[]{dummyCar}));
            ((DeleteListener)Mockito.verify((Object)deleteListenerMock)).afterDelete((Iterable)Arrays.asList((Object[])new Car[]{dummyCar}));
            Mockito.clearInvocations((Object[])new Object[]{insertListenerMock, updateListenerMock, selectListenerMock});
            dummyCar = new Car(1L);
            dummyCar.setModel("Renault");
            dummyCar.setColor(new Color(666));
            abstractVehiclePersister.persist((Object)dummyCar);
            ((PersistListener)Mockito.verify((Object)persistListenerMock)).beforePersist((Iterable)Arrays.asHashSet((Object[])new Car[]{dummyCar}));
            ((PersistListener)Mockito.verify((Object)persistListenerMock)).afterPersist((Iterable)Arrays.asHashSet((Object[])new Car[]{dummyCar}));
            ((InsertListener)Mockito.verify((Object)insertListenerMock)).beforeInsert((Iterable)Arrays.asList((Object[])new Car[]{dummyCar}));
            ((InsertListener)Mockito.verify((Object)insertListenerMock)).afterInsert((Iterable)Arrays.asList((Object[])new Car[]{dummyCar}));
            ((SelectListener)Mockito.verify((Object)selectListenerMock)).beforeSelect((Iterable)Arrays.asHashSet((Object[])new Identifier[]{dummyCar.getId()}));
            ((SelectListener)Mockito.verify((Object)selectListenerMock, (VerificationMode)Mockito.times((int)2))).afterSelect(Collections.emptySet());
            Mockito.clearInvocations((Object[])new SelectListener[]{selectListenerMock});
            dummyCar.setModel("Peugeot");
            abstractVehiclePersister.persist((Object)dummyCar);
            ((UpdateListener)Mockito.verify((Object)updateListenerMock)).beforeUpdate((Iterable)ArgumentMatchers.any(), ArgumentMatchers.eq((boolean)true));
            ((UpdateListener)Mockito.verify((Object)updateListenerMock)).afterUpdate((Iterable)ArgumentMatchers.any(), ArgumentMatchers.eq((boolean)true));
            ((SelectListener)Mockito.verify((Object)selectListenerMock)).beforeSelect((Iterable)Arrays.asHashSet((Object[])new Identifier[]{dummyCar.getId()}));
            dummyCar.setModel("Renault");
            ((SelectListener)Mockito.verify((Object)selectListenerMock, (VerificationMode)Mockito.times((int)2))).afterSelect((Set)Arrays.asHashSet((Object[])new Car[]{dummyCar}));
            Mockito.clearInvocations((Object[])new SelectListener[]{selectListenerMock});
            AbstractVehicle loadedCar = (AbstractVehicle)abstractVehiclePersister.select(new PersistedIdentifier<Long>(1L));
            ((SelectListener)Mockito.verify((Object)selectListenerMock)).beforeSelect((Iterable)Arrays.asHashSet((Object[])new PersistedIdentifier[]{new PersistedIdentifier<Long>(1L)}));
            ((SelectListener)Mockito.verify((Object)selectListenerMock, (VerificationMode)Mockito.times((int)2))).afterSelect((Set)Arrays.asHashSet((Object[])new AbstractVehicle[]{loadedCar}));
        }
    }

    @Nested
    class SingleTableWithOneToOne {
        SingleTableWithOneToOne() {
        }

        @Test
        void oneSubClass() {
            EntityPersister abstractVehiclePersister = MappingEase.entityBuilder(Vehicle.class, Identifier.LONG_TYPE).mapKey(AbstractVehicle::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).mapOneToOne(Vehicle::getEngine, (EntityMappingConfigurationProvider)MappingEase.entityBuilder(Engine.class, Identifier.LONG_TYPE).mapKey(Engine::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED)).cascading(CascadeOptions.RelationMode.ALL_ORPHAN_REMOVAL).mapPolymorphism((PolymorphismPolicy)PolymorphismPolicy.singleTable().addSubClass((SubEntityMappingConfigurationProvider)MappingEase.subentityBuilder(Car.class).map(AbstractVehicle::getId).map(Car::getModel).map(Vehicle::getColor), (Object)"CAR")).build(FluentEntityMappingConfigurationSupportPolymorphismWithRelationTest.this.persistenceContext);
            HashSet tables = (HashSet)Iterables.collect((Iterable)DDLDeployer.collectTables((PersistenceContext)FluentEntityMappingConfigurationSupportPolymorphismWithRelationTest.this.persistenceContext), Table::getName, HashSet::new);
            Assertions.assertThat((Collection)tables).containsExactlyInAnyOrder((Object[])new String[]{"Vehicle", "Engine"});
            Assertions.assertThat((Collection)FluentEntityMappingConfigurationSupportPolymorphismWithRelationTest.this.persistenceContext.getPersisters()).extracting(EntityPersister::getClassToPersist).containsExactlyInAnyOrder((Object[])new Class[]{Vehicle.class});
            DDLDeployer ddlDeployer = new DDLDeployer(FluentEntityMappingConfigurationSupportPolymorphismWithRelationTest.this.persistenceContext);
            ddlDeployer.deployDDL();
            Car dummyCar = new Car(1L);
            dummyCar.setModel("Renault");
            dummyCar.setEngine(new Engine(100L));
            dummyCar.setColor(new Color(666));
            abstractVehiclePersister.insert((Object)dummyCar);
            PersistenceContext.ExecutableBeanPropertyQueryMapper modelQuery = FluentEntityMappingConfigurationSupportPolymorphismWithRelationTest.this.persistenceContext.newQuery((CharSequence)"select * from Vehicle", String.class).mapKey("model", String.class);
            Set allCars = (Set)modelQuery.execute(Accumulators.toSet());
            Assertions.assertThat((Collection)allCars).containsExactly((Object[])new String[]{"Renault"});
            dummyCar.setModel("Peugeot");
            abstractVehiclePersister.persist((Object)dummyCar);
            Set existingModels = (Set)modelQuery.execute(Accumulators.toSet());
            Assertions.assertThat((Collection)existingModels).containsExactly((Object[])new String[]{"Peugeot"});
            AbstractVehicle loadedCar = (AbstractVehicle)abstractVehiclePersister.select(new PersistedIdentifier<Long>(1L));
            Assertions.assertThat((Object)loadedCar).isEqualTo((Object)dummyCar);
            abstractVehiclePersister.delete((Object)dummyCar);
            existingModels = (Set)modelQuery.execute(Accumulators.toSet());
            Assertions.assertThat((Collection)existingModels).isEmpty();
            PersistenceContext.ExecutableBeanPropertyQueryMapper engineQuery = FluentEntityMappingConfigurationSupportPolymorphismWithRelationTest.this.persistenceContext.newQuery((CharSequence)"select id from Engine", Long.class).mapKey("id", Long.class);
            Assertions.assertThat((Collection)((Collection)engineQuery.execute(Accumulators.toSet()))).isEmpty();
        }

        @Test
        void twoSubClasses() {
            EntityPersister abstractVehiclePersister = MappingEase.entityBuilder(Vehicle.class, Identifier.LONG_TYPE).mapKey(AbstractVehicle::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).mapOneToOne(Vehicle::getEngine, (EntityMappingConfigurationProvider)MappingEase.entityBuilder(Engine.class, Identifier.LONG_TYPE).mapKey(Engine::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED)).cascading(CascadeOptions.RelationMode.ALL_ORPHAN_REMOVAL).mapPolymorphism((PolymorphismPolicy)PolymorphismPolicy.singleTable().addSubClass((SubEntityMappingConfigurationProvider)MappingEase.subentityBuilder(Car.class).map(Car::getModel).map(Vehicle::getColor), (Object)"CAR").addSubClass((SubEntityMappingConfigurationProvider)MappingEase.subentityBuilder(Truck.class).map(Vehicle::getColor), (Object)"TRUCK")).build(FluentEntityMappingConfigurationSupportPolymorphismWithRelationTest.this.persistenceContext);
            HashSet tables = (HashSet)Iterables.collect((Iterable)DDLDeployer.collectTables((PersistenceContext)FluentEntityMappingConfigurationSupportPolymorphismWithRelationTest.this.persistenceContext), Table::getName, HashSet::new);
            Assertions.assertThat((Collection)tables).containsExactlyInAnyOrder((Object[])new String[]{"Vehicle", "Engine"});
            Assertions.assertThat((Collection)FluentEntityMappingConfigurationSupportPolymorphismWithRelationTest.this.persistenceContext.getPersisters()).extracting(EntityPersister::getClassToPersist).containsExactlyInAnyOrder((Object[])new Class[]{Vehicle.class});
            DDLDeployer ddlDeployer = new DDLDeployer(FluentEntityMappingConfigurationSupportPolymorphismWithRelationTest.this.persistenceContext);
            ddlDeployer.deployDDL();
            Car dummyCar = new Car(1L);
            dummyCar.setModel("Renault");
            dummyCar.setEngine(new Engine(100L));
            dummyCar.setColor(new Color(666));
            Truck dummyTruck = new Truck(2L);
            dummyTruck.setColor(new Color(42));
            abstractVehiclePersister.insert((Iterable)Arrays.asList((Object[])new Vehicle[]{dummyCar, dummyTruck}));
            PersistenceContext.ExecutableBeanPropertyQueryMapper modelQuery = FluentEntityMappingConfigurationSupportPolymorphismWithRelationTest.this.persistenceContext.newQuery((CharSequence)"select * from Vehicle", Duo.class).mapKey(Duo::new, "model", String.class, "color", Integer.class);
            Set allCars = (Set)modelQuery.execute(Accumulators.toSet());
            Assertions.assertThat((Collection)allCars).containsExactlyInAnyOrder((Object[])new Duo[]{new Duo((Object)"Renault", (Object)666), new Duo(null, (Object)42)});
            dummyCar.setModel("Peugeot");
            abstractVehiclePersister.persist((Object)dummyCar);
            Set existingModels = (Set)modelQuery.execute(Accumulators.toSet());
            Assertions.assertThat((Collection)existingModels).containsExactlyInAnyOrder((Object[])new Duo[]{new Duo((Object)"Peugeot", (Object)666), new Duo(null, (Object)42)});
            AbstractVehicle loadedVehicle = (AbstractVehicle)abstractVehiclePersister.select(new PersistedIdentifier<Long>(1L));
            Assertions.assertThat((Object)loadedVehicle).isEqualTo((Object)dummyCar);
            loadedVehicle = (AbstractVehicle)abstractVehiclePersister.select(new PersistedIdentifier<Long>(2L));
            Assertions.assertThat((Object)loadedVehicle).isEqualTo((Object)dummyTruck);
            Set loadedVehicles = abstractVehiclePersister.selectAll();
            Assertions.assertThat((Collection)loadedVehicles).containsExactlyInAnyOrder((Object[])new Vehicle[]{dummyCar, dummyTruck});
            abstractVehiclePersister.delete((Object)dummyCar);
            existingModels = (Set)modelQuery.execute(Accumulators.toSet());
            Assertions.assertThat((Collection)existingModels).containsExactlyInAnyOrder((Object[])new Duo[]{new Duo(null, (Object)42)});
            abstractVehiclePersister.delete((Object)dummyTruck);
            existingModels = (Set)modelQuery.execute(Accumulators.toSet());
            Assertions.assertThat((Collection)existingModels).isEmpty();
            PersistenceContext.ExecutableBeanPropertyQueryMapper engineQuery = FluentEntityMappingConfigurationSupportPolymorphismWithRelationTest.this.persistenceContext.newQuery((CharSequence)"select id from Engine", Long.class).mapKey("id", Long.class);
            Assertions.assertThat((Collection)((Collection)engineQuery.execute(Accumulators.toSet()))).isEmpty();
        }

        @Test
        void twoSubClasses_withCommonProperties() {
            EntityPersister abstractVehiclePersister = MappingEase.entityBuilder(Vehicle.class, Identifier.LONG_TYPE).mapKey(AbstractVehicle::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Vehicle::getColor).mapOneToOne(Vehicle::getEngine, (EntityMappingConfigurationProvider)MappingEase.entityBuilder(Engine.class, Identifier.LONG_TYPE).mapKey(Engine::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED)).cascading(CascadeOptions.RelationMode.ALL_ORPHAN_REMOVAL).mapPolymorphism((PolymorphismPolicy)PolymorphismPolicy.singleTable().addSubClass((SubEntityMappingConfigurationProvider)MappingEase.subentityBuilder(Car.class).map(Car::getModel), (Object)"CAR").addSubClass((SubEntityMappingConfigurationProvider)MappingEase.subentityBuilder(Truck.class), (Object)"TRUCK")).build(FluentEntityMappingConfigurationSupportPolymorphismWithRelationTest.this.persistenceContext);
            HashSet tables = (HashSet)Iterables.collect((Iterable)DDLDeployer.collectTables((PersistenceContext)FluentEntityMappingConfigurationSupportPolymorphismWithRelationTest.this.persistenceContext), Table::getName, HashSet::new);
            Assertions.assertThat((Collection)tables).containsExactlyInAnyOrder((Object[])new String[]{"Vehicle", "Engine"});
            Assertions.assertThat((Collection)FluentEntityMappingConfigurationSupportPolymorphismWithRelationTest.this.persistenceContext.getPersisters()).extracting(EntityPersister::getClassToPersist).containsExactlyInAnyOrder((Object[])new Class[]{Vehicle.class});
            DDLDeployer ddlDeployer = new DDLDeployer(FluentEntityMappingConfigurationSupportPolymorphismWithRelationTest.this.persistenceContext);
            ddlDeployer.deployDDL();
            Car dummyCar = new Car(1L);
            dummyCar.setModel("Renault");
            dummyCar.setEngine(new Engine(100L));
            dummyCar.setColor(new Color(666));
            Truck dummyTruck = new Truck(2L);
            dummyCar.setEngine(new Engine(200L));
            dummyTruck.setColor(new Color(42));
            abstractVehiclePersister.insert((Iterable)Arrays.asList((Object[])new Vehicle[]{dummyCar, dummyTruck}));
            PersistenceContext.ExecutableBeanPropertyQueryMapper carIdQuery = FluentEntityMappingConfigurationSupportPolymorphismWithRelationTest.this.persistenceContext.newQuery((CharSequence)"select id from Vehicle where DTYPE ='CAR'", Integer.class).mapKey("id", Integer.class);
            Set carIds = (Set)carIdQuery.execute(Accumulators.toSet());
            Assertions.assertThat((Collection)carIds).containsExactly((Object[])new Integer[]{1});
            PersistenceContext.ExecutableBeanPropertyQueryMapper truckIdQuery = FluentEntityMappingConfigurationSupportPolymorphismWithRelationTest.this.persistenceContext.newQuery((CharSequence)"select id from Vehicle where DTYPE ='TRUCK'", Integer.class).mapKey("id", Integer.class);
            Set truckIds = (Set)truckIdQuery.execute(Accumulators.toSet());
            Assertions.assertThat((Collection)truckIds).containsExactly((Object[])new Integer[]{2});
            dummyCar.setModel("Peugeot");
            abstractVehiclePersister.persist((Object)dummyCar);
            Vehicle loadedVehicle = (Vehicle)abstractVehiclePersister.select(new PersistedIdentifier<Long>(1L));
            Assertions.assertThat((Object)loadedVehicle).isEqualTo((Object)dummyCar);
            dummyCar.setColor(new Color(256));
            abstractVehiclePersister.update((Object)dummyCar, (Object)loadedVehicle, false);
            loadedVehicle = (Vehicle)abstractVehiclePersister.select(new PersistedIdentifier<Long>(2L));
            Assertions.assertThat((Object)loadedVehicle).isEqualTo((Object)dummyTruck);
            EntityPersister.ExecutableEntityQuery vehicleExecutableQuery1 = abstractVehiclePersister.selectWhere(Vehicle::getColor, (ConditionalOperator)Operators.eq((Object)new Color(42)));
            Set loadedVehicles = (Set)vehicleExecutableQuery1.execute(Accumulators.toSet());
            Assertions.assertThat((Collection)loadedVehicles).containsExactlyInAnyOrder((Object[])new Vehicle[]{dummyTruck});
            EntityPersister.ExecutableEntityQuery vehicleExecutableQuery = abstractVehiclePersister.selectWhere(Vehicle::getColor, (ConditionalOperator)Operators.eq((Object)new Color(256)));
            loadedVehicles = (Set)vehicleExecutableQuery.execute(Accumulators.toSet());
            Assertions.assertThat((Collection)loadedVehicles).containsExactlyInAnyOrder((Object[])new Vehicle[]{dummyCar});
            abstractVehiclePersister.delete((Iterable)Arrays.asList((Object[])new Vehicle[]{dummyCar, dummyTruck}));
            PersistenceContext.ExecutableBeanPropertyQueryMapper carQuery = FluentEntityMappingConfigurationSupportPolymorphismWithRelationTest.this.persistenceContext.newQuery((CharSequence)("select count(*) as carCount from Vehicle where id = " + dummyCar.getId().getDelegate()), Integer.class).mapKey("carCount", Integer.class);
            Integer carCount = (Integer)Iterables.first((Iterable)((Iterable)carQuery.execute(Accumulators.toSet())));
            Assertions.assertThat((Integer)carCount).isEqualTo(0);
            PersistenceContext.ExecutableBeanPropertyQueryMapper truckQuery = FluentEntityMappingConfigurationSupportPolymorphismWithRelationTest.this.persistenceContext.newQuery((CharSequence)("select count(*) as truckCount from Vehicle where id = " + dummyTruck.getId().getDelegate()), Integer.class).mapKey("truckCount", Integer.class);
            Integer truckCount = (Integer)Iterables.first((Iterable)((Iterable)truckQuery.execute(Accumulators.toSet())));
            Assertions.assertThat((Integer)truckCount).isEqualTo(0);
            PersistenceContext.ExecutableBeanPropertyQueryMapper engineQuery = FluentEntityMappingConfigurationSupportPolymorphismWithRelationTest.this.persistenceContext.newQuery((CharSequence)"select id from Engine", Long.class).mapKey("id", Long.class);
            Assertions.assertThat((Collection)((Collection)engineQuery.execute(Accumulators.toSet()))).isEmpty();
        }

        @Test
        void listenersAreNotified() {
            EntityPersister abstractVehiclePersister = MappingEase.entityBuilder(Vehicle.class, Identifier.LONG_TYPE).mapKey(AbstractVehicle::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).mapOneToOne(Vehicle::getEngine, (EntityMappingConfigurationProvider)MappingEase.entityBuilder(Engine.class, Identifier.LONG_TYPE).mapKey(Engine::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED)).cascading(CascadeOptions.RelationMode.ALL_ORPHAN_REMOVAL).mapPolymorphism((PolymorphismPolicy)PolymorphismPolicy.singleTable().addSubClass((SubEntityMappingConfigurationProvider)MappingEase.subentityBuilder(Car.class).map(Car::getModel).map(Vehicle::getColor), (Object)"CAR")).build(FluentEntityMappingConfigurationSupportPolymorphismWithRelationTest.this.persistenceContext);
            DDLDeployer ddlDeployer = new DDLDeployer(FluentEntityMappingConfigurationSupportPolymorphismWithRelationTest.this.persistenceContext);
            ddlDeployer.deployDDL();
            Car dummyCar = new Car(1L);
            dummyCar.setModel("Renault");
            dummyCar.setColor(new Color(666));
            PersistListener persistListenerMock = (PersistListener)Mockito.mock(PersistListener.class);
            InsertListener insertListenerMock = (InsertListener)Mockito.mock(InsertListener.class);
            UpdateListener updateListenerMock = (UpdateListener)Mockito.mock(UpdateListener.class);
            SelectListener selectListenerMock = (SelectListener)Mockito.mock(SelectListener.class);
            DeleteListener deleteListenerMock = (DeleteListener)Mockito.mock(DeleteListener.class);
            abstractVehiclePersister.addPersistListener(persistListenerMock);
            abstractVehiclePersister.addInsertListener(insertListenerMock);
            abstractVehiclePersister.addUpdateListener(updateListenerMock);
            abstractVehiclePersister.addSelectListener(selectListenerMock);
            abstractVehiclePersister.addDeleteListener(deleteListenerMock);
            abstractVehiclePersister.insert((Object)dummyCar);
            ((InsertListener)Mockito.verify((Object)insertListenerMock)).beforeInsert((Iterable)Arrays.asList((Object[])new Car[]{dummyCar}));
            ((InsertListener)Mockito.verify((Object)insertListenerMock)).afterInsert((Iterable)Arrays.asList((Object[])new Car[]{dummyCar}));
            abstractVehiclePersister.update((Object)dummyCar, (Object)dummyCar, true);
            ((UpdateListener)Mockito.verify((Object)updateListenerMock)).beforeUpdate((Iterable)ArgumentMatchers.any(), ArgumentMatchers.eq((boolean)true));
            ((UpdateListener)Mockito.verify((Object)updateListenerMock)).afterUpdate((Iterable)ArgumentMatchers.any(), ArgumentMatchers.eq((boolean)true));
            abstractVehiclePersister.delete((Object)dummyCar);
            ((DeleteListener)Mockito.verify((Object)deleteListenerMock)).beforeDelete((Iterable)Arrays.asList((Object[])new Car[]{dummyCar}));
            ((DeleteListener)Mockito.verify((Object)deleteListenerMock)).afterDelete((Iterable)Arrays.asList((Object[])new Car[]{dummyCar}));
            Mockito.clearInvocations((Object[])new Object[]{insertListenerMock, updateListenerMock, selectListenerMock});
            dummyCar = new Car(1L);
            dummyCar.setModel("Renault");
            dummyCar.setColor(new Color(666));
            abstractVehiclePersister.persist((Object)dummyCar);
            ((PersistListener)Mockito.verify((Object)persistListenerMock)).beforePersist((Iterable)Arrays.asHashSet((Object[])new Car[]{dummyCar}));
            ((PersistListener)Mockito.verify((Object)persistListenerMock)).afterPersist((Iterable)Arrays.asHashSet((Object[])new Car[]{dummyCar}));
            ((InsertListener)Mockito.verify((Object)insertListenerMock)).beforeInsert((Iterable)Arrays.asList((Object[])new Car[]{dummyCar}));
            ((InsertListener)Mockito.verify((Object)insertListenerMock)).afterInsert((Iterable)Arrays.asList((Object[])new Car[]{dummyCar}));
            ((SelectListener)Mockito.verify((Object)selectListenerMock)).beforeSelect((Iterable)Arrays.asHashSet((Object[])new Identifier[]{dummyCar.getId()}));
            ((SelectListener)Mockito.verify((Object)selectListenerMock, (VerificationMode)Mockito.times((int)2))).afterSelect(Collections.emptySet());
            Mockito.clearInvocations((Object[])new SelectListener[]{selectListenerMock});
            dummyCar.setModel("Peugeot");
            abstractVehiclePersister.persist((Object)dummyCar);
            ((UpdateListener)Mockito.verify((Object)updateListenerMock)).beforeUpdate((Iterable)ArgumentMatchers.any(), ArgumentMatchers.eq((boolean)true));
            ((UpdateListener)Mockito.verify((Object)updateListenerMock)).afterUpdate((Iterable)ArgumentMatchers.any(), ArgumentMatchers.eq((boolean)true));
            ((SelectListener)Mockito.verify((Object)selectListenerMock)).beforeSelect((Iterable)Arrays.asHashSet((Object[])new Identifier[]{dummyCar.getId()}));
            dummyCar.setModel("Renault");
            ((SelectListener)Mockito.verify((Object)selectListenerMock, (VerificationMode)Mockito.times((int)2))).afterSelect((Set)Arrays.asHashSet((Object[])new Car[]{dummyCar}));
            Mockito.clearInvocations((Object[])new SelectListener[]{selectListenerMock});
            AbstractVehicle loadedCar = (AbstractVehicle)abstractVehiclePersister.select(new PersistedIdentifier<Long>(1L));
            ((SelectListener)Mockito.verify((Object)selectListenerMock)).beforeSelect((Iterable)Arrays.asHashSet((Object[])new PersistedIdentifier[]{new PersistedIdentifier<Long>(1L)}));
            ((SelectListener)Mockito.verify((Object)selectListenerMock, (VerificationMode)Mockito.times((int)2))).afterSelect((Set)Arrays.asHashSet((Object[])new AbstractVehicle[]{loadedCar}));
        }
    }
}

