/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.runtime.load;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Function;
import org.assertj.core.api.AbstractCollectionAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.assertj.core.presentation.StandardRepresentation;
import org.codefilarete.stalactite.engine.runtime.load.AbstractJoinNode;
import org.codefilarete.stalactite.engine.runtime.load.EntityInflater;
import org.codefilarete.stalactite.engine.runtime.load.EntityJoinTree;
import org.codefilarete.stalactite.engine.runtime.load.JoinNode;
import org.codefilarete.stalactite.mapping.ClassMapping;
import org.codefilarete.stalactite.mapping.EntityMapping;
import org.codefilarete.stalactite.query.model.Fromable;
import org.codefilarete.stalactite.query.model.Query;
import org.codefilarete.stalactite.query.model.QueryEase;
import org.codefilarete.stalactite.query.model.Selectable;
import org.codefilarete.stalactite.query.model.Union;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.Key;
import org.codefilarete.stalactite.sql.ddl.structure.PrimaryKey;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.tool.collection.Arrays;
import org.codefilarete.tool.collection.Iterables;
import org.codefilarete.tool.function.Predicates;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class EntityJoinTreeTest {
    EntityJoinTreeTest() {
    }

    static ClassMapping buildMappingStrategyMock(String tableName) {
        return EntityJoinTreeTest.buildMappingStrategyMock(new Table(tableName));
    }

    static ClassMapping buildMappingStrategyMock(Table table) {
        ClassMapping mappingStrategyMock = (ClassMapping)Mockito.mock(ClassMapping.class);
        Mockito.when((Object)mappingStrategyMock.getTargetTable()).thenReturn((Object)table);
        Mockito.when((Object)mappingStrategyMock.getSelectableColumns()).thenAnswer(invocation -> table.getColumns());
        return mappingStrategyMock;
    }

    @Test
    void projectTo() {
        ClassMapping totoMappingMock = EntityJoinTreeTest.buildMappingStrategyMock("Toto");
        Table totoTable = totoMappingMock.getTargetTable();
        totoTable.addColumn("id", Long.TYPE).primaryKey();
        PrimaryKey totoPrimaryKey = totoTable.getPrimaryKey();
        Column totoNameColumn = totoTable.addColumn("name", String.class);
        ClassMapping tataMappingMock = EntityJoinTreeTest.buildMappingStrategyMock("Tata");
        Table tataTable = tataMappingMock.getTargetTable();
        tataTable.addColumn("id", Long.TYPE).primaryKey();
        PrimaryKey tataPrimaryKey = tataTable.getPrimaryKey();
        Column tataNameColumn = tataTable.addColumn("name", String.class);
        ClassMapping tutuMappingMock = EntityJoinTreeTest.buildMappingStrategyMock("Tutu");
        Table tutuTable = tutuMappingMock.getTargetTable();
        tutuTable.addColumn("id", Long.TYPE).primaryKey();
        PrimaryKey tutuPrimaryKey = tutuTable.getPrimaryKey();
        Column tutuNameColumn = tutuTable.addColumn("name", String.class);
        ClassMapping titiMappingMock = EntityJoinTreeTest.buildMappingStrategyMock("Titi");
        Table titiTable = titiMappingMock.getTargetTable();
        titiTable.addColumn("id", Long.TYPE).primaryKey();
        PrimaryKey titiPrimaryKey = titiTable.getPrimaryKey();
        Column titiNameColumn = titiTable.addColumn("name", String.class);
        EntityJoinTree entityJoinTree1 = new EntityJoinTree((EntityInflater)new EntityInflater.EntityMappingAdapter((EntityMapping)totoMappingMock), (Fromable)totoMappingMock.getTargetTable());
        String tataAddKey = entityJoinTree1.addRelationJoin("ROOT", (EntityInflater)new EntityInflater.EntityMappingAdapter((EntityMapping)tataMappingMock), (Key)totoPrimaryKey, (Key)tataPrimaryKey, null, EntityJoinTree.JoinType.INNER, null, Collections.emptySet());
        String tutuAddKey = entityJoinTree1.addRelationJoin(tataAddKey, (EntityInflater)new EntityInflater.EntityMappingAdapter((EntityMapping)tutuMappingMock), (Key)tataPrimaryKey, (Key)tutuPrimaryKey, null, EntityJoinTree.JoinType.INNER, null, Collections.emptySet());
        EntityJoinTree entityJoinTree2 = new EntityJoinTree((EntityInflater)new EntityInflater.EntityMappingAdapter((EntityMapping)tataMappingMock), (Fromable)tataMappingMock.getTargetTable());
        String titiAddKey = entityJoinTree2.addRelationJoin("ROOT", (EntityInflater)new EntityInflater.EntityMappingAdapter((EntityMapping)titiMappingMock), (Key)tataPrimaryKey, (Key)titiPrimaryKey, null, EntityJoinTree.JoinType.INNER, null, Collections.emptySet());
        entityJoinTree2.projectTo(entityJoinTree1, tataAddKey);
        JoinNode tataJoinClone = entityJoinTree1.getJoin(tataAddKey);
        Assertions.assertThat((Object)tataJoinClone).isNotNull();
        Assertions.assertThat((long)Iterables.stream((Iterator)entityJoinTree1.joinIterator()).count()).isEqualTo(3L);
        Assertions.assertThat((Object)entityJoinTree2.giveJoin((Key)tataPrimaryKey, (Key)titiPrimaryKey)).isNotNull();
        AbstractJoinNode abstractJoinNode = entityJoinTree1.giveJoin((Key)tataPrimaryKey, (Key)titiPrimaryKey);
        Assertions.assertThat((Object)abstractJoinNode).isNotSameAs((Object)entityJoinTree2.giveJoin((Key)tataPrimaryKey, (Key)titiPrimaryKey));
        Assertions.assertThat((Collection)abstractJoinNode.getColumnsToSelect()).isEqualTo((Object)titiMappingMock.getSelectableColumns());
        Assertions.assertThat((Object)abstractJoinNode.getParent()).isEqualTo((Object)tataJoinClone);
        Assertions.assertThat((int)entityJoinTree1.getJoinIndex().size()).isEqualTo(4);
        Assertions.assertThat((int)entityJoinTree2.getJoinIndex().size()).isEqualTo(2);
    }

    @Test
    void joinIterator() {
        ClassMapping totoMappingMock = EntityJoinTreeTest.buildMappingStrategyMock("Toto");
        Table totoTable = totoMappingMock.getTargetTable();
        totoTable.addColumn("id", Long.TYPE).primaryKey();
        PrimaryKey totoPrimaryKey = totoTable.getPrimaryKey();
        Column totoNameColumn = totoTable.addColumn("name", String.class);
        ClassMapping tataMappingMock = EntityJoinTreeTest.buildMappingStrategyMock("Tata");
        Table tataTable = tataMappingMock.getTargetTable();
        tataTable.addColumn("id", Long.TYPE).primaryKey();
        PrimaryKey tataPrimaryKey = tataTable.getPrimaryKey();
        Column tataNameColumn = tataTable.addColumn("name", String.class);
        ClassMapping tutuMappingMock = EntityJoinTreeTest.buildMappingStrategyMock("Tutu");
        Table tutuTable = tutuMappingMock.getTargetTable();
        tutuTable.addColumn("id", Long.TYPE).primaryKey();
        PrimaryKey tutuPrimaryKey = tutuTable.getPrimaryKey();
        Column tutuNameColumn = tutuTable.addColumn("name", String.class);
        ClassMapping titiMappingMock = EntityJoinTreeTest.buildMappingStrategyMock("Titi");
        Table titiTable = titiMappingMock.getTargetTable();
        titiTable.addColumn("id", Long.TYPE).primaryKey();
        PrimaryKey titiPrimaryKey = titiTable.getPrimaryKey();
        Column titiNameColumn = titiTable.addColumn("name", String.class);
        Table tataTableClone = new Table("tata2");
        ClassMapping tataCloneMappingMock = EntityJoinTreeTest.buildMappingStrategyMock(tataTableClone);
        tataTableClone.addColumn("id", Long.TYPE).primaryKey();
        PrimaryKey tataClonePrimaryKey = tataTableClone.getPrimaryKey();
        Column tataCloneNameColumn = tataTableClone.addColumn("name", String.class);
        Table tutuTableClone = new Table("tutu2");
        ClassMapping tutuCloneMappingMock = EntityJoinTreeTest.buildMappingStrategyMock(tutuTableClone);
        tutuTableClone.addColumn("id", Long.TYPE).primaryKey();
        Column tutuCloneNameColumn = tutuTableClone.addColumn("name", String.class);
        PrimaryKey tutuClonePrimaryKey = tutuTableClone.getPrimaryKey();
        EntityJoinTree entityJoinTree = new EntityJoinTree((EntityInflater)new EntityInflater.EntityMappingAdapter((EntityMapping)totoMappingMock), (Fromable)totoMappingMock.getTargetTable());
        String tataAddKey = entityJoinTree.addRelationJoin("ROOT", (EntityInflater)new EntityInflater.EntityMappingAdapter((EntityMapping)tataMappingMock), (Key)totoPrimaryKey, (Key)tataPrimaryKey, null, EntityJoinTree.JoinType.INNER, null, Collections.emptySet());
        String tutuAddKey = entityJoinTree.addRelationJoin(tataAddKey, (EntityInflater)new EntityInflater.EntityMappingAdapter((EntityMapping)tutuMappingMock), (Key)tataPrimaryKey, (Key)tutuPrimaryKey, null, EntityJoinTree.JoinType.INNER, null, Collections.emptySet());
        String titiAddKey = entityJoinTree.addRelationJoin(tataAddKey, (EntityInflater)new EntityInflater.EntityMappingAdapter((EntityMapping)titiMappingMock), (Key)tataPrimaryKey, (Key)titiPrimaryKey, null, EntityJoinTree.JoinType.INNER, null, Collections.emptySet());
        String tataAddKey2 = entityJoinTree.addRelationJoin("ROOT", (EntityInflater)new EntityInflater.EntityMappingAdapter((EntityMapping)tataCloneMappingMock), (Key)totoPrimaryKey, (Key)tataClonePrimaryKey, null, EntityJoinTree.JoinType.INNER, null, Collections.emptySet());
        String tutuAddKey2 = entityJoinTree.addRelationJoin(tataAddKey2, (EntityInflater)new EntityInflater.EntityMappingAdapter((EntityMapping)tutuCloneMappingMock), (Key)tataClonePrimaryKey, (Key)tutuClonePrimaryKey, null, EntityJoinTree.JoinType.INNER, null, Collections.emptySet());
        Iterator actual = entityJoinTree.joinIterator();
        ((ListAssert)((ListAssert)Assertions.assertThat((List)Iterables.copy((Iterator)actual)).usingElementComparator(Predicates.toComparator((BiPredicate)Predicates.and((Function[])new Function[]{AbstractJoinNode::getLeftJoinLink, AbstractJoinNode::getRightJoinLink})))).withRepresentation(new Printer(AbstractJoinNode.class, joinNode -> joinNode.getLeftJoinLink() + " = " + joinNode.getRightJoinLink()))).isEqualTo((Object)Arrays.asList((Object[])new AbstractJoinNode[]{entityJoinTree.giveJoin((Key)totoPrimaryKey, (Key)tataPrimaryKey), entityJoinTree.giveJoin((Key)totoPrimaryKey, (Key)tataClonePrimaryKey), entityJoinTree.giveJoin((Key)tataPrimaryKey, (Key)tutuPrimaryKey), entityJoinTree.giveJoin((Key)tataPrimaryKey, (Key)titiPrimaryKey), entityJoinTree.giveJoin((Key)tataClonePrimaryKey, (Key)tutuClonePrimaryKey)}));
    }

    @Test
    void foreachJoinWithDepth() {
        ClassMapping totoMappingMock = EntityJoinTreeTest.buildMappingStrategyMock("Toto");
        Table totoTable = totoMappingMock.getTargetTable();
        totoTable.addColumn("id", Long.TYPE).primaryKey();
        PrimaryKey totoPrimaryKey = totoTable.getPrimaryKey();
        Column totoNameColumn = totoTable.addColumn("name", String.class);
        ClassMapping tataMappingMock = EntityJoinTreeTest.buildMappingStrategyMock("Tata");
        Table tataTable = tataMappingMock.getTargetTable();
        tataTable.addColumn("id", Long.TYPE).primaryKey();
        PrimaryKey tataPrimaryKey = tataTable.getPrimaryKey();
        Column tataNameColumn = tataTable.addColumn("name", String.class);
        ClassMapping tutuMappingMock = EntityJoinTreeTest.buildMappingStrategyMock("Tutu");
        Table tutuTable = tutuMappingMock.getTargetTable();
        tutuTable.addColumn("id", Long.TYPE).primaryKey();
        PrimaryKey tutuPrimaryKey = tutuTable.getPrimaryKey();
        Column tutuNameColumn = tutuTable.addColumn("name", String.class);
        ClassMapping titiMappingMock = EntityJoinTreeTest.buildMappingStrategyMock("Titi");
        Table titiTable = titiMappingMock.getTargetTable();
        titiTable.addColumn("id", Long.TYPE).primaryKey();
        PrimaryKey titiPrimaryKey = titiTable.getPrimaryKey();
        Column titiNameColumn = titiTable.addColumn("name", String.class);
        Table tataTableClone = new Table("tata2");
        ClassMapping tataCloneMappingMock = EntityJoinTreeTest.buildMappingStrategyMock(tataTableClone);
        tataTableClone.addColumn("id", Long.TYPE).primaryKey();
        PrimaryKey tataClonePrimaryKey = tataTableClone.getPrimaryKey();
        Column tataCloneNameColumn = tataTableClone.addColumn("name", String.class);
        Table tutuTableClone = new Table("tutu2");
        ClassMapping tutuCloneMappingMock = EntityJoinTreeTest.buildMappingStrategyMock(tutuTableClone);
        tutuTableClone.addColumn("id", Long.TYPE).primaryKey();
        PrimaryKey tutuClonePrimaryKey = tutuTableClone.getPrimaryKey();
        Column tutuCloneNameColumn = tutuTableClone.addColumn("name", String.class);
        EntityJoinTree entityJoinTree = new EntityJoinTree((EntityInflater)new EntityInflater.EntityMappingAdapter((EntityMapping)totoMappingMock), (Fromable)totoMappingMock.getTargetTable());
        String tataAddKey = entityJoinTree.addRelationJoin("ROOT", (EntityInflater)new EntityInflater.EntityMappingAdapter((EntityMapping)tataMappingMock), (Key)totoPrimaryKey, (Key)tataPrimaryKey, null, EntityJoinTree.JoinType.INNER, null, Collections.emptySet());
        String tutuAddKey = entityJoinTree.addRelationJoin(tataAddKey, (EntityInflater)new EntityInflater.EntityMappingAdapter((EntityMapping)tutuMappingMock), (Key)tataPrimaryKey, (Key)tutuPrimaryKey, null, EntityJoinTree.JoinType.INNER, null, Collections.emptySet());
        String titiAddKey = entityJoinTree.addRelationJoin(tataAddKey, (EntityInflater)new EntityInflater.EntityMappingAdapter((EntityMapping)titiMappingMock), (Key)tataPrimaryKey, (Key)titiPrimaryKey, null, EntityJoinTree.JoinType.INNER, null, Collections.emptySet());
        String tataAddKey2 = entityJoinTree.addRelationJoin("ROOT", (EntityInflater)new EntityInflater.EntityMappingAdapter((EntityMapping)tataCloneMappingMock), (Key)totoPrimaryKey, (Key)tataClonePrimaryKey, null, EntityJoinTree.JoinType.INNER, null, Collections.emptySet());
        String tutuAddKey2 = entityJoinTree.addRelationJoin(tataAddKey2, (EntityInflater)new EntityInflater.EntityMappingAdapter((EntityMapping)tutuCloneMappingMock), (Key)tataClonePrimaryKey, (Key)tutuClonePrimaryKey, null, EntityJoinTree.JoinType.INNER, null, Collections.emptySet());
        ArrayList depth = new ArrayList();
        ArrayList collectedNodes = new ArrayList();
        entityJoinTree.foreachJoinWithDepth((Object)1, (o, abstractJoinNode) -> {
            depth.add(o);
            collectedNodes.add(abstractJoinNode);
            o = o + 1;
            return o;
        });
        Assertions.assertThat(depth).isEqualTo((Object)Arrays.asList((Object[])new Integer[]{1, 1, 2, 2, 2}));
        ((ListAssert)Assertions.assertThat(collectedNodes).withRepresentation(new Printer(AbstractJoinNode.class, joinNode -> joinNode.getLeftJoinLink() + " = " + joinNode.getRightJoinLink()))).isEqualTo((Object)Arrays.asList((Object[])new AbstractJoinNode[]{entityJoinTree.giveJoin((Key)totoPrimaryKey, (Key)tataPrimaryKey), entityJoinTree.giveJoin((Key)totoPrimaryKey, (Key)tataClonePrimaryKey), entityJoinTree.giveJoin((Key)tataPrimaryKey, (Key)tutuPrimaryKey), entityJoinTree.giveJoin((Key)tataPrimaryKey, (Key)titiPrimaryKey), entityJoinTree.giveJoin((Key)tataClonePrimaryKey, (Key)tutuClonePrimaryKey)}));
    }

    @Test
    void giveTables() {
        ClassMapping totoMappingMock = EntityJoinTreeTest.buildMappingStrategyMock("Toto");
        Table totoTable = totoMappingMock.getTargetTable();
        totoTable.addColumn("id", Long.TYPE).primaryKey();
        PrimaryKey totoPrimaryKey = totoTable.getPrimaryKey();
        Column totoNameColumn = totoTable.addColumn("name", String.class);
        ClassMapping tataMappingMock = EntityJoinTreeTest.buildMappingStrategyMock("Tata");
        Table tataTable = tataMappingMock.getTargetTable();
        tataTable.addColumn("id", Long.TYPE).primaryKey();
        PrimaryKey tataPrimaryKey = tataTable.getPrimaryKey();
        Column tataNameColumn = tataTable.addColumn("name", String.class);
        ClassMapping tutuMappingMock = EntityJoinTreeTest.buildMappingStrategyMock("Tutu");
        Table tutuTable = tutuMappingMock.getTargetTable();
        tutuTable.addColumn("id", Long.TYPE).primaryKey();
        PrimaryKey tutuPrimaryKey = tutuTable.getPrimaryKey();
        Column tutuNameColumn = tutuTable.addColumn("name", String.class);
        ClassMapping titiMappingMock = EntityJoinTreeTest.buildMappingStrategyMock("Titi");
        Table titiTable = titiMappingMock.getTargetTable();
        titiTable.addColumn("id", Long.TYPE).primaryKey();
        PrimaryKey titiPrimaryKey = titiTable.getPrimaryKey();
        Column titiNameColumn = titiTable.addColumn("name", String.class);
        Table tataTableClone = new Table("tata2");
        ClassMapping tataCloneMappingMock = EntityJoinTreeTest.buildMappingStrategyMock(tataTableClone);
        tataTableClone.addColumn("id", Long.TYPE).primaryKey();
        PrimaryKey tataClonePrimaryKey = tataTableClone.getPrimaryKey();
        Column tataCloneNameColumn = tataTableClone.addColumn("name", String.class);
        Table tutuTableClone = new Table("tutu2");
        ClassMapping tutuCloneMappingMock = EntityJoinTreeTest.buildMappingStrategyMock(tutuTableClone);
        tutuTableClone.addColumn("id", Long.TYPE).primaryKey();
        PrimaryKey tutuClonePrimaryKey = tutuTableClone.getPrimaryKey();
        Column tutuCloneNameColumn = tutuTableClone.addColumn("name", String.class);
        EntityJoinTree entityJoinTree = new EntityJoinTree((EntityInflater)new EntityInflater.EntityMappingAdapter((EntityMapping)totoMappingMock), (Fromable)totoMappingMock.getTargetTable());
        String tataAddKey = entityJoinTree.addRelationJoin("ROOT", (EntityInflater)new EntityInflater.EntityMappingAdapter((EntityMapping)tataMappingMock), (Key)totoPrimaryKey, (Key)tataPrimaryKey, null, EntityJoinTree.JoinType.INNER, null, Collections.emptySet());
        String tutuAddKey = entityJoinTree.addRelationJoin(tataAddKey, (EntityInflater)new EntityInflater.EntityMappingAdapter((EntityMapping)tutuMappingMock), (Key)tataPrimaryKey, (Key)tutuPrimaryKey, null, EntityJoinTree.JoinType.INNER, null, Collections.emptySet());
        String titiAddKey = entityJoinTree.addRelationJoin(tataAddKey, (EntityInflater)new EntityInflater.EntityMappingAdapter((EntityMapping)titiMappingMock), (Key)tataPrimaryKey, (Key)titiPrimaryKey, null, EntityJoinTree.JoinType.INNER, null, Collections.emptySet());
        String tataAddKey2 = entityJoinTree.addRelationJoin("ROOT", (EntityInflater)new EntityInflater.EntityMappingAdapter((EntityMapping)tataCloneMappingMock), (Key)totoPrimaryKey, (Key)tataClonePrimaryKey, null, EntityJoinTree.JoinType.INNER, null, Collections.emptySet());
        String tutuAddKey2 = entityJoinTree.addRelationJoin(tataAddKey2, (EntityInflater)new EntityInflater.EntityMappingAdapter((EntityMapping)tutuCloneMappingMock), (Key)tataClonePrimaryKey, (Key)tutuClonePrimaryKey, null, EntityJoinTree.JoinType.INNER, null, Collections.emptySet());
        ((AbstractCollectionAssert)Assertions.assertThat((Collection)entityJoinTree.giveTables()).usingElementComparator(Table.COMPARATOR_ON_SCHEMA_AND_NAME)).containsExactlyInAnyOrder((Object[])new Table[]{totoTable, tataTable, tataTableClone, titiTable, tutuTable, tutuTableClone});
    }

    @Test
    void lookupTable() {
        EntityJoinTree testInstance = new EntityJoinTree((EntityInflater)Mockito.mock(EntityInflater.class), (Fromable)new Table("root Table"));
        Table table1 = new Table("table1");
        Column table1A = table1.addColumn("table1_a", String.class);
        Table table2 = new Table("table2");
        Column table2A = table1.addColumn("table2_a", String.class);
        Table table3 = new Table("table3");
        Column table3A = table1.addColumn("table3_a", String.class);
        Table table4 = new Table("table4");
        Column table4A = table1.addColumn("table4_a", String.class);
        Union table5 = new Union(new Query[]{(Query)((Query.FluentFromClause)QueryEase.select((Selectable)table4A, (String)"a").from((Fromable)table4).innerJoin((Fromable)table3, "whatever join")).getQuery()});
        Union union = new Union(new Query[]{(Query)QueryEase.select((Selectable)table1A, (String)"a").from((Fromable)table1).getQuery(), (Query)((Query.FluentFromClause)((Query.FluentFromClause)QueryEase.select((Selectable)table2A, (String)"a").from((Fromable)table2).innerJoin((Fromable)table3, "whatever join 1")).leftOuterJoin((Fromable)table5.asPseudoTable("a sub pseudo table"), "whatever join 2")).getQuery()});
        Set foundTables = testInstance.lookupTable(union.asPseudoTable("a pseudo table"));
        Assertions.assertThat((Collection)foundTables).containsExactlyInAnyOrder((Object[])new Table[]{table1, table2, table3, table4});
    }

    private static class Printer<E>
    extends StandardRepresentation {
        private final Class<E> elementType;
        private final Function<E, String> printingFunction;

        private Printer(Class<E> elementType, Function<E, String> printingFunction) {
            this.elementType = elementType;
            this.printingFunction = printingFunction;
        }

        public String toStringOf(Object o) {
            if (this.elementType.isInstance(o)) {
                return this.printingFunction.apply(o);
            }
            return super.toStringOf(o);
        }
    }
}

