/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.runtime.load;

import java.util.HashSet;
import java.util.Set;
import org.codefilarete.stalactite.engine.runtime.load.EntityInflater;
import org.codefilarete.stalactite.engine.runtime.load.EntityJoinTree;
import org.codefilarete.stalactite.engine.runtime.load.EntityTreeInflater;
import org.codefilarete.stalactite.engine.runtime.load.EntityTreeJoinNodeConsumptionListener;
import org.codefilarete.stalactite.engine.runtime.load.JoinNode;
import org.codefilarete.stalactite.engine.runtime.load.JoinRowConsumer;
import org.codefilarete.stalactite.engine.runtime.load.PolymorphicMergeJoinRowConsumer;
import org.codefilarete.stalactite.engine.runtime.load.RelationJoinNode;
import org.codefilarete.stalactite.engine.runtime.load.TablePerClassPolymorphicRelationJoinNode;
import org.codefilarete.stalactite.query.model.QueryStatement;
import org.codefilarete.stalactite.query.model.Selectable;
import org.codefilarete.stalactite.query.model.Union;
import org.codefilarete.stalactite.sql.ddl.structure.Key;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.stalactite.sql.result.BeanRelationFixer;
import org.codefilarete.stalactite.sql.result.ColumnedRow;
import org.codefilarete.tool.Nullable;
import org.codefilarete.tool.Reflections;
import org.codefilarete.tool.collection.Iterables;

public class TablePerClassPolymorphicRelationJoinNode<C, T1 extends Table<T1>, JOINCOLTYPE, I>
extends RelationJoinNode<C, T1, QueryStatement.PseudoTable, JOINCOLTYPE, I> {
    private final Set<SubPersisterAndDiscriminator<? extends C>> subPersisters = new HashSet<SubPersisterAndDiscriminator<? extends C>>();
    private final QueryStatement.PseudoTable pseudoTable;
    private final QueryStatement.PseudoColumn<Integer> discriminatorColumn;

    public TablePerClassPolymorphicRelationJoinNode(JoinNode<?, T1> parent, Union subPersistersUnion, Key<T1, JOINCOLTYPE> leftJoinColumn, Key<?, JOINCOLTYPE> rightJoinColumn, EntityJoinTree.JoinType joinType, Set<? extends Selectable<?>> columnsToSelect, @javax.annotation.Nullable String tableAlias, EntityInflater<C, I> entityInflater, BeanRelationFixer<Object, C> beanRelationFixer, QueryStatement.PseudoColumn<Integer> discriminatorColumn) {
        super(parent, leftJoinColumn, rightJoinColumn, joinType, columnsToSelect, tableAlias, entityInflater, beanRelationFixer, null);
        this.pseudoTable = subPersistersUnion.asPseudoTable(this.getTableAlias());
        this.discriminatorColumn = discriminatorColumn;
    }

    @Override
    public QueryStatement.PseudoTable getRightTable() {
        return this.pseudoTable;
    }

    @Override
    public Set<Selectable<?>> getColumnsToSelect() {
        return this.pseudoTable.getColumns();
    }

    public TablePerClassPolymorphicRelationJoinRowConsumer toConsumer(JoinNode<C, QueryStatement.PseudoTable> joinNode) {
        return new TablePerClassPolymorphicRelationJoinRowConsumer(joinNode, this.discriminatorColumn, this.getConsumptionListener());
    }

    public <D extends C> void addSubPersisterJoin(PolymorphicMergeJoinRowConsumer<D, I> subPersisterJoin, int discriminatorValue) {
        this.subPersisters.add(new SubPersisterAndDiscriminator<D>(subPersisterJoin, discriminatorValue));
    }

    public class TablePerClassPolymorphicRelationJoinRowConsumer
    implements RelationJoinNode.RelationJoinRowConsumer<C, I>,
    JoinRowConsumer.ForkJoinRowConsumer {
        private final ThreadLocal<org.codefilarete.stalactite.engine.runtime.load.TablePerClassPolymorphicRelationJoinNode$TablePerClassPolymorphicRelationJoinRowConsumer.RowIdentifier<? extends C>> currentlyFoundConsumer = new ThreadLocal();
        private final JoinNode<C, QueryStatement.PseudoTable> joinNode;
        @javax.annotation.Nullable
        private final EntityTreeJoinNodeConsumptionListener<C> consumptionListener;
        private final QueryStatement.PseudoColumn<Integer> discriminatorColumn;

        private TablePerClassPolymorphicRelationJoinRowConsumer(JoinNode<C, QueryStatement.PseudoTable> joinNode, @javax.annotation.Nullable QueryStatement.PseudoColumn<Integer> discriminatorColumn, EntityTreeJoinNodeConsumptionListener<C> consumptionListener) {
            this.joinNode = joinNode;
            this.consumptionListener = consumptionListener;
            this.discriminatorColumn = discriminatorColumn;
        }

        public JoinNode<C, ?> getNode() {
            return this.joinNode;
        }

        @Override
        public C applyRelatedEntity(Object parentJoinEntity, ColumnedRow row, EntityTreeInflater.TreeInflationContext context) {
            RowIdentifier rowIdentifier = this.giveIdentifier(row);
            this.currentlyFoundConsumer.set((org.codefilarete.stalactite.engine.runtime.load.TablePerClassPolymorphicRelationJoinNode$TablePerClassPolymorphicRelationJoinRowConsumer.RowIdentifier)rowIdentifier);
            if (rowIdentifier == null) {
                return null;
            }
            Object rightIdentifier = rowIdentifier.entityIdentifier;
            EntityTreeInflater.RelationIdentifier eventuallyApplied = new EntityTreeInflater.RelationIdentifier(parentJoinEntity, TablePerClassPolymorphicRelationJoinNode.this.getEntityType(), rightIdentifier, this);
            if (rightIdentifier != null && context.isTreatedOrAppend(eventuallyApplied)) {
                Object rightEntity = context.giveEntityFromCache(TablePerClassPolymorphicRelationJoinNode.this.getEntityType(), rightIdentifier, () -> rowIdentifier.rowConsumer.transform(row));
                TablePerClassPolymorphicRelationJoinNode.this.getBeanRelationFixer().apply(parentJoinEntity, rightEntity);
                if (this.consumptionListener != null) {
                    this.consumptionListener.onNodeConsumption(rightEntity, row);
                }
                return rightEntity;
            }
            return null;
        }

        @javax.annotation.Nullable
        private <D extends C> org.codefilarete.stalactite.engine.runtime.load.TablePerClassPolymorphicRelationJoinNode$TablePerClassPolymorphicRelationJoinRowConsumer.RowIdentifier<D> giveIdentifier(ColumnedRow row) {
            Object identifier;
            SubPersisterAndDiscriminator discriminatorConsumer;
            Integer discriminatorValue = (Integer)row.get(this.discriminatorColumn);
            if (discriminatorValue != null && (discriminatorConsumer = (SubPersisterAndDiscriminator)Iterables.find((Iterable)TablePerClassPolymorphicRelationJoinNode.this.subPersisters, o -> ((SubPersisterAndDiscriminator)o).discriminatorValue == discriminatorValue)) != null && (identifier = discriminatorConsumer.subPersisterJoin.giveIdentifier(row)) != null) {
                return new RowIdentifier(identifier, discriminatorConsumer.subPersisterJoin);
            }
            return null;
        }

        @Override
        public JoinRowConsumer giveNextConsumer() {
            return (JoinRowConsumer)Nullable.nullable(this.currentlyFoundConsumer.get()).map(rowIdentifier -> ((RowIdentifier)rowIdentifier).rowConsumer).get();
        }

        @Override
        public void afterRowConsumption(EntityTreeInflater.TreeInflationContext context) {
            this.currentlyFoundConsumer.remove();
        }

        public String toString() {
            return Reflections.toString(this.getClass());
        }

        private class RowIdentifier<D extends C> {
            private final I entityIdentifier;
            private final PolymorphicMergeJoinRowConsumer<D, I> rowConsumer;

            private RowIdentifier(I entityIdentifier, PolymorphicMergeJoinRowConsumer<D, I> rowConsumer) {
                this.entityIdentifier = entityIdentifier;
                this.rowConsumer = rowConsumer;
            }
        }
    }

    private class SubPersisterAndDiscriminator<D extends C> {
        private final PolymorphicMergeJoinRowConsumer<D, I> subPersisterJoin;
        private final int discriminatorValue;

        public SubPersisterAndDiscriminator(PolymorphicMergeJoinRowConsumer<D, I> subPersisterJoin, int discriminatorValue) {
            this.subPersisterJoin = subPersisterJoin;
            this.discriminatorValue = discriminatorValue;
        }
    }
}

