/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.runtime;

import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Queue;
import java.util.Set;
import java.util.function.Function;
import org.codefilarete.stalactite.engine.SelectExecutor;
import org.codefilarete.stalactite.engine.listener.SelectListener;
import org.codefilarete.stalactite.engine.runtime.RelationIds;
import org.codefilarete.stalactite.sql.result.BeanRelationFixer;
import org.codefilarete.tool.Nullable;
import org.codefilarete.tool.Reflections;
import org.codefilarete.tool.collection.Iterables;

public class SecondPhaseRelationLoader<SRC, TRGT, ID>
implements SelectListener<SRC, ID> {
    private final BeanRelationFixer<SRC, TRGT> beanRelationFixer;
    private final ThreadLocal<Queue<Set<RelationIds<Object, Object, Object>>>> relationIdsHolder;

    public SecondPhaseRelationLoader(BeanRelationFixer<SRC, TRGT> beanRelationFixer, ThreadLocal<Queue<Set<RelationIds<Object, Object, Object>>>> relationIdsHolder) {
        this.beanRelationFixer = beanRelationFixer;
        this.relationIdsHolder = relationIdsHolder;
    }

    public void beforeSelect(Iterable<ID> ids) {
        Queue<Set<RelationIds<Object, Object, Object>>> existingSet = this.relationIdsHolder.get();
        if (existingSet == null) {
            existingSet = new ArrayDeque<Set<RelationIds<Object, Object, Object>>>();
            this.relationIdsHolder.set(existingSet);
        }
        existingSet.add(new HashSet());
    }

    public void afterSelect(Set<? extends SRC> result) {
        this.selectTargetEntities(result);
        this.relationIdsHolder.remove();
    }

    private <TRGTID> void selectTargetEntities(Iterable<? extends SRC> sourceEntities) {
        HashMap<SelectExecutor, Set> selectsToExecute = new HashMap<SelectExecutor, Set>();
        HashMap idAccessors = new HashMap();
        HashMap targetIdPerSource = new HashMap();
        Set<RelationIds<Object, Object, Object>> relationIds = this.relationIdsHolder.get().poll();
        relationIds.stream().filter(r -> !SecondPhaseRelationLoader.isDefaultValue(r.getTargetId())).forEach(r -> {
            idAccessors.putIfAbsent(r.getSelectExecutor(), r.getIdAccessor());
            targetIdPerSource.computeIfAbsent(r.getSource(), k -> new HashSet()).add(r.getTargetId());
            selectsToExecute.computeIfAbsent(r.getSelectExecutor(), k -> new HashSet()).add(r.getTargetId());
        });
        HashMap<SelectExecutor, Set> targetsPerSelector = new HashMap<SelectExecutor, Set>();
        selectsToExecute.forEach((selectExecutor, ids) -> targetsPerSelector.put((SelectExecutor)selectExecutor, selectExecutor.select((Iterable)ids)));
        HashMap targetPerId = new HashMap();
        targetsPerSelector.forEach((selector, loadedTargets) -> targetPerId.putAll(Iterables.map((Iterable)loadedTargets, (Function)((Function)idAccessors.get(selector)))));
        sourceEntities.forEach(src -> Nullable.nullable(targetIdPerSource.get(src)).invoke(targetIds -> targetIds.forEach(targetId -> this.beanRelationFixer.apply(src, targetPerId.get(targetId)))));
    }

    public static boolean isDefaultValue(Object value) {
        return value == null || Reflections.PRIMITIVE_DEFAULT_VALUES.get(value.getClass()) == value;
    }

    public void onSelectError(Iterable<ID> ids, RuntimeException exception) {
        this.relationIdsHolder.remove();
    }
}

