/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.runtime;

import java.util.HashMap;
import java.util.Map;
import org.codefilarete.reflection.AccessorDefinition;
import org.codefilarete.stalactite.engine.AssociationTableNamingStrategy;
import org.codefilarete.stalactite.engine.ForeignKeyNamingStrategy;
import org.codefilarete.stalactite.query.model.Fromable;
import org.codefilarete.stalactite.query.model.JoinLink;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.Database;
import org.codefilarete.stalactite.sql.ddl.structure.Key;
import org.codefilarete.stalactite.sql.ddl.structure.PrimaryKey;
import org.codefilarete.stalactite.sql.ddl.structure.Table;

public class AssociationTable<SELF extends AssociationTable<SELF, LEFTTABLE, RIGHTTABLE, LEFTID, RIGHTID>, LEFTTABLE extends Table<LEFTTABLE>, RIGHTTABLE extends Table<RIGHTTABLE>, LEFTID, RIGHTID>
extends Table<SELF> {
    private final Key<SELF, LEFTID> oneSideForeignKey;
    private final PrimaryKey<LEFTTABLE, LEFTID> oneSideKey;
    private final Key<SELF, RIGHTID> manySideForeignKey;
    private final PrimaryKey<RIGHTTABLE, RIGHTID> manySideKey;
    private final Map<Column<LEFTTABLE, ?>, Column<SELF, ?>> leftIdentifierColumnMapping = new HashMap();
    private final Map<Column<RIGHTTABLE, ?>, Column<SELF, ?>> rightIdentifierColumnMapping = new HashMap();

    public AssociationTable(Database.Schema schema, String name, PrimaryKey<LEFTTABLE, LEFTID> oneSideKey, PrimaryKey<RIGHTTABLE, RIGHTID> manySideKey, AccessorDefinition accessorDefinition, AssociationTableNamingStrategy namingStrategy, ForeignKeyNamingStrategy foreignKeyNamingStrategy, boolean createOneSideForeignKey, boolean createManySideForeignKey) {
        super(schema, name);
        this.oneSideKey = oneSideKey;
        this.manySideKey = manySideKey;
        AssociationTableNamingStrategy.ReferencedColumnNames<LEFTTABLE, RIGHTTABLE> columnNames = namingStrategy.giveColumnNames(accessorDefinition, oneSideKey, manySideKey);
        Key.KeyBuilder leftForeignKeyBuilder = Key.from((Fromable)this);
        oneSideKey.getColumns().forEach(oneSideKeyColumn -> {
            Column column = this.addColumn(columnNames.getLeftColumnName((Column<LEFTTABLE, ?>)oneSideKeyColumn), oneSideKeyColumn.getJavaType());
            column.primaryKey();
            leftForeignKeyBuilder.addColumn((JoinLink)column);
            this.leftIdentifierColumnMapping.put((Column<LEFTTABLE, ?>)oneSideKeyColumn, (Column<SELF, ?>)column);
        });
        Key leftForeignKey = leftForeignKeyBuilder.build();
        this.oneSideForeignKey = createOneSideForeignKey ? this.addForeignKey(foreignKeyNamingStrategy::giveName, leftForeignKey, (Key)oneSideKey) : leftForeignKey;
        Key.KeyBuilder rightForeignKeyBuilder = Key.from((Fromable)this);
        manySideKey.getColumns().forEach(manySideKeyColumn -> {
            Column column = this.addColumn(columnNames.getRightColumnName((Column<RIGHTTABLE, ?>)manySideKeyColumn), manySideKeyColumn.getJavaType());
            column.primaryKey();
            rightForeignKeyBuilder.addColumn((JoinLink)column);
            this.rightIdentifierColumnMapping.put((Column<RIGHTTABLE, ?>)manySideKeyColumn, (Column<SELF, ?>)column);
        });
        Key rightForeignKey = rightForeignKeyBuilder.build();
        this.manySideForeignKey = createManySideForeignKey ? this.addForeignKey(foreignKeyNamingStrategy::giveName, rightForeignKey, (Key)manySideKey) : rightForeignKey;
    }

    public AssociationTable(Database.Schema schema, String name, PrimaryKey<LEFTTABLE, LEFTID> oneSideKey, PrimaryKey<RIGHTTABLE, RIGHTID> manySideKey, AccessorDefinition accessorDefinition, AssociationTableNamingStrategy namingStrategy, ForeignKeyNamingStrategy foreignKeyNamingStrategy) {
        this(schema, name, oneSideKey, manySideKey, accessorDefinition, namingStrategy, foreignKeyNamingStrategy, true, true);
    }

    public Key<SELF, LEFTID> getOneSideForeignKey() {
        return this.oneSideForeignKey;
    }

    public Key<LEFTTABLE, LEFTID> getOneSideKey() {
        return this.oneSideKey;
    }

    public Key<SELF, RIGHTID> getManySideForeignKey() {
        return this.manySideForeignKey;
    }

    public Key<RIGHTTABLE, RIGHTID> getManySideKey() {
        return this.manySideKey;
    }

    public Map<Column<LEFTTABLE, ?>, Column<SELF, ?>> getLeftIdentifierColumnMapping() {
        return this.leftIdentifierColumnMapping;
    }

    public Map<Column<RIGHTTABLE, ?>, Column<SELF, ?>> getRightIdentifierColumnMapping() {
        return this.rightIdentifierColumnMapping;
    }
}

